<?php
/* Note: Other parts of the page may use the JS functions below, but as a general rule,
 * they should avoid modifying this part of the DOM directly.
 */
?>

<script>
    var SR_EDITING = false;
    $(document).ready(function () {
        clearScheduledReportModal();

        $('#sr-form').on('submit', function(e) {
            $('#sr-message').hide();
            e.preventDefault();
            var array_args = $(e.target).serializeArray();
            var obj_args = serializeArrayToObject(array_args);
            var errmsg = scheduledReportValidate(obj_args);

            if (errmsg) {
                sr_show_error(errmsg);
                return;
            }

            str_args = $(e.target).serialize();
            if (SR_EDITING) {
                str_args += '&edit=1';
            }

            url = '<?php echo site_url('api/report/schedule'); ?>';
            url += '?' + str_args;
            $.get(url, {}, function(data) {
                if (data.hasOwnProperty('errmsg')) {
                    sr_show_error(data.errmsg);
                    return;
                }
                else {
                    window.location.href = '<?php echo site_url('reports/scheduled'); ?>';
                }
            }, 'json');
        });
    });

    function sr_show_error(msg) {
        $('#sr-error-message').html(msg);
        $('#sr-message').addClass('alert-danger').show();
    }

    function showTimeOpts() {
        var opt = $('#sr-input-which').val();

        switch (opt) {
            case 'daily':
                $('#sr-input-time-group').show();
                $('#sr-input-weekday-group').hide();
                $('#sr-input-monthday-group').hide();
                break;
            case 'weekly':
                $('#sr-input-time-group').show();
                $('#sr-input-weekday-group').show();
                $('#sr-input-monthday-group').hide();
                break;
            case 'monthly':
                $('#sr-input-time-group').show();
                $('#sr-input-weekday-group').hide();
                $('#sr-input-monthday-group').show();
                break;
            case 'Once': /* Same as default, fall through */
            default:
                $('#sr-input-time-group').hide();
                $('#sr-input-weekday-group').hide();
                $('#sr-input-monthday-group').hide();
                break;
        }
    }
    function showScheduledReportModal() {
        showTimeOpts();
        $('#schedule-report').modal('show');
    }

    function clearScheduledReportModal(is_mail = false) {

        var defaultOptions = {title: '<?php echo _("Schedule this Report"); ?>'};
        $('#sr-is-mail-only').hide();
        if ($('#sr-is-mail-only').is(':selected')) {
            $('#sr-input-which').val('daily');
        }

        if (is_mail) {
            defaultOptions['title'] = '<?php echo _('E-mail this Report'); ?>';
            $('#sr-is-mail-only').show();
            $('#sr-input-which').val('once');
        }

        defaultOptions['recipients'] = '<?php echo htmlspecialchars($email); ?>';
        defaultOptions['subject'] = $('#dashboard-title').html();
        defaultOptions['message'] = '';
        populateScheduledReportModal(defaultOptions);
    }

    function populateScheduledReportModal(options) {

        if (!options.hasOwnProperty('title')) {
            options.title = '<?php echo _('Edit Scheduled Report'); ?>';
        }

        $('#sr-modal-title-here').html(options.title);

        val_array = ['id', 'dashboard-id', 'name', 'which', 'hour', 'minute', 'ampm', 'weekday', 'monthday', 'recipients', 'subject'];
        html_array = ['message'];
        checkbox_array = ['attachments-pdf', 'attachments-jpg', 'hide'];

        for (i in options) {

            if (val_array.indexOf(i) !== -1) {
                $('#sr-input-' + i).val(options[i]);
            }

            if (html_array.indexOf(i) !== -1) {
                $('#sr-input-' + i).html(options[i]);
            }

            if (checkbox_array.indexOf(i) !== -1) {
                $('#sr-input-' + i).prop('checked', options[i]);
            }
        }
    }

    function scheduledReportValidate(query_object) {

        if (query_object.name === '' || query_object.recipients === '' || query_object.subject === '') {
            return '<?php echo _('Please fill out all of the required form fields.'); ?>';
        }

        var rec_arr = query_object.recipients.split(',');
        for (var i = 0; i < rec_arr.length; i++) {
            if (rec_arr[i].indexOf('@') === -1) {
                return '<?php echo _('Please enter valid e-mail addresses for all recipients');?>';
            }
        }
    }

</script>

<div class="modal hide fade in" id="schedule-report" tabindex="-1" role="dialog">
    <form id="sr-form">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <input type="hidden" id="sr-input-id" name="id" value="">
                <input type="hidden" id="sr-input-dashboard-id" name="dashboard-id" value="">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">×</button>
                    <h2 id="sr-modal-title-here"></h2>
                </div>
                <div class="modal-body">
                    <div id="sr-message" class="alert hide" style="margin: 0 0 15px 0;">
                        <div id="sr-error-message"></div>
                    </div>
                    <div class="form-horizontal">
                        <div class="form-group">
                            <label class="col-sm-3 control-label form-required" for="sr-input-name"><?php echo _('Name'); ?></label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" id="sr-input-name" name="name">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-3 control-label" for="sr-input-frequency"><?php echo _('Frequency'); ?></label>
                            <div class="col-sm-9">
                                <select id="sr-input-which" name="which" class="form-control" onchange="showTimeOpts()">
                                    <option id="sr-is-mail-only" value='once'><?php echo _("One Time"); ?></option>
                                    <option value='daily'><?php echo _("Daily"); ?></option>
                                    <option value='weekly'><?php echo _("Weekly"); ?></option>
                                    <option value='monthly'><?php echo _("Monthly"); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group hide" id="sr-input-time-group">
                            <label class="col-sm-3 control-label" for="sr-input-time"><?php echo _('Time'); ?></label>
                            <div class="col-sm-9">
                                <select id="sr-input-hour" name="hour" class="form-control">
                                    <?php
                                    for ($x = 1; $x < 12; $x++) {
                                        $nstr = sprintf("%02d", $x);
                                        echo "<option value='" . $nstr . "'>" . $nstr . "</option>";
                                    }
                                    echo "<option value='0'>12</option>";
                                    ?>
                                </select>:<select id="sr-input-minute" name="minute" class="form-control">
                                    <?php
                                    for ($x = 0; $x < 60; $x++) {
                                        $nstr = sprintf("%02d", $x);
                                        echo "<option value='" . $nstr . "'>" . $nstr . "</option>";
                                    }
                                    ?>
                                </select>
                                <select id="sr-input-ampm" name="ampm" class="form-control">
                                    <option value="am">AM</option>
                                    <option value="pm">PM</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group hide" id="sr-input-weekday-group">
                            <label class="col-sm-3 control-label" for="sr-input-weekday"><?php echo _("Weekday"); ?>:</label>
                            <div class="col-sm-9">
                                <select id="sr-input-weekday" name="weekday" class="form-control">
                                    <?php
                                    $days = array(
                                        0 => 'Sunday',
                                        1 => 'Monday',
                                        2 => 'Tuesday',
                                        3 => 'Wednesday',
                                        4 => 'Thursday',
                                        5 => 'Friday',
                                        6 => 'Saturday',
                                    );
                                    foreach ($days as $did => $day) {
                                        echo "<option value='" . $did . "'>" . $day . "</option>";
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group hide" id="sr-input-monthday-group">
                            <label class="col-sm-3 control-label" for="sr-input-monthday"><?php echo _("Day of Month");?>:</label>
                            <div class="col-sm-9">
                                <select id="sr-input-monthday" name="monthday" class="form-control">
                                    <?php
                                    for ($x = 1; $x <= 31; $x++) {
                                        echo "<option value='" . $x . "'>" . $x . "</option>";
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group" id="sr-input-attachments-group">
                            <label class="col-sm-3 control-label" for="sr-input-attachments"><?php echo _('Attachments'); ?></label>
                            <div class="col-sm-9">
                                <table class="table table-condensed table-no-border table-auto-width">
                                    <tbody id="sr-insert-custom-attachments-here">
                                        <tr>
                                            <td><label><input id="sr-input-attachments-pdf" type="checkbox" name="attachments[pdf]" style="vertical-align: bottom" checked> <i class="fa fa-14 fa-file-pdf-o" alt="PDF" title="PDF"></i> PDF</label></td>
                                        </tr>
                                        <tr>
                                            <td><label><input id="sr-input-attachments-jpg" type="checkbox" name="attachments[jpg]" style="vertical-align: bottom"> <i class="fa fa-14 fa-file-image-o" alt="JPG" title="JPG"></i> JPG</label></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-3 control-label form-required" for="sr-input-recipients"><?php echo _("Recipients"); ?></label>
                            <div class="col-sm-9">
                                <input type="text" id="sr-input-recipients" name="recipients" class="textfield form-control" placeholder="<?php echo _("Comma-separated, i.e. 'root@localhost,admin@example.com'"); ?>">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-3 control-label form-required" for="sr-input-subject"><?php echo _("Subject"); ?></label>
                            <div class="col-sm-9">
                                <input type="text" id="sr-input-subject" name="subject" class="textfield form-control">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-3 control-label" for="sr-input-message"><?php echo _("Message"); ?></label>
                            <div class="col-sm-9">
                                <textarea style="width: 40%; min-width: 400px; height: 100px;" wrap="physical" id="sr-input-message" class="form-control" name="message"></textarea>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-3 control-label" for="sr-input-hide"><?php echo _("Hide"); ?></label>
                            <div class="col-sm-9">
                                <input type="checkbox" name="hide" id="sr-input-hide" value="1" style="vertical-align: bottom">
                                <?php echo _("Do not show this report in the \"Scheduled Reports\" list"); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-sm btn-primary" id="schedule-report-submit"><?php echo _("Submit"); ?></button>
                    <button class="btn btn-sm btn-default" id="schedule-report-close-modal" data-dismiss="modal"><?php echo _("Close"); ?></button>
                </div>
            </div>
        </div>
    </form>
</div>

