<?php echo $header; ?>
<script>
    $(document).ready(function () {

        SR_EDITING = true;

        $('.edit').click(function() {
            var options = {};
            options['id'] = $(this).data('id');
            options['dashboard-id'] = $(this).data('dashboard-id');
            options['name'] = $(this).data('name');
            options['which'] = $(this).data('which');
            options['hour'] = $(this).data('hour');
            options['minute'] = $(this).data('minute');
            options['ampm'] = $(this).data('ampm');
            options['weekday'] = $(this).data('weekday');
            options['monthday'] = $(this).data('monthday');
            options['attachments-pdf'] = $(this).data('attachments-pdf');
            options['attachments-jpg'] = $(this).data('attachments-jpg');
            options['recipients'] = $(this).data('recipients');
            options['subject'] = $(this).data('subject');
            options['message'] = $(this).data('message');
            options['hide'] = $(this).data('hide');

            clearScheduledReportModal();
            populateScheduledReportModal(options);
            showScheduledReportModal();
        });

        var delete_timeout;
        $('.delete').click(function(e) {
            e.preventDefault();
            $.post(this.href, {}, function(data) {
                if (data.hasOwnProperty('errmsg')) {
                    alert(data.errmsg);
                    return;
                }
                window.location.reload();
            }, 'json');
        });
    });
</script>
<div class="configure-layout">
    <?php echo $leftbar; ?>
    <?php echo $schedule_modal;?>
    <div class="rside">
        <h1 style="margin-bottom: 10px;"><?php echo _("Scheduled Reports"); ?></h1>
        <p><?php echo _('To schedule a report, click one of the reports on the left and click on the clock icon in the upper-right corner of that screen.'); ?></p>
        <?php if (!empty($msg)) { ?>
        <div class="alert alert-<?php echo $msg_type; ?>" style="margin-bottom: 15px;"><div style='float: right;'><a href='#' class='close' data-dismiss='alert'>&times;</a></div><?php echo $msg; ?></div>
        <?php } ?>

        <table class="table table-striped table-condensed table-bordered">
            <thead>
                <tr>
                    <th><?php echo _("Report Name"); ?></th>
                    <th><?php echo _("Created By"); ?></th>
                    <th><?php echo _("Subject"); ?></th>
                    <th><?php echo _("Frequency"); ?></th>
                    <th><?php echo _("Recipients"); ?></th>
                    <th style="width: 140px; text-align: center;"><?php echo _("Actions"); ?></th>
                </tr>
            </thead>
            <tbody id="real-time-alert-list">
                <?php


                foreach ($scheduled_reports as $index => $report) {
                    if ($report['frequency']['which'] === "once") {
                        unset($scheduled_reports[$index]);
                    }
                }

                if (count($scheduled_reports) > 0) {
                    foreach ($scheduled_reports as $report) {
                ?>

                <tr>
                    <td>
                        <?php echo html_escape($report['name']); ?>
                        <div class="clear"></div>
                    </td>
                    <td><?php echo array_key_exists('created_by', $report) ? $report['created_by'] : _('&lt;Creator not found&gt;'); ?></td>
                    <td><?php echo $report['subject']; ?></td>
                    <td><?php echo $report['formatted_time']; ?></td>
                    <td><?php echo implode(', ', $report['recipients']); ?></td>

                    <td class="actions">
                        <a class="edit ls-tooltip" 
                           data-id="<?php echo $report['id']; ?>"
                           data-dashboard-id="<?php echo $report['dashboard-id']; ?>"
                           data-name="<?php echo $report['name']; ?>"
                           data-which="<?php echo $report['frequency']['which']; ?>"
                           data-hour="<?php echo $report['frequency']['hour'] == 12 ? '0': $report['frequency']['hour']; ?>"
                           data-minute="<?php echo $report['frequency']['minute']; ?>"
                           data-ampm="<?php echo $report['frequency']['ampm']; ?>"
                           data-weekday="<?php echo $report['frequency']['weekday']; ?>"
                           data-monthday="<?php echo $report['frequency']['monthday']; ?>"
                           data-attachments-pdf="<?php echo array_key_exists('pdf', $report['attachments']) ? 'true' : 'false'; ?>"
                           data-attachments-jpg="<?php echo array_key_exists('jpg', $report['attachments']) ? 'true' : 'false'; ?>"
                           data-recipients="<?php echo implode(',', $report['recipients']); ?>"
                           data-subject="<?php echo $report['subject']; ?>"
                           data-message="<?php echo $report['message']; ?>"
                           data-hide="<?php echo $report['hide'] ? 'true' : 'false'; ?>"
                           title="<?php echo _('Edit'); ?>"><i class="fa fa-pencil"></i></a>
                        <a class="view ls-tooltip" href="<?php echo site_url('reports/view/' . $report["dashboard-id"]); ?>" title="<?php echo _('View'); ?>"><i class="fa fa-chevron-right"></i></a>
                        <a class="delete ls-tooltip" href="<?php echo site_url('api/report/unschedule/' . $report['id']); ?>" title="<?php echo _('Delete'); ?>">
                        <i class="fa fa-trash"></i></a>
                    </td>
                </tr>
                    <?php } /* end foreach scheduled_reports */
                } else {
                ?>
                <tr>
                    <td colspan="6"><?php echo _("You have no reports scheduled."); ?></td>
                </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
</div>

<?php echo $footer; ?>