<?php echo $header; ?>

<script type="text/javascript">
$(document).ready(function() {
    var temp;
    $('input[name="key_type"]').click(function() {
        if ($(this).val() == 'trial') {
            temp = $('input[name="key"]').val();
            $('input[name="key"]').val('');
            $('input[name="key"]').attr('disabled', true);
        } else {
            $('input[name="key"]').val(temp);
            $('input[name="key"]').attr('disabled', false);
        }
    });
    $('a.selector').click(function() {
        var type = $(this).data('type');
        $('.select-type').hide();
        if (type == 'install') {
            $('.install').show();
        } else if (type == 'connect') {
            $('.connect').show();
        }
    });
    $('.back').click(function() {
        $('.install').hide();
        $('.connect').hide();
        $('.select-type').show();
        $('.alert').hide();
    });
    $('form').submit(function(e) {
        $(this).find('button[name="finish"]').attr('disabled', true).text("<?php echo _('Please Wait...'); ?>");
    });
});
</script>

<div class="container" id="container">

    <div class="row">
        <div class="col-sm-12">
            <div class="install-title">
                <h2><?php echo _('Final Installation Steps'); ?></h2>
                <p><?php echo _("You're almost done. Setup your instance or connect to existing cluster."); ?></p>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12 col-lg-8 col-lg-offset-2">
            <?php if (!empty($error)) { ?>
            <div class="alert alert-danger" style="text-align: center; margin-bottom: 60px;"><?php echo $error; ?></div>
            <?php } ?>
        </div>
    </div>

    <div class="select-type <?php if (!empty($type)) { echo 'hide'; } ?>">
        <div class="row">
            <div class="col-sm-offset-3 col-sm-6 col-lg-4 col-lg-offset-4">
                <a class="well no-border selector" data-type="install">
                    <i class="fa fa-hdd-o"></i>
                    <span><?php echo _('Install'); ?></span>
                    <p><?php echo _("Install a new Nagios Log Server cluster"); ?></p>
                </a>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-offset-3 col-sm-6 col-lg-4 col-lg-offset-4">
                <a class="well no-border selector" data-type="connect">
                    <i class="fa fa-plug"></i>
                    <span><?php echo _('Connect'); ?></span>
                    <p><?php echo _("Add this as an instance to an existing cluster"); ?></p>
                </a>
            </div>
        </div>
    </div>

    <div class="install <?php if ($type != 'install') { echo 'hide'; } ?>">
        <?php echo form_open('', array('class' => 'form-horizontal')); ?>
        <div class="row">
            <div class="col-sm-6 col-lg-3 col-lg-offset-2">
                <h4><?php echo _('License Setup'); ?></h4>
                <p><?php echo _('Choose a trial license, enter your key, or') . ' <a href="https://www.nagios.com/products/nagios-log-server" target="_blank">' . _('get a license now') . '</a>.'; ?></p>
            </div>
            <div class="col-sm-6 col-lg-5">
                <div class="well no-border">
                    <div class="form-group">
                        <label class="col-sm-3 control-label"></label>
                        <div class="col-sm-9">
                            <div class="radio">
                                <label><input type="radio" name="key_type" value="trial" checked> <?php echo _('Free 30 day trial'); ?></label> &nbsp; 
                                <label><input type="radio" value="key" name="key_type"> <?php echo _('I already have a key'); ?></label>
                            </div>
                        </div>
                    </div>
                    <div class="form-group" style="margin-bottom: 0;">
                        <label class="col-sm-3 control-label"><?php echo _('License Key'); ?></label>
                        <div class="col-sm-7">
                            <input type="text" class="form-control" style="width: 100%;" name="key" value="" disabled>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-6 col-lg-3 col-lg-offset-2">
                <h4><?php echo _('Admin Account Setup'); ?></h4>
                <p><?php echo _('Enter the admin account settings. The default username is nagiosadmin.'); ?></p>
            </div>
            <div class="col-sm-6 col-lg-5">
                <div class="well no-border">
                    <div class="form-group">
                        <label class="col-sm-4 control-label"><?php echo _('Username'); ?></label>
                        <div class="col-sm-8">
                            <input type="text" class="form-control" name="username" value="<?php echo ($username == '') ? 'nagiosadmin' : $username; ?>" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-4 control-label"><?php echo _('Full Name'); ?></label>
                        <div class="col-sm-8">
                            <input type="text" class="form-control" name="admin_name" value="<?php echo ($admin_name == '') ? 'Nagios Administrator' : $admin_name; ?>" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-4 control-label"><?php echo _('Password'); ?></label>
                        <div class="col-sm-8">
                            <input type="password" class="form-control" name="password" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-4 control-label"><?php echo _('Confirm Password'); ?></label>
                        <div class="col-sm-8">
                            <input type="password" class="form-control" name="conf_password" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-4 control-label"><?php echo _('Email'); ?></label>
                        <div class="col-sm-8">
                            <input type="text" class="form-control" name="email" value="<?php echo htmlspecialchars($email); ?>" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-4 control-label"><?php echo _('Language'); ?></label>
                        <div class="col-sm-8">
                            <select id="language" class="form-control" name="language">
                                <option value="default" <?php if ($user_language == 'default') { echo 'selected'; } ?>><?php echo _('Default'); ?></option>
                                <?php foreach ($languages as $l) { ?>
                                <option value="<?php echo $l; ?>" <?php if ($user_language == $language && $language == $l) { echo 'selected'; } ?>>
                                    <?php echo get_language_name($l); ?>
                                </option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group" style="margin-bottom: 0;">
                        <label class="col-sm-4 control-label"><?php echo _('Timezone'); ?></label>
                        <div class="col-sm-8">
                            <select name="timezone" class="form-control" style="min-width: 300px;">
                                <?php
                                $cur_timezone = get_current_timezone();
                                if (!empty($set_timezone)) { $cur_timezone = $set_timezone; }
                                foreach (get_timezones() as $name => $val) {
                                ?>
                                <option value="<?php echo $val; ?>" <?php if ($val == $cur_timezone) { echo 'selected'; } ?>><?php echo $name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div style="text-align: right;">
                    <input type="hidden" name="type" value="install">
                    <button type="button" class="btn btn-sm btn-default back"><i class="fa fa-chevron-left"></i> <?php echo _("Back"); ?></button>
                    <button type="submit" value="1" name="finish" class="btn btn-sm btn-primary"><?php echo _('Finish Installation'); ?> <i class="fa fa-chevron-right fa-r"></i></button>
                </div>
            </div>
        </div>
        <?php echo form_close(); ?>
    </div>

    <div class="connect <?php if ($type != 'connect') { echo 'hide'; } ?>">
        <?php echo form_open('', array('class' => 'form-horizontal')); ?>
        <div class="row">
            <div class="col-sm-6 col-lg-3 col-lg-offset-2">
                <h4><?php echo _('Connect to Existing Cluster'); ?></h4>
                <p><?php echo _('Enter your Cluster ID and the hostname or IP address of one of the instances in the existing cluster.'); ?></p>
                <p><?php echo _('To get the Cluster ID, navigate to Administration -> Cluster Status from any active instance.'); ?></p>
            </div>
            <div class="col-sm-6 col-lg-5">
                <div class="well">
                    <div class="form-group">
                        <label class="col-sm-3 col-lg-4 control-label"><?php echo _('IP Address / Hostname'); ?></label>
                        <div class="col-sm-8 col-lg-4">
                            <input type="text" name="hostname" class="form-control" style="width: 100%;" value="<?php echo $hostname; ?>">
                        </div>
                    </div>
                    <div class="form-group" style="margin-bottom: 0;">
                        <label class="col-sm-3 col-lg-4 control-label"><?php echo _('Cluster ID'); ?></label>
                        <div class="col-sm-8 col-lg-6">
                            <input type="text" name="cluster_id" class="form-control" style="width: 100%;" value="<?php echo $cluster_id; ?>">
                        </div>
                    </div>
                </div>
                <div style="text-align: right;">
                    <input type="hidden" name="type" value="connect">
                    <button type="button" class="btn btn-sm btn-default back"><i class="fa fa-chevron-left"></i> <?php echo _("Back"); ?></button>
                    <button type="submit" value="1" name="finish" class="btn btn-sm btn-primary"><?php echo _('Connect to Cluster'); ?> <i class="fa fa-chevron-right fa-r"></i></button>
                </div>
            </div>
        </div>
        <?php echo form_close(); ?>
    </div>

</div>

<?php echo $footer; ?>