$(document).ready(function() {
    function SelectAndCopyText(element) {
        var doc = document;
        var text = '';

        if (doc.body.createTextRange) { // For Internet Explorer
            var range = doc.body.createTextRange();
            range.moveToElementText(element);
            range.select();
            text = range.text;
        } else if (window.getSelection) { // For modern browsers
            var selection = window.getSelection();
            var range = doc.createRange();
            range.selectNodeContents(element);
            selection.removeAllRanges();
            selection.addRange(range);
            text = selection.toString();
        }

        // Try to use navigator.clipboard
        if (navigator.clipboard && navigator.clipboard.writeText) {
            navigator.clipboard.writeText(text).catch(function(err) {
                // Fallback for non-HTTPS
                fallbackCopyTextToClipboard(text);
            });
        } else {
            fallbackCopyTextToClipboard(text);
        }
    }

    // This is a bit troll but saving this for now for functionality
    // execCommand copy needs an input box so we create a hiden textarea to insert the text into so we can use execommand for copy
    function fallbackCopyTextToClipboard(text) {
        var textarea = document.createElement("textarea");
        textarea.value = text;
        textarea.style.position = "fixed";
        textarea.style.opacity = "0";
        textarea.style.left = "-9999px";
        document.body.appendChild(textarea);
        textarea.focus();
        textarea.select();

        try {
            document.execCommand('copy');
        } catch (err) {
            console.error('Error copying text: ', err);
        }

        document.body.removeChild(textarea);
    }

    $(".copy-button").click(function() {
        SelectAndCopyText($(this).parent().find('code').get(0));

        var iconElement = $(this);
        iconElement.addClass('fade-out');

        setTimeout(function() {
            iconElement.removeClass('fade-out fa-copy').addClass('fade-in fa-check');

            setTimeout(function() {
                iconElement.removeClass('fade-in').addClass('fade-out');

                setTimeout(function() {
                    iconElement.removeClass('fade-out fa-check').addClass('fade-in fa-copy');

                    setTimeout(function() {
                        iconElement.removeClass('fade-in');
                    }, 100);
                }, 150);
            }, 1000);
        }, 150);
    });
});
