

    ////////////////////////////////////////
    //  Polyfills
    //////////////////////////////////////// 

// Retrieved from MDN docs at 
// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/map#Polyfill
if (!Array.prototype.filter){
  Array.prototype.filter = function(func, thisArg) {
    'use strict';
    if ( ! ((typeof func === 'Function' || typeof func === 'function') && this) )
        throw new TypeError();
   
    var len = this.length >>> 0,
        res = new Array(len), // preallocate array
        t = this, c = 0, i = -1;
    if (thisArg === undefined){
      while (++i !== len){
        // checks to see if the key was set
        if (i in this){
          if (func(t[i], i, t)){
            res[c++] = t[i];
          }
        }
      }
    }
    else{
      while (++i !== len){
        // checks to see if the key was set
        if (i in this){
          if (func.call(thisArg, t[i], i, t)){
            res[c++] = t[i];
          }
        }
      }
    }
   
    res.length = c; // shrink down array to proper size
    return res;
  };
}

// Production steps of ECMA-262, Edition 5, 15.4.4.19
// Reference: http://es5.github.io/#x15.4.4.19
// Retrieved from MDN docs at 
// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/map#Polyfill
if (!Array.prototype.map) {

  Array.prototype.map = function(callback/*, thisArg*/) {

    var T, A, k;

    if (this == null) {
      throw new TypeError('this is null or not defined');
    }

    var O = Object(this);

    var len = O.length >>> 0;

    if (typeof callback !== 'function') {
      throw new TypeError(callback + ' is not a function');
    }

    if (arguments.length > 1) {
      T = arguments[1];
    }

    A = new Array(len);

    k = 0;

    while (k < len) {

      var kValue, mappedValue;

      if (k in O) {

        kValue = O[k];

        mappedValue = callback.call(T, kValue, k, O);


        // For best browser support, use the following:
        A[k] = mappedValue;
      }
      k++;
    }

    return A;
  };
}

// Production steps of ECMA-262, Edition 5, 15.4.4.17
// Reference: http://es5.github.io/#x15.4.4.17
// Retrieved from MDN docs at 
// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/some#Polyfill
if (!Array.prototype.some) {
  Array.prototype.some = function(fun, thisArg) {
    'use strict';

    if (this == null) {
      throw new TypeError('Array.prototype.some called on null or undefined');
    }

    if (typeof fun !== 'function') {
      throw new TypeError();
    }

    var t = Object(this);
    var len = t.length >>> 0;

    for (var i = 0; i < len; i++) {
      if (i in t && fun.call(thisArg, t[i], i, t)) {
        return true;
      }
    }

    return false;
  };
}

    ////////////////////////////////////////
    //  Other Utility Functions
    //////////////////////////////////////// 

/* Turn the array returned by $().serializeArray into a normal JS object */
/* This doesn't play that well with array inputs, for now */
function serializeArrayToObject(inputArray) {

    ret = {};
    for (var i = 0; i < inputArray.length; i++) {
        ret[inputArray[i]['name']] = inputArray[i]['value'];
    }

    return ret;
}



    ////////////////////////////////////////
    //  Event Binding
    //////////////////////////////////////// 

$(document).ready(function() {
    
    // Dismiss trial notice
    $('#close_trial').click(function() {
        $.post(site_url + 'api/system/dismiss_trial', { }, function(data) { });
        $('.content').removeClass('global-notice');
        $('#close_trial').parent().parent().toggle();
    });

    // Dismiss the free license version message
    $('#ignore_free_notice').click(function() {
        $.post(site_url + 'api/system/ignore_free_notice', { }, function(data) { });
        $('.content').removeClass('global-notice');
        $('#ignore_free_notice').parent().parent().toggle();
    });

    // Dismiss the eol message
    $('#ignore_eol_notice').click(function() {
        $.post(site_url + 'api/system/ignore_eol_notice', { }, function(data) { });
        $('.content').removeClass('global-notice');
        $('#ignore_free_notice').parent().parent().toggle();
    });

    // Resize the navbar on the config editor pages
    var resize_cfg_navbar = function() {
        if ($('.config-editor-side').length) {
            var height = $(window).height() - 250;
            $('.config-editor-side').css('height', height+"px");
        }
    }
    
    var resize_admin_navbar = function() {
        if ($('.admin-leftbar').length) {
            var height = $(window).height() - 250;
            $('.admin-leftbar').css('height', height+"px");
            var well_height = $('.admin-leftbar').height() - 52 - $('.admin-leftbar .well:first').height();
            $('.admin-leftbar .well:last').css('height', well_height+"px");
        }
    }

    // Auto height resizing

    $(window).resize(function() {
        $('.fix-height').height('auto');
        $('.fix-height').each(function() {
            $(this).height($(this).height());
        });
    });

    $('.fix-height').each(function() {
        $(this).height($(this).height());
    });

    // Get the status of the server and check every minute after
    get_server_status();
    setInterval(get_server_status, 1*60*1000);

    // Resize the configure menu sidebar
    resize_cfg_navbar();
    resize_admin_navbar();
    $(window).resize(function() {
        resize_cfg_navbar();
        resize_admin_navbar();

        // Resize bootstrap on small window
        //var max_height = $(window).height() - 120;
        //$(".modal").css({ "height": max_height, "overflow-y": "auto" });
    });
    
    // Select all in select-all class boxes
    $('.select-all').click(function() {
        $(this).select();
    });

    ////////////////////////////////////////
    //  Grid functions
    ////////////////////////////////////////
    $('.hide-grid').click(function () {
        $(this).parent().parent('.grid-title').parent('.grid').children('.grid-content').toggleClass('hide');
    })
    
    ////////////////////////////////////////
    //  Navbar Search Redirection
    ////////////////////////////////////////
    $('.navbar-search').submit(function (e) {
        e.preventDefault(); //STOP default action
        querystring=$(this).serialize().replace(/\+/g,'%20');
        window.location.replace($(this).attr('action') + "?" + querystring);
    });

    if ($.fn.tooltip !== undefined) {
        $('.ls-tooltip').tooltip({ container: 'body' });
        $('body').tooltip({
            selector: '.tt-bind'
        });
    }

    if ($.fn.popover !== undefined) {
        $('.ls-pop').popover({ container: 'body' });
        $('body').popover({
            selector: '.pop',
            html: true
        });
    }

    jQuery.fn.extend({
        //use example: $('textarea').insertAtCaret( 'some string of characters' );
        insertAtCaret: function(myValue){
          return this.each(function(i) {
            if (document.selection) {
              //For browsers like Internet Explorer
              this.focus();
              var sel = document.selection.createRange();
              sel.text = myValue;
              this.focus();
            }
            else if (this.selectionStart || this.selectionStart == '0') {
              //For browsers like Firefox and Webkit based
              var startPos = this.selectionStart;
              var endPos = this.selectionEnd;
              var scrollTop = this.scrollTop;
              this.value = this.value.substring(0, startPos)+myValue+this.value.substring(endPos,this.value.length);
              this.focus();
              this.selectionStart = startPos + myValue.length;
              this.selectionEnd = startPos + myValue.length;
              this.scrollTop = scrollTop;
            } else {
              this.value += myValue;
              this.focus();
            }
          });
        }    
    });

    // Confirgure text box coolness
    $(".box-wrapper").on('keydown', 'textarea', function(e) { 
        var keyCode = e.keyCode || e.which;
        if (keyCode == 9) {
            e.preventDefault();
            $(this).insertAtCaret('    '); // Inserts a "tab" made of spaces...
        } 
    });

    // Configure advanced settings
    $(".nodes-toggle-advanced").click(function() {
        if ($(this).find('i').hasClass('fa-caret-up')) {
            $(this).find('i').removeClass('fa-caret-up');
            $(this).find('i').addClass('fa-caret-down');
            $('.nodes').show();
        } else {
            $(this).find('i').removeClass('fa-caret-down');
            $(this).find('i').addClass('fa-caret-up');
            $('.nodes').hide();
        }
    });

    // ===================================
    // Paging options
    // ===================================

    $('.results-per-page').change(function() {
        var num = $(this).val();
        if (num == 'c') {
            $('.custom-box').show(); // Custom page size
        } else {
            $('.custom-box').hide();
            $('.pp').val(num);
            $('form.pp-form').submit();
        }
    });

    $('.custom-box .custom').keyup(function(e) {
        if (e.keyCode == '13') {
            $('.custom-box .save-custom').trigger('click');
        }
    });

    $('.custom-box .save-custom').click(function() {
        var num = parseInt($('.custom-box .custom').val());
        if (num > 0) {
            $('.pp').val(num);
            $('form.pp-form').submit();
        }
    });

    // Remove panel-container on homepage
    if ($('.home-container').length > 0) {
        $('.home-container').find('.panel-extra').css('border', 'none');
    }
        
    ////////////////////////////////////////
    //  Backup Management
    //////////////////////////////////////// 
    // delete repository
    $('.delete-repository').click(function(e) {
        if (is_demo_mode) {
            alert(_("This function is not available in demo mode."));
            return false;
        }
        var repo = $(this).children().first().val();
        var conf = confirm(_("Are you sure you want to PERMANENTLY DELETE repository") + " " + repo + "?");
        if (conf == true && (typeof(repo) !== 'undefined') && (repo.length > 0)) {
            $.ajax({
                url: site_url + 'api/backend/_snapshot/' + repo,
                type: 'DELETE',
                success: function(data) {
                    if (data.success == 0) {
                        alert(data.errormsg);
                    } else {
                        window.location.href = window.location.href;
                    }
                }
            });
        }
    });

    $('.btn-create-repo').click(function() {
        $('#create-repo-modal').modal('show');
    });


    // Restore snapshot modal
    $('.restore-index').click(function() {
        if (is_demo_mode) {
            alert(_("This function is not available in demo mode."));
            return false;
        }

        var repo = $(this).data('repo');
        var index_name = $(this).data('index');
        var per_snapshot = $(this).data('other');
        $('.restore-snapshots').html('');

        for (key in per_snapshot) {
            var current_snapshot = per_snapshot[key];
            var start_time = new Date(current_snapshot.start_time_in_millis);
            $('.restore-snapshots').append('<tr><td style="width: 20px; text-align: right;"><input type="radio" name="'+repo+'" id="choose-'+current_snapshot.curator_name+'" value="'+current_snapshot.curator_name+'" class="rsi"></td><td><label for="choose-'+current_snapshot.curator_name+'" style="font-weight: 400;">'+start_time.toString()+'</label></td></tr>');
        }

        // Things we know we need.
        $('.restore-index-name').html(index_name);
        $('.restore-repo').val(repo);

        $('#restore-modal').modal('show');
    });

    // View indexes in snapshot
    $('.show-indexes').click(function() {
        var repo = $(this).data('repo');
        var snapshot = $(this).data('snapshot');
        var created_date = $(this).data('created');

        $('.snapshot-time').html(created_date);
        $('.indexes-modal-list').html('');

        $.get(site_url + 'api/backend/_snapshot/' + repo + '/' + snapshot, {}, function(data) {

            if (data.snapshots[0].indices.length > 0) {
                $(data.snapshots[0].indices).each(function(k, v) {
                    $('.indexes-modal-list').append('<tr><td>'+v+'</td></tr>');
                });
            
                // Check everything
                $('#checkall').prop('checked', false);
                $('#checkall').click();

                $('#indexes-modal').modal('show');
            } else {
                alert(_('Could not find indices in snapshot.'));
            }

        });
    });

    $('.restore-indices').on('click', 'tr', function(e) {
        if (is_demo_mode) {
            alert(_("This function is not available in demo mode."));
            return false;
        }
        if ($(e.target).hasClass('rsi')) { return; }
        if ($(this).find('.rsi').is(':checked')) {
            $(this).find('.rsi').prop('checked', false);
        } else {
            $(this).find('.rsi').prop('checked', true);
        }
    });

    $('#checkall').click(function() {
        if ($(this).is(':checked')) {
            $('.rsi').prop('checked', true);
        } else {
            $('.rsi').prop('checked', false);
        }
    });

    $('#do-restore').click(function() {
        if (is_demo_mode) {
            alert(_("This function is not available in demo mode."));
            return false;
        }

        var repo = $('.restore-repo').val();
        var index = $('.restore-index-name').html().split(', ');

        var curator_name = $('.rsi:checked').val();

        // Do actual restore
        restore_snapshot(repo, curator_name, [index]);
        $(this).button('loading');
    });
    
    $('.action-restore-indices').change(function() {
        var action = this.value;
        var repo = $(this).data('repo');
        var repo_class = repo.replace(" ", "-");
        var selected = $('input.'+repo_class+'[name=sel]:checked');
        var indices = selected.map(function() { return this.value }).toArray();

        if (indices.length === 0) {
            alert(_('No indices selected'));
            $(this).val('');
            return;
        }

        // the "Restore" buttons hold a lot of the data
        var selected_buttons = selected.parent().parent().children('td').children('button');

        // Each index gets an array of relevant snapshot objects
        var restore_objects = selected_buttons.map(function() { return [$(this).data('other')]; }).toArray();

        switch (action) {
            case 'restore':
                // Retrieve only the snapshots that hold all of these indices (set intersection)
                var snapshot_objects = restore_objects[0].map(function(obj) { return JSON.stringify(obj); });

                var intersecting_array;
                for (key in restore_objects) {
                    // Get the objects from the next index, convert them to JSON strings.
                    intersecting_array = restore_objects[key].map(function(obj) { return JSON.stringify(obj); });
                    // Save the intersection of the two arrays.
                    snapshot_objects = snapshot_objects.filter(
                        function(item_a) { 
                            return intersecting_array.some(
                                function (item_b) { 
                                    return item_a === item_b; 
                            }); 
                    });
                }

                snapshot_objects = snapshot_objects.map(function(json_string) { return JSON.parse(json_string); });

                if (snapshot_objects.length === 0) {
                    alert(_("No snapshot contains every one of these indices."));
                    return;
                }

                $('.restore-snapshots').html('');

                for (key in snapshot_objects) {
                    var current_snapshot = snapshot_objects[key];
                    var start_time = new Date(current_snapshot.start_time_in_millis);
                    $('.restore-snapshots').append('<tr><td style="width: 20px; text-align: right;"><input type="radio" name="'+repo+'" id="choose-'+current_snapshot.curator_name+'" value="'+current_snapshot.curator_name+'" class="rsi"></td><td><label for="choose-'+current_snapshot.curator_name+'" style="font-weight: 400;">'+start_time.toString()+'</label></td></tr>');
                }

                // Things we know we need.
                $('.restore-index-name').html(indices.join(', '));
                $('.restore-repo').val(repo);

                $('#restore-modal').modal('show');

                break;
            default:
                break;
        }
    });

    // Loads the modal for snapshot deletion
    $('.show-delete-snapshots').click(function() {
        if (is_demo_mode) {
            alert(_("This function is not available in demo mode."));
            return false;
        }

        // string
        var repo = $(this).data('repo');
        // array of objects like {snapshot: 'curator-name', start_time_in_millis: 1234567890000}
        var snapshots = $(this).data('snapshots');

        $('.delete-snapshots').html('');

        for (key in snapshots) {
            var name = snapshots[key].snapshot;
            var time = new Date(snapshots[key].start_time_in_millis).toString();

            $('.delete-snapshots').append('<tr><td style="width: 20px; text-align: right;"><input type="checkbox" name="'+name+'" id="delete-choose-'+name+'" value="'+name+'" class="rsi rsi-delete"></td><td><label for="delete-choose-'+name+'" style="font-weight: 400;">'+time+'</label></td></tr>');
        }
        $('.repo-name').html(repo);

        $('#delete-snapshot-modal').modal('show');
    });

    // Clicked from the modal, actually deletes the specific snapshot(s).
    $('#do-delete-snapshots').click(function() {
        if (is_demo_mode) {
            alert(_("This function is not available in demo mode."));
            return false;
        }

        var snapshots = $('.rsi-delete:checked').map(function() { return this.value; });
        var repo = $('.repo-name').html();
        $(this).button('loading');

        var finished_count = 0;
        var errmsgs = '';
        snapshots.each(function() {
            $.ajax({
                url: site_url + 'api/backend/_snapshot/' + repo + "/" + this,
                type: 'DELETE',
                success: function (data) {
                    if (data.acknowledged != true) {
                        errmsgs += data.error + "\n";
                    }
                },
                complete: function() {
                    finished_count += 1;
                    $('.deletion-progress').html('(' + finished_count + '/' + snapshots.length + ')');
                    var log = {
                        type: 'BACKUP',
                        message: 'Snapshot deleted: ' + finished_count + '/' + snapshots.length
                    };
                    $.post(site_url + 'api/log/create', { log: log }, function() {});
                }
            });
            $('.deletion-progress').html('(0/' + snapshots.length + ')');
        });

        var function_tracker = setInterval(function() {
            if (finished_count === snapshots.length) {
                if (errmsgs !== '') {
                    $('#do-delete-snapshots').button('reset');
                    alert(errmsgs);
                }
                window.location.href = window.location.href;
                clearInterval(function_tracker);
            }
        }, 500);
    });
});

// Do ajax request for server status and build the status HTML
function get_server_status() {
    if (!logged_in) { return; }

    $.post(site_url + 'api/system/system_service_status', { }, function(data) {
        if (data.error) {
            var message = String(data.message);
            data = "<span class='pop header-pop' data-placement='bottom' " + 'data-content="<div class=\'system-service\'>' + message + '</div>"' + "><img class='tt-bind' data-placement='left' src='" + site_url + "media/icons/error.png' title='" + message.replace('.', '') + "'></span>";
        }
        $('.system-alerts').html(data);               
    });
}

function restore_snapshot(repo, snapshot, indices)
{
    $.get(site_url + 'api/backend/_cluster/state/metadata/' + snapshot, { }, function(data) {
        if (typeof(data.metadata.indices[snapshot]) !== 'undefined' && data.metadata.indices[snapshot].state != 'close') {
            alert(_('You cannot restore an opened index'));
            return;
        } else {
            if ((typeof(repo) !== 'undefined') && (repo.length > 0) && (typeof(snapshot) !== 'undefined') && (snapshot.length > 0)) {

                var ids = '';
                if (indices.length > 0) {
                    ids = '{ "indices": "' + indices.join(',') + '" }';
                }

                $.ajax({
                    type: 'POST',
                    url: site_url + 'api/backend/_snapshot/' + repo + "/" + snapshot + "/_restore",
                    data: ids,
                    dataType: 'json',
                    contentType: 'text/plain',
                    success: function(data) {
                        if (data == null) {
                            alert(_('Can not restore index(s). One or more indices selected may already be open.'));
                            $('#do-restore').button('reset');
                            return;
                        }
                        if (data.accepted != true) {
                            alert(data.error);
                        } else {
                            window.location.href = window.location.href + '?restoring=' + snapshot;
                        }
                }});
            }
        }
    });
}

// Used to escape meta-characters in jQuery selectors
function selector_escape(str_in)
{
    if (typeof CSS !== "undefined" && typeof CSS.escape !== "undefined") {
        return CSS.escape(str_in);
    }

    var meta_characters = /[!"#\$%&'()*+,./:;<=>?@\[\\\]^`{|}~]/g;
    return str_in.replace(meta_characters, '\\$&');
}
