// Function to start/stop/restart
function run_action(event) {
    var key = $('#node-select option:selected').val();

    var service = $(event.target).parent().data('service');
    var action = $(event.target).data('action');
    var display_service = service.charAt(0).toUpperCase() + service.slice(1);

    var log = {
        type: 'INFO',
        message: display_service + ' ' + action + ' initiated'
    };
    $.post(site_url + 'api/log/create', { log: log }, function() {
        window.location.href = window.location.href;
    }).done(do_service_action(key, service, action));
};

function check_node(key, endpoint, subsystem, action) {
    // Split out the hostname, ipaddress and id
    var keyValues = key.split('|', 3);

    var hostname = keyValues[0];
    var ipaddress = keyValues[1];

    // Get the address of this server.
    var protocol = window.location.protocol;
    var port = ":" + window.location.port;
    port = (port === ':') ? '' : port;
    var url = protocol + '//' + hostname + port + endpoint;

    var checkNodeUrl = "/nagioslogserver/api/system/check_node_status";
    var returnData = '';
    var fallback = false;

    // Check the url with the hostname.  If it does not resolve, fallback to the ip address.
    // NOTE: This has to be "synchronized"/wait for the answer.
    // NOTE: Synchronized is DEPRECATED, but jQuery overrides the other javascript methods.
    $.ajax({
        type: 'POST',
        url: checkNodeUrl,
        data: { token: apikey,
                action: action,
                protocol: protocol,
                endpoint: port + endpoint,
                hostname: hostname,
                ipaddress: ipaddress,
                subsystem: subsystem,
                thisHostname: hostname
            },
        dataType: 'json',
        async: false
    })
    .done(function(data) {
        returnData = {
            'url': url,
            'data': data.data, 
            'status': data.status,
            'statusText': data.statusText,
        }
    })
    .fail(function(response) {
        returnData = {
            'url': '',
            'status': response.status,
            'statusText': response.statusText,
        }
    })

    return JSON.stringify(returnData);
}

function check_service(key, service)
{
    var endpoint = "/nagioslogserver/api/system/status";

    var img = '';
 
    // Get the "correct" url (hostname/ipaddress)
    jsonResponse = check_node(key, endpoint, service, '');
    response = JSON.parse(jsonResponse);

    // Check if check_node() failed - likely PHP error.
    if (response.status != 'success') {
        // There was likely an internal error (PHP) from check_node().
        img = base_url+"media/icons/error.png";

        $('#'+service+'-status').html('<img class="tt-bind" data-placement="right" title="'+response.statusText+'" src="'+img+'">');
        $('#'+service+'-actions').html('[ <span style="color: red">'+(response.status > 0 ? response.status+': ' : '')+response.statusText+'</span> ]');

        // Do not allow on click action
        $('#'+service+'-actions').removeClass('service-actions');

        return;
    }

    var data = JSON.parse(response.data);

    if (data.status == "running") {
        img = base_url+"media/icons/accept.png";
    } else if (data.status == "stopped") {
        img = base_url+"media/icons/exclamation.png";
    } else {
        img = base_url+"media/icons/error.png";
    }

    $('#'+service+'-status').html('<img class="tt-bind" data-placement="right" title="'+data.message+'" src="'+img+'">');

    if (data.status == "running") {
        var stop = "";

        if (service != "elasticsearch") {
            stop = '[ <i class="fa fa-stop"></i> <a data-action="stop">'+stopText+'</a> ]';
        }

        $('#'+service+'-actions').html('[ <i class="fa fa-refresh"></i> <a data-action="restart">'+restartText+'</a> ] '+stop);
    } else if (data.error != 1 && service != "elasticsearch") {
        $('#'+service+'-actions').html('[ <i class="fa fa-play"></i> <a data-action="start">'+startText+'</a> ]');
    } else if (data.error == 1 && service == "elasticsearch") {
        // TODO: WHAT DO WE NEED TO DO IN THIS SITUATION?
        console.log("ERROR: check_service(): key ["+key+"] service ["+service+"]");
        console.log("data");
        console.log(data);
    }

    // Make sure the action is attached.
    $('#'+service+'-actions').addClass('service-actions');
    $('.service-actions').on('click', 'a', function (event) {
        run_action(event);
    });
}

function clear_all_status()
{
    $('.status').html('<i class="fa fa-spinner fa-pulse fa-fw fa-loader"></i>');
    $('span[id$=-actions').html('');
}

function do_service_action(key, service, action)
{
    var endpoint = "/nagioslogserver/api/system/";

    $('#'+service+'-status').html('<i class="fa fa-spinner fa-pulse fa-fw fa-loader"></i>');

    // Get the "correct" url (hostname/ipaddress)
    jsonResponse = check_node(key, endpoint, service, action);
    response = JSON.parse(jsonResponse);

    var data = JSON.parse(response.data);

    setTimeout(check_all_services, 2000);
    setTimeout(get_server_status, 2000);
}
