#!/bin/bash

# Useful for separating command titles
# from their contents
underline()
{
    echo "--------------------------"
    echo ""
}

# Useful for separating different
# command contents in same file
section()
{
    echo ""
    echo "**************************"
    echo ""
}

# Determine if a command exists
is_command()
{
    which "$1" >/dev/null 2>&1
}

profilename="system-profile"

profiledir="system-profile"
basedir="/tmp/"
dir="$basedir/$profiledir"


rm -f "$basedir/${profilename}.tar.gz"
rm -rf "$dir"
mkdir -p "$dir"


echo "Current date" > "$dir/timestamp.txt"
underline >> "$dir/timestamp.txt"
date >> "$dir/timestamp.txt"


echo "Version" > "$dir/lsversion.txt"
underline >> "$dir/lsversion.txt"
cat /var/www/html/nagioslogserver/lsversion >> "$dir/lsversion.txt" 2>&1

echo "CPU Info" > "$dir/cpu-info.txt"
underline >> "$dir/cpu-info.txt"
cat /proc/cpu-info >> "$dir/cpu-info.txt"

echo "curl -s 'localhost:9200/_cat/master?v'" > "$dir/masters.txt"
underline >> "$dir/masters.txt"
curl -s "localhost:9200/_cat/master?v" >> "$dir/masters.txt" 2>&1


echo "curl -s 'localhost:9200/_cat/nodes?v'" > "$dir/nodes.txt"
underline >> "$dir/nodes.txt"
curl -s "localhost:9200/_cat/nodes?v" >> "$dir/nodes.txt" 2>&1


echo "curl -s 'localhost:9200/_cluster/health/*?level=shards&pretty'" > "$dir/shard-health.txt"
underline >> "$dir/shard-health.txt"
curl -s "localhost:9200/_cluster/health/*?level=shards&pretty" >> "$dir/shard-health.txt" 2>&1


echo "curl -s 'localhost:9200/_cat/shards?pretty'" > "$dir/shard-status.txt"
underline >> "$dir/shard-status.txt"
curl -s "localhost:9200/_cat/shards?pretty" >> "$dir/shard-status.txt" 2>&1


echo "curl -s 'localhost:9200/_cat/indices?pretty'" > "$dir/indices-status.txt"
underline >> "$dir/indices-status.txt"
curl -s "localhost:9200/_cat/indices?pretty" >> "$dir/indices-status.txt" 2>&1


echo "curl -s 'localhost:9200/_nodes/jvm?pretty'" > "$dir/jvm-status.txt"
underline >> "$dir/jvm-status.txt"
curl -s "localhost:9200/_nodes/jvm?pretty" >> "$dir/jvm-status.txt" 2>&1


echo "curl -s 'localhost:9200/_cluster/state?pretty'" > "$dir/cluster.txt"
underline >> "$dir/cluster.txt"
curl -s "localhost:9200/_cluster/state?pretty" >> "$dir/cluster.txt" 2>&1


echo "curl -s 'localhost:9200/_cat/pending_tasks?v'" > "$dir/pending-tasks.txt"
underline >> "$dir/pending-tasks.txt"
curl -s "localhost:9200/_cat/pending_tasks?v" >> "$dir/pending-tasks.txt" 2>&1


echo "curl -s 'localhost:9200/_cat/recovery?v'" > "$dir/recovery.txt"
underline >> "$dir/recovery.txt"
curl -s "localhost:9200/_cat/recovery?v" >> "$dir/recovery.txt" 2>&1


echo "curl -s 'localhost:9200/_cat/plugins?v'" > "$dir/plugins.txt"
underline >> "$dir/plugins.txt"
curl -s "localhost:9200/_cat/plugins?v" >> "$dir/plugins.txt" 2>&1


echo "/usr/local/nagioslogserver/logstash/bin/plugin list" > "$dir/logstash-plugins.txt"
underline >> "$dir/logstash-plugins.txt"
/usr/local/nagioslogserver/logstash/bin/plugin list >> "$dir/logstash-plugins.txt" 2>&1


echo "free -m" > "$dir/memory.txt"
underline >> "$dir/memory.txt"
free -m >> "$dir/memory.txt" 2>&1


echo "ps aux" > "$dir/psaux.txt"
underline >> "$dir/psaux.txt"
ps aux >> "$dir/psaux.txt" 2>&1


if is_command "netstat"; then
    echo "netstat -an" > "$dir/netstat.txt"
    underline >> "$dir/netstat.txt"
    netstat -an >> "$dir/netstat.txt" 2>&1
fi

if is_command "dmidecode"; then
    echo "dmidecode -s system-manufacturer" > "$dir/dmidecode.txt"
    underline >> "$dir/dmidecode.txt"
    dmidecode -s system-manufacturer >> "$dir/dmidecode.txt"
fi

echo "node_uuid" >> "$dir/node_uuid.txt"
underline >> "$dir/node_uuid.txt"
cat "/usr/local/nagioslogserver/var/node_uuid" >> "$dir/node_uuid.txt"

echo "df -h" > "$dir/disk.txt"
underline >> "$dir/disk.txt"
df -h >> "$dir/disk.txt" 2>&1
section >> "$dir/disk.txt"

echo "df -ih" >> "$dir/disk.txt"
underline >> "$dir/disk.txt"
df -ih >> "$dir/disk.txt" 2>&1


if is_command "ifconfig"; then
    echo "ifconfig" > "$dir/network.txt"
    underline >> "$dir/network.txt"
    ifconfig >> "$dir/network.txt" 2>&1
    section >> "$dir/network.txt"
fi


echo "ip a" >> "$dir/network.txt"
underline >> "$dir/network.txt"
ip a >> "$dir/network.txt" 2>&1


if is_command "iptables"; then
    echo "iptables -S" > "$dir/iptables.txt"
    underline >> "$dir/iptables.txt"
    iptables -S >> "$dir/iptables.txt" 2>&1
fi


if is_command "firewall-cmd"; then
    echo "firewall-cmd --list-all-zones" > "$dir/firewalld.txt"
    underline >> "$dir/firewalld.txt"
    firewall-cmd --list-all-zones >> "$dir/firewalld.txt" 2>&1
fi


if is_command "ufw"; then
    echo "ufw status" > "$dir/ufw.txt"
    underline >> "$dir/ufw.txt"
    ufw status >> "$dir/ufw.txt" 2>&1
fi


# Copy entire Logstash conf.d dir
if [ -d /usr/local/nagioslogserver/logstash/etc/conf.d ]; then
    cp -r /usr/local/nagioslogserver/logstash/etc/conf.d "$dir/logstash-confd"
fi


echo "ls -alhR /store" > "$dir/store.txt"
underline >> "$dir/store.txt"
ls -alhR /store >> "$dir/store.txt" 2>&1


# Try and get Apache logs
mkdir "$dir/apachelogs/"
if [ -d /var/log/httpd ]; then
    cp /var/log/httpd/*_log "$dir/apachelogs"
elif [ -d /var/log/apache2 ]; then
    cp /var/log/apache2/*.log "$dir/apachelogs"
else
    echo "No apache logs found!" > "$dir/apachelogs/no_logs.txt"
fi

# Remove any symlinks and gzipped logs from apachelogs/
find "$dir/apachelogs" -type l -exec rm -f {} \;


# Try and get syslog
if [ -f "/var/log/messages" ]; then
    cp /var/log/messages "$dir/systemlog.txt"
elif [ -f "/var/log/syslog" ]; then
    cp /var/log/syslog "$dir/systemlog.txt"
else
    echo "No /var/log/{messages,syslog} found!" > "$dir/systemlog.txt"
fi


cp -r /var/log/elasticsearch "$dir/elasticsearchlog"
cp -r /var/log/logstash "$dir/logstashlogs"


cd "$basedir"
tar -zcvf "${profilename}.tar.gz" "$profiledir"

rm -rf "$profiledir"
