<?php
require_once('../setlang.inc.php');
?>
// Language variables for plugging into Kibana (for JS portions)
var lang = {
    'histogram_desc': "<?php echo escape_html(_('A bucketed time series chart of the current query or queries. Uses the Elasticsearch date_histogram facet. If using time stamped indices this panel will query them sequentially to attempt to apply the lighest possible load to your Elasticsearch cluster')); ?>",
    'histogram': "<?php echo escape_html(_('Histogram')); ?>",
    'remove': "<?php echo escape_html(_('Remove')); ?>",
    'panel': "<?php echo escape_html(_('panel')); ?>",
    'remove_this': "<?php echo escape_html(_('Are you sure you want to remove this')); ?>",
    'drag_me': "<?php echo escape_html(_('Drag here to move')); ?>",
    'query': "<?php echo escape_html(_('query')); ?>",
    'Queries': "<?php echo escape_html(_('Queries')); ?>",
    'Inspect': "<?php echo escape_html(_('Inspect')); ?>",
    'Style': "<?php echo escape_html(_('Style')); ?>",
    'filtering': "<?php echo escape_html(_('filtering')); ?>",
    'bettermap_desc': "<?php echo escape_html(_('Displays geo points in clustered groups on a map. The caveat for this panel is that, for better or worse, it does NOT use the terms facet and it DOES query sequentially. This however means that it transfers more data and is generally heavier to compute, while showing less actual data. If you have a time filter, it will attempt to show to most recent points in your search, up to your defined limit.')); ?>",
    'column_desc': "<?php echo escape_html(_('A pseudo panel that lets you add other panels to be arranged in a column with defined heights.')); ?>",
    'dashcontrol_desc': "<?php echo escape_html(_('This panel has been moved to the navigation bar. See the dashboard setting editor to configure it.')); ?>",
    'Local Default Set': "<?php echo escape_html(_('Local Default Set')); ?>",
    'Incompatible Browser': "<?php echo escape_html(_('Incompatible Browser')); ?>",
    'Dashboard Saved': "<?php echo escape_html(_('Dashboard Saved')); ?>",
    'This dashboard has been saved to Elasticsearch as': "<?php echo escape_html(_('This dashboard has been saved to Elasticsearch as')); ?>",
    'Save Failed': "<?php echo escape_html(_('Save Failed')); ?>",
    'Dashboard could not be saved to Elasticsearch': "<?php echo escape_html(_('Dashboard could not be saved to Elasticsearch')); ?>",
    'Your local default dashboard has been cleared': "<?php echo escape_html(_('Your local default dashboard has been cleared')); ?>",
    'Sorry, your browser is too old for this feature': "<?php echo escape_html(_('Sorry, your browser is too old for this feature')); ?>",
    'has been set as your local default': "<?php echo escape_html(_('has been set as your local default')); ?>",
    'Dashboard Deleted': "<?php echo escape_html(_('Dashboard Deleted')); ?>",
    'has been deleted': "<?php echo escape_html(_('has been deleted')); ?>",
    'Dashboard Not Found': "<?php echo escape_html(_('Dashboard Not Found')); ?>",
    'Could not find': "<?php echo escape_html(_('Could not find')); ?>",
    'in Elasticsearch': "<?php echo escape_html(_('in Elasticsearch')); ?>",
    'Dashboard Not Deleted': "<?php echo escape_html(_('Dashboard Not Deleted')); ?>",
    'An error occurred deleting the dashboard': "<?php echo escape_html(_('An error occurred deleting the dashboard')); ?>",
    'Gist saved': "<?php echo escape_html(_('Gist saved')); ?>",
    'You will be able to access your exported dashboard file at': "<?php echo escape_html(_('You will be able to access your exported dashboard file at')); ?>",
    'Gist could not be saved': "<?php echo escape_html(_('Gist could not be saved')); ?>",
    'Gist Failed': "<?php echo escape_html(_('Gist Failed')); ?>",
    'Could not retrieve dashboard list from gist': "<?php echo escape_html(_('Could not retrieve dashboard list from gist')); ?>",
    'Problem': "<?php echo escape_html(_('Problem')); ?>",
    'Sorry, the HTML5 File APIs are not fully supported in this browser.': "<?php echo escape_html(_('Sorry, the HTML5 File APIs are not fully supported in this browser.')); ?>",
    'in a moment': "<?php echo escape_html(_('in a moment')); ?>",
    'derivequeries_desc': "<?php echo escape_html(_('This panel has been replaced with the topN mode in the query pull down.')); ?>",
    'fields_desc': "<?php echo escape_html(_('You should not use this table, it does not work anymore. The table panel now integrates a field selector. This module will soon be removed.')); ?>",
    'filtering_desc': "<?php echo escape_html(_('A controllable list of all filters currently applied to the dashboard. You almost certainly want one of these on your dashboard somewhere.')); ?>",
    'goal_desc': "<?php echo escape_html(_('Displays the progress towards a fixed goal on a pie chart')); ?>",
    'hits_desc': "<?php echo escape_html(_('The total hits for a query or set of queries. Can be a pie chart, bar chart, list, or absolute total of all queries combined')); ?>",
    'map_desc': "<?php echo escape_html(_('Displays a map of shaded regions using a field containing a 2 letter country, or US state, code. Regions with more hit are shaded darker. Node that this does use the Elasticsearch terms facet, so it is important that you set it to the correct field.')); ?>",
    'query_desc': "<?php echo escape_html(_('Manage all of the queries on the dashboard. You almost certainly need one of these somewhere. This panel allows you to add, remove, label, pin and color queries')); ?>",
    'sparklines_desc': "<?php echo escape_html(_('Sparklines are tiny, simple, time series charts, shown separately. Because sparklines are uncluttered by grids, axis markers and colors, they are perfect for spotting change in a series')); ?>",
    'auto': "<?php echo escape_html(_('auto')); ?>",
    'In': "<?php echo escape_html(_('In')); ?>",
    'mode a field must be specified': "<?php echo escape_html(_('mode a field must be specified')); ?>",
    'stats_desc': "<?php echo escape_html(_('A statistical panel for displaying aggregations using the Elastic Search statistical facet query')); ?>",
    'Paging': "<?php echo escape_html(_('Paging')); ?>",
    'table_desc': "<?php echo escape_html(_('A paginated table of records matching your query or queries. Click on a row to expand it and review all of the fields associated with that document.')); ?>",
    'Top 10 terms in field': "<?php echo escape_html(_('Top 10 terms in field')); ?>",
    'Statistics for': "<?php echo escape_html(_('Statistics for')); ?>",
    'terms_desc': "<?php echo escape_html(_('Displays the results of an elasticsearch facet as a pie chart, bar chart, or a table')); ?>",
    'Missing field': "<?php echo escape_html(_('Missing field')); ?>",
    'Other values': "<?php echo escape_html(_('Other values')); ?>",
    'The Rest': "<?php echo escape_html(_('The Rest')); ?>",
    'text_desc': "<?php echo escape_html(_('A static text panel that can use plain text, markdown, or (sanitized) HTML')); ?>",
    'timepicker_desc': "<?php echo escape_html(_('A panel for controlling the time range filters. If you have time based data, or if you use time stamped indices, you need one of these')); ?>",
    'trends_desc': "<?php echo escape_html(_('A stock-ticker style representation of how queries are moving over time. For example, if the time is 1:10pm, your time picker was set to Last 10m, and the Time ago parameter was set to 1h, the panel would show how much the query results have changed since 12:00-12:10pm')); ?>",
    'Time field must be consistent amongst time filters': "<?php echo escape_html(_('Time field must be consistent amongst time filters')); ?>",
    'A time filter must exist for this panel to function': "<?php echo escape_html(_('A time filter must exist for this panel to function')); ?>",
    'The dashboard file you want to upload is malformed, please correct it and retry.': "<?php echo escape_html(_('The dashboard file you want to upload is malformed, please correct it and retry.')); ?>",
    'Are you sure you want to do that?': "<?php echo escape_html(_('Are you sure you want to do that?')); ?>",
    'Configure': "<?php echo escape_html(_('Configure')); ?>",
    'loading': "<?php echo escape_html(_('loading')); ?>",
    'There were no results because no indices were found that match your selected time span': "<?php echo escape_html(_('There were no results because no indices were found that match your selected time span')); ?>",
    'No Results': "<?php echo escape_html(_('No Results')); ?>",
    'No time filter': "<?php echo escape_html(_('No time filter')); ?>",
    'Timestamped indices are configured without a failover. Waiting for time filter.': "<?php echo escape_html(_('Timestamped indices are configured without a failover. Waiting for time filter.')); ?>",
    'Error': "<?php echo escape_html(_('Error')); ?>",
    'No Dashboard': "<?php echo escape_html(_('No Dashboard')); ?>",
    'The dashboard you had selected no longer exists. Try loading a different dashboard.': "<?php echo escape_html(_('The dashboard you had selected no longer exists. Try loading a different dashboard.')); ?>",
    'Please make sure it exists': "<?php echo escape_html(_('Please make sure it exists')); ?>",
    'Could not load': "<?php echo escape_html(_('Could not load')); ?>",
    'Could not contact Elasticsearch at': "<?php echo escape_html(_('Could not contact Elasticsearch at')); ?>",
    'Please ensure that Elasticsearch is reachable from your system.': "<?php echo escape_html(_('Please ensure that Elasticsearch is reachable from your system.')); ?>",
    'Could not find': "<?php echo escape_html(_('Could not find')); ?>",
    'If you are using a proxy, ensure it is configured correctly': "<?php echo escape_html(_('If you are using a proxy, ensure it is configured correctly')); ?>",
    'Please make sure it exists and returns a valid dashboard': "<?php echo escape_html(_('Please make sure it exists and returns a valid dashboard')); ?>",
    'You must enter an alert name.': "<?php echo escape_html(_('You must enter an alert name.')); ?>",
    'You must enter a check interval and lookback period.': "<?php echo escape_html(_('You must enter a check interval and lookback period.')); ?>",
    'You must enter a warning and critical threshold.': "<?php echo escape_html(_('You must enter a warning and critical threshold.')); ?>",
    'Check successfully created. You can': "<?php echo escape_html(_('Check successfully created. You can')); ?>",
    'view it now': "<?php echo escape_html(_('view it now')); ?>",
    'Could not create check, please try again.': "<?php echo escape_html(_('Could not create check, please try again.')); ?>",
    'Must enter a valid name for the query.': "<?php echo escape_html(_('Must enter a valid name for the query.')); ?>",
    'Query updated successfully.': "<?php echo escape_html(_('Query updated successfully.')); ?>",
    'Deprecation Notice': "<?php echo escape_html(_('Deprecation Notice')); ?>",
    'WARNING: Legacy dashboard': "<?php echo escape_html(_('WARNING: Legacy dashboard')); ?>",
    'This dashboard has been loaded from the browsers local cache. If you use another brower or computer you will not be able to access it!': "<?php echo escape_html(_('This dashboard has been loaded from the browsers local cache. If you use another brower or computer you will not be able to access it!')); ?>",
    'No index found at': "<?php echo escape_html(_('No index found at')); ?>",
    'Please create at least one index. If you are using a proxy ensure it is configured correctly.': "<?php echo escape_html(_('Please create at least one index. If you are using a proxy ensure it is configured correctly.')); ?>",
    'Not Saved': "<?php echo escape_html(_('Not Saved')); ?>",
    'Home Set': "<?php echo escape_html(_('Home Set')); ?>",
    'This page has been set as your default dashboard': "<?php echo escape_html(_('This page has been set as your default dashboard')); ?>",
    'Local Default Clear': "<?php echo escape_html(_('Local Default Clear')); ?>",
    'Your default dashboard has been reset to the default': "<?php echo escape_html(_('Your default dashboard has been reset to the default')); ?>",
    'You must enter a name for the dashboard.': "<?php echo escape_html(_('You must enter a name for the dashboard.')); ?>",
    'This dashboard has been saved.': "<?php echo escape_html(_('This dashboard has been saved.')); ?>",
    'This dashboard has been saved as': "<?php echo escape_html(_('This dashboard has been saved as')); ?>",
    'Dashboard could not be saved.': "<?php echo escape_html(_('Dashboard could not be saved.')); ?>",
    'Dashboard has been deleted.': "<?php echo escape_html(_('Dashboard has been deleted.')); ?>",
    'Could not find dashboard': "<?php echo escape_html(_('Could not find dashboard')); ?>",
    'General': "<?php echo escape_html(_('General')); ?>",
    'Panel': "<?php echo escape_html(_('Panel')); ?>",
    'Create and alert': "<?php echo escape_html(_('Create an alert')); ?>",
    'Leave fullscreen': "<?php echo escape_html(_('Leave fullscreen')); ?>",
    'Fullscreen': "<?php echo escape_html(_('Fullscreen')); ?>",
    'This function is not available in demo mode.': "<?php echo escape_html(_('This function is not available in demo mode.')); ?>",
    'Export as CSV': "<?php echo escape_html(_('Export as CSV')); ?>",
    'Zoom in': "<?php echo escape_html(_('Zoom in')); ?>",
    'Zoom Out': "<?php echo escape_html(_('Zoom Out')); ?>"
}

function glv(langvar) {
    if (langvar in lang) {
        return lang[langvar];
    }
    return langvar;
}
