define([
  'angular',
  'lodash'
],
function (angular, _) {
  'use strict';

  var module = angular.module('kibana.controllers');

  module.controller('dashLoader', function($scope, $http, timer, dashboard, alertSrv, $location) {
    $scope.loader = dashboard.current.loader;

    $scope.init = function() {
      $scope.gist_pattern = /(^\d{5,}$)|(^[a-z0-9]{10,}$)|(gist.github.com(\/*.*)\/[a-z0-9]{5,}\/*$)/;
      $scope.gist = $scope.gist || {};
      $scope.elasticsearch = $scope.elasticsearch || {};
    };

    $scope.showDropdown = function(type) {
      if(_.isUndefined(dashboard.current.loader)) {
        return true;
      }

      var _l = dashboard.current.loader;
      if(type === 'load') {
        return (_l.load_elasticsearch || _l.load_gist || _l.load_local);
      }
      if(type === 'save') {
        return (_l.save_elasticsearch || _l.save_gist || _l.save_local || _l.save_default);
      }
      if(type === 'report') {
        return (_l.save_elasticsearch);
      }
      if(type === 'share') {
        return (_l.save_temp);
      }
      return false;
    };

    $scope.set_default = function() {
      if(dashboard.set_default($location.path())) {
        alertSrv.set(glv('Home Set'), glv('This page has been set as your default dashboard'), 'success', 5000);
      } else {
        alertSrv.set(glv('Incompatible Browser'), glv('Sorry, your browser is too old for this feature'), 'error', 5000);
      }
    };

    $scope.purge_default = function() {
      if(dashboard.purge_default()) {
        alertSrv.set(glv('Local Default Clear'), glv('Your default dashboard has been reset to the default'), 'success', 5000);
      } else {
        alertSrv.set(glv('Incompatible Browser'), glv('Sorry, your browser is too old for this feature'), 'error', 5000);
      }
    };

    $scope.elasticsearch_save = function(type,ttl,update) {
      let save_dashboard = _.cloneDeep(dashboard);
      save_dashboard.imported = 0;

      if (($scope.elasticsearch.title == undefined || $scope.elasticsearch.title == '') && type != 'save' && type != 'temp' && type != 'report' && type != 'global-report') {
        alertSrv.set(glv('Save failed'), glv('You must enter a name for the dashboard.'), 'error', 5000);
        return;
      }
      $http.post('index.php/api/user/get_details')
      .success(function(userdata) {

        if (type == 'save') {
          $scope.dash_saved();
          type = "dashboard";
          if (save_dashboard.current.edit_type == "global") {
            userdata.username = "global";
          }
        }

        // Overwrite this for global dashboards
        if (type == "global-dashboard") {
          type = "dashboard";
          userdata.username = "global";
        }

        // Overwrite this for global reports
        if (type == "global-report") {
          type = "report";
          userdata.username = "global";
        }

        if (userdata.username == "global") { 
          save_dashboard.current.edit_type = "global";
        } else {
          save_dashboard.current.edit_type = "";
        }

        if (type == "report") {
          save_dashboard.current.report == true;
        }

        save_dashboard.elasticsearch_save(
          type,
          ($scope.elasticsearch.title || save_dashboard.current.title),
          ($scope.loader.save_temp_ttl_enable ? ttl : false),
          userdata.username,
          userdata.groups,
          (update === undefined ? false : update)
        ).then(
          function(result) {
          if(!_.isUndefined(result._id)) {
            if (type !== "temp") {
              if (update === true) {
                alertSrv.set(glv('Dashboard Saved'), glv('This dashboard has been saved.'), 'success', 5000);
              } else {
                if (type !== "report") {
                  alertSrv.set(glv('Dashboard Saved'), glv('This dashboard has been saved as') + ' "' + $scope.elasticsearch.title + '"','success',5000);
                } else {
                  alertSrv.set(glv('Report Saved'), glv('This report has been saved as') + ' "' + ($scope.elasticsearch.title || save_dashboard.current.title) + '"','success',5000);
                  var log = {
                    type: 'INFO',
                    message: 'Report created: ' + ($scope.elasticsearch.title || save_dashboard.current.title)
                  };
                  $.post(site_url + 'api/log/create', { log: log }, function() {
                      window.location.href = window.location.href;
                  });
                }
              }
            } else {
              $scope.share = save_dashboard.share_link(save_dashboard.current.title,'temp',result._id);
            }
          } else {
            alertSrv.set(glv('Save failed'), glv('Dashboard could not be saved.'), 'error', 5000);
          }
        });
      });
    };

    $scope.elasticsearch_delete = function(id, type) {

      if (is_demo_mode) {
        alertSrv.set(glv('Dashboard Not Deleted'), glv('This function is not available in demo mode.'), 'error', 5000);
        return;
      }

      dashboard.elasticsearch_delete(id, type).then(
        function(result) {
          if(!_.isUndefined(result)) {
            if(result.found) {
              alertSrv.set(glv('Dashboard Deleted'), glv('Dashboard has been deleted.'), 'success', 5000);
              // Find the deleted dashboard in the cached list and remove it
              var toDelete = _.where($scope.elasticsearch.dashboards,{_id:id})[0];
              $scope.elasticsearch.dashboards = _.without($scope.elasticsearch.dashboards,toDelete);
            } else {
              alertSrv.set(glv('Dashboard Not Found'), glv('Could not find dashboard')+' '+$scope.elasticsearch.title+'', 'warning', 5000);
            }
          } else {
            alertSrv.set(glv('Dashboard Not Deleted'), glv('An error occurred deleting the dashboard'), 'error', 5000);
          }
        }
      );
    };

    $scope.elasticsearch_dblist = function(query) {
      $http.post('index.php/api/user/get_details')
      .success(function(userdata) {
        var type = (dashboard.current.report === true) ? 'report' : 'dashboard';
        dashboard.elasticsearch_list(query,$scope.loader.load_elasticsearch_size, userdata, type).then(
          function(result) {
          if(!_.isUndefined(result.hits)) {
            $scope.hits = result.hits.hits.length;
            $scope.elasticsearch.dashboards = result.hits.hits;
          }
        });
      });
    };

    $scope.fullscreen = function() {
      if ($('#header').is(':visible')) {
        $('#header').hide();
        $('#footer').hide();
        $('.push').hide();
        $('#wrapper').addClass('no-after');
        $('i.atn00').removeClass('fa-arrows-alt').addClass('fa-close');
      } else {
        $('#header').show();
        $('.push').show();
        $('#footer').show();
        $('#wrapper').removeClass('no-after');
        $('i.atn00').removeClass('fa-close').addClass('fa-arrows-alt');
      }
    };

    $scope.save_gist = function() {
      dashboard.save_gist($scope.gist.title).then(
        function(link) {
        if(!_.isUndefined(link)) {
          $scope.gist.last = link;
          alertSrv.set(glv('Gist saved'), glv('You will be able to access your exported dashboard file at') + ' <a href="'+link+'">'+link+'</a> ' + glv('in a moment'), 'success');
        } else {
          alertSrv.set(glv('Save failed'), glv('Gist could not be saved'), 'error', 5000);
        }
      });
    };

    $scope.gist_dblist = function(id) {
      dashboard.gist_list(id).then(
        function(files) {
        if(files && files.length > 0) {
          $scope.gist.files = files;
        } else {
          alertSrv.set(glv('Gist Failed'), glv('Could not retrieve dashboard list from gist'), 'error', 5000);
        }
      });
    };

    $scope.get_username = function() {
      var username = '';
      try { username = LS_USERNAME; } catch (err) {}
      return username;
    }

    $scope.admin_perms = function() {
      var admin = 0;
      try { admin = is_admin; } catch (err) {}
      return admin;
    }

    $scope.alert_perms = function() {
      var alert = 0;
      try { alert = can_create_alerts; } catch (err) {}
      return alert;
    }

  });

});
