define([
  'angular',
  'lodash'
],
function (angular,_) {
  'use strict';

  angular
    .module('kibana.directives')
    .directive('configModal', function($modal,$q) {
      return {
        restrict: 'A',
        link: function(scope, elem, attrs) {
          var
            model = attrs.kbnModel,
            partial = attrs.configModal;


          // create a new modal. Can't reuse one modal unforunately as the directive will not
          // re-render on show.
          elem.bind('click',function(){

            // Create a temp scope so we can discard changes to it if needed
            var tmpScope = scope.$new();
            tmpScope[model] = angular.copy(scope[model]);

            tmpScope.editSave = function(panel) {
              // Correctly set the top level properties of the panel object
              _.each(panel,function(v,k) {
                scope[model][k] = panel[k];
              });
	          };

            var panelModal = $modal({
              template: partial,
              persist: true,
              show: false,
              scope: tmpScope,
              keyboard: false
            });

            // and show it
            $q.when(panelModal).then(function(modalEl) {
              modalEl.on("show", function() {
                if (is_admin) { $('.admin_only').show(); } else { $('.admin_only').hide(); }
                if ($(this).find('.modal-body').hasClass('manage-queries')) {
                  get_queries_list();
                }
                if ($(this).find('.modal-body').hasClass('manage-buttons')) {
                  get_buttons();
                  get_default_button_state();
                }
                if ($(this).find('.modal-body').hasClass('make-button')) {
                  get_queries_list_button();
                }
                $('body').addClass('modal-open');
              }).on("hidden", function(e) {
                if ($(e.target).hasClass('modal')) {
                  if ($(this).find('.modal-body').hasClass('delete-modal-on-close')) {
                    $(this).remove();
                  }
                  $('body').removeClass('modal-open');
                }
              });
              modalEl.modal('show');
            });
            scope.$apply();
          });
        }
      };
    });
});
