define([
  'angular',
  'jquery'
],
function (angular,$) {
  'use strict';

  angular
    .module('kibana.directives')
    .directive('kibanaPanel', function($compile, $rootScope) {

      // Check if we are in an iframe
      var c_style = "panel-container";
      if (window.self !== window.top) {
        c_style = "";
      }
      
      var container = '<div class="'+c_style+'"></div>';
      var content = '<div class="panel-content" ng-style="{\'min-height\':row.height}"></div>';

      var panelHeader =
      '<div class="panel-header container-fluid">'+
        '<div class="row">' +
          '<div class="col-sm-12 alert-error panel-error" ng-hide="!panel.error">' +
            '<a class="close" ng-click="panel.error=false">&times;</a>' +
            '<i class="fa fa-exclamation-circle"></i> {{panel.error}}' +
          '</div>' +
        '</div>\n' +

        '<div class="row panel-extra">' +
          '<div class="panel-extra-container">' +

            '<span class="extra row-button" ng-show="panel.editable != false && panel.removable != false && dashboard.current.report != true">' +
              '<span confirm-click="dash_edited(); row.panels = _.without(row.panels,panel)" '+
              'confirmation="'+glv('remove_this')+' {{lang(panel.type)}} '+glv('panel')+'?" class="pointer">'+
              '<i class="fa fa-remove pointer" bs-tooltip="\''+glv('remove')+'\'"></i></span>'+
            '</span>' +

            '<span class="extra row-button" ng-hide="panel.draggable == false || dashboard.current.report == true">' +
              '<span class="pointer" bs-tooltip="\''+glv('drag_me')+'\'"' +
              'data-drag=true data-jqyoui-options="kbnJqUiDraggableOptions"'+
              ' jqyoui-draggable="'+
              '{'+
                'animate:false,'+
                'mutate:false,'+
                'index:{{$index}},'+
                'onStart:\'panelMoveStart\','+
                'onStop:\'panelMoveStop\''+
                '}"  ng-model="row.panels"><i class="fa fa-arrows"></i></span>'+
            '</span>' +

            '<span class="row-button extra" ng-show="panel.editable != false && dashboard.current.report != true">' +
              '<span config-modal="./app/partials/paneleditor.php" kbn-model="panel" class="pointer">'+
              '<i class="fa fa-cog pointer" bs-tooltip="\''+glv('Configure')+'\'"></i></span>'+
            '</span>' +

            '<span ng-repeat="task in panelMeta.modals" class="row-button extra" ng-show="task.show && dashboard.current.report != true">' +
              '<span bs-modal="task.partial" class="pointer k-modal"><i ' +
                'bs-tooltip="task.description" ng-class="task.icon" class="pointer"></i></span>'+
            '</span>' +

            '<span class="extra" style="margin-right: 10px; margin-top: 3px;" ng-show="panelMeta.export == true && dashboard.current.report != true">' +
              '<span>'+
                '<a href="export?limit={{elimit}}&fields={{panel.fields|uriencode}}&q={{equery}}"><i class="fa fa-download fa-large"></i> '+glv("Export as CSV")+'</a>' +
              '</span>'+
            '</span>' +

            '<span class="row-button extra" ng-show="panelMeta.loading == true">' +
              '<span>'+
                '<i class="fa fa-spinner fa-spin fa-large"></i>' +
              '</span>'+
            '</span>' +

            '<span class="panel-text panel-title">' +
              '{{panel.title?panel.title:panel.type}}' +
            '</span>'+

          '</div>'+
        '</div>\n'+
      '</div>';
      return {
        restrict: 'A',
        replace: true,
        link: function($scope, elem, attr) {
          // once we have the template, scan it for controllers and
          // load the module.js if we have any
          var newScope = $scope.$new();

          elem.parent().parent().parent().resize(function() {
            $rootScope.$broadcast('render');
          });

          $scope.kbnJqUiDraggableOptions = {
            revert: 'invalid',
            helper: function() {
              return $('<div style="width:200px;height:100px;background: rgba(100,100,100,0.50);"/>');
            },
            placeholder: 'keep'
          };

          // compile the module and uncloack. We're done
          function loadModule($module) {
            $module.appendTo(elem);
            elem.wrapInner(container);
            /* jshint indent:false */
            $compile(elem.contents())(newScope);
            elem.removeClass("ng-cloak");
          }

          newScope.$on('$destroy',function() {
            elem.unbind();
            elem.remove();
          });

          $scope.$watch(attr.type, function (name) {
            elem.addClass("ng-cloak");
            // load the panels module file, then render it in the dom.
            var nameAsPath = name.replace(".", "/");
            $scope.require([
              'jquery',
              'text!panels/'+nameAsPath+'/module.php',
              'text!panels/'+nameAsPath+'/editor.php'
            ], function ($, moduleTemplate) {
              var $module = $(moduleTemplate);
              // top level controllers
              var $controllers = $module.filter('ngcontroller, [ng-controller], .ng-controller');
              // add child controllers
              $controllers = $controllers.add($module.find('ngcontroller, [ng-controller], .ng-controller'));

              if ($controllers.length) {
                $controllers.first().prepend(panelHeader);

                $controllers.first().find('.panel-header').nextAll().wrapAll(content);

                $scope.require([
                  'panels/'+nameAsPath+'/module'
                ], function() {
                  loadModule($module);
                });
              } else {
                loadModule($module);
              }
            });
          });
        }
      };
    });

});
