/*

  ## query

  ### Parameters
  * query ::  A string or an array of querys. String if multi is off, array if it is on
              This should be fixed, it should always be an array even if its only
              one element
*/
define([
  'angular',
  'app',
  'lodash',

  'css!./query.css'
], function (angular, app, _) {
  'use strict';

  var module = angular.module('kibana.panels.query', []);
  app.useModule(module);

  module.controller('query', function($scope, querySrv, $rootScope, dashboard, $q, $modal, $http, $compile){
    $scope.panelMeta = {
      status  : "Stable",
      description : glv('query_desc')
    };

    // Set and populate defaults
    var _d = {
      query   : "*",
      pinned  : true,
      history : [],
      remember: 10 // max: 100, angular strap can't take a variable for items param
    };
    _.defaults($scope.panel,_d);

    $scope.querySrv = querySrv;
    $scope.dashboard = dashboard;

    // A list of query types for the query config popover
    $scope.queryTypes = querySrv.types;

    var queryHelpModal = $modal({
      template: './app/panels/query/helpModal.php',
      persist: true,
      show: false,
      scope: $scope,
    });

    $scope.init = function() {
      $scope.dashboard.naturalLanguageQueries = [];
      // Ensure initial load_user_buttons call for already present buttons
      $scope.load_user_buttons();
    };

    $scope.refresh = function() {
      update_history(_.pluck($scope.dashboard.current.services.query.list,'query'));
      dashboard.refresh();
      $scope.$emit('loaded');
    };

    $scope.render = function() {
      $rootScope.$broadcast('render');
    };

    $scope.toggle_pin = function(id) {
      $scope.dash_edited();
      dashboard.current.services.query.list[id].pin = dashboard.current.services.query.list[id].pin ? false : true;
    };

    $scope.queryIcon = function(type) {
      return querySrv.queryTypes[type].icon;
    };

    $scope.queryConfig = function(type) {
      return "./app/panels/query/editors/"+(type||'lucene')+".php";
    };

    $scope.queryHelpPath = function(type) {
      return "./app/panels/query/help/"+(type||'lucene')+".php";
    };

    $scope.queryHelp = function(type) {
      $scope.help = {
        type: type
      };
      $q.when(queryHelpModal).then(function(modalEl) {
        modalEl.modal('show');
      });
    };

    $scope.typeChange = function(q) {
      $scope.dash_edited();
      var _nq = {
        id   : q.id,
        type : q.type,
        query: q.query,
        alias: q.alias,
        color: q.color
      };
      dashboard.current.services.query.list[_nq.id] = querySrv.defaults(_nq);
    };

    $scope.get_queries = function(search) {
      var cachebuster = Date.now(); 
      $.ajax({
        type: "POST",
        async: false,
        url: site_url+"api/check/get_queries",
        data: { cb: cachebuster, search: search },
        dataType: 'json'
      }).done(function(data) {
        $scope.nls_queries = data;
      });
    };

    $scope.load_user_buttons = function() {
        var userButtonsContainer = angular.element(document.getElementById('user-buttons'));
        $compile(userButtonsContainer.contents())($scope);
    };

    var update_history = function(query) {
      if($scope.panel.remember > 0) {
        $scope.panel.history = _.union(query.reverse(),$scope.panel.history);
        var _length = $scope.panel.history.length;
        if(_length > $scope.panel.remember) {
          $scope.panel.history = $scope.panel.history.slice(0,$scope.panel.remember);
        }
      }
    };

  /**
   * Updates the query based on button click and current state.
   * @param {Event} event - The triggering event.
   */
$scope.setQuery = function (event) {
    // Get the target button element and its associated query value.
    var buttonElement = event.currentTarget;
    var buttonValue = buttonElement.getAttribute('data-query-value');
    var buttonText = buttonElement.textContent.trim();

    // If button is already active, we are looking to remove its associated query.
    if (angular.element(buttonElement).hasClass('active')) {
        angular.element(buttonElement).removeClass('active');
        
        // Check if the button's query value exists in the current set of queries.
        for (var id of $scope.dashboard.current.services.query.ids) {
            if ($scope.dashboard.current.services.query.list[id].query === buttonValue) {
                
                // Clear the value of the corresponding natural language query field.
                $scope.dashboard.naturalLanguageQueries[id] = '';
                
                // If there's more than one query, remove the matching one. Otherwise, set to default ('*').
                if ($scope.dashboard.current.services.query.ids.length > 1) {
                    $scope.querySrv.remove(id);
                } else {
                    $scope.dashboard.current.services.query.list[id].query = '*';
                }
                break;
            }
        }
    } else {
        // Button was not active, so we add or set its associated query.
        angular.element(buttonElement).addClass('active');
        
        var isDefaultQuery = false;
        var currentQueryId = $scope.unPinnedQueries[0];

        if ($scope.dashboard.current.services.query.list[currentQueryId].query === '*') {
            $scope.dashboard.current.services.query.list[currentQueryId].query = buttonValue;
            isDefaultQuery = true;
        } else {
            currentQueryId = $scope.querySrv.set({ query: buttonValue });
        }

        // Set the value of the corresponding natural language query field to the name of the button.
        $scope.dashboard.naturalLanguageQueries[currentQueryId] = buttonText;
    }

    // Refresh the display and blur the button to remove focus.
    $scope.refresh();
    buttonElement.blur();
};



  // Flag for controlling the visibility of advanced search options.
  $scope.showAdvancedSearch = false;

  /**
  * Toggle the visibility of advanced search options.
  */
  $scope.toggleAdvancedSearch = function () {
    $scope.showAdvancedSearch = !$scope.showAdvancedSearch;
  };

  /**
  * Updates the active state of query buttons based on current queries.
  */
  $scope.updateButtonToggleState = function () {
    var buttons = document.querySelectorAll('.query-set-button');

    for (var button of buttons) {
        var buttonValue = button.getAttribute('data-query-value').replace(/\s+/g, '').toLowerCase();
        var isQueryPresent = $scope.dashboard.current.services.query.ids.some(id => {
            var queryValue = $scope.dashboard.current.services.query.list[id].query.replace(/\s+/g, '').toLowerCase();
            return queryValue.includes(buttonValue);
        });

        if (isQueryPresent) {
            angular.element(button).addClass('active');
        } else {
            angular.element(button).removeClass('active');
        }
    }
};

$scope.updateButtonToggleState();

  /**
  * Removes a specific query and updates the button state.
  * @param {string} id - The ID of the query to remove.
  */
  $scope.removeAndToggle = function (id) {
    $scope.querySrv.remove(id);
    $scope.updateButtonToggleState();
    $scope.refresh();
  };

  // Watch for changes in the query list and update button states accordingly.
  $scope.$watch('dashboard.current.services.query.list', function () {
    $scope.updateButtonToggleState();
  }, true);

  /**
  * Clears all queries and resets them to the default.
  */
  $scope.clearAllQueries = function () {
    // Clear all advanced queries
    while ($scope.dashboard.current.services.query.ids.length > 1) {
        $scope.querySrv.remove($scope.dashboard.current.services.query.ids[0]);
    }
    var id = $scope.dashboard.current.services.query.ids[0];
    $scope.dashboard.current.services.query.list[id].query = '*';

    // Clear all natural language queries
    for (var queryId in $scope.dashboard.naturalLanguageQueries) {
        $scope.dashboard.naturalLanguageQueries[queryId] = '';
    }

    // Deactivate all toggled buttons
    var toggledButtons = document.querySelectorAll('.query-set-button.active');
    toggledButtons.forEach(function (button) {
        angular.element(button).removeClass('active');
    });

    $scope.refresh();
};


  // TODO: convert to post and figure out how to properly deal with 403 denial -ssunga 10/17/23
  $scope.isLoading = false;

  $scope.postNaturalLanguageQuery = function(id) {
    if($scope.isLoading) return;  

    $scope.isLoading = true;

    const query = $scope.dashboard.naturalLanguageQueries[id];

    // Reset error state
    const inputField = document.getElementById('natural-language-query-field');
    if (inputField) {
        inputField.style.border = '';
    }
    const errorMessage = document.querySelector('.experimental-error');
    if (errorMessage) {
        errorMessage.remove();
    }

    const url = 'dashboard/natural_language_to_query?input=' + encodeURIComponent(query) + '&current_fields=' + encodeURIComponent(JSON.stringify($scope.current_fields));

    $http.get(url)
        .success(function(data) {
            if (data.is_valid) {
                $scope.dashboard.current.services.query.list[id].query = data.query;
                $scope.refresh();
            } else {
                const inputField = document.getElementById('natural-language-query-field');
                if (inputField) {
                    inputField.style.border = '1px solid red';
                    let errorMessage = document.querySelector('.experimental-error');
                    if (!errorMessage) {
                        errorMessage = document.createElement('span');
                        errorMessage.className = 'experimental-error';
                        const experimentalElement = document.querySelector('.experimental');
                        if (experimentalElement) {
                            experimentalElement.parentNode.insertBefore(errorMessage, experimentalElement.nextSibling);
                        }
                    }
                    errorMessage.textContent = "The NLP feature did not generate a valid Lucene query on this attempt. Please try a different request or a different model.";
                }
            }
            $scope.isLoading = false;
        })
        .error(function(error) {
            alert("Failed to fetch natural language query: " + error);
            $scope.isLoading = false;
        });
  };


  $http.get('dashboard/get_natural_language_query_status').then(function(response) {
    $scope.naturalLanguageQuery = response.data.value;
  });


  


$scope.$on('current_fields', function (event, current_fields) {
    $scope.current_fields = current_fields;
});

// Make sure $scope.load_user_buttons() gets called whenever necessary
$scope.$on('event:buttonsLoaded', function() {
  $scope.load_user_buttons();
});

// $scope.$on('unique_field_values', function (event, unique_fields) {
//   $scope.unique_fields = unique_fields;
// });


    $scope.init();

  });

});