<?php include_once('../../setlang.inc.php'); ?>

<div ng-controller='query' ng-init="init()" class="query-panel">

    <span class="dropdown" style="font-size: 13px; font-weight: normal; vertical-align: middle;">
        <span style="margin-right: 10px;" id="query-name" ng-show="dashboard.current.loaded_query">{{dashboard.current.loaded_query}}</span>
        <div id="user-buttons" style="display:flex; justify-content: {{showAdvancedSearch ? 'start' : 'start'}}; align-items: {{showAdvancedSearch ? 'start' : 'start'}}; flex-wrap: wrap;">
                <button style="margin-bottom:10px;" class="btn btn-sm btn-primary pointer" ng-click="clearAllQueries()" title="Remove all the applied filter queries."><i class="fa fa-times-circle"></i> Clear All</button>
            </div>

        <ul class="dropdown-menu" style="padding:10px; width: 320px;">
            <li>
                <form class="nomargin">
                    <input type="text" ng-model="nls_query" ng-change="get_queries(nls_query)" placeholder="<?php echo _('Type to filter'); ?>" style="width: 306px;">
                </form>
                <h6 ng-hide="nls_queries.length"><?php echo _('No queries found'); ?></h6>
                <table class="table table-condensed table-striped kibana-load" style="margin-bottom: 0;">
                    <tr bindonce ng-repeat="row in nls_queries | orderBy:['name']">
                        <td>
                            <i ng-show="row.show_everyone == 1" class="fa fa-globe"></i>
                            <a bo-text="row.name" ng-click="dash_edited(); dashboard.reload_nls_dash(row.id);"></a>
                        </td>
                    </tr>
                </table>
            </li>
        </ul>
    </span>

    <script defer>
    var placeholders = [
        "Show me logs from yesterday",
        "Login Attempts, use Windows Event IDs",
        "Apache 404 errors",
        "I want to see system logs from 192.168.0.12",
        "An advanced, robust, complicated query for sshd errors.",
        "session starts (pam)",
    ];

    var currentPlaceholderIndex = 0;
    var currentCharIndex = 0;
    var backspacing = false;

    function update_placeholder() {
        var inputField = document.getElementById('natural-language-query-field');
        if (inputField) {
            if (!backspacing) {
                if (currentCharIndex <= placeholders[currentPlaceholderIndex].length) {
                    inputField.placeholder = placeholders[currentPlaceholderIndex].substr(0, currentCharIndex);
                    currentCharIndex++;
                    setTimeout(update_placeholder, 25);
                } else {
                    setTimeout(() => {
                        backspacing = true;
                        update_placeholder();
                    }, 1000);
                }
            } else {
                if (currentCharIndex > 0) {
                    currentCharIndex--;
                    inputField.placeholder = placeholders[currentPlaceholderIndex].substr(0, currentCharIndex);
                    setTimeout(update_placeholder, 10);
                } else {
                    backspacing = false;
                    next_placeholder();
                }
            }
        }
    }

    function next_placeholder() {
        currentPlaceholderIndex = (currentPlaceholderIndex + 1) % placeholders.length;
        currentCharIndex = 0;
        update_placeholder();
    }

    function load_user_buttons() {
        var buttons = '';
        var html = '';
        var queryMappings = {
            "404" : {
                "query" : '((status:404 OR message:&quot;HTTP/1.1\\&quot; 404&quot; OR message:&quot;HTTP/1.0\\&quot; 404&quot;) AND (type:apache_access OR source:/var/log/apache2/* OR source:/var/log/httpd/*)) OR ((sc-status:404 OR message:&quot;GET * 404 0&quot;) AND (type:iis OR source:/var/log/iis/*))',
                "title" : 'Display logs that report 404 errors from both Apache and IIS sources.',
                "icon" : 'fa-exclamation-triangle'
            },
            "500" : {
                "query" : '((status:[500 TO 505] OR message:&quot;HTTP/1.1\\&quot; 500&quot; OR message:&quot;HTTP/1.0\\&quot; 500&quot; OR message:&quot;Internal Server Error&quot; OR message:&quot;HTTP/1.1\\&quot; 501&quot; OR message:&quot;HTTP/1.0\\&quot; 501&quot; OR message:&quot;Not Implemented&quot; OR message:&quot;HTTP/1.1\\&quot; 502&quot; OR message:&quot;HTTP/1.0\\&quot; 502&quot; OR message:&quot;Bad Gateway&quot; OR message:&quot;HTTP/1.1\\&quot; 503&quot; OR message:&quot;HTTP/1.0\\&quot; 503&quot; OR message:&quot;Service Unavailable&quot; OR message:&quot;HTTP/1.1\\&quot; 504&quot; OR message:&quot;HTTP/1.0\\&quot; 504&quot; OR message:&quot;Gateway Timeout&quot; OR message:&quot;HTTP/1.1\\&quot; 505&quot; OR message:&quot;HTTP/1.0\\&quot; 505&quot; OR message:&quot;HTTP Version Not Supported&quot;) AND (type:apache_access OR source:/var/log/apache2/* OR source:/var/log/httpd/*)) OR ((sc-status:[500 TO 505] OR message:&quot;GET * 500 0&quot; OR message:&quot;GET * 501 0&quot; OR message:&quot;GET * 502 0&quot; OR message:&quot;GET * 503 0&quot; OR message:&quot;GET * 504 0&quot; OR message:&quot;GET * 505 0&quot;) AND (type:iis OR source:/var/log/iis/*))',
                "title" : 'Filter logs that indicate server errors ranging from 500 to 505, for both Apache and IIS servers.',
                "icon" : 'fa-bomb'
            },
            "SSH" : {
                "query" : '(program:sshd AND ((message:&quot;Failed password&quot; OR message:&quot;Invalid user&quot; OR message:&quot;Received disconnect from&quot; OR message:&quot;Connection closed by authenticating user&quot; OR message:&quot;refused connect from&quot; OR message:&quot;Unable to negotiate with&quot; OR message:&quot;fatal: no matching cipher found&quot; OR message:&quot;Disconnected from&quot; OR message:&quot;Received disconnect&quot; OR message:&quot;authentication failure&quot; OR message:&quot;permission denied&quot; OR message:&quot;connection timeout&quot; OR message:&quot;Connection timed out&quot;) AND NOT (message:&quot;successful login&quot; OR message:&quot;Connection established&quot; OR message:&quot;Authenticated successfully&quot;))) OR program:sshd',
                "title" : 'Filter logs that indicate SSH connection attempts, errors, timeouts, and other related activities.',
                "icon" : 'fa-terminal'
            },
            "AD Errors" : {
                "query" : '((EventID:1311 AND (message:&quot;Replication Topology Problems&quot; OR message:&quot;Fixing Replication Topology Problems&quot;)) OR (EventID:1388 AND (message:&quot;lingering object&quot; OR message:&quot;A lingering object is detected&quot;)) OR (EventID:1988 AND (message:&quot;lingering object&quot; OR message:&quot;A lingering object is detected&quot;)) OR (EventID:2042 AND message:&quot;It has been too long since this machine replicated&quot;) OR (EventID:1925 AND (message:&quot;Attempt to establish a replication link failed&quot; OR message:&quot;DNS lookup problem&quot;)) OR (EventID:2087 AND message:&quot;DNS lookup failure&quot;) OR (EventID:2108 AND message:&quot;Database inconsistency during inbound replication&quot;) OR (EventID:1084) OR (EventID:4935 AND message:&quot;Replication failure begins&quot;)) AND type:eventlog',
                "title" : 'Show logs that indicate specific error events from Active Directory, such as replication and DNS issues.',
                "icon" : 'fa-sitemap'
            },
            "Account Lockout" : {
                "query" : '(EventID:4740 AND (EventType:AUDIT_SUCCESS OR EventType:AUDIT_FAILURE)) OR (message:&quot;locked out&quot; AND type:eventlog)',
                "title" : 'Retrieve logs about accounts being locked out due to multiple failed login attempts or other security reasons.',
                "icon" : 'fa-lock'
            },
            "Password Change" : {
                "query" : '((EventID:4723 AND (EventType:AUDIT_SUCCESS OR EventType:AUDIT_FAILURE)) OR (EventID:4724 AND (EventType:AUDIT_SUCCESS OR EventType:AUDIT_FAILURE)) OR ((EventID:4723 AND message:&quot;change&quot;) OR (EventID:4724 AND message:&quot;reset&quot;)) OR message:&quot;change an account\'s password&quot; OR message:&quot;reset an account\'s password&quot;) AND type:eventlog',
                "title" : 'Show logs where account passwords have been changed or reset.',
                "icon" : 'fa-key'
            },
            "Failed Login" : {
                "query" : '((EventID:4625 OR message:&quot;account failed to log on&quot;) AND (type:eventlog))',
                "title" : 'Retrieve logs related to failed login attempts on the system.',
                "icon" : 'fa-user-times'
            },
            "Sendmail" : {
                "query" : '((message:&quot;sendmail: refused mail&quot; OR message:&quot;sendmail: alias database*&quot; OR message:&quot;sendmail: stat=Deferred&quot; OR message:&quot;sendmail: stat=Sent&quot; OR message:&quot;sendmail: stat=Failed&quot; OR message:&quot;sendmail: Authentication-Warning*&quot; OR message:&quot;sendmail: STARTTLS&quot; OR message:&quot;sendmail: lost input channel&quot; OR message:&quot;sendmail: queue runner&quot; OR message:&quot;sendmail: rejecting connections&quot; OR message:&quot;sendmail: timeout waiting&quot;) AND (type:sendmail OR source:/var/log/mail.log* OR source:/var/log/sendmail.log* OR program:*sendmail*))',
                "title" : 'Display logs associated with the sendmail service, including failed deliveries and authentication warnings.',
                "icon" : 'fa-envelope'
            },            
            "MySQL Errors" : {
                "query" : 'program:*mysqld* OR (program:*mysqld* AND message:*error*)',
                "title" : 'Filter logs related to MySQL database errors, such as access denials, syntax errors, and connection issues.',
                "icon" : 'fa-database'
            },
            "Network Outages" : {
                "query" : '((EventID:4000 AND message:&quot;DNS&quot;) OR (EventID:5719 AND (message:&quot;logon&quot; OR message:&quot;network&quot;)) OR (EventID:1129 AND message:&quot;network&quot;) OR (EventID:4321 AND message:&quot;Net&quot;) OR (EventID:4202 AND message:&quot;update&quot;) OR (EventID:4004 AND (message:&quot;dns&quot; OR message:&quot;DNS&quot;)) OR (EventID:4016 AND (message:&quot;dns&quot; OR message:&quot;DNS&quot;)) OR (EventID:20106 AND message:&quot;interface&quot;) OR (EventID:20227 AND message:&quot;VPN&quot;) OR (EventID:10400 AND message:&quot;link&quot;))',
                "title" : 'Filter logs indicating network outages, failures, and disconnections.',
                "icon" : 'fa-plug'
            },
            "Windows Firewall" : {
                "query" : '((EventID:2005 AND message:&quot;firewall&quot;) OR EventID:2005 AND Severity:INFO AND Channel:&quot;Microsoft-Windows-Windows Firewall With Advanced Security/Firewall&quot;) OR (EventID:(2006 OR 2033) AND Severity:INFO AND Channel:&quot;Microsoft-Windows-Windows Firewall With Advanced Security/Firewall&quot;) OR (EventID:2009 AND Severity:ERROR AND Channel:&quot;Microsoft-Windows-Windows Firewall With Advanced Security/Firewall&quot;) OR (EventID:2004 AND Severity:INFO AND Channel:&quot;Microsoft-Windows-Windows Firewall With Advanced Security/Firewall&quot;) OR (EventID:4946 AND message:&quot;added&quot;) OR (EventID:4947 AND message:&quot;modified&quot;) OR (EventID:4950 AND message:&quot;changed&quot;)  OR (EventID:4954 AND message:&quot;changed&quot;) OR (EventID:5025 AND message:&quot;stopped&quot;) OR (EventID:5031 AND message:&quot;blocked&quot;)',
                "title" : 'Display logs pertaining to the Windows Firewall, capturing both allowed and blocked events.',
                "icon" : 'fa-shield'
            },
            "Windows Updates" : {
                "query" : '((EventID: 17 AND (message:&quot;Windows&quot; OR message:&quot;update&quot;)) OR (EventID: 19 AND (message:&quot;Windows&quot; OR message:&quot;update&quot;)) OR (EventID: 20 AND (message:&quot;Windows&quot; OR message:&quot;update&quot;)) OR (EventID: 24 AND (message:&quot;Windows&quot; OR message:&quot;update&quot;)) OR (EventID: 25 AND (message:&quot;Windows&quot; OR message:&quot;update&quot;)) OR (EventID: 35 AND (message:&quot;Windows&quot; OR message:&quot;update&quot;)))',
                "title" : 'Retrieve logs related to Windows Update events, both successful and unsuccessful.',
                "icon" : 'fa-windows'
            }
        };
        $.get(site_url+"api/user/get_user_button_states", {}, function(data) {
            data = JSON.parse(data);
            var default_state = (data['show_default_buttons'] === "false") ? false : true;
            var global_state = (data['show_global_buttons'] === "false") ? false : true;

            if (default_state) {
                $.each(queryMappings, function(k, v) {
                    html += '<button style="margin-bottom:10px;" class="btn btn-sm btn-default query-set-button default-btn" ng-click="setQuery($event)" data-query-value="' + v.query + '" title="' + v.title + '"><i class="fa ' + v.icon + '"></i> ' + k + '</button>'
                });
            }

            $.get(site_url+"api/check/get_user_buttons", '', function(data) {
                if (!data.error && data["hits"]["hits"].length > 0) {
                    buttons = data["hits"]["hits"];
                    $.each(buttons, function(k, v) {
                        var global = '';
                        var global_class = '';
                        if (v._source.show_everyone == 'true') {
                            global = '<i class="fa fa-globe" title="<?php echo _('Can be used by anyone. Only admins can edit.'); ?>"></i> ';
                            global_class = ' global-btn ';
                        }
                        if ((global && global_state) || !global) {
                            html += '<button id="' + v._id + '" style="margin-bottom:10px;" class="btn btn-sm btn-default query-set-button' + global_class + '" ng-click="setQuery($event)" data-query-value="(' + v._source.query + ')">' + global + ' ' + v._source.name + '</button>';
                        }
                    });
                }
                html += '<button style="margin-bottom:10px;" class="btn btn-sm btn-default" config-modal="app/partials/makequerybtn.php" title="Add New Query Shortcut"><i class="fa fa-plus"></i></button>';
                var userButtonsContainer = angular.element(document.getElementById('user-buttons'));
                userButtonsContainer.append(html);
                var scope = angular.element(userButtonsContainer).scope();
                scope.load_user_buttons();
            }, 'json');
        });
    }

    load_user_buttons();
    update_placeholder();
</script>

<label class="query-label" ng-if="naturalLanguageQuery == 1">
    Natural Language Queries
    <span class="experimental"><i class="fa fa-flask"></i> Experimental</span>
</label>

<div ng-if="naturalLanguageQuery == 1">
    <div style="margin-top:10px;" ng-repeat="id in (unPinnedQueries = (dashboard.current.services.query.ids|pinnedQuery:false))"
        ng-class="{'short-query': unPinnedQueries.length>1, 'xl-query': unPinnedQueries.length == 1}">
        
        <form class="form-search form-inline" ng-submit="postNaturalLanguageQuery(id)">
            <div class="input-group" ng-class="{'input-loading': isLoading}">
                <div class="loading-animation" ng-if="isLoading"></div>
                    <div class="input-group-addon input-group-addon-secondary">
                    <i ng-class="queryIcon(dashboard.current.services.query.list[id].type)" ng-show="dashboard.current.services.query.list[id].enable" data-unique="1" data-placement="bottomLeft" ng-style="{color: dashboard.current.services.query.list[id].color}"></i>
                    <i class="fa fa-remove pointer remove-query" ng-show="dashboard.current.services.query.ids.length > 1" ng-click="removeAndToggle(id);"></i>
                </div> 
                
                <input id='natural-language-query-field' autocomplete='off' class="search-query panel-query natural-language-query"
                    ng-model="dashboard.naturalLanguageQueries[id]">
            </div>
            <div class="end-query">
                <button type="submit" class="btn btn-sm btn-primary pointer" style="border-radius:5px;" ng-show="$last" ng-disabled="isLoading"><i
                        class="fa fa-arrow-right"></i></button>
                <button type="button" class="btn btn-sm btn-default pointer"  
                    ng-click="dash_edited(); query_edited(); querySrv.set({})"  style="border-radius:5px;" ng-show="$last" ng-disabled="isLoading"><i
                        class="fa fa-plus"></i></button>
            </div>
        </form>
    </div>
</div>



    <div style="display:flex; flex-direction: column;">
        <span ng-init="show=false" style="cursor: pointer; color: #23B55E; transition: color 0.3s;" ng-click="show=!show; toggleAdvancedSearch()" onmouseover="this.style.color='#006400';" onmouseout="this.style.color='#23B55E';">Advanced Search <span ng-style="show ? {'transform': 'rotate(0deg)'} : {'transform': 'rotate(90deg)'}" style="margin-left: 5px; display: inline-block; transition: transform 0.3s;">▶</span></span>
    </div>

    <div style ="margin-top:10px; " ng-show="showAdvancedSearch" ng-repeat="id in (unPinnedQueries = (dashboard.current.services.query.ids|pinnedQuery:false))" ng-class="{'short-query': unPinnedQueries.length>1, 'xl-query': unPinnedQueries.length == 1}">
        <form class="form-search form-inline" ng-submit="refresh()">
            <div class="input-group">
                <div class="input-group-addon">
                    <i class="pointer" ng-class="queryIcon(dashboard.current.services.query.list[id].type)" ng-show="dashboard.current.services.query.list[id].enable" data-unique="1" bs-popover="'app/panels/query/meta.php'" data-placement="bottomLeft" ng-style="{color: dashboard.current.services.query.list[id].color}"></i>
                    <i class="fa fa-circle-o pointer" ng-click="dashboard.current.services.query.list[id].enable=true;dashboard.refresh();" ng-hide="dashboard.current.services.query.list[id].enable" bs-tooltip="'<?php echo _('Activate query'); ?>'" ng-style="{color: dashboard.current.services.query.list[id].color}"></i>
                    <i class="fa fa-remove pointer remove-query" ng-show="dashboard.current.services.query.ids.length > 1" ng-click="removeAndToggle(id);"></i>
                </div> 
               
                <input class="search-query panel-query" ng-disabled="!dashboard.current.services.query.list[id].enable" ng-class="{ 'input-block-level': unPinnedQueries.length==1, 'last-query': $last, 'has-remove': dashboard.current.services.query.ids.length > 1 }" bs-typeahead="panel.history" data-min-length=0 data-items=100 type="text" ng-model="dashboard.current.services.query.list[id].query" ng-blur="refresh()" ng-change="query_edited(); logQuery(id)">
            </div>
            <div class="end-query">
                <button type="button" class="btn btn-sm btn-primary pointer" ng-click="refresh()" ng-show="$last"><i class="fa fa-search"></i></button>
                <button type="button" class="btn btn-sm btn-default pointer" ng-click="dash_edited(); query_edited(); querySrv.set({})" ng-show="$last"><i class="fa fa-plus"></i></button>
            </div>
        </form>
    </div>

    <span ng-repeat="id in dashboard.current.services.query.ids|pinnedQuery:true">
        <span class="pointer badge pins" ng-show="$first" ng-click="panel.pinned = !panel.pinned"><?php echo _('Pinned'); ?> <i class="fa" ng-class="{'fa-caret-right':panel.pinned,'fa-caret-left':!panel.pinned}"></i></span>
        <span ng-show="panel.pinned" class="badge pinned">
            <i class="fa fa-circle pointer" ng-show="dashboard.current.services.query.list[id].enable" ng-style="{color: dashboard.current.services.query.list[id].color}" data-unique="1" bs-popover="'app/panels/query/meta.php'" data-placement="bottomLeft"></i>
            <i class="pointer fa fa-circle-o" bs-tooltip="'<?php echo _('Activate query'); ?>'" ng-click="dashboard.current.services.query.list[id].enable=true;dashboard.refresh();" ng-hide="dashboard.current.services.query.list[id].enable" ng-style="{color: dashboard.current.services.query.list[id].color}"></i>
            <span bs-tooltip="dashboard.current.services.query.list[id].query | limitTo:45">
                {{dashboard.current.services.query.list[id].alias || dashboard.current.services.query.list[id].query}}
            </span>
        </span>
    </span>

    <span style="display:inline-block" ng-show="unPinnedQueries.length == 0">
        <i class="fa fa-search pointer" ng-click="refresh()"></i>
        <i class="fa fa-plus pointer" ng-click="querySrv.set({})"></i>
    </span>

</div>
