<?php include_once('../../setlang.inc.php'); ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-sm-6 section">
            <h5><?php echo _('Options'); ?></h5>
            <div class="editor-option">
                <label class="small"><?php echo _('Header'); ?></label><input style="margin-top: 8px;" type="checkbox" ng-model="panel.header" ng-checked="panel.header">
            </div>
            <div class="editor-option">
                <label class="small"><?php echo _('Sorting'); ?></label><input style="margin-top: 8px;" type="checkbox" ng-model="panel.sortable" ng-checked="panel.sortable">
            </div>
            <div class="editor-option" style="white-space:nowrap;" ng-show="panel.sortable">
                <label class="small"><?php echo _('Sort'); ?></label>
                <input class="form-control" bs-typeahead="fields.list" ng-model="panel.sort[0]" type="text"></input>
                <i ng-click="set_sort(panel.sort[0])" class="fa" ng-class="{'fa-chevron-up': panel.sort[1] == 'asc','fa-chevron-down': panel.sort[1] == 'desc'}"></i>
            </div>
            <div class="editor-option">
                <label class="small"><?php echo _('Font Size'); ?></label>
                <select class="form-control" ng-model="panel.style['font-size']" ng-options="f for f in ['7pt','8pt','9pt','10pt','12pt','14pt','16pt','18pt','20pt','24pt','28pt','32pt','36pt','42pt','48pt','52pt','60pt','72pt']"></select></span>
            </div>
            <div class="editor-option" style="margin: 10px 0;">
                <label class="small"><?php echo _('Trim Factor'); ?> <tip><?php echo _('Trim fields to this long divided by # of rows. Requires data refresh.'); ?></tip></label>
                <input type="number" class="form-control" ng-model="panel.trimFactor" ng-change="set_refresh(true)">
            </div>
            <br>
            <div class="editor-option">
                <label class="small"><?php echo _('Local Time'); ?> <tip><?php echo _('Adjust time field to browser\'s local time'); ?></tip></label>
                <input style="margin-top: 8px;" type="checkbox" ng-change="set_refresh(true)" ng-model="panel.localTime" ng-checked="panel.localTime">
            </div>
            <div class="editor-option" ng-show="panel.localTime">
                <label class="small"><?php echo _('Time Field'); ?></label>
                <input type="text" class="form-control" ng-model="panel.timeField" ng-change="set_refresh(true)" bs-typeahead="fields.list">
            </div>
        </div>
        <div class="col-sm-6">
            <div class="section" style="margin-bottom: 20px;">
                <h5><?php echo _('Columns'); ?></h5>
                <form class="input-append editor-option">
                    <input bs-typeahead="fields.list" type="text" class="form-control" ng-model='newfield'>
                    <button class="btn btn-sm btn-default" ng-click="panel.fields = _.toggleInOut(panel.fields,newfield);newfield=''"><i class="fa fa-plus"></i></button>
                </form><br>
                <span style="margin-left: 3px; font-size: 90%;" ng-repeat="field in panel.fields" class="label label-default">{{field}} <i class="pointer fa fa-remove" ng-click="panel.fields = _.toggleInOut(panel.fields,field)"></i></span>
            </div>
            <div class="section">
                <h5><?php echo _('Highlighted Fields'); ?></h5>
                <form class="input-append editor-option">
                    <input bs-typeahead="fields.list" type="text" class="form-control" ng-model='newhighlight' ng-change="set_refresh(true)">
                    <button class="btn btn-sm btn-default" ng-click="panel.highlight = _.toggleInOut(panel.highlight,newhighlight);newhighlight=''"><i class="fa fa-plus"></i></button>
                </form><br>
                <span style="margin-left: 3px; font-size: 90%;" ng-repeat="field in panel.highlight" class="label label-default">{{field}} <i class="pointer fa fa-remove" ng-click="panel.highlight = _.toggleInOut(panel.highlight,field);set_refresh(true)" ></i></span>
            </div>
        </div>
    </div>
</div>