<?php include_once('../setlang.inc.php'); ?>

<style>
.method_option { display: none; }
</style>

<div class="modal-dialog">
    <div class="modal-content" role="document">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            <h2><?php echo _('Create an Alert'); ?></h2>
        </div>
        <div class="modal-body manage-alerts delete-modal-on-close">
            <div class="alert hide" style="margin: 0 0 15px">
                <div class="alert-message"></div>
            </div>
            <div class="alert-body">
                <p id="alerteditor-initial-message"><?php echo _('Create an alert based on the <i>current</i> dashboard\'s queries and filters.'); ?></p>
                <div id="alert_alert"></div>
                <div class="well" style="margin-bottom: 0;">
                    <div class="form-horizontal">
                        <div class="form-group">
                            <label class="col-sm-3 control-label" for="a_name"><?php echo _('Alert Name'); ?></label>
                            <div class="col-sm-9">
                                <input type="text" name="name" class="form-control" style="width: 300px;" id="a_name" value="<?php echo sprintf(_('%s Check'), '{{dashboard.current.title}}'); ?>">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-3 control-label" for="a_ci"><?php echo _('Check Interval'); ?></label>
                            <div class="col-sm-9">
                                <input type="text" name="check_interval" class="form-control" style="width: 60px;" id="a_ci">
                                <i style="margin-left: 5px; font-size: 14px; vertical-align: middle;" class="fa fa-question-circle" bs-tooltip="'<?php echo _('Check interval is how often the check will be performed, default is s for seconds. The values available are seconds (s), minutes (m), hours (h), and days (d). Example check intervals: 60s, 5m, 10m, 2h, 1d'); ?>'"></i>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-3 control-label" for="a_lp"><?php echo _('Lookback Period'); ?></label>
                            <div class="col-sm-9">
                                <input type="text" name="lookback_period" class="form-control" style="width: 60px;" id="a_lp">
                                <i style="margin-left: 5px; font-size: 14px; vertical-align: middle;" class="fa fa-question-circle" bs-tooltip="'<?php echo _('How long to look back when grabbing data to query, default is s for seconds. This will normally be the same as the check interval. Example lookback periods: 60s, 5m, 10m, 2h, 1d'); ?>'"></i>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-3 control-label" for="a_w"><?php echo _('Thresholds'); ?></label>
                            <div class="col-sm-9">
                                <input type="text" name="warning" id="a_w" class="form-control" style="width: 70px;" placeholder="<?php echo _("Warning"); ?>">
                                <input type="text" name="critical" id="a_c" class="form-control" style="width: 70px;" placeholder="<?php echo _("Critical"); ?>"> <?php echo _('# of events'); ?>
                                <i style="margin-left: 5px; font-size: 14px; vertical-align: middle;" class="fa fa-question-circle" bs-tooltip="'<?php echo _('Can use any valid Nagios threshold value. Use 1: for warning and critical to alert with critical on nothing being found.'); ?>'"></i>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-3 control-label" for="a_type"><?php echo _('Notification Method'); ?></label>
                            <div class="col-sm-9">
                                <select name="type" id="a_type" class="form-control" onchange="show_method_options(this);" style="width: auto;">
                                    <option value=""><?php echo _('None'); ?></option>
                                    <option class="admin_only" value="nrdp"><?php echo _('Nagios (send using NRDP)'); ?></option>
                                    <option value="email"><?php echo _('Email Users'); ?></option>
                                    <option class="admin_only" value="exec"><?php echo _('Execute Script'); ?></option>
                                    <option class="admin_only" value="snmp"><?php echo _('Send SNMP Trap'); ?></option>
                                </select>
                                <i style="margin-left: 5px; font-size: 14px; vertical-align: middle;" class="fa fa-question-circle" bs-tooltip="'<?php echo _('Define how you would like to receive the check when it meets the requirements.'); ?>'"></i>
                            </div>
                        </div>
                        <div class="form-group method_option email_option">
                            <label class="col-sm-3 control-label" for="a_users"><?php echo _('Select Users'); ?></label>
                            <div class="col-sm-9">
                                <select id="select_users" style="width: 380px; height: 100px;" class="form-control" name="users" multiple></select>
                            </div>
                        </div>
                        <div class="form-group method_option email_option">
                            <label class="col-sm-3 control-label" for="a_users"><?php echo _("Email Template"); ?></label>
                            <div class="col-sm-9">
                                <select id="templates" class="form-control" name="tpl_id"></select>
                            </div>
                        </div>
                        <div class="form-group method_option exec_option">
                            <label class="col-sm-3 control-label" for="a_script"><?php echo _('Script'); ?></label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" name="exec_location" id="a_script" style="width: 100%;" value="" placeholder="/usr/local/nagioslogserver/scripts/myscript.sh">
                            </div>
                        </div>
                        <div class="form-group method_option exec_option">
                            <label class="col-sm-3 control-label" for="a_args"><?php echo _('Arguments'); ?></label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" name="exec_args" id="a_args" style="width: 100%;" value="" placeholder="-H 192.168.0.1 -U test -p hello">
                                <div style="margin-top: 10px;">
                                    <div><?php echo _('Alerts will automatically replace these placeholders'); ?>:</div>
                                    <div><strong>%count%</strong> - <?php echo _('The total # of events'); ?></div>
                                    <div><strong>%status%</strong> - <?php echo _('The status (ok, warning, critical)'); ?></div>
                                    <div><strong>%output%</strong> - <?php echo _('The output from the alert'); ?></div>
                                    <div><strong>%lastrun%</strong> - <?php echo _('The timestamp of the last run'); ?></div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group method_option nrdp_option">
                            <label class="col-sm-3 control-label" for="a_nrdp_servers"><?php echo _('NRDP Server'); ?></label>
                            <div class="col-sm-9">
                                <select id="a_nrdp_servers" class="form-control" name="nrdp_server"></select>
                            </div>
                        </div>
                        <div class="form-group method_option nrdp_option">
                            <label class="col-sm-3 control-label" for="a_hostname"><?php echo _('Hostname'); ?></label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" name="hostname" id="a_hostname" value="">
                                <i style="margin-left: 5px; font-size: 14px; vertical-align: middle;" class="fa fa-question-circle" bs-tooltip="'<?php echo _('The hostname you want the alert to show up as in Nagios'); ?>'"></i>
                            </div>
                        </div>
                        <div class="form-group method_option nrdp_option">
                            <label class="col-sm-3 control-label" for="a_servicename"><?php echo _('Servicename'); ?></label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" name="servicename" id="a_servicename" value="">
                                <i style="margin-left: 5px; font-size: 14px; vertical-align: middle;" class="fa fa-question-circle" bs-tooltip="'<?php echo _('The servicename related to the hostname that will show up in Nagios'); ?>'"></i>
                            </div>
                        </div>
                        <div class="form-group method_option snmp_option">
                            <label class="col-sm-3 control-label" for="a_snmp_receivers"><?php echo _('Trap Receiver'); ?></label>
                            <div class="col-sm-9">
                                <select id="a_snmp_receivers" class="form-control" name="snmp_receiver"></select>
                            </div>
                        </div>
                        <div class="form-group method_option email_option nrdp_option snmp_option exec_option" style="margin-bottom: 0; display: none;">
                            <label class="col-sm-3 control-label"></label>
                            <div class="col-sm-9 checkbox">
                                <label>
                                    <input type="checkbox" name="send_wc_only" id="a_send_wc_only" value="1">
                                    <?php echo _('Only alert when Warning or Critical threshold is met.'); ?>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-sm btn-success create-alert-btn" ng-click="dashboard.create_nls_alert(this);"><?php echo _('Create Alert'); ?></button>
            <button type="button" class="btn btn-sm btn-default" ng-click="dismiss();"><?php echo _('Close'); ?></button>
        </div>
    </div>
</div>

<script>
function show_method_options(select) {
    var method = $(select).val();
    clear_method_options();

    switch (method)
    {
        case "email":
            $('#a_send_wc_only').attr('checked', true);
            $.post(site_url+'api/user/get_all_users', { form_encode: true }, function(data) {
                html = '';
                $.each(data, function(k, user) {
                    var name = '';
                    if (user.name != '' && user.name != undefined) { name = ' ('+user.name+')'; }
                    if (is_admin) {
                        html += '<option value="'+user.id+'">'+user.username+name+'</option>';
                    } else {
                        if (user.username == LS_USERNAME) {
                            html += '<option value="'+user.id+'">'+user.username+name+'</option>';
                        }
                    }
                });
                $('#select_users').html(html);
            }, 'json');
            $.get(site_url+'api/check/get_templates', { }, function(data) {
                $('#templates').html('<option value="system"><?php echo _("System Default"); ?></option>');
                $(data).each(function(k, v) {
                    $('#templates').append('<option value="'+v._id+'">'+v._source.name+'</option>');
                });
            });
            $('.email_option').show();
            break;

        case "nrdp":
            // Check for NRDP server configurations
            $.get(site_url+'api/check/get_nrdp', {}, function(data) {
                html = '';
                $.each(data, function(k, v) {
                    html += '<option value="'+v._id+'">'+v._source.name+'</option>';
                });
                $('#a_nrdp_servers').html(html);
            }, 'json');
            $('.nrdp_option').show();
            break;

        case "snmp":
            // Check for SNMP trap receivers
            $.get(site_url+'api/check/get_snmp_receivers', {}, function(data) {
                html = '';
                $.each(data, function(k, v) {
                    html += '<option value="'+v._id+'">'+v._source.name+'</option>';
                });
                $('#a_snmp_receivers').html(html);
            }, 'json');
            $('.snmp_option').show();
            break;

        case "exec":
            $('.exec_option').show();
            break;

        default:
            break;
    }
}

function clear_method_options() {
    $('.method_option').hide();
    $('#a_send_wc_only').attr('checked', false);
}
</script>