<?php include_once('../setlang.inc.php'); ?>

<div class="modal-dialog modal-sm">
    <div class="modal-content" role="document">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            <h2><?php echo _('Add New Easy Button'); ?></h2>
        </div>
        <div class="buttons-message-container hide alert alert-danger" style="margin: 0;">
            <div class="buttons-message"></div>
        </div>
        <div class="modal-body delete-modal-on-close make-button">
            <input type="text" class="form-control" style="width: 100%; vertical-align: top;" id="button_name" placeholder="<?php echo _('Give this button a name'); ?>...">            
            <select id="queries-list" class="queries-list form-control" style="width: 100%; margin-top: 5px;"></select>
            <label style="width: 100%; display: inline-block; font-weight: normal; line-height: 29px;" class="admin_only hide">
                <input type="checkbox" id="show_everyone"> <?php echo _('Make global'); ?> <i class="fa fa-question-circle" bs-tooltip="'<?php echo _('Global queries can be seen and used by anyone. Only admins can edit/delete global queries.'); ?>'" data-placement="bottom"></i>
            </label>
        </div>
        <div class="modal-footer">
            <button class="btn btn-sm btn-primary" id="query-create-btn" style="vertical-align: top;" ><?php echo _('Create'); ?></button>
            <button id="modal-close" type="button" class="btn btn-sm btn-default" ng-click="dismiss();"><?php echo _('Close'); ?></button>
        </div>
    </div>
</div>

<script>
var files;

function escape_html(str) {
    return str.replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;');
}

function get_queries_list_button() {
    let html = '';
    
    $.get(site_url+"api/check/get_queries", {}, function(data) {
        if (data.length > 0) {
            html += '<option value="">Select a query</option>';
            $.each(data, function(k, v) {
                var global = '';
                var query_string = '';
                var es_queries = JSON.parse(v.services);

                // for whatever reason we store default queries in "...filter.list" so we get to look here too!
                $.each(es_queries.filter.list, function(key, value) {
                    if (value.type == "field" || value.type == "querystring") {
                        if (value.query.length && value.query !="*") {
                            if (query_string.length) {
                                query_string += " OR (" + value.query + ")"
                            }
                            else {
                                query_string += value.query;
                            }
                        }
                    }
                });

                if (query_string.length == 0) {
                    // check for user queries in "query" object
                    $.each(es_queries.query.list, function(key, value) {
                        if (value.query.length) {
                            if (query_string.length) {
                                query_string += " OR (" + value.query + ")"
                            }
                            else {
                                query_string += value.query;
                            }
                        }
                    });
                }
                
                query_string = query_string.replace(/"/g, '&quot;');
                html += '<option value="' + escape_html(query_string) + '">' + global + escape_html(v.name) + ' | Created by: ' + escape_html(v.created_by) + '</option>';
            });
        } else {
            html = '<option value=""><?php echo _('No queries have been created'); ?>.</option>';
        }
        $('.queries-list').html(html);
    }, 'json');
}

$('#query-create-btn').click(function() {
    var button_name = $('#button_name').val();
    var query = $('#queries-list').val();
    var show_everyone = ($('#show_everyone').is(":checked")) ? 'true' : 'false';

    if (!button_name.length) {
        $('.buttons-message').html('<?php echo _('Please give your button a name.'); ?>');
        $('.buttons-message-container').show();
        return;
    }
    if (!query.length) {
        $('.buttons-message').html('<?php echo _('Please select a query for your button.'); ?>');
        $('.buttons-message-container').show();
        return;
    }

    $.ajax({
        type: "POST",
        url: site_url+"api/check/make_query_button",
        data: {
            name: button_name,
            query: query,
            show_everyone: show_everyone
        },
        success: function(response) {
            if (response == 'error-name') {
                $('.buttons-message').html('<?php echo _('You must provide a unique button name.'); ?>');
                $('.buttons-message-container').show();
            }
            else if (response == 'error-query') {
                $('.buttons-message').html('<?php echo _('A button with this query already exists.'); ?>');
                $('.buttons-message-container').show();
            }
            else if (response == 'success') {
                location.reload();
            }
        }
    });
});

</script>