<?php include_once('../setlang.inc.php'); ?>

<div class="modal-dialog modal-md">
    <div class="modal-content" role="document">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            <h2><?php echo _('Manage Easy Buttons'); ?></h2>
        </div>
        <div class="buttons-message-container hide alert" style="margin: 0;">
            <div class="buttons-message"></div>
        </div>
        <div class="modal-body delete-modal-on-close manage-buttons">
            <div>
                <h4 style=""><?php echo _('Show/Hide Easy Buttons'); ?></h4>
                <div class="flex toggle-container">
                    <div class="flex justify-between">
                        <div>
                            <label for="default-toggle">Default Buttons</label>
                        </div>
                        <label class="switch">
                            <input id="default-toggle" type="checkbox">
                            <span class="slider round"></span>
                        </label>
                    </div>
                    <div class="flex justify-between">
                        <div>
                            <label for="global-toggle">Global Buttons</label>
                        </div>
                        <label class="switch">
                            <input id="global-toggle" type="checkbox">
                            <span class="slider round"></span>
                        </label>
                    </div>
                </div>
                <h4 style="margin: 0; line-height: 28px;"><?php echo _('Edit Custom Buttons'); ?></h4>
                <form id="button-form">
                    <table class="table table-bordered table-striped table-condensed edit-button-table">
                        <thead>
                            <th id="global-header"><?php echo _('Global'); ?></th>
                            <th id="name-header"><?php echo _('Name'); ?></th>
                            <th id="action-header"><?php echo _('Actions'); ?></th>
                        </thead>
                        <tbody class="buttons-list">
                        </tbody>
                    </table>
                </form>
            </div>
        </div>
        <div class="modal-footer flex button-modal justify-end">
            <button class="btn btn-sm btn-primary" id="buttons-save"><?php echo _('Save'); ?></button>
            <button type="button" class="btn btn-sm btn-default" ng-click="dismiss();"><?php echo _('Close'); ?></button>
        </div>
    </div>
</div>

<script>

function escape_html(str) {
    return str.replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;');
}

function get_buttons() {
    var html = '';
    $.get(site_url+"api/check/get_user_buttons", { is_admin: is_admin }, function(data) {
        var buttons = data['hits']['hits'];
        if (buttons.length > 0) {
            $.each(buttons, function(k, v) {
                var actions = '';
                var is_global = false;
                var global_html = '';

                if (v['_source']['show_everyone'] == "true") {
                    global_html = '<i class="fa fa-globe" title="<?php echo _('Can be used by anyone. Only admins can edit.'); ?>" > </i>';
                    is_global = true;
                }
                if (v['_source']['show_everyone'] == "true" && is_admin || v['_source']['show_everyone'] != "true") {
                    actions += '<a class="fa-l" onclick="edit_button(\''+v['_id']+'\', ' + is_global + ');" title="<?php echo _('Edit button'); ?>"><i class="fa fa-pencil"></i></a>';
                    actions += '<a onclick="delete_button(\''+v['_id']+'\');" title="<?php echo _('Delete button'); ?>"><i class="fa fa-trash-o"></i></a>';
                }

                html += '<tr><td class="global"><div class="table-cell-flex global-indicator ' + v['_id']+ '">' + global_html + '</div></td>'
                html += '<td class="name"><div class="flex custom-button-container ' + v['_id']+ '"><div id="title-' + v['_id']+ '" class="' + is_global + '" value="' + v['_source']['query'] + '">'+escape_html(v['_source']['name'])+'</div></td>';
                html += '<td class="actions">'+actions+'</td></tr>';
            });
        } else {
            html = '<tr><td colspan="9"><?php echo _('No buttons have been created'); ?>.</td></tr>';
        }
        $('.buttons-list').html(html);
    }, 'json');
}

function get_default_button_state() {
    $.get(site_url+"api/user/get_user_button_states", {}, function(data) {
        data = JSON.parse(data);
        var default_state = (data['show_default_buttons'] === "false") ? false : true;
        var global_state = (data['show_global_buttons'] === "false") ? false : true;
        $('#default-toggle').prop('checked', default_state);
        $('#global-toggle').prop('checked', global_state);
    });
}

function delete_button(id) {
    if (confirm("<?php echo _('Are you sure you want to delete this button?'); ?>")) {
        $.post(site_url+"api/check/delete_button", { id: id }, function(data) {
            get_buttons();
            $('#' + id ).hide();
        });
    }
}

function edit_button(id, is_global) {
    var selector = 'title-' + id;
    var select_html  = '<select name="query-' + id + '" class="button-form query-select">';
    var existing_title = $('#' + selector).html();
    var checked = (is_global) ? 'checked' : '';
    var current_query = $('#' + selector).attr('value');
    var global_html = '<div class="table-cell-flex global-indicator ' + id + '"><input type="checkbox" class="button-form" id="show_everyone-' + id + '" name="show_everyone-' + id + '" ' + checked + '/></div>';
    var editable_text = '<input name="name-' + id + '" value="' + existing_title + '" class="button-form" size="40" />';

    $.get(site_url+"api/check/get_queries", {}, function(data) {
        if (data.length > 0) {
            $.each(data, function(k, v) {
                var query_string = '';
                var selected = '';
                var es_queries = JSON.parse(v.services);

                // for whatever reason we store default queries in "...filter.list" so we get to look here too!
                $.each(es_queries.filter.list, function(key, value) {
                    if (value.type == "field" || value.type == "querystring") {
                        if (value.query.length && value.query !="*") {
                            if (query_string.length) {
                                query_string += " OR (" + value.query + ")"
                            }
                            else {
                                query_string += value.query;
                            }
                        }
                    }
                });

                if (query_string.length == 0) {
                    // check for user queries in "query" object
                    $.each(es_queries.query.list, function(key, value) {
                        if (value.query.length) {
                            if (query_string.length) {
                                query_string += " OR (" + value.query + ")"
                            }
                            else {
                                query_string += value.query;
                            }
                        }
                    });
                }

                selected = (current_query == query_string) ? 'selected' : '';
                query_string = query_string.replace(/"/g, '&quot;');
                select_html += '<option ' + selected + ' value="' + escape_html(query_string) + '">' + escape_html(v.name) + ' | Created by: ' + escape_html(v.created_by) + '</option>';
            });
        } else {
            select_html = '<option value=""><?php echo _('No queries have been created'); ?>.</option>';
        }
        select_html += '</select>';
        $('#' + selector).replaceWith(editable_text + select_html);
        $('.global-indicator.' + id).replaceWith(global_html);
        $('.custom-button-container.' + id).addClass("justify-between");
    }, 'json');
}

$('#buttons-save').click(function() {
    var inputs = document.getElementsByClassName('button-form');
    var formArray = Array.from(inputs);
    var values = {};
    var show_default = $('#default-toggle').is(":checked")
    var show_global = $('#global-toggle').is(":checked")

    $.each(formArray, function(k, v) {
        var type = v.name.substring(0, v.name.indexOf('-'));
        var id = v.name.substring(v.name.indexOf('-') + 1, v.name.length);
        var actual_value = v.value;
        if (type == "show_everyone") {
            var actual_value = $('#show_everyone-' + id).is(":checked");
        }
        values[k] = {value : actual_value, id : id, type : type};
    });

    $.post(site_url+"api/user/toggle_default_buttons", { show_default : show_default, show_global : show_global }, function(data) {
        var response = JSON.parse(data);
        if (response.status == "failure") {
            $('.buttons-message').html('<?php echo _('Something went wrong, please try again.'); ?>');
            $('.buttons-message-container').addClass('alert-error');
            $('.buttons-message-container').show();
        }
        else {
            $.ajax({
                type: "POST",
                url: site_url+"api/check/edit_buttons",
                data: { values: values },
                success: function(response) {
                    if (response == 'error-name') {
                        $('.buttons-message').html('<?php echo _('You must provide a unique button name.'); ?>');
                        $('.buttons-message-container').addClass('alert-error');
                        $('.buttons-message-container').show();
                    }
                    else if (response == 'error-query') {
                        $('.buttons-message').html('<?php echo _('A button with this query already exists.'); ?>');
                        $('.buttons-message-container').addClass('alert-error');
                        $('.buttons-message-container').show();
                    }
                    else if (response == 'success') {
                        location.reload();
                    }
                }
            });
        }
    });
});

</script>
