#!/bin/bash
# check_es_cluster_status.sh - Monitor a local elasticsearch cluster's health.

if command -v python2 &> /dev/null
then
    python_cmd="python2"
elif command -v python3 &> /dev/null
then
    python_cmd="python3"
else
    echo "UNKNOWN: Python is not installed"
    exit 3
fi

es_output=`curl -s localhost:9200/_cluster/health | $python_cmd -c "
import sys, json
data = json.load(sys.stdin)
if 'number_of_nodes' in data and 'status' in data: sys.stdout.write('{} {}'.format(data['status'], data['number_of_nodes']))"`


if [ -z "$es_output" ]; then
	echo "UNKNOWN: could not retrieve cluster health data"
	exit 3
fi

# If the cluster status is GREEN or RED, set OK or CRITICAL (respectively) and exit immediately.
# If the cluster status is YELLOW, check the number of instances. 1-instance clusters are always yellow, so return OK in this case.
for i in $es_output; do
	case $i in

		"green")
			echo "OK: Cluster status is GREEN"
			exit 0
			;;
		"red")
			echo "CRITICAL: Cluster status is RED"
			exit 2
			;;
		"yellow")
			# Check the number of instances in this cluster.
			;;
		"1")
			echo "OK: Cluster status is YELLOW but there is only one instance in the cluster"
			exit 0
			;;
		*)
			echo "WARNING: Cluster status is YELLOW"
			exit 1
			;;
	esac
done
