<?php

// Taken from https://stackoverflow.com/questions/6054033/pretty-printing-json-with-php
// As a work-around for JSON_PRETTY_PRINT in PHP 5.3.3.
function prettyPrint( $json )
{
    $result = '';
    $level = 0;
    $in_quotes = false;
    $in_escape = false;
    $ends_line_level = NULL;
    $json_length = strlen( $json );

    for( $i = 0; $i < $json_length; $i++ ) {
        $char = $json[$i];
        $new_line_level = NULL;
        $post = "";
        if( $ends_line_level !== NULL ) {
            $new_line_level = $ends_line_level;
            $ends_line_level = NULL;
        }
        if ( $in_escape ) {
            $in_escape = false;
        } else if( $char === '"' ) {
            $in_quotes = !$in_quotes;
        } else if( ! $in_quotes ) {
            switch( $char ) {
                case '}': case ']':
                    $level--;
                    $ends_line_level = NULL;
                    $new_line_level = $level;
                    break;

                case '{': case '[':
                    $level++;
                case ',':
                    $ends_line_level = $level;
                    break;

                case ':':
                    $post = " ";
                    break;

                case " ": case "\t": case "\n": case "\r":
                    $char = "";
                    $ends_line_level = $new_line_level;
                    $new_line_level = NULL;
                    break;
            }
        } else if ( $char === '\\' ) {
            $in_escape = true;
        }
        if( $new_line_level !== NULL ) {
            $result .= "\n".str_repeat( "\t", $new_line_level );
        }
        $result .= $char.$post;
    }

    return $result;
}

function show_arguments_link($path, $data)
{
    $link = '<div class="show-arguments-link" style="display: inline">(<a>' . _('Show Arguments') . '</a>)</div>
             <div class="hide-arguments-link" style="display: none">(<a>'   . _('Hide Arguments') . '</a>)</div>';
    $arguments = $path;
    if ($data) {
        $arguments .= "\n";
        if (defined('JSON_PRETTY_PRINT')) {
            $arguments .= json_encode(json_decode($data), JSON_PRETTY_PRINT);
        }
        else {
            $arguments .= prettyPrint($data);
        }
    }
    $arguments = '<div class="arguments-data" style="display: none"><pre>' . $arguments . '</pre></div>';
    return $link . $arguments;
}

function rerun_query_action($index, $request_method, $path, $data)
{
    $ci =& get_instance();
    $action = array(
        'type' => 'query_rerun',
        'index' => $index,
        'path' => $path,
        'request_method' => $request_method,
        'data' => $data
    );

    return $action;
}

function rerun_query_link($action_array) {

    $ci =& get_instance();
    $link = '<div class="show-results-link">' .
            /* id is randomly generated so that multiple forms with target="_blank" can exist on one page */
           '<form id="'.uniqid().'" method="post" action="' . site_url('alerts/raw_custom') . '" target="_blank" style="display: inline"><!--
             --><input type="hidden" name="index" value="' . $action_array['index'] . '"><!--
             --><input type="hidden" name="path" value="' . $action_array['path'] . '"><!--
             --><input type="hidden" name="request_method" value="' . $action_array['request_method'] . '"><!--
             --><input type="hidden" name="data" value=\'' . $action_array['data'] . '\'><!--
             --><input type="hidden" name="' . $ci->security->get_csrf_token_name() . '" value="' . $ci->security->get_csrf_hash() .'"><!--
             --><button class="btn-link"><i class="fa fa-play" title="' ._('Show Query Results') . '"></i></button><!--
         --></form></div>';
    return $link;
}