<?php

/**
 * Redirect if user isn't logged in.
 **/
function require_auth()
{
    $ci =& get_instance();
    if (!($ci->users->logged_in())) {
        redirect('auth/login?next='.$_SERVER['REQUEST_URI']);
    }
}

/**
 * check for an admin user
 **/
function is_admin()
{
    $ci =& get_instance();
    return $ci->users->is_admin();
}

/**
 * Check for a logged-in user
 **/
function logged_in()
{
    $ci =& get_instance();
    return $ci->users->logged_in();
}

function in_api_call()
{
    $ci =& get_instance();
    return $ci->users->in_api_call();
}

/**
 * Gets the current session's username
 *
 * @return string Current session's username
 */
function get_username()
{
    $ci =& get_instance();
    $user = $ci->users->get_user();
    return $user['username'];
}

/**
 * Checks user's permissions to see if they have the correct permission
 *
 * @param   string  $type   The name of the type of permission
 * @param   array   $perms  An array of permission(s) required to allow access
 * @return  bool            True if user has permission(s)
 */
function user_has_permission($type='', $perms=array())
{
    if (empty($type)) { return false; }
    if (is_admin()) { return true; }

    $ci =& get_instance();

    if ($ci->input->is_cli_request()) {
        /* Shell already has direct access to the database. This just allows upgrade scripts to use normal controllers */
        return true;
    }

    $user = $ci->users->get_user();

    // Verify that user has permissions set
    if (empty($user['perms']) || empty($user['perms'][$type])) {
        return false;
    } else {
        // Check if each permission matches
        foreach ($perms as $perm) {
            if (!in_array($perm, $user['perms'][$type])) {
                return false;
            }
        }
        return true;
    }

    return false;
}

/**
 * Check to see if Nagios Reactor should be shown
 *
 * @return  bool    True if we should show Reactor
 */
function show_nagios_reactor()
{
    $ci =& get_instance();
    $results = $ci->elasticsearch->query_wresultSize('reactor_server');
    if ($results['hits']['total']['value'] > 0) {
        return true;
    }
    return false;
}

/**
 * Check user type assignment (user or admin)
 *
 * @param $type string The auth_type of user "admin" or "user"
 *
 * @return bool True or false if the type matches
 **/
function is_user_type($type) 
{
    $ci =& get_instance();
    $user = $ci->users->get_user();
    return ($user['auth_type'] == 'admin' || $user['auth_type'] == $type);
}
