<?php

/* DO NOT REMOVE THIS LINE! sourceguardian-check */

/**
 *  functions that can be called from cmdsubsys
 **/
 
/************************************************
	POLLER FUNCTIONS 
*************************************************/ 
/**
 * updates the cluster_host file
 **/
function update_cluster_hosts()
{
    $ci =& get_instance();
    
    $hosts_file = $ci->config->item('hosts_file');
    if (!is_writable($hosts_file)) {
        echo "$hosts_file is not writeable, check file permissions";
        exit(1);
    }
    $es = new Elasticsearch(array('index' => '/'));
    $cluster = $es->backend_call('_cluster/state/version,master_node,nodes');

    // Check if we have valid return
    if(is_array($cluster['nodes'])) {
    
        $ips = file($hosts_file);
        
        foreach($cluster['nodes'] as $key => $value) {
            if ($value['attributes']['client'])
                continue;
            // Convert to readable IP/Port
            $ip_port = split_inet_string($value['transport_address']);
            $ips[] = $ip_port['ip'];
        }

        $ips = array_map('trim',$ips);
        
        $new_ip_list = array_unique($ips);
        $new_ip_list = implode("\n", $new_ip_list);

        file_put_contents($hosts_file, $new_ip_list);
    } else {
        echo _('ERROR: Connection to OpenSearch cannot be made')."\n";
        return false;
    }
}

/**
 * Updates this node in the OpenSearch db
 **/
function update_opensearch_nodes()
{
    $es_type = 'node';
    $ci =& get_instance();
    $ci->load->model('systemstat');
    $ci->load->helper('licensing_helper');
    $ci->load->helper('network');
    $es = new Elasticsearch();
    $es_root = new Elasticsearch(array("index" => "/"));
    
    $node_data = array("last_updated" => time(),
                       "ls_version" => get_product_version(),
                       "ls_release" => get_product_release(),
                       "opensearch" => $ci->systemstat->status('opensearch'),
                       "logstash" => $ci->systemstat->status('logstash'));

    // Get the proper ip address of the node... and then get hostname if exists
    $stats = $es_root->backend_call('_nodes/_local/stats/?human');
    
    if(!is_array($stats['nodes'])){
        echo _('ERROR: Connection to OpenSearch cannot be made')."\n";
        return false;
    }
    
    $node_stats = reset($stats['nodes']);
    $p = split_inet_string($node_stats['transport_address']);
    $hostname = dns_reverse_lookup($p['ip']);
    $node_data['address'] = $p['ip'];

    if (!empty($hostname)) {
        $node_data['hostname'] = $hostname;
    }

    // Check if node already exists in the database
    $result = $es->get($es_type, NODE);
    if (empty($result['found'])) {
        // Doesn't exist.. so let's add it...
        $es->add($es_type, $node_data, NODE);
        
        $log = array('type' => 'POLLER',
                     'message' => _('New instance added to Nagios Log Server'),
                     'node' => NODE
                    );
        $logged = $ci->logger->log($log);
        
    } else {
        // Does exist... let's update it
        $es->update($es_type, $node_data, NODE);
    }

    // Update Opensearch yml configuration.
    // Retrieve the current node list.
    $es2 = new Elasticsearch(array("index" => "nagioslogserver_node"));
    $result = $es2->query_all_wresultSize('',10000);
    $nodes = array();
    foreach ($result['hits']['hits'] as $hit) {
        if ($hit['_id'] !== 'global') {
            $nodes[$hit['_id']] = array(
                'address' => $hit['_source']['address'],
                'name' => $hit['_source']['hostname']
            );
        }
    }

    $yml_file = '/usr/local/nagioslogserver/opensearch/config/opensearch.yml';
    // Read the current yml configuration.
    $yml = preg_split("/\r\n|\n|\r/", file_get_contents($yml_file));
    $discovery_ips = [];
    foreach ($yml as $line) {
        if (strpos($line, 'discovery.seed_hosts') === 0) {
            try {
                $discovery_ips = json_decode(str_replace( 'discovery.seed_hosts: ', '', $line));
            }
            catch (Exception $e) {
                // TODO: find an example that makes this barf and put up an appropriate message
            }
        }
    }

    $added_discovery = false;

    foreach ($nodes as $name => $node_info) {
        if (! in_array($node_info['address'], $discovery_ips)) {
                $discovery_ips[] = $node_info['address'];
                $added_discovery = true;
        }
    }

    if ($added_discovery) {
        $yml_content = [];

        foreach ($yml as $line) {
            if (strpos($line, 'discovery.seed_hosts') === 0) {
                $yml_content[] = 'discovery.seed_hosts: ' . json_encode($discovery_ips);
            } else {
                $yml_content[] = $line;
            }
        }

        file_put_contents($yml_file, implode("\n", $yml_content));

        // TODO: Kick of logstash reconfiguration reload on all nodes.
        $ci->load->model('cmdsubsys');

        $es3 = new Elasticsearch(array("index" => "nagioslogserver_snapshot"));

        // Delete the oldest snapshot

        // Check how many automatic snapshots already exist...
        $result = $es3->query_wresultSize('', 'auto:1');
        if ($result['hits']['total']['value'] >= 10) {
            // Find the oldest snapshot
            $oldest = PHP_INT_MAX;
            $oldest_id = '';
            foreach ($result['hits']['hits'] as $s) {
                if ($oldest > $s['_source']['created']) {
                    $oldest = $s['_source']['created'];
                    $oldest_id = $s['_id'];
                }
            }

            $result = $es3->get('', $oldest_id);
            $args = array("path" => $result['_source']['path']);
    
            // Delete the snapshot on each node...
            $result = $es3->query_wresultSize('node');
            foreach ($result['hits']['hits'] as $node) {
                if ($node['_id'] == "global") { continue; }
                $data = array("command" => 'delete_snapshot', "node" => $node['_id'], "args" => $args);
                $r = $ci->cmdsubsys->create($data);
            }
    
            // Delete it from the DB
            $es3->delete('', $oldest_id);
            $es3->refresh('');
        }
        
        // Add new snapshot to the OpenSearch DB
        $data = array("name" => "Apply Config Snapshot", "auto" => 1);
        $result = $es3->add('snapshot', $data);
        $es3->refresh('snapshot');
        $args = array("sh_id" => $result['_id'], "sh_created" => time());
        
        // Create the jobs to apply config
        $result = $es2->query_all_wresultSize('',10000);
        foreach ($result['hits']['hits'] as $node) {
            if ($node['_id'] == "global") { continue; }
            $data = array("command" => 'apply_config', "node" => $node['_id'], "args" => $args);
            $job = $ci->cmdsubsys->create($data);
        }
        
        // Set conifguration option
        set_option('configuration_required', 0);
    }
}
