<?php echo $header; ?>
<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">
        <h1 class="form-title tw-inline-flex">
            <?php echo _('Cluster Status'); ?>
            <div class="clear"></div>
        </h1>
        <div class="tw-inline-flex tw-float-right tw-gap-2 tw-items-center">
            <tooltip-provider>
                <tooltip data-position="top" data-delay="100">
                    <tooltip-trigger>
                        <!-- the cluster id needs to be displayed verbatim for use in other nodex -->
                        <span class="badge" name="cluster_id" style="text-transform:none"><?php echo ' ' . $cluster['health']['cluster_name']; ?> <span class="material-symbols-outlined base">check_circle</span></span>
                    </tooltip-trigger>
                    <tooltip-content>
                        <div><?php echo _('Cluster ID'); ?></div>
                    </tooltip-content>
                </tooltip>
            </tooltip-provider>
        </div>

        <div class="form-spacer"></div>

        <div id="workspace">
            <div class="alert alert-info hide" id="indices_opening"><?php echo sprintf(_('Some indices are still opening. %1$s of %2$s remaining'), '<div id="indices_opening_remaining" style="display: inline"></div>', '<div id="indices_opening_total" style="display: inline"></div>');?>
            </div>
            <div class="tw-flex tw-gap-4">
                <div class="tw-w-1/2">
                    <div class="tw-my-4">
                        <div class="tw-flex tw-gap-2 tw-items-center tw-my-2">
                            <span class="material-symbols-outlined">query_stats</span>
                            <span class="form-header"><?php echo _("Cluster Statistics"); ?></span>
                        </div>
                        <div class="tw-rounded-lg tw-border-border tw-border tw-p-[6px] tw-overflow-auto">
                            <div>
                                <div class="col-sm-12 col-lg-6 tw-p-[10px]">
                                    <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo number_format($cluster['stats']['indices']['docs']['count']); ?></span><span><?php echo _("Documents"); ?></span></div>
                                </div>
                                <div class="col-sm-12 col-lg-6 tw-p-[10px]">
                                    <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo strtoupper($index['stats']['_all']['primaries']['store']['size']); ?></span><span><?php echo _("Primary Size"); ?></span></div>
                                </div>
                                <div class="col-sm-12 col-lg-6 tw-p-[10px]">
                                    <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo strtoupper($index['stats']['_all']['total']['store']['size']); ?></span><span><?php echo _("Total Size"); ?></span></div>
                                </div>
                                <div class="col-sm-12 col-lg-6 tw-p-[10px]">
                                    <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo $cluster['health']['number_of_data_nodes']; ?></span><span><?php echo _("Data Instances"); ?></span></div>
                                </div>
                                <div class="col-sm-12 col-lg-6 tw-p-[10px]">
                                    <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo $index['stats']['_shards']['total']; ?></span><span><?php echo _("Total Shards"); ?></span></div>
                                </div>
                                <div class="col-sm-12 col-lg-6 tw-p-[10px]">
                                    <div class="tw-text-center tw-p-5 tw-border tw-border-border tw-rounded-lg"><span class="stat-detail"><?php echo $cluster['stats']['indices']['count']; ?></span><span><?php echo _("Indices"); ?></span></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tw-w-1/2">
                    <div class="tw-my-4">
                        <div class="tw-flex tw-gap-2 tw-items-center tw-my-2">
                            <span class="material-symbols-outlined">cardiology</span>
                            <span class="form-header"><?php echo _("Cluster Health"); ?></span>
                        </div>
                        <div class="tw-rounded-lg tw-border-border tw-border tw-p-4 tw-overflow-auto">
                            <table class="ui-table">
                                <tbody class="ui-tbody">
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Status"); ?></td>
                                        <td class="ui-td"><span class="badge <?php echo $status_label; ?>"><?php echo ucfirst($cluster['health']['status']); ?></span></td>
                                    </tr>
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Timed Out?"); ?></td>
                                        <td class="ui-td"><?php echo ($cluster['health']['timed_out']) ? 'true' : 'false'; ?></td>
                                    </tr>
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("# Instances"); ?></td>
                                        <td class="ui-td"><?php echo $cluster['health']['number_of_nodes']; ?></td>
                                    </tr>
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("# Data Instances"); ?></td>
                                        <td class="ui-td"><?php echo $cluster['health']['number_of_data_nodes']; ?></td>
                                    </tr>
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Active Primary Shards"); ?></td>
                                        <td class="ui-td"><?php echo $cluster['health']['active_primary_shards']; ?></td>
                                    </tr>
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Active Shards"); ?></td>
                                        <td class="ui-td"><?php echo $cluster['health']['active_shards']; ?></td>
                                    </tr>
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Relocating Shards"); ?></td>
                                        <td class="ui-td"><?php echo $cluster['health']['relocating_shards']; ?></td>
                                    </tr>
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Initializing Shards"); ?></td>
                                        <td class="ui-td"><?php echo $cluster['health']['initializing_shards']; ?></td>
                                    </tr>
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Unassigned Shards"); ?></td>
                                        <td class="ui-td"><?php echo $cluster['health']['unassigned_shards']; ?></td>
                                    </tr>
                                </tbody>
                            </table>
                            <div class="clear"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <?php echo $indices_table; ?>
            </div>
        </div>
    </div>
</div>

<!-- Confirm Conversion Modal -->
<div id="convert-to-cluster-confirmation" class="modal hide fade" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="convert-to-cluster-confirmation-header"><?php echo _('Please Confirm'); ?></h4>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
            <div class="modal-body">
                <p class="form-subheader"><?php echo _('Converting NLS from a single node to a cluster is a one-way operation. Please confirm that you want this server to be a multi-node cluster. OpenSearch will restart, and the web interface may be inaccessible for several minutes. You may be logged out afterward. Please keep this page open until it refreshes.'); ?></p>
                <span id="clustering-status"></span>
            </div>
            <div class="modal-footer tw-flex tw-space-x-2 tw-justify-end">
                <button id="convert-to-cluster-confirmation-confirm" class="ui-btn ui-btn-default"><?php echo _('Confirm'); ?></button>
                <button class="ui-btn ui-btn-outlined" data-dismiss="modal" aria-hidden="true"><?php echo _('Cancel'); ?></button>
            </div>
        </div>
    </div>
</div>

<script>

    $(document).ready(function() {
        $('.convert-to-cluster').click(function () {
            $('#convert-to-cluster-confirmation').modal('show');
        });

        $('#convert-to-cluster-confirmation-confirm').click(function() {
            // Trigger migration to cluster
            $.get('<?php echo site_url("api/system/to_cluster"); ?>', {}, function(data) {
                if (data.hasOwnProperty('error')) {
                    alert(data.error);
                    return;
                }

                $('#clustering-status').html(data.message);

                poll_command_status(data.command_ids);
            });
        });
    });


    function poll_command_status(command_ids) {
        let commands_finished = Array(command_ids.length).fill(false);
        let polling_functions = Array(command_ids.length);

        function poll_single_status(index) {
            if (commands_finished[index]) { 
                return;
            }

            $.get('<?php echo site_url("api/system/get_job_by_id"); ?>', { id: command_ids[index] }, function(data) {
                if (data['status'] == 'completed') {
                    clearInterval(polling_functions);
                    commands_finished[i] = true;
                    if (commands_finished.indexOf(false) < 0) {
                        // TODO: "finished configuration changes! restarting OpenSearch..."
                        $('#clustering-status').html('<?php echo json_encode(_("Finished configuration changes - restarting OpenSearch...")); ?>');
                        restart_opensearch();
                    }
                    else {
                        clustering_status_tick();
                    }
                }
            });
        }

        for (i in command_ids) {
            polling_functions[i] = setInterval(poll_single_status, 3000, i);
        }
    }

    function restart_opensearch() {

        let interval_id = setInterval(clustering_status_tick, 3000);

        $.get('<?php echo site_url('api/system/restart') ?>', { subsystem: 'opensearch' }, function(data) {
            clearInterval(interval_id); 

            if (data.hasOwnProperty('error')) {
                $('#clustering-status').html(<?php echo json_encode(_('Failed to restart OpenSearch.')); ?>);
                return;
            }

            $('#clustering-status').html(<?php echo json_encode(_("OpenSearch restarted, refreshing...")); ?>);
            setTimeout(function() { window.location.reload(); }, 3000);
        });
    }

    function clustering_status_tick() {
        $('#clustering-status').append('.');
    }
</script>

<?php echo $footer; ?>