<?php echo $header; 


/**
 * Taken from XI codebase
 */
function human_readable_bytes($bytes)
{
    $base = log($bytes) / log(1024);
    $suffixes = array('B', 'KB', 'MB', 'GB', 'TB');
    return round(pow(1024, $base - floor($base)), 2) . " " . $suffixes[floor($base)];
}
?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">

<?php if (is_demo_mode()) { ?>
        <h1 class="form-title"><?php echo _('Custom Includes'); ?></h1>
        <p class="form-subtitle"><?php echo _('This page is not supported in demo mode.'); ?></p>
    </div>
</div>
<?php echo $footer; ?>
<?php return; } // end is_demo_mode() ?>



        <h1 class="form-title"><?php echo _('Custom Includes'); ?></h1>
        <p class="form-subtitle"><?php echo _('Allowed file types for upload are: .css, .js, .png, .jpg, .jpeg, .gif, and .bmp. Uploading the same filename will overwrite the original. CSS and JS files will be included in the order they appear in the list below. To change include order, drag and drop the rows and then save changes.'); ?></p>
        <div class="form-spacer"></div>

        <?php if (!empty($errors)) { ?>
            <div class="alert alert-error">
                <?php echo _('Some files were skipped due to the following errors:') . '<br>'; ?>
                <?php echo implode('<br>', $errors); ?>
            </div>
        <?php } ?>

        <div class="tw-mb-6">
            <form action="<?php echo site_url('admin/custom_includes'); ?>?&upload=1" method="post" enctype="multipart/form-data" style="margin: 0;">
                <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">
                <input type="hidden" name="MAX_FILE_SIZE" value="50000000"><!-- 50 MB max size, i.e. files will be limited by php.ini, not this form. -->
                <div class="input-group" style="width: 280px; float: left;">
                    <span class="input-group-btn">
                        <button class="ui-btn ui-btn-outlined" style="width: 80px;">
                            <?php echo _('Browse'); ?>&hellip;
                            <input id="uploaded-files" class="tw-absolute tw-inset-0 tw-w-full tw-h-full tw-opacity-0 tw-cursor-pointer" type="file" name="uploadedfile[]" multiple>
                        </button>
                    </span>
                    <input id="file-names-here" type="text" class="ui-input tw-mx-2 tw-w-[240px]" style="width: 240px;" readonly>
                </div>
                <button type="submit" class="ui-btn ui-btn-outlined"><div class="tw-flex tw-items-center tw-justify-center tw-gap-2"><span class="material-symbols-outlined">upload</span> <?php echo _('Upload'); ?></div></button>
            </form>
            <div class="clear"></div>
        </div>

        <ui-tabs default-value="css">
            <tabs-list>
               <tabs-trigger value="css"><?php echo _("CSS"); ?></tabs-trigger>
               <tabs-trigger value="javascript"><?php echo _("Javascript"); ?></tabs-trigger>
               <tabs-trigger value="images"><?php echo _("Images"); ?></tabs-trigger>
            </tabs-list>

        <?php echo form_open('admin/custom_includes?sort=1'); ?>

            <tabs-content value="css">
                <table class="ui-table">
                    <thead class="ui-thead">
                        <tr class="ui-tr">
                            <th class="ui-th tw-w-[36px]"></th>
                            <th class="ui-th"><?php echo _('File Name'); ?></th>
                            <th class="ui-th tw-w-[140px]"><?php echo _('File Size'); ?></th>
                            <th class="ui-th"></th>
                        </tr>
                    </thead>
                    <tbody class="ui-tbody <?php if (count($includes['css']) > 0) { echo 'sortable'; } ?>">
                        <?php
                        if (count($includes['css']) > 0) {
                            foreach ($includes['css'] as $i => $f) {
                                ?>
                                <tr class="ui-tr">
                                    <td class="ui-td">
                                        <input type="checkbox" name="css[]" value="<?php echo $i; ?>" class="tt-bind ui-checkbox-group-item" title="<?php echo _('Include'); ?>" <?php if ($f['inc']) { echo 'checked'; } ?>>
                                        <input type="hidden" name="css_order[]" value="<?php echo $i; ?>">
                                    </td>
                                    <td class="ui-td"><?php echo $f['name']; ?></td>
                                    <td class="ui-td tw-w-[140px]"><?php echo human_readable_bytes($f['size']); ?></td>
                                    <td class="ui-td tw-text-center tw-w-[80px]">
                                        <a href="<?php echo site_url('admin/custom_includes'); ?>?delete=1&type=css&id=<?php echo $i; ?>&name=<?php echo $f['name']; ?>" class="tt-bind" data-placement="left" title="<?php echo _('Delete'); ?>"><i class="fa fa-times fa-14" style="color: red"></i></a>
                                    </td>
                                </tr>
                                <?php
                            }
                        } else {
                            ?>
                            <tr class="ui-tr">
                                <td class="ui-td" colspan="4"><em><?php echo _('No CSS files have been added.'); ?></em></td>
                            </tr>
                            <?php
                        } ?>
                    </tbody>
                </table>
            </tabs-content>
            <tabs-content value="javascript">
                <table class="ui-table">
                    <thead ui-thead">
                        <tr class="ui-tr">
                            <th class="ui-th tw-w-[36px]"></th>
                            <th class="ui-th"><?php echo _('File Name'); ?></th>
                            <th class="ui-th tw-w-[140px]"><?php echo _('File Size'); ?></th>
                            <th class="ui-th"></th>
                        </tr>
                    </thead>
                    <tbody class="<?php if (count($includes['js']) > 0) { echo 'sortable'; } ?>">
                        <?php
                        if (count($includes['js']) > 0) {
                            foreach ($includes['js'] as $i => $f) {
                                ?>
                                <tr class="ui-tr">
                                    <td class="ui-td">
                                        <input type="checkbox" name="js[]" value="<?php echo $i; ?>" class="tt-bind ui-checkbox-group-item" title="<?php echo _('Include'); ?>" <?php if ($f['inc']) { echo 'checked'; } ?>>
                                        <input type="hidden" name="js_order[]" value="<?php echo $i; ?>">
                                    </td>
                                    <td class="ui-td"><?php echo $f['name']; ?></td>
                                    <td class="ui-td tw-w-[140px]"><?php echo human_readable_bytes($f['size']); ?></td>
                                    <td class="ui-td tw-text-center tw-w-[80px]">
                                        <a href="<?php echo site_url('admin/custom_includes'); ?>?delete=1&type=js&id=<?php echo $i; ?>&name=<?php echo $f['name']; ?>" class="tt-bind" data-placement="left" title="<?php echo _('Delete'); ?>"><i class="fa fa-times fa-14" style="color: red"></i></a>
                                    </td>
                                </tr>
                                <?php
                            }
                        } else {
                            ?>
                            <tr class="ui-tr">
                                <td class="ui-td" colspan="4"><em><?php echo _('No JS files have been added.'); ?></em></td>
                            </tr>
                            <?php
                        } ?>
                    </tbody>
                </table>
            </tabs-content>
            <tabs-content value="images">
                <table class="ui-table">
                    <thead ui-thead">
                        <tr class="ui-tr">
                            <th class="ui-th"><?php echo _('File Name'); ?></th>
                            <th class="ui-th tw-w-[140px]"><?php echo _('File Size'); ?></th>
                            <th class="ui-th"></th>
                        </tr>
                    </thead>
                    <tbody class="<?php if (count($includes['images']) > 0) { echo 'sortable'; } ?>">

                        <?php
                        if (count($includes['images']) > 0) {
                            foreach ($includes['images'] as $i => $f) {
                                ?>
                                <tr class="ui-tr">
                                    <td class="ui-td"><?php echo $f['name']; ?></td>
                                    <td class="ui-td tw-w-[140px]"><?php echo human_readable_bytes($f['size']); ?></td>
                                    <td class="ui-td tw-w-[80px] tw-text-center">
                                    <dropdown-menu data-position="bottom">
                                        <dropdown-trigger as-child>
                                            <div class="material-symbols-outlined ui-icon-btn">more_horiz</div>
                                        </dropdown-trigger>
                                        <dropdown-content class="ui-dropdown-content">
                                            <a href="<?php echo base_url('media/custom/images/') . $f['name']; ?>" class="tt-bind">
                                            <dropdown-item class="ui-dropdown-item">
                                                <?php echo _('Preview'); ?>
                                            </dropdown-item></a>
                                            <a class="rename" data-type="images" data-id="<?php echo $i; ?>" data-name="<?php echo $f['name']; ?>"  class="tt-bind">
                                            <dropdown-item class="ui-dropdown-item"><?php echo _('Edit'); ?></dropdown-item></a>
                                            <a href="<?php echo site_url('admin/custom_includes'); ?>?delete=1&type=images&id=<?php echo $i; ?>&name=<?php echo $f['name']; ?>" class="tt-bind">
                                            <dropdown-item class="ui-dropdown-item"><?php echo _('Delete'); ?></dropdown-item></a>
                                        </dropdown-content>
                                    </dropdown-menu>
                                    </td>
                                </tr>
                                <?php
                            }
                        } else {
                            ?>
                            <tr class="ui-tr">
                                <td class="ui-td" colspan="4"><em><?php echo _('No images have been added.'); ?></em></td>
                            </tr>
                            <?php
                        } ?>
                    </tbody>
                </table>
            </tabs-content>
        </ui-tabs>
        

        <div>
            <button type="submit" class="ui-btn ui-btn-default"><?php echo _('Save Changes'); ?></button>
        </div>

        <?php echo form_close(); ?>

    </div>
</div>

<div id="rename-modal" class="modal hide fade" data-backdrop="static" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">

        <?php echo form_open('admin/custom_includes'); ?>

        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h2><?php echo _("Rename an Image"); ?></h2>
            </div>
            <div class="modal-body delete-modal-on-close">
                <?php if (is_demo_mode()) { ?>
                <div class="alert alert-danger" style="margin: 0 0 15px 0;">
                    <?php echo _("This function is not available in demo mode."); ?>
                </div>
                <?php } ?>
                <div class="alert-body">
                    <input type="hidden" name="rename" value="1">
                    <input type="hidden" value="" id="rename-id" name="id">
                    <input type="hidden" value="" id="rename-type" name="type">
                    <div class="well" style="margin-bottom: 0;">
                        <div class="form-horizontal">
                            <div class="form-group">
                                <label class="col-sm-3 control-label" for="a_name"><?php echo _("Current Name"); ?></label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" name="name" style="width: 300px;" id="rename-old-name" disabled>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="col-sm-3 control-label" for="a_name"><?php echo _("New Name"); ?></label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" name="name" style="width: 300px;" id="rename-new-name">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="ui-btn ui-btn-default tw-mr-2" <?php if (is_demo_mode()) { echo 'disabled'; } ?> id="rename-submit-btn"><?php echo _("Submit"); ?></button>
                <button type="button" class="ui-btn ui-btn-outlined" data-dismiss="modal" aria-hidden="true"><?php echo _("Cancel"); ?></button>
            </div>
        </div>

        <?php echo form_close(); ?>

    </div>
</div>
<script>
    $(document).ready(function () {
        // last tab handling
        if (localStorage.getItem('last_tab') !== null){
            // initialize needed vars
            var tabs = ['css', 'javascript', 'images']
            var last_tab = localStorage.getItem('last_tab')
            // quick loop through and check which tab was last selected
            tabs.forEach(e => {
                var tab_element = $("#show-" + e)
                var tab_element_content = $("#" + e)
                
                // load the last tab as the active tab and tab content
                if(e == last_tab) {
                    tab_element.parent().addClass('active')
                    tab_element.attr('aria-expanded', 'true')
                    tab_element_content.addClass('active')
                }
                // remove active tab and tab content classes if not last selected
                else {
                    tab_element.parent().removeClass('active')
                    tab_element.attr('aria-expanded', 'false')
                    tab_element_content.removeClass('active')
                }
            });
        }
        
        $('#uploaded-files').change(function() {
            var names = '';
            for (var i = 0; i < this.files.length; i++) {
                names += this.files[i].name + ', ';
            }
            names = names.substring(0, names.length-2);
            $('#file-names-here').val(names);
        });

        // Populate and open the "Rename an Image" modal
        $('.rename').click(function() {
            var id = $(this).data('id');
            var old_name = $(this).data('name');
            var type = $(this).data('type');

            $('#rename-id').val(id);
            $('#rename-old-name').val(old_name);
            $('#rename-type').val(type);
            $('#rename-modal').modal('show');
        });

        // Enable drag-and-drop sorting on populated tables
        $('.sortable').sortable();
        
        // When a tab is clicked, save in localstorage so we can return to it after form submission (page reloading)
        $('.nav-tabs').click(function (e) {
            localStorage.setItem("last_tab", e.target.hash.substring(1));
        });

        // Return to the tab we were on last (if a form was submitted)
        var tab = "<?php echo htmlentities($tab, ENT_COMPAT, 'UTF-8'); ?>";
        if (tab) {
            $('#show-' + tab).click();
        }
    });
</script>

<?php echo $footer; ?>