<?php echo $header; ?>
<script type="text/javascript">
var USERID = '<?php echo $user["id"]; ?>';
var hash = '<?php echo $hash; ?>';
$(document).ready(function() {

    if (hash == "") {
        hash = window.location.hash;
        $('input[name="hash"]').val(hash);
    }

    show_correct_fields();
    check_required('.alerts');
    check_required('.contacts');
    check_required('.config');

    $('#account_type').change(function() {
        show_correct_fields();
    });

    // Set the hash value to current tab
    $('a[data-toggle="tab"]').on('shown.bs.tab', function(e) {
        window.location.hash = e.target.hash;
        $('input[name="hash"]').val(e.target.hash);
    });

    // Set current tab to the hash given on page load
    if (hash != "") {
        // Activate appropriate tabs
        $('.tab-pane').removeClass('active');
        $('.nav-tabs li').removeClass('active');
        $('.nav-tabs li a').each(function(k, v) {
            var x = $(v).attr('href');
            if (x == hash) {
                $(v).parent().addClass('active');
            }
        });

        // Show the actual content
        $(hash).addClass('active');
        $(hash).show();
    }

    $('input[name="auth_type"]').change(function() {
        var type = $(this).val();
        if (type == 'user') {
            $('.user-perms').show();
        } else {
            $('.user-perms').hide();
        }
    });

    // Toggle all perms or not in the row
    $('.toggle-all').click(function() {

        var section = $(this).data('section');
        
        if ($('#' + section + '-admin').is(":checked")) {
            $('.' + section).prop('disabled', false)
                            .prop('checked', false);
        }
        else {
            $('#' + section + '-admin').prop('checked', true);
            $('.' + section).not('#' + section + '-admin')
                            .prop('checked', true)
                            .prop('disabled', true);
        }

        check_required('.config');
        check_required('.contacts');
        check_required('.alerts');
    });

    admin_button('alerts');
    admin_button('contacts');

    // If create, edit, or delete selected... must have view
    $('.alerts').click(function () { check_required('.alerts'); });
    $('.contacts').click(function () { check_required('.contacts'); });
    $('.config').click(function () { check_required('.config'); });

    $('input[name="auth_type"]').click(function () {
        var auth_type = $(this).val();
        if (auth_type == 'admin') {
            $('.no-admin').prop('checked', false);
            $('.yes-admin').prop('checked', true);
            $('.no-admin').prop('disabled', true);
        } else {
            $('.no-admin').prop('disabled', false);
        }
    });

    // When a "Known Hosts" item is selected, paste it into the Additional Hosts textarea (unless it's already there)
    $('#host-list-known-hosts').change(function(e) {

        // Build the regex:
        // To match an entry like '192.168.0.1', we want a regexp like '/^192\.168\.0\.1$/m'
        // Get the IP Address that was just selected
        var addr = e.target.value;

        // Replace all periods '.' with the escaped periods '\.'
        var addr_escaped = addr.replace(/\./g, '\\.');

        // Match any line exactly matching the IP Address
        var match_regexp = new RegExp('^' + addr_escaped + '$', 'm');

        // If the IP Address is already present, do nothing
        var current_text = $('#host-list-selected-hosts').val();
        if (!current_text.match(match_regexp)) {

            // Insert a newline only if we need to
            var last_character = current_text[current_text.length-1];
            if ((typeof last_character !== 'undefined') && last_character !== '\n') {
                $('#host-list-selected-hosts')[0].value += "\n";
            }

            // Finally, insert the IP address into the textarea.
            $('#host-list-selected-hosts')[0].value += addr;
        }
    });

    // Move selcted elements from 'Host Lists' to 'Selected Host Lists', and add hidden form elements to match
    $('#add-to-selected-hosts').click( function() {
        var new_hosts = $('#all-host-lists').children(':selected');
        var old_hosts = $('#selected-host-lists').children();
        var new_host;
        var matching_sentinel;

        for (var i = 0; i < new_hosts.length; i++) {
            new_host = new_hosts[i];

            matching_sentinel = false;

            // Verify that the host is not already in the Selected Host Lists table
            for (var j = 0; j < old_hosts.length; j++) {

                if (old_hosts[j].value === new_host.value) {
                    matching_sentinel = true;
                    break;
                }
            }

            if (matching_sentinel) {
                continue;
            }
            // Otherwise, add it to the table.
            $('#selected-host-lists').append(new_host);
            // Also create a hidden input so that the selected host is passed to POST.
            $('#insert-selected-host-lists-here').append('<input type="hidden" class="host-list-hidden" id="selected-host-list-'+$(new_host).val()+'" name="host_lists[]" value="'+$(new_host).val()+'">');
        }
    });

    // Move selected elements from Selected Host Lists to Host Lists, remove any relevant hidden form elements
    $('#remove-from-selected-hosts').click(function() {
        var hosts_to_remove = $('#selected-host-lists').children(':selected');

        hosts_to_remove.each(function() {

            // Remove the hidden input associated with the selected host list from the DOM.
            $('#selected-host-list-'+$(this).val()).remove();
            // Remove the entry from the selected host lists table.
            $('#all-host-lists').append($(this));
        });
    });

    // When the page loads, move items from Host Lists to Selected Host Lists based on the presence of hidden form elements.
    $('.host-list-hidden').each(function () {
        var item_id = $(this).val();
        var select_option = $('#host-list-option-' + item_id);
        $('#selected-host-lists').append(select_option);
    });
});

function check_required(obj)
{
    if ($(obj + ':checked').not(obj + '-req').length > 0) {
        $(obj + '-req').prop('checked', true);
        $(obj + '-req').prop('disabled', true);
    } else {
        $(obj + '-req').prop('disabled', false);
    }
}

/* This function is only needed when a permissions row has more than just "View" and "Admin" boxes */
function admin_button(obj) {
    $('#'+obj+'-admin').click(function() {
        if ($(this).is(":checked")) {
            $(this).parents('tr').find('input').prop('checked', true);
            $(this).parents('tr').find('input').not('#'+obj+'-admin').prop('disabled', true);
        } else {
            $(this).parents('tr').find('input').not('#'+obj+'-admin').prop('disabled', false);
            $('.'+obj+'-req').prop('disabled', true);
        }
    });
};

function show_correct_fields()
{
    var type = $('#account_type').val();

    if (type == "ldap") {
        $('.ad-required').hide();
        $('.ldap-required').show();
        $('.pw-box').hide();
    } else if (type == "ad") {
        $('.ldap-required').hide();
        $('.ad-required').show();
        $('.pw-box').hide();
    } else {
        $('.ldap-required').hide();
        $('.ad-required').hide();
        $('.pw-box').show();
    }

    if (USERID == 1) {
        $('.pw-box').show();
    }

    if ($('#alerts-admin').is(":checked")) {
        $('input[name="perms[alerts][]"]').not('#alerts-admin').prop('disabled', true);
    }
    if ($('#contacts-admin').is(":checked")) {
        $('input[name="perms[contacts][]"]').not('#contacts-admin').prop('disabled', true);
    }
}
</script>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">

        <h1 class="form-title"><?php echo _('Edit User'); ?> <span>&middot; <?php echo html_escape($user['username']); ?></span></h1>
        <div class="form-spacer"></div>

        <?php if (!empty($msg)) { ?><div class="alert alert-success tw-mx-2"><?php echo $msg; ?></div><?php } ?>
        <?php if (!empty($error)) { ?><div class="alert alert-danger tw-mx-2"><?php echo $error; ?></div><?php } ?>

        <?php echo form_open('admin/users/edit/'.$user['id']);?>
        <input type="hidden" name="hash" value="">

        <ui-tabs default-value="details">
            <tabs-list>
                <tabs-trigger value="details"><?php echo _('Details'); ?></tabs-trigger>
                <tabs-trigger value="authentication"><?php echo _('External Authentication'); ?></tabs-trigger>
                <tabs-trigger value="permissions"><?php echo _('Permissions'); ?></tabs-trigger>
            </tabs-list>

            <tabs-content value="details">
                <h5 class="form-header"><?php echo _('User Details'); ?></h5>
                <div class="form-spacer"></div>
                <div class="tw-w-1/3 tw-mb-6">
                    <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
                        <label class="tw-block tw-text-sm tw-font-medium"><?php echo _("Full Name"); ?><div class="tw-text-error tw-inline-block">*</div></label>
                        <input type="text" class="ui-input" name="name" placeholder="<?php echo _('Name');?>" value="<?php if (set_value('name')) { echo set_value('name'); } else { echo html_escape($user['name']); } ?>"> 
                    </div>
                    <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
                        <label class="tw-block tw-text-sm tw-font-medium"><?php echo _("Email"); ?><div class="tw-text-error tw-inline-block">*</div></label>
                        <input type="text" class="ui-input" name="email" placeholder="<?php echo _('Email');?>" value="<?php if (set_value('email')) { echo set_value('email'); } else { echo html_escape($user['email']); } ?>">
                    </div>
                </div>
                <h5 class="form-header"><?php echo _('Account Information'); ?></h5>
                <div class="form-spacer"></div>
                <div class="tw-w-1/3">
                    <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
                        <label class="tw-block tw-text-sm tw-font-medium"><?php echo _('Username'); ?><div class="tw-text-error tw-inline-block">*</div></label>
                        <input type="text" class="ui-input" name="username" value="<?php echo html_escape($user['username']); ?>" disabled>
                    </div>
                    <?php if (!isset($user['auth_settings']) ||
                        !isset($user['auth_settings']['type']) ||
                        $user['auth_settings']['type'] !== 'ldap' &&
                        $user['auth_settings']['type'] !== 'ad') { ?>
                    <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
                        <label class="tw-block tw-text-sm tw-font-medium"><?php echo _('Password'); ?><div class="tw-text-error tw-inline-block">*</div></label>
                        <input type="password" class="ui-input" name="password" value="<?php echo set_value('password'); ?>">
                    </div>

                    <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
                        <label class="tw-block tw-text-sm tw-font-medium"><?php echo _('Confirm Password'); ?><div class="tw-text-error tw-inline-block">*</div></label>
                        <input type="password" class="ui-input" name="password2" value="<?php echo set_value('password2'); ?>">
                    </div>
                    <?php } ?>
                    <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
                        <label class="tw-block tw-text-sm tw-font-medium"><?php echo _('Language'); ?></label>
                        <select name="language" class="ui-select">
                            <option value="default" <?php if ($user['language'] == 'default') { echo 'selected'; } ?>><?php echo _('Default'); ?></option>
                            <?php foreach ($languages as $l) { ?>
                            <option value="<?php echo $l; ?>" <?php if ($user['language'] == $l) { echo 'selected'; } ?>>
                                <?php echo get_language_name($l); ?>
                            </option>
                            <?php } ?>
                        </select>
                    </div>

                    <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
                        <label class="tw-block tw-text-sm tw-font-medium"><?php echo _('User Theme'); ?></label>
                        <select name="theme" class="ui-select">
                            <?php foreach ($themes as $key => $value) { ?>
                                <option value="<?php echo $key ?>" <?php if ($user['theme'] == $key) { echo 'selected'; } ?>>
                                    <?php echo $value; ?>
                                </option>
                            <?php } ?>
                        </select>
                    </div>

                    <div class="ui-radio-group tw-mb-6">
                        <label class="tw-block tw-text-sm tw-font-medium"><?php echo _('Dashboard Mode'); ?>:</label>
                        <div class="tw-flex tw-items-center tw-space-x-2">
                            <input type="radio" id="simple_mode_true" name="simple_mode" value="true" class="ui-radio-group-item" <?php if ($user['simple_mode'] == 'true') { echo "checked"; } ?>>
                            <label for="radio1" class="ui-label"><b><?php echo _('Simple'); ?></b>
                        </div>
                        <div class="tw-flex tw-items-center tw-space-x-2">
                            <input type="radio" id="simple_mode_false" name="simple_mode" value="false" class="ui-radio-group-item" <?php if (empty($user['simple_mode']) || $user['simple_mode'] == 'false') { echo "checked"; } ?>>
                            <label for="radio2" class="ui-label"><b><?php echo _('Advanced'); ?></b>
                        </div>
                    </div>

                </div>
            </tabs-content>

            <tabs-content value="authentication">
                <p class="tw-mb-5"><?php echo _('User accounts can be authenticated in many different ways either from your local database or external programs such as Active Directory or LDAP. You can set up external authentication servers in the'); ?> <a href="<?php echo site_url('admin/auth_servers'); ?>"><?php echo _('LDAP/AD Integration settings'); ?></a>.</p>

                <?php if ($user['id'] == 1) { ?>
                <div class="alert alert-info tw-mx-2">
                    <?php echo _('<strong>Superuser Auth Settings</strong> You can not turn off local authentication for the main admin account. Even if you select a separate authentication method you will still be able to log in with the local password for this user.'); ?>
                </div>
                <?php } ?>
                <div class="tw-w-2/5">
                    <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
                        <label class="tw-block tw-text-sm tw-font-medium"><?php echo _('Auth Type'); ?></label>
                        <select name="account_type" class="ui-select" id="account_type">
                            <option value="local" <?php if (empty($user['auth_settings']['type'])) { echo "selected"; } ?>><?php echo _('Local Only (Default)'); ?></option>
                            <option value="ad" <?php if (empty($ad_servers)) { echo "disabled"; } if (@$user['auth_settings']['type'] == "ad") { echo "selected"; } ?>><?php echo _('Active Directory'); ?> <?php if (empty($ad_servers)) { ?>(<?php echo _('No Servers'); ?>)<?php } ?></option>
                            <option value="ldap" <?php if (empty($ldap_servers)) { echo "disabled"; } if (@$user['auth_settings']['type'] == "ldap") { echo "selected"; } ?>><?php echo _('LDAP'); ?> <?php if (empty($ldap_servers)) { ?>(<?php echo _('No Servers'); ?>)<?php } ?></option>
                        </select>
                    </div>

                    <div class="hide ldap-required">
                        <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
                            <label class="tw-block tw-text-sm tw-font-medium"><?php echo _('LDAP Server'); ?></label>
                            <select name="ldap_server" class="ui-select" id="ldap_server">
                                <?php foreach ($ldap_servers as $ldap) { ?>
                                <option value="<?php echo html_escape($ldap['id']); ?>"><?php echo html_escape($ldap['name']).' ('.html_escape($ldap['host']).')'; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="hide ldap-required">
                        <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
                            <label class="tw-block tw-text-sm tw-font-medium"><?php echo _("User's Full DN"); ?></label>
                            <input type="text" class="ui-input" name="dn" <?php if (!empty($user['auth_settings']['dn'])) { echo 'value="'.html_escape($user['auth_settings']['dn']).'"'; } ?> placeholder="cn=John Smith,dn=nagios,dc=com">
                        </div>
                    </div>
                    <div class="hide ad-required">
                        <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
                            <label class="tw-block tw-text-sm tw-font-medium"><?php echo _('AD Server'); ?></label>
                            <select name="ad_server" class="ui-select" id="ad_server">
                                <?php foreach ($ad_servers as $ad) { ?>
                                <option value="<?php echo html_escape($ad['id']); ?>"><?php echo html_escape($ad['name']).' ('.html_escape($ad['controllers']).')'; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="hide ad-required">
                        <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
                            <label class="tw-block tw-text-sm tw-font-medium"><?php echo _('AD Username'); ?></label>
                            <input type="text" class="ui-input" name="ad_username" id="ad_username" <?php if (!empty($user['auth_settings']['ad_username'])) { echo 'value="'.$user['auth_settings']['ad_username'].'"'; } ?>>
                            <?php if (!empty($ad_suffix)) { ?>
                            <span class="input-group-addon"><?php echo html_escape($ad_suffix); ?></span>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </tabs-content>

            <tabs-content value="permissions">
                <h5 class="form-header"><?php echo _('User Access Level'); ?></h5>
                <div class="form-spacer"></div>
                <p class="tw-mb-2"><?php echo _('Set the user level of access inside the UI.'); ?></p>

                <div class="ui-radio-group tw-mb-6">
                    <div class="tw-flex tw-items-center tw-space-x-2">
                        <input type="radio" id="radio1" name="auth_type" value="admin" class="ui-radio-group-item" <?php if ($admin_checked) { echo "checked"; } if ($user['id'] == 1) { echo ' disabled'; } ?>>
                        <label for="radio1" class="ui-label"><b><?php echo _('Admin'); ?></b> &middot;
                        <?php echo _('Full Access. Admins can change/delete all components and settings including indexes, backups, dashboards, queries, and alerts. They can also update the Nagios Log Server configuration and manage users.'); ?></label>
                    </div>
                    <div class="tw-flex tw-items-center tw-space-x-2">
                        <input type="radio" id="radio2" name="auth_type" value="user" class="ui-radio-group-item" <?php if ($user_checked) { echo "checked"; } if ($user['id'] == 1) { echo ' disabled'; } ?>>
                        <label for="radio2" class="ui-label"><b><?php echo _('User'); ?></b> &middot;
                        <?php echo _("Limited Access. Users are allowed to only edit their account and their own dashboards by default."); ?></label>
                    </div>
                </div>

                <div class="user-perms tw-mb-6 <?php if ($admin_checked) { echo "hide"; } ?>">
                    <h5 class="form-header"><?php echo _('User Permissions'); ?></h5>
                    <div class="form-spacer"></div>
                    <p class="tw-mb-2"><?php echo _('Give users special permissions to access certain tabs and functionalities. By default, users can only view alerts.'); ?></p>
                    <table class="ui-table">
                        <thead class="ui-thead">
                            <tr class="ui-tr">
                                <th class="ui-th"><?php echo _("Permission"); ?></th>
                                <th class="ui-th"><?php echo _("View"); ?></th>
                                <th class="ui-th"><?php echo _("Create"); ?></th>
                                <th class="ui-th"><?php echo _("Edit"); ?></th>
                                <th class="ui-th"><?php echo _("Delete"); ?></th>
                                <th class="ui-th"><div class="tw-flex tw-items-center"><?php echo _("Admin"); ?> <span class="material-symbols-outlined base" title="<?php echo _("By default, the create, edit, and delete permissions only apply to items the user makes. This setting allows users to manage all items, not just their own."); ?>">help</span></div></th>
                                <th class="ui-th"></th>
                            </tr>
                        </thead>
                        <tbody class="ui-tbody">
                            <tr class="ui-tr">
                                <td class="ui-td"><?php echo _("Alerts"); ?></td>
                                <td class="ui-td">
                                    <label>
                                        <input type="checkbox" class="alerts alerts-req ui-checkbox-group-item" name="perms[alerts][]" value="view" <?php if (@in_array('view', $user['perms']['alerts'])) { echo 'checked'; } ?>>
                                    </label>
                                </td>
                                <td class="ui-td">
                                    <label>
                                        <input type="checkbox" class="alerts ui-checkbox-group-item" name="perms[alerts][]" value="create" <?php if (@in_array('create', $user['perms']['alerts'])) { echo 'checked'; } ?>>
                                    </label>
                                </td>
                                <td class="ui-td">
                                    <label>
                                        <input type="checkbox" class="alerts ui-checkbox-group-item" name="perms[alerts][]" value="edit" <?php if (@in_array('edit', $user['perms']['alerts'])) { echo 'checked'; } ?>>
                                    </label>
                                </td>
                                <td class="ui-td">
                                    <label>
                                        <input type="checkbox" class="alerts ui-checkbox-group-item" name="perms[alerts][]" value="delete" <?php if (@in_array('delete', $user['perms']['alerts'])) { echo 'checked'; } ?>>
                                    </label>
                                </td>
                                <td class="ui-td">
                                    <label>
                                        <input type="checkbox" id="alerts-admin" class="alerts ui-checkbox-group-item" name="perms[alerts][]" value="all" <?php if (@in_array('all', $user['perms']['alerts'])) { echo 'checked'; } ?>>
                                    </label>
                                </td>
                                <td class="ui-td">
                                    <a class="toggle-all" data-section="alerts" data-toggle="0"><?php echo _("Toggle All"); ?></a>
                                </td>
                            </tr>
                            <tr class="ui-tr">
                                <td class="ui-td"><?php echo _("Contacts"); ?></td>
                                <td class="ui-td">
                                    <label>
                                        <input type="checkbox" class="contacts contacts-req ui-checkbox-group-item" name="perms[contacts][]" value="view" <?php if (is_array($user['perms']['contacts']) && in_array('view', $user['perms']['contacts'])) { echo 'checked'; } ?>>
                                    </label>
                                </td>
                                <td class="ui-td"></td>
                                <td class="ui-td">
                                    <label>
                                        <input type="checkbox" class="contacts ui-checkbox-group-item" name="perms[contacts][]" value="edit" <?php if (is_array($user['perms']['contacts']) && in_array('edit', $user['perms']['contacts'])) { echo 'checked'; } ?>>
                                    </label>
                                </td>
                                <td class="ui-td"></td>
                                <td class="ui-td">
                                    <label>
                                        <input type="checkbox" id="contacts-admin" class="contacts ui-checkbox-group-item" name="perms[contacts][]" value="all" <?php if (is_array($user['perms']['contacts']) && in_array('all', $user['perms']['contacts'])) { echo 'checked'; } ?>>
                                    </label>
                                </td>
                                <td class="ui-td">
                                    <a class="toggle-all" data-section="contacts" data-toggle="0"><?php echo _("Toggle All"); ?></a>
                                </td>
                            </tr>
                            <tr class="ui-tr">
                                <td class="ui-td"><?php echo _('Configuration'); ?></td>
                                <td class="ui-td">
                                    <label>
                                        <input type="checkbox" class="config config-req ui-checkbox-group-item" name="perms[configure][]" value="view" <?php if (@in_array('view', $user['perms']['configure'])) { echo 'checked'; } ?>>
                                    </label>
                                </td>
                                <td class="ui-td"></td>
                                <td class="ui-td"></td>
                                <td class="ui-td"></td>
                                <td class="ui-td">
                                    <label>
                                        <input type="checkbox" id="config-admin" class="config ui-checkbox-group-item" name="perms[configure][]" value="all" <?php if (@in_array('all', $user['perms']['configure'])) { echo 'checked'; } ?>>
                                    </label>
                                </td>
                                <td class="ui-td">
                                    <a class="toggle-all" data-section="config" data-toggle="0"><?php echo _("Toggle All"); ?></a>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <h5 class="form-header"><?php echo _('Restrict Host Visibility'); ?></h5>
                <div class="form-spacer"></div>
                <p class="tw-mb-2"><?php echo _('Create a whitelist of visible hosts for non-API users.'); ?></p>

                <div class="tw-grid tw-items-center tw-justify-center tw-w-[600px] tw-grid-cols-[1fr_50px_1fr] tw-grid-rows-[30px_1fr_60px_30px_1fr] tw-mb-6">

                    <label class="tw-col-[1] tw-row-[1]"><?php echo _('Host Lists'); ?></label>
                    <select multiple id="all-host-lists" class="ui-select-multi tw-col-[1] tw-row-[2]">
                        <?php foreach ($host_lists as $host_list) {
                            echo '<option id="host-list-option-'.$host_list['_id'].'" value="'.$host_list['_id'].'">'.html_escape($host_list['_source']['name']).'</option>';
                        } ?>
                    </select>

                    <div class="tw-col-[2] tw-row-[2] tw-text-center">
                        <span class="material-symbols-outlined tw-cursor-pointer" id="add-to-selected-hosts">arrow_forward</span>
                        <span class="material-symbols-outlined tw-cursor-pointer" id="remove-from-selected-hosts">arrow_back</span>
                    </div>

                    <div id="insert-selected-host-lists-here" class="hide"><?php
                        if (isset($user['host_lists'])) {
                            foreach ($user['host_lists'] as $host_list) {
                                echo '<input type="hidden" id="selected-host-list-' . $host_list . '" class="host-list-hidden" name="host_lists[]" value="'. $host_list . '">';
                            }
                         } ?>
                    </div>

                    <label class="tw-col-[3] tw-row-[1]"><?php echo _('Selected Host Lists'); ?></label>
                    <select multiple id="selected-host-lists" class="ui-select-multi tw-col-[3] tw-row-[2]">
                    </select>

                    <p class="tw-col-start-1 tw-col-end-4 tw-row-start-3 tw-pb-0 tw-justify-self-start"><?php echo _('Select any additional hosts from the menu to the left, or enter their IP addresses manually on the right.'); ?></p>

                    <label class="tw-col-[1] tw-row-[4]"><?php echo _('Known Hosts'); ?></label>
                    <select multiple id="host-list-known-hosts" class="ui-select-multi tw-col-[1] tw-row-[5]" size="5">
                        <?php 
                        $ci =& get_instance();
                        $ci->load->helper('network');
                        foreach ($known_hosts as $host => $_) {
                            $name = dns_reverse_lookup($host, true);
                            echo "<option value=\"$host\">".htmlentities("$host ($name)", ENT_QUOTES, 'UTF-8')."</option>";
                        } ?>
                    </select>

                    <label class="tw-col-[3] tw-row-[4]"><?php echo _('Additional Hosts'); ?></label>
                    <textarea class="ui-select-multi tw-col-[3] tw-row-[5]" name="hosts" placeholder="<?php echo _('IP Addresses only, one per line'); ?>" id="host-list-selected-hosts"><?php echo (is_array($user['hosts']) ? implode("\n", $user['hosts']) : ''); ?></textarea>
                </div>

                <h5 class="form-header tw-mt-2"><?php echo _('API Access'); ?></h5>
                <div class="form-spacer"></div>
                <p class="tw-py-2"><?php echo _('If you want to allow this user to use the external API via an access key.'); ?></p>

                <div class="ui-radio-group">
                    <div class="tw-flex tw-items-center tw-space-x-2">
                        <input type="radio" id="radio1" name="apiaccess" value="1" class="ui-radio-group-item yes-admin" <?php if ($user['apiaccess'] || $user['auth_type'] == 'admin') { echo 'checked'; } ?>>
                        <label for="radio1" class="ui-label"><?php echo _('Yes'); ?></label>
                    </div>
                    <div class="tw-flex tw-items-center tw-space-x-2">
                        <input type="radio" id="radio2" name="apiaccess" value="0" class="ui-radio-group-item no-admin" <?php if (!$user['apiaccess']) { echo 'checked'; } else if ($user['auth_type'] == 'admin') { echo 'disabled'; } ?>>
                        <label for="radio2" class="ui-label"><?php echo _('No'); ?></label>
                    </div>
                </div>
            </tabs-content>
        </ui-tabs>

        <div >
            <div class="form-actions tw-mt-3 tw-flex tw-gap-2">
                <button type="submit" class="ui-btn ui-btn-default"><?php echo _('Save User'); ?></button>
                <a href="<?php echo site_url('admin/users'); ?>" class="ui-btn ui-btn-outlined"><?php echo _('Cancel'); ?></a>
            </div>
        </div>

        <?php echo form_close();?>

    </div>
</div>

<?php echo $footer; ?>