<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">

        <h1 class="form-title"><?php echo _('LDAP / AD Import Users'); ?></h1>
        <p class="form-subtitle"><?php echo _("Log into your LDAP / Active Directory"); ?> <strong><?php echo _("administrator"); ?></strong> <?php echo _("or"); ?> <strong><?php echo _("privileged account"); ?></strong> <?php echo _("to be able to import users directly into Log Server."); ?></p>
        <div class="form-spacer"></div>

        <?php if (!empty($errors)) { ?>
        <div class="alert alert-error tw-my-2.5">
            <button type="button" class="close" data-dismiss="alert"><i class="material-symbols-outlined">close</i></button>
            <?php echo $errors; ?>
        </div>
        <?php } ?>

        <?php echo form_open('admin/users/import'); ?>
        <div class="tw-w-1/3">
            <div class="tw-flex tw-flex-col tw-mb-2 tw-w-full">
                <input class="ui-input" name="username" type="text" value="<?php if (!empty($username)) { echo $username; } ?>" placeholder="<?php echo _("Username"); ?>">
            </div>
            <div class="tw-flex tw-flex-col tw-mb-2 tw-w-full">
                <input class="ui-input" type="password" name="password" placeholder="<?php echo _("Password"); ?>">
            </div>
            <div class="tw-flex tw-flex-col tw-w-full">
                <select name="auth_server_id" class="ui-select">
                    <?php foreach ($auth_servers as $as) { ?>
                    <option value="<?php echo $as['id']; ?>" <?php if (empty($as['active'])) { echo "disabled"; } if (!empty($auth_server_id)) { if ($auth_server_id == $as['id']) { echo 'selected'; } } ?>><?php if ($as['type'] == "ad") { echo _('Active Directory').' - '.$as['name']. ' - '. $as['controllers']; } else { echo _('LDAP').' - '.$as['host']; } ?></option>
                    <?php } ?>
                </select>
            </div>
            <div class="tw-mt-8 tw-flex tw-gap-2">
                <button type="submit" value="1" name="submitted" class="ui-btn ui-btn-default"><?php echo _('Next'); ?> <span class="material-symbols-outlined">chevron_right</span></button>
                <?php echo form_close(); ?>
                <a class="ui-btn ui-btn-outlined" href="<?php echo site_url('admin/auth_servers'); ?>"><?php echo _('Manage Authentication Servers'); ?></a>
            </div>
        </div>




    </div>
</div>

<?php echo $footer; ?>