
<script type="text/javascript">
var lastChecked = null;

var opening_indices = ['<?= (is_array($opening_indices)) ? implode("','", $opening_indices) : "" ?>'];
if (opening_indices[0] === '') {
    opening_indices = [];
}

var opening_indices_interval_tracker = null;

$(document).ready(function() {

    add_checkbox_magic();

    handle_opening_indices();

    $('#cb-toggle').click(function() {
        if ($(this).is(':checked')) {
            $('input[name="sel"]').prop('checked', true);
        } else {
            $('input[name="sel"]').prop('checked', false);
        }
    });

    $('#index-action').change(function() {
        var action = $(this).val();
        var indices = [];
        $('input[name="sel"]:checked').each(function(k, v) { indices.push($(v).val()); });

        switch (action) {

            case 'open':
                var conf = confirm("<?php echo _('Are you sure you want to open all the selected indexes?'); ?>");
                if (conf == true) {
                    set_opening_indices(indices);
                    $.each(indices, function(k, v) {
                        open_index(v);
                    });
                }
                break;

            case 'close':
                var conf = confirm("<?php echo _('Are you sure you want to close all the selected indexes?'); ?>");
                if (conf == true) {
                    $.each(indices, function(k, v) {
                        close_index(v);
                    });
                }
                break;

            case 'delete':
                var conf = confirm("<?php echo _('Are you sure you want to delete all the selected indexes?'); ?>");
                if (conf == true) {
                    $.each(indices, function(k, v) {
                        delete_index(v);
                    });
                }
                break;

        }
        window.location.href = window.location.href;
    });

    // close open index
    $('.close-index').click(function(e) {
        if (is_demo_mode) {
            alert("This function is not available in demo mode.");
            return false;
        }
        var index = this.id;
        var conf = confirm("Are you sure you want to close index " + index + "?");
        if (conf == true && index.indexOf("logstash") > -1) {
            $.post(site_url + 'api/backend/' + index + '/_close', {}, function(data) {
                if (data.success == 0) {
                    alert(data.errormsg);
                } else {
                    var log = {
                        type: 'CONFIG',
                        message: 'Index ' + index + ' closed',
                    };
                    $.post(site_url + 'api/log/create', { log: log }, function() {
                         window.location.href = window.location.href;
                    });
                }
            }, 'json');
        }
    });
    
    // open closed index
    $('.open-index').click(function(e) {
        if (is_demo_mode) {
            alert("This function is not available in demo mode.");
            return false;
        }
        var index = this.id;
        var conf = confirm("Are you sure you want to open index " + index + "?");
        if (conf == true && index.indexOf("logstash") > -1) {

            set_opening_indices([index]);
            $.post(site_url + 'api/backend/' + index + '/_open', {}, function(data) {
                if (data.success == 0) {
                    alert(data.errormsg);
                } else {
                    var log = {
                        type: 'CONFIG',
                        message: 'Index ' + index + ' opened'
                    };
                    $.post(site_url + 'api/log/create', { log: log }, function() {
                         window.location.href = window.location.href;
                    });
                }
            }, 'json');
        }
    });
    
    // delete index
    $('.delete-index').click(function(e) {
        if (is_demo_mode) {
            alert("This function is not available in demo mode.");
            return false;
        }
        var index = $(this).find('input').val();
        var conf = confirm("Are you sure you want to PERMANENTLY DELETE index " + index + "?");
        if (conf == true && index.indexOf("logstash") > -1) {
            $.ajax({
                url: site_url + 'api/backend/' + index + '/',
                type: 'DELETE',
                success: function(data) {
                    if (data.success == 0) {
                        alert(data.errormsg);
                    } else {
                        window.location.href = window.location.href;
                    }
                }
            });
        }
    });

});

function handle_opening_indices() {

    if (opening_indices.length !== 0) {

        // Disable each button
        for (i in opening_indices) {
            jq_escaped = selector_escape(opening_indices[i]);
            $('#' + jq_escaped).attr('disabled', true);
        }

        // Create the throbber
        $('#indices_opening_total').html(opening_indices.length);
        $('#indices_opening_remaining').html(opening_indices.length);
        $('#indices_opening').removeClass('hide');

        opening_indices_interval_tracker = setInterval(function() {

            $.ajax({
                url: site_url + '/api/system/indices_status',
                type: 'POST',
                async: false,
                data: { indices: opening_indices },
                dataType: 'json',
                success: function(data) {

                    for (var i = opening_indices.length - 1; i >= 0; i--) {
                        index_name = opening_indices[i];
                        if (data[index_name] === "STARTED") {
                            $('#' + selector_escape(index_name)).attr('disabled', false);
                            opening_indices.splice(i, 1);
                        }
                    }

                    $('#indices_opening_remaining').html(opening_indices.length);

                    if (opening_indices.length === 0) {
                        $('#indices_opening').html('<?php echo _('All indices finished opening.'); ?>');
                        clearInterval(opening_indices_interval_tracker);
                        set_opening_indices(opening_indices); // opening_indices = []
                    }
                }
            });
        }, 1000);
    }
}

function set_opening_indices(indices) {
    $.ajax({
        url: site_url + 'api/system/set_opening_indices',
        type: 'POST',
        async: true,
        data: { indices: indices }
    });
}

function close_index(index) {
    $.ajax({
        url: site_url + 'api/backend/' + index + '/_close',
        type: 'POST',
        async: false,
        success: function(data) {
            if (data.success == 0) {
                alert(data.errormsg);
            }
        }
    });
}

function open_index(index) {
    $.ajax({
        url: site_url + 'api/backend/' + index + '/_open',
        type: 'POST',
        async: false,
        success: function(data) {
            if (data.success == 0) {
                alert(data.errormsg);
            }
        }
    });
}

function delete_index(index) {
    $.ajax({
        url: site_url + 'api/backend/' + index + '/',
        type: 'DELETE',
        async: false,
        success: function(data) {
            if (data.success == 0) {
                alert(data.errormsg);
            }
        }
    });
}

function add_checkbox_magic() {
    var $chkboxes = $('input[name="sel"]');
    $chkboxes.click(function(e) {
        if (!lastChecked) {
            lastChecked = this;
            return;
        }
        if (e.shiftKey) {
            var start = $chkboxes.index(this);
            var end = $chkboxes.index(lastChecked);
            $chkboxes.slice(Math.min(start,end), Math.max(start,end)+ 1).prop('checked', lastChecked.checked);
        }
        lastChecked = this;
    });
}
</script>


                <?php if (!isset($index['stats']['count']) || $index['stats']['count'] != 1): ?>

                <div>

                    <div class="tw-my-4">
                        <div class="tw-flex tw-gap-2 tw-items-center tw-my-2">
                            <span class="material-symbols-outlined">database</span>
                            <span class="form-header"><?php echo _("Indices"); ?></span>
                        </div>
                        <!-- <div class="grid-content overflow"> -->
                        <div class="tw-rounded-lg tw-border-border tw-border tw-p-4 tw-overflow-auto tw-max-h-[600px] tw-w-full">
                            <table id="indicesTable" class="ui-table">
                                <thead class="ui-thead">
                                    <tr class="ui-tr">
                                        <th class="ui-th tw-w-[18px]"><div class="tw-flex tw-items-center"><input type="checkbox" id="cb-toggle" class="ui-checkbox-group-item"></div></th>
                                        <th class="ui-th"><?php echo _("Index"); ?></th>
                                        <th class="ui-th"># <?php echo _("Docs"); ?></th>
                                        <th class="ui-th"><?php echo _("Primary Size"); ?></th>
                                        <th class="ui-th"># <?php echo _("Shards"); ?></th>
                                        <th class="ui-th"># <?php echo _("Replicas"); ?></th>
                                        <th class="ui-th"></th>
                                    </tr>
                                </thead>
                                <tbody class="ui-tbody">
                                    <?php foreach ($index['stats']['indices'] as $index_id => $indices): ?>
                                    <tr class="ui-tr">
                                        <td class="ui-td">
                                            <div class="tw-flex tw-items-center">
                                            <?php if ($index_id != ('logstash-' . date('Y.m.d'))) { ?>
                                                <input class="ui-checkbox-group-item" type="checkbox" name="sel" value="<?php echo $index_id; ?>">
                                            <?php } ?>
                                            </div>
                                        </td>
                                        <td class="ui-td">
                                            <?php if ($indices['state'] == "open"): ?>
                                            <a data-title="Index Information" data-placement="bottom" rel="tipRight" href="<?php echo site_url('admin/index_status/'.$index_id); ?>" data-original-title="" title=""><?php echo $index_id; ?></a>
                                            <?php else: ?>
                                                <?php echo $index_id; ?>
                                            <?php endif; ?>
                                        </td>
                                        <td class="ui-td"><?php if (@isset($indices['primaries'])) { echo number_format($indices['primaries']['docs']['count']); } else { echo "-"; } ?></td>
                                        <td class="ui-td"><?php if (@isset($indices['primaries'])) { echo @strtoupper($indices['primaries']['store']['size']); } else { echo "-"; } ?></td>
                                        <td class="ui-td"><?php echo $indices['settings']['index']['number_of_shards']; ?></td>
                                        <td class="ui-td"><?php echo $indices['settings']['index']['number_of_replicas']; ?></td>
                                        <td class="ui-td">
                                            <dropdown-menu data-position="bottom-right">
                                                <dropdown-trigger as-child>
                                                    <div class="material-symbols-outlined ui-icon-btn">more_horiz</div>
                                                </dropdown-trigger>
                                                <dropdown-content class="ui-dropdown-content">
                                                <?php if ($index_id != ('logstash-' . date('Y.m.d'))) { ?>
                                                <?php if ($indices['state'] == 'close'): ?>
                                                    <a id="<?php echo $index_id; ?>" class="open-index"><dropdown-item class="ui-dropdown-item">
                                                        <?php echo _("Open"); ?>
                                                    </dropdown-item></a>
                                                <?php else: ?>
                                                    <a id="<?php echo $index_id; ?>" class="close-index"><dropdown-item class="ui-dropdown-item">
                                                        <?php echo _("Close"); ?>
                                                    </dropdown-item></a>
                                                <?php endif; } ?>
                                                    <a class="delete-index"><dropdown-item class="ui-dropdown-item">
                                                        <input type="hidden" value="<?php echo $index_id; ?>"/><?php echo _("Delete"); ?>
                                                    </dropdown-item></a>
                                                </dropdown-content>
                                            </dropdown-menu>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                            <div class="tw-grid tw-mt-2 tw-w-[200px] tw-items-center">
                                <label class="tw-block tw-text-sm tw-font-medium">
                                    <?php echo _('With selected indices'); ?>
                                </label>
                                <select id="index-action" class="ui-select">
                                    <option></option>
                                    <option value="open"><?php echo _('Open'); ?></option>
                                    <option value="close"><?php echo _('Close'); ?></option>
                                    <option value="delete"><?php echo _('Delete'); ?></option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>

                <?php else: ?>
                
                <div class="col-sm-6">

                    <div class="tw-my-4">
                        <div class="tw-flex tw-gap-2 tw-items-center tw-my-2">
                            <span class="material-symbols-outlined">search</span>
                            <span class="form-header"><?php echo _("Search Totals"); ?></span>
                        </div>
                        <div class="tw-rounded-lg tw-border-border tw-border tw-p-4 tw-overflow-auto">
                            <table class="ui-table">
                                <tbody class="ui-tbody">
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Query Total"); ?>:</td>
                                        <td class="ui-td"><?php echo $index['stats']['_all']['total']['search']['query_total']; ?></td>
                                    </tr>
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Query Time"); ?>:</td>
                                        <td class="ui-td"><?php echo $index['stats']['_all']['total']['search']['query_time']; ?></td>
                                    </tr>
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Fetch Total"); ?>:</td>
                                        <td class="ui-td"><?php echo $index['stats']['_all']['total']['search']['fetch_total']; ?></td>
                                    </tr>
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Fetch Time"); ?>:</td>
                                        <td class="ui-td"><?php echo $index['stats']['_all']['total']['search']['fetch_time']; ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="tw-my-4">
                        <div class="tw-flex tw-gap-2 tw-items-center tw-my-2">
                            <span class="material-symbols-outlined">description</span>
                            <span class="form-header"><?php echo _("Get Totals"); ?></span>
                        </div>
                        <div class="tw-rounded-lg tw-border-border tw-border tw-p-4 tw-overflow-auto">
                            <table class="ui-table">
                                <tbody class="ui-tbody">
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Get Total"); ?>:</td>
                                        <td class="ui-td"><?php echo $index['stats']['_all']['total']['get']['total']; ?></td>
                                    </tr>
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Get Time"); ?>:</td>
                                        <td class="ui-td"><?php echo $index['stats']['_all']['total']['get']['getTime']; ?></td>
                                    </tr>
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Exists Total"); ?>:</td>
                                        <td class="ui-td"><?php echo $index['stats']['_all']['total']['get']['exists_total']; ?></td>
                                    </tr>
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Exists Time"); ?>:</td>
                                        <td class="ui-td"><?php echo $index['stats']['_all']['total']['get']['exists_time']; ?></td>
                                    </tr>
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Missing Total"); ?>:</td>
                                        <td class="ui-td"><?php echo $index['stats']['_all']['total']['get']['missing_total']; ?></td>
                                    </tr>
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Missing Time"); ?>:</td>
                                        <td class="ui-td"><?php echo $index['stats']['_all']['total']['get']['missing_time']; ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                </div>
                <div class="col-sm-6">

                    <div class="tw-my-4">
                        <div class="tw-flex tw-gap-2 tw-items-center tw-my-2">
                            <span class="material-symbols-outlined">description</span>
                            <span class="form-header"><?php echo _("Documents"); ?></span>
                        </div>
                        <div class="tw-rounded-lg tw-border-border tw-border tw-p-4 tw-overflow-auto">
                            <table class="ui-table">
                                <tbody class="ui-tbody">
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Primary Documents"); ?>:</td>
                                        <td class="ui-td"><?php echo $index['stats']['_all']['primaries']['docs']['count']; ?></td>
                                    </tr>
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Total Documents"); ?>:</td>
                                        <td class="ui-td"><?php echo $index['stats']['_all']['total']['docs']['count']; ?></td>
                                    </tr>
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Deleted Documents"); ?>:</td>
                                        <td class="ui-td"><?php echo $index['stats']['_all']['total']['docs']['deleted']; ?></td>
                                    </tr>
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Primary Size"); ?>:</td>
                                        <td class="ui-td"><?php echo strtoupper($index['stats']['_all']['primaries']['store']['size']); ?></td>
                                    </tr>
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Total Size"); ?>:</td>
                                        <td class="ui-td"><?php echo strtoupper($index['stats']['_all']['total']['store']['size']); ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    
                    <div class="tw-my-4">
                        <div class="tw-flex tw-gap-2 tw-items-center tw-my-2">
                            <span class="material-symbols-outlined">list</span>
                            <span class="form-header"><?php echo _("Indexing Totals"); ?></span>
                        </div>
                        <div class="tw-rounded-lg tw-border-border tw-border tw-p-4 tw-overflow-auto">
                            <table class="ui-table">
                                <tbody class="ui-tbody">
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Index Total"); ?>:</td>
                                        <td class="ui-td"><?php echo $index['stats']['_all']['total']['indexing']['index_total']; ?></td>
                                    </tr>
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Index Time"); ?>:</td>
                                        <td class="ui-td"><?php echo $index['stats']['_all']['total']['indexing']['index_time']; ?></td>
                                    </tr>
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Delete Total"); ?>:</td>
                                        <td class="ui-td"><?php echo $index['stats']['_all']['total']['indexing']['delete_total']; ?></td>
                                    </tr>
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Delete Time"); ?>:</td>
                                        <td class="ui-td"><?php echo $index['stats']['_all']['total']['indexing']['delete_time']; ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    
                    <div class="tw-my-4">
                        <div class="tw-flex tw-gap-2 tw-items-center tw-my-2">
                            <span class="material-symbols-outlined">settings</span>
                            <span class="form-header"><?php echo _("Operations"); ?></span>
                        </div>
                        <div class="tw-rounded-lg tw-border-border tw-border tw-p-4 tw-overflow-auto">
                            <table class="ui-table">
                                <tbody class="ui-tbody">
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Refresh Total"); ?>:</td>
                                        <td class="ui-td"><?php echo $index['stats']['_all']['total']['refresh']['total']; ?></td>
                                    </tr>
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Refresh Time"); ?>:</td>
                                        <td class="ui-td"><?php echo $index['stats']['_all']['total']['refresh']['total_time']; ?></td>
                                    </tr>
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Flush Total"); ?>:</td>
                                        <td class="ui-td"><?php echo $index['stats']['_all']['total']['flush']['total']; ?></td>
                                    </tr>
                                    <tr class="ui-tr">
                                        <td class="ui-td"><?php echo _("Flush Time"); ?>:</td>
                                        <td class="ui-td"><?php echo $index['stats']['_all']['total']['flush']['total_time']; ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                </div>
                <?php endif; ?>

                </div>
