<?php echo $header; ?>

<script type="text/javascript">

    function getRequestedRoles() {
        const enabledCheckboxes = document.querySelectorAll('input[type="checkbox"]:enabled');

        const requestedRoles = {
            'roles': {}
        };

        let managerElgibleCount = 0;

        enabledCheckboxes.forEach(checkbox => {
            let name = checkbox.name.split('-');
            if (name.length > 3) {
                let hostname = name.slice(2).join('-');
                name = name.slice(0,2);
                name[2] = hostname;
            }
            if (name.length >2) {
                const role = name[0];
                const address = name[1];
                const hostname = name[2] || '';
                const is_enabled = checkbox.checked;

                if (role === 'cluster_manager' && is_enabled) {
                    managerElgibleCount++;
                }

                if (address.length > 0) {
                    if (requestedRoles.roles[address] === undefined) {
                        requestedRoles.roles[address] = {};
                    }
                    requestedRoles.roles[address][role] = is_enabled;
                    requestedRoles.roles[address]['name'] = hostname;
                }
            }
        });

        return {managerElgibleCount, requestedRoles};
    }

    function saveInstanceRoles() {
        const {managerElgibleCount, requestedRoles} = getRequestedRoles();

        $.ajax({
                url: site_url + '/api/system/set_instance_roles',
                type: 'POST',
                data: {roles: JSON.stringify(requestedRoles)},
                success: function() {
                    clearInterval(reconfigureCountdown);
                    $('#opensearch-config-error').modal('hide');
                },
                error: function() {
                    $('#configure-opensearch-message').hide();
                    $('configure-opensearch').hide();
                    $('#reconfigure-countdown').hide();
                    $('#configure-opensearch-failed').show();
                    $('#configure-opensearch-ok').show();
                }
            });
    }

    function loadInstanceRoles() {
        function makeNodeCell(node, cell, role) {
            let retVal = '';
            switch(cell) {
                case 'ip':
                    return ' <td class="ui-td">' + node.ip + '</td>\n';
                case 'hostname':
                    return ' <td class="ui-td">' + node.name + '</td>\n';
                case 'version':
                    return ' <td class="ui-td">' + node.version + '</td>\n';
                case 'is_manager':
                    retVal =  ' <td class="ui-td">';
                    if (node.is_manager) {
                        retVal += '<input disabled class="ui-checkbox-group-item" type="checkbox" name="manager" checked>';
                    }
                    retVal += '</td>\n';
                    return retVal;
                case 'roles':
                    let value = role + '-' + node.ip + '-' + node.name;
                    let checked = node.roles.includes(role) ? ' checked' : '';
                    retVal =  ' <td class="ui-td">';
                    retVal += '<input class="ui-checkbox-group-item" type="checkbox" name="' + value + '" value="' + value +  '"' + checked + '>';
                    retVal += '</td>\n';
                    return retVal;

            }
        };

        function makeNodeRow(node) {
            retVal = '';
            ['ip', 'hostname', 'version', 'is_manager', 'roles'].forEach((cell) => {
                if (cell === 'roles') {
                    ['cluster_manager', 'data', 'ingest', 'remote_cluster_client', 'search', 'dynamic', 'coordinating']. forEach((role) => {
                        retVal += makeNodeCell(node, cell, role);
                    });
                } else {
                    retVal += makeNodeCell(node, cell);
                }
            });
            return retVal;
        };

        $.get(site_url + '/api/system/get_instance_roles', {}, (data) => {
            let nodes = JSON.parse(data);
            let nodeCount = Object.keys(nodes).length;
            if (nodeCount === 1) {
                $('#indicesTableContainer').text('There is only one instance in the cluster, so there are no roles to configure.');
                return;
            }
            $('.save-instance-roles').show();
            Object.entries(nodes).forEach(([nodeid, node]) => {
                row = makeNodeRow(node);
                $('#instanceRolesTableBody').append('<tr class="ui-tr">' + row + '</tr>');
            });
        })
    }

    $(document).ready(function() {
        loadInstanceRoles();

        function doCountdown() {
            if (typeof reconfigureCountdown !== 'undefined') {
                clearInterval(reconfigureCountdown);
            }

            $('#configure-opensearch').show();
            $('#reconfigure-countdown').hide();
            $('#opensearch-config-error').modal('show');
        }

        $('#opensearch-minimum-manager-eligible-close').click(function() {
            $('#opensearch-minimum-manager-eligible').modal('hide');
        })

        $('#opensearch-recommended-manager-eligible-close').click(function() {
            $('#opensearch-recommended-manager-eligible').modal('hide');
        })

        $('#opensearch-recommended-manager-eligible-comtinue').click(function() {
            $('#opensearch-recommended-manager-eligible').modal('hide');
            doCountdown();
        })

        $('.save-instance-roles').click(function() {
            const {managerElgibleCount, requestedRoles} = getRequestedRoles();

            if (managerElgibleCount < 1) {
                $('#opensearch-minimum-manager-eligible').modal('show');
                return;
            }

            if (managerElgibleCount < 2) {
                $('#opensearch-recommended-manager-eligible').modal('show');
                return;
            }

            doCountdown();
        })

        function startReconfigureCountdown() {
            let countdown = 119;
            reconfigureCountdown = setInterval(() => {
                if (countdown <= 0) {
                    clearInterval(reconfigureCountdown);
                    $('#reconfigure-countdown').addClass('hide');
                } else {
                    $('#reconfigure-countdown').text(countdown + ' seconds remaining');
                    countdown--;
                }
            }, 1000);
        }

        $('#configure-opensearch').click(function() {
            $('#configure-opensearch').hide();
            $('#reconfigure-countdown').show();
            startReconfigureCountdown();
            saveInstanceRoles();
        });
    });
</script>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">

        <h1 class="form-title tw-inline-flex">
            <?php echo _("Instance Roles"); ?>
        </h1>

        <div class="form-spacer"></div>

        <div id="workspace">
            <div>
                <div>
                    <div>
                        <div class="tw-my-4">
                            <div class="tw-flex tw-gap-2 tw-items-center tw-my-2">
                                <i class="fa fa-building-o"></i>
                                <span class="form-header"><?php echo _("Instances"); ?></span>
                            </div>
                            <div class="tw-rounded-lg tw-border-border tw-border tw-p-4 tw-overflow-auto" id="indicesTableContainer">
                                <table id="indicesTable" class="ui-table">
                                    <thead class="ui-thead">
                                        <tr class="ui-tr">
                                            <th class="ui-th"><?php echo _("IP"); ?></th>
                                            <th class="ui-th"><?php echo _("Hostname"); ?></th>
                                            <th class="ui-th"><?php echo _("OpenSearch Version"); ?></th>
                                            <th class="ui-th"><?php echo _("Current Cluster Manager"); ?></th>
                                            <th class="ui-th"><?php echo _("Manager Eligible"); ?></th>
                                            <th class="ui-th"><?php echo _("Data"); ?></th>
                                            <th class="ui-th"><?php echo _("Ingest"); ?></th>
                                            <th class="ui-th"><?php echo _("Remote Cluster Client"); ?></th>
                                            <th class="ui-th"><?php echo _("Search"); ?></th>
                                            <th class="ui-th"><?php echo _("Dynamic"); ?></th>
                                            <!-- TODO: Checking coordinating node for an instance should disable the others and vice-versa -->
                                            <th class="ui-th"><?php echo _("Coordinating"); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody class="ui-tbody" id="instanceRolesTableBody">
                                        <?php if (false && isset($node_roles)) { foreach ($node_roles as $node_id => $node): ?>
                                        <tr class="ui-tr">
                                            <td class="ui-td">
                                                <a data-title="Index Information" data-placement="bottom" rel="tipRight" href="<?php echo site_url('admin/instance_status/'.$node['name']); ?>" data-original-title="" title=""><?php if (!empty($node['ip'])) { echo $node['ip']; } else { echo $node['address']; } ?></a>
                                            </td>
                                            <td class="ui-td"><?php if (!empty($node['host'])) { echo $node['host']; } else { if ($node['hostname'] != $node['address']) { echo $node['hostname']; } } ?></td>
                                            <td class="ui-td"><?php echo $node['version']; ?></td>
                                            <td class="ui-td"><?php if ($node['is_manager']) { ?><input disabled class="ui-checkbox-group-item" type="checkbox" name="manager" checked><?php } ?></td>
                                            <td class="ui-td"><input class="ui-checkbox-group-item" type="checkbox" name="manager" <?php echo 'value="' . $node['host'] . '-' . 'manager"'; if (in_array('cluster_manager', $node['roles'])) { echo 'checked'; } ?>></td>
                                            <td class="ui-td"><input class="ui-checkbox-group-item" type="checkbox" name="data" <?php echo 'value="' . $node['host'] . '-' . 'data"';if (in_array('data', $node['roles'])) { echo 'checked'; } ?>></td>
                                            <td class="ui-td"><input class="ui-checkbox-group-item" type="checkbox" name="ingest" <?php echo 'value="' . $node['host'] . '-' . 'ingest"';if (in_array('ingest', $node['roles'])) { echo 'checked'; } ?>></td>
                                            <td class="ui-td"><input class="ui-checkbox-group-item" type="checkbox" name="remote_cluster_client" <?php echo 'value="' . $node['host'] . '-' . 'remote_cluster_client"';if (in_array('remote_cluster_client', $node['roles'])) { echo 'checked'; } ?>></td>
                                            <td class="ui-td"><input class="ui-checkbox-group-item" type="checkbox" name="search" <?php echo 'value="' . $node['host'] . '-' . 'search"';if (in_array('search', $node['roles'])) { echo 'checked'; } ?>></td>
                                            <td class="ui-td"><input disabled class="ui-checkbox-group-item" type="checkbox" name="dynamic" <?php echo 'value="' . $node['host'] . '-' . 'manager"';if (in_array('dynamic', $node['roles'])) { echo 'checked'; } ?>></td>
                                            <td class="ui-td"><input class="ui-checkbox-group-item" type="checkbox" name="coordinating" <?php echo 'value="' . $node['host'] . '-' . 'coordinating"';if (count($node['roles']) === 0) { echo 'checked'; } ?>></td>
                                        </tr>
                                        <?php endforeach; } ?>
                                    </tbody>
                                </table>
                            </div>
                            <button style="display:none" class="ui-btn ui-btn-default tw-text-primary-foreground tw-mb-4 save-instance-roles" >
                                <?php echo _('Save Instance Roles'); ?>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="opensearch-config-error" class="modal hide fade" tabindex="-3" role="dialog" aria-labelledby="opensearch-config-error-header" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="form-header" id="opensearch-config-error-header"><?php echo _('OpenSearch needs configuration'); ?></div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
            <div class="modal-body">
                <div id="configure-opensearch-message"><?php echo _("Nagios Log Server will now reconfigure the backend. Thi will apply to all of the instances in the cluster, and may take several minutes. You may be asked to log in again.") ?></div>
                <div id="reconfigure-countdown" class="hide"><?php echo _('120 seconds remaining'); ?></div>
                <div id="configure-opensearch-failed" class="hide"><?php echo _("Nagios Log Server could not restart the back end in a timely manner.") ?></div>
                <button class="ui-btn ui-btn-default tw-mt-4" id="configure-opensearch"><?php echo _("Apply OpenSearch Configuration"); ?></button>
            </div>
        </div>
    </div>
</div>

<div id="opensearch-minimum-manager-eligible" class="modal hide fade" tabindex="-3" role="dialog" aria-labelledby="opensearch-config-error-header" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="form-header" id="opensearch-minimum-manager-eligible-header"><?php echo _('Insufficient Manager Eligible Instances'); ?></div>
            </div>
            <div class="modal-body">
                <div id="opensearch-minimum-manager-eligible-message"><?php echo _("Nagios Log Server requires at least one Manager Eligible instance to run. Please check at least one instance to be Manager Eligible.") ?></div>
                <button class="ui-btn ui-btn-default tw-mt-4" id="opensearch-minimum-manager-eligible-close"><?php echo _("Ok"); ?></button>
            </div>
        </div>
    </div>
</div>

<div id="opensearch-recommended-manager-eligible" class="modal hide fade" tabindex="-3" role="dialog" aria-labelledby="opensearch-config-error-header" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="form-header" id="opensearch-recommended-manager-eligible-header"><?php echo _('Insufficient Manager Eligible Instances'); ?></div>
            </div>
            <div class="modal-body">
                <div id="opensearch-recommended-manager-eligible-message"><?php echo _("You have only one Manager Eligible instance. We recommend at least 2 in order to maintain cluster health. Please check at least one instance to be Manager Eligible.") ?></div>
                <button class="ui-btn ui-btn-default tw-mt-4" id="opensearch-recommended-manager-eligible-comtinue"><?php echo _("Continue with one Manager Eligible instance"); ?></button>
                <button class="ui-btn ui-btn-default tw-mt-4" id="opensearch-recommended-manager-eligible-close"><?php echo _("Cancel"); ?></button>
            </div>
        </div>
    </div>
</div>

<div id="opensearch-config-error" class="modal hide fade" tabindex="-3" role="dialog" aria-labelledby="opensearch-config-error-header" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="form-header" id="opensearch-config-error-header"><?php echo _('OpenSearch needs configuration'); ?></div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
            <div class="modal-body">
                <div id="configure-opensearch-message"><?php echo _("Nagios Log Server will now reconfigure the backend. Thi will apply to all of the instances in the cluster, and may take several minutes. You may be asked to log in again.") ?></div>
                <div id="reconfigure-countdown" class="hide"><?php echo _('120 seconds remaining'); ?></div>
                <div id="configure-opensearch-failed" class="hide"><?php echo _("Nagios Log Server could not restart the back end in a timely manner.") ?></div>
                <button class="ui-btn ui-btn-default tw-mt-4" id="configure-opensearch"><?php echo _("Apply OpenSearch Configuration"); ?></button>
            </div>
        </div>
    </div>
</div>

<?php echo $footer; ?>
