<?php
require_once(APPPATH . 'views/leftbar_common.php');

function is_clustered()
{
    $es = new Elasticsearch(array('index' => 'nagioslogserver'));
    $r = $es->query_wresultSize('node');
    // Take into account the global node here. It doesn't count as a node in the cluster.
    return $r['hits']['total']['value'] > 2;
}

function management_sections() 
{
    $items = [
        [
            'url' => site_url('admin/users'),
            'icon' => 'person',
            'text' => _('User Management')
        ]
    ];

    if (is_clustered()) {
        $items[] = [
            'url' => site_url('admin/instance_roles'),
            'icon' => 'view_sidebar',
            'text' => _('Instance Roles')
        ];
    }

    $items[] = [
        'url' => site_url('admin/host_lists'),
        'icon' => 'list',
        'text' => _('Host List Management')
    ];
    $items[] = [
        'url' => site_url('admin/auth_servers'),
        'icon' => 'lan',
        'text' => _('LDAP/AD Integration')
    ];
    $items[] = [
        'url' => site_url('admin/ncpa'),
        'icon' => 'monitoring',
        'text' => _('Monitor Backend (NCPA)')
    ];
    $items[] = [
        'url' => site_url('admin/custom_includes'),
        'icon' => 'add',
        'text' => _('Custom Includes')
    ];

    return $items;

}

$sections = [
    'Reports' => [
        'header_text'=> _('Reports'),
        'items' => [
            [
                'url' => site_url('admin/audit-log'),
                'icon' => 'description',
                'text' => _('Audit Log')
            ],
            [
                'url' => site_url('admin/unique_hosts'),
                'icon' => 'storage',
                'text' => _('Unique Hosts')
            ],
        ]
    ],
    'System' => [
        'header_text'=> _('System'),
        'items' => [
            [
                'url' => site_url('admin/cluster'),
                'icon' => 'view_quilt',
                'text' => _('Cluster Status')
            ],
            [
                'url' => site_url('admin/instance_status'),
                'icon' => 'view_module',
                'text' => _('Instance Status')
            ],
            [
                'url' => site_url('admin/index_status'),
                'icon' => 'database',
                'text' => _('Index Status')
            ],
            [
                'url' => site_url('admin/snapshots'),
                'icon' => 'backup',
                'text' => _('Snapshots &amp; Maintenance')
            ],
            [
                'url' => site_url('admin/system'),
                'icon' => 'flag',
                'text' => _('System Status')
            ],
            [
                'url' => site_url('admin/migration'),
                'icon' => 'tab_move',
                'text' => _('Migrate Data')
            ],
            [
                'url' => site_url('admin/subsystem'),
                'icon' => 'settings',
                'text' => _('Command Subsystem')
            ],
        ]
    ],
    'Management' => [
        'header_text'=> _('Management'),
        'items' => management_sections(),
    ],
    'General' => [
        'header_text'=> _('General'),
        'items' => [
            [
                'url' => site_url('admin/globals'),
                'icon' => 'public',
                'text' => _('Global Settings')
            ],
            [
                'url' => site_url('admin/mail'),
                'icon' => 'mail',
                'text' => _('Mail Settings')
            ],
            [
                'url' => site_url('admin/license'),
                'icon' => 'bookmark',
                'text' => _('License Information')
            ],
            [
                'url' => site_url('admin/proxy'),
                'icon' => 'rss_feed',
                'text' => _('Proxy Configuration')
            ],
        ]
    ],
    'Configure' => [
        'header_text'=> _('Logstash Configuration'),
        'items' => [
            [
                'url'  => site_url('configure/apply_logstash_configuration'),
                'icon' => 'settings',
                'text' => _('Apply Logstash Config'),
                'badge' => get_option('configuration_required', 0) ? 'warning' : 'warning',
                'icon_title' => get_option('configuration_required', 0) ? _('New configuration needs to be applied.') : null
            ],
            [
                'url'  => site_url('configure/snapshots'),
                'icon' => 'history',
                'text' => _('Config Snapshots')
            ],
            [
                'url' => site_url('configure/instance/global'),
                'icon' => 'globe',
                'text' => _('Global Config')
            ],
            [
                'submenu' => [ "Instance" => [
                    'header_text'=> _('Instance Config'),
                    'items' => array_map(function($n) {
                        $icon = 'radio_button_checked';
                        $title = _('This instance is OK');
                        
                        if (time() - $n['_source']['last_updated'] > 60*5) {
                            $icon = 'error';
                            $title = _("This instance may not be running... It hasn't checked in for over 5 minutes.");
                        } else {
                            $ls_bool = ($n['_source']['logstash']['status'] == "running");
                            $es_bool = ($n['_source']['opensearch']['status'] == "running");
                            if (!$ls_bool && !$es_bool) {
                                $icon = 'circle_outline';
                                $title = _("This instance is currently not running either Logstash or OpenSearch");
                            } else if (!$es_bool) {
                                $icon = 'adjust';
                                $title = _("This instance is not running OpenSearch");
                            } else if (!$ls_bool) {
                                $icon = 'adjust';
                                $title = _("This instance is not running logstash");
                            }
                        }
                        
                        return [
                            'url' => site_url('configure/instance/'.$n['_id']),
                            'icon' => $icon,
                            'text' => $n['_source']['hostname'],
                            'icon_title' => $title . ' (' . _("Instance UUID") . ': ' . $n['_id'] . ')',
                            'check' => $_SERVER['SERVER_ADDR'] == $n['_source']['address']
                        ];
                    }, $logstash_nodes)]
                ]
            ]
        ]
    ],
];

renderLeftbar($sections, 'adminLeftbarOpenSections');
?>