<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="rside">
        <div class="form-container">
            <h1 class="form-title"><?php echo _('License Information'); ?></h1>
            <?php if (is_trial_license()) { ?>
            <p class="form-subtitle"><?php echo _('Manage your Nagios Log Server license. If you do not have one, you can'); ?> <a href="https://www.nagios.com/products/nagios-log-server/pricing/buy" target="_new"><?php echo _("purchase one"); ?></a>.</p>
            <?php } ?>
            <div class="form-spacer"></div>

            <div class="tw-w-3/4">
            <?php if (!empty($success)) { ?><div class="alert alert-success"><?php echo $success; ?></div><?php } ?>
            <?php if (!empty($error)) { ?><div class="alert alert-error"><?php echo $error; ?></div><?php } ?>

            <div class="tw-mb-6">
                <?php if (is_trial_license()) { ?>
                    <?php if (get_trial_days_left() > 60) { ?>
                        <div class="alert alert-warning"><?php echo _('<b>Extended Trial</b> - Your trial will end in'); ?> <strong><?php echo get_trial_days_left(); ?></strong> <?php echo _('days'). " (60 + " . (get_trial_days_left() - 60) . " " . _("bonus days") . ")"; ?>.</div>
                    <?php } else { ?>
                        <div class="alert alert-warning"><?php echo _('Update your license key. Your trial will end in'); ?> <strong><?php echo get_trial_days_left(); ?></strong> <?php echo _('days'); ?>.</div>
                    <?php } ?>
                <?php } else if (is_subscription_license() == true && is_subscription_expired()) { ?>
                <div class="alert alert-error"><?php echo _("This subscription for Nagios Log Server has expired"); ?>.</div>
                <?php } else if (is_subscription_license() == true && get_subscription_days_left() < 30) { ?>
                <div class="alert alert-error"><?php echo _("The subscription to Nagios Log Server will expire in"); ?> <?php echo get_subscription_days_left(); ?> <?php echo _("days"); ?>.</div>
                <?php } else if (!empty($error)) { ?>
                <div class="alert alert-error"><?php echo $error; ?></div>
                <?php } else { ?>
                <div class="alert alert-success"><?php echo _('Your license key is valid'); if (is_license_activated()) { echo ' ' . _('and activated'); } ?>.</div>
                <?php } ?>
            </div>

            <?php echo form_open('admin/license'); ?>
            <div class="tw-mb-4">
                <label class="tw-block tw-text-sm tw-font-medium tw-mb-1" for="license_key"><?php echo _('License Key'); ?></label>
                <div class="tw-flex tw-flex-row tw-mb-2 tw-w-full tw-items-center tw-gap-2">
                    <input <?php if (is_demo_mode()) { echo 'disabled'; } ?> type="text" id="license_key" name="key" class="ui-input tw-w-full" value="<?php if (!is_demo_mode()) { echo get_license_key(); } else { echo 'DEMO MODE'; } ?>">
                    <button <?php if (is_demo_mode()) { echo 'disabled'; } ?> type="submit" value="1" name="setkey" class="ui-btn ui-btn-default"><?php echo _('Set Key'); ?></button>
                </div>
            </div>
            <?php echo form_close(); ?>

            <div class="tw-mb-6">
                <label class="tw-block tw-mb-2 tw-text-lg tw-font-medium"><?php echo _("License Information"); ?></label>
                <div class="tw-relative tw-w-full tw-overflow-auto">
                    <?php echo get_license_info(get_license_key()); ?>
                </div>
            </div>

            <?php if (!is_trial_license() && !is_free_license()) { ?>
            <div class="tw-mb-6">
                <label class="tw-block tw-mb-2 tw-text-lg tw-font-medium"><?php echo _("Maintenance & Activation"); ?></label>
                <div class="tw-relative tw-w-full tw-overflow-auto">
                    <table class="ui-table">
                        <tbody class="ui-tbody">
                            <tr class="ui-tr">
                                <td class="ui-td"><?php echo _('License Activated'); ?>:</td>
                                <td class="ui-td"><?php if (is_license_activated()) { echo _('Yes'); } else { echo _('No') . ' - <a href="' . site_url('admin/activate') . '">' . _('Activate now') . '</a>'; } ?></td>
                            </tr>
                            <tr class="ui-tr">
                                <td class="ui-td"><?php echo _('Maintenance Status'); ?>:</td>
                                <td class="ui-td">
                                    <?php if (is_demo_mode()) { echo _('DEMO MODE'); } else { if (does_license_have_maintenance()) { echo _('Current - Expires on'); } else { echo _('<b>Expired!</b> - Ends on'); } ?> 
                                    <?php echo date("m/d/Y", get_maintenance_end_date()); ?> <?php if (get_maintenance_days_left() > 0) { ?>(<?php echo get_maintenance_days_left() . " " . _('days left'); ?>)<?php } } ?> - <a href="https://www.nagios.com/renew/?license_hash=<?php echo md5(get_license_key()); ?>" target="_blank"><?php echo _('Renew Now') ?></a>
                                </td>
                            </tr>
                            <tr class="ui-tr">
                                <td class="ui-td"><?php echo _('Last Maintenance Check'); ?>:</td>
                                <td class="ui-td"><?php echo date("m/d/Y H:i:s", get_option('last_met_check_time')); ?> - <a href="<?php echo site_url('admin/license?maint_check=1'); ?>"><?php echo _('Run Check'); ?></a></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php } ?>

            <?php if (is_trial_license() || is_free_license()) { ?>
            <div class="tw-mb-6">
                <label class="tw-block tw-mb-2 tw-text-lg tw-font-medium"><?php echo _("Trial Extension"); ?></label>
                <p class="tw-mb-2"><?php echo _("Need a trial extension? Contact"); ?> <a href="mailto:sales@nagios.com">sales@nagios.com</a> <?php echo _("for more information"); ?>.</p>
                <?php echo form_open('admin/extend_trial'); ?>
                <div class="tw-flex tw-flex-row tw-mb-2 tw-w-full tw-items-center tw-gap-2">
                    <input type="text" name="trial_extension_key" value="<?php echo set_value('trial_extension_key'); ?>" class="ui-input tw-w-full" placeholder="<?php echo _("Trial Extension Key"); ?>">
                    <button <?php if (is_demo_mode()) { echo 'disabled'; } ?> type="submit" value="1" name="setkey" class="ui-btn ui-btn-default"><?php echo _('Apply'); ?></button>
                </div>
                <?php echo form_close(); ?>
            </div>
            <?php } ?>
            </div>
        </div>
    </div>
</div>

<?php echo $footer; ?>