<?php

echo $header;

// FIX THIS!!!!!
$nodeList = array();

foreach ($nodes as $node) {
    $nodeList[] = $node['_source']['hostname'].'|'.$node['_source']['address'];
}
?>

<div class="configure-layout">
    <?= $leftbar ?>

    <div class="form-container">

        <div id="create-alert-message" class="alert hide">
            <div id="alert-message"></div>
        </div>

        <h1 class="form-title"><?= _('Monitor Backend (via NCPA)') ?></h1>
        <p class="form-subtitle"><?= _('This page provides information regarding the monitoring of Nagios Log Server itself. Nagios Log Server comes with the Nagios Cross-Platform Agent installed, so that you can integrate with a Nagios XI server.') ?></p>
        <div class="form-spacer"></div>

        <?php if (!empty($success)) { ?><div class="alert alert-success"><?= $success ?></div><?php } ?>
        <?php if (!empty($error)) { ?><div class="alert alert-error"><?= $error ?></div><?php } ?>

        <a class="ui-btn ui-btn-default" target="_blank" href="<?= 'https://' . $_SERVER['SERVER_ADDR'] . ':5693/';?>"><span class="tw-text-primary-foreground"><?= _("Open NCPA Interface") ?></span></a>

        <h3 class="form-header tw-mt-8"><?= _('Tokens') ?></h3>
        <p class="tw-my-2"><?= _('When saved, these tokens will be applied to all instances.');?></p>
        <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
            <label class="tw-block tw-text-sm tw-font-medium"><?= _("NCPA API Token") ?></label>
            <div class="tw-flex tw-gap-2 tw-w-[450px]">
                <input type="text" class="ui-input" id="ncpa-api-input" value="<?= $api_token;?>">
                <tooltip-provider>
                    <tooltip data-position="top" data-delay="100">
                        <tooltip-trigger>
                            <button class="ui-btn ui-btn-outlined generate-random"><span class="material-symbols-outlined">replay</span></button>
                        </tooltip-trigger>
                        <tooltip-content>
                        <div><?= _("Generate new API token");?></div>
                    </tooltip-content>
                    </tooltip>
                </tooltip-provider>
                <button class="ui-btn ui-btn-default save-config" data-endpoint="ncpa-api"><div class="tw-flex tw-items-center tw-justify-center tw-gap-2"><span class="material-symbols-outlined">save</span> <?= _("Save");?></div></button>
            </div>
        </div>

        <h3 class="form-header tw-mt-8"><?= _('Processes') ?></h3>

        <div class="tw-grid tw-my-2 tw-w-[300px] tw-items-center tw-mb-6">
            <label class="tw-block tw-text-sm tw-font-medium"><?= _("Instance") ?></label>
            <select id="node-select" class="ui-select">
                <?php foreach ($nodes as $node) {
                    $node = $node['_source'];
                    $thisInstance = '';

                    # SERVER_ADDR may be localhost or the inet6 address, so check HTTP_HOST, as well.
                    # The value returned by HTTP_HOST and SERVER_ADDR may be the hostname or an ip, so check both.
                    # NOTE: I was changing /etc/hosts and hostname via hostnamectl, so this may not be correct.
                    if ($node['hostname'] == $_SERVER['HTTP_HOST']   || $node['address'] == $_SERVER['HTTP_HOST'] ||
                        $node['hostname'] == $_SERVER['SERVER_ADDR'] || $node['address'] == $_SERVER['SERVER_ADDR']) {

                        $thisInstance = "[This Instance] ";
                    }
                ?>
                <option value="<?= $node['hostname'].'|'.$node['address'] ?>">
                    <?= $thisInstance ?>
                    <?= empty($node['hostname']) ? $node['address'] : "{$node['hostname']} ({$node['address']})" ?>
                </option>
                <?php } ?>
            </select>
        </div>
        <div class="tw-inline-block tw-bg-secondary tw-text-secondary-foreground tw-rounded-lg tw-p-2 tw-w-auto">
            <div class="tw-flex tw-items-center tw-mb-2"><span id="ncpa-status" class="status tw-mr-1 tw-flex"><i class="spinner"></i></span> <?= _('NCPA') ?> <span data-service="ncpa" class="service-actions" id="ncpa-actions"></span></div>
        </div>
    </div>
</div>

<script type="text/javascript">
    // Required by status-check.js functions
    var apikey = '<?= $apikey ?>';

    $(document).ready(function() {

        // FIX THIS!!!!
        var nodeList = ['<?= implode("', '", $nodeList);?>'];

        $('#system-profile').click(function() {
            window.location.href = site_url+'api/system/get_system_profile';
        });

        $('.save-config').click(function() {
            var endpoint = $(this).data('endpoint');
            var value = $('#ncpa-api-input').val();

            $(this).prop('disabled', true);
            $(this).html('<span class="material-symbols-outlined tw-mr-2">save</span> <?= _("Saving...") ?>');

            save(endpoint, value)
        });


        // Depends on var nodeList.
        function save(endpoint, value) {
            var addr
            var url;

            for (idx in nodeList) {
                key = nodeList[idx];

                $.post(site_url + "/api/system/set_token", { key: endpoint, value: value, token: '<?= $apikey ?>' }, function(data) {
                    $('.save-config').prop('disabled', false);
                    $('.save-config').html('<span class="material-symbols-outlined tw-mr-2">save</span> <?= _("Save") ?>');

                    if (data.error || data.status) {
                        show_error(data.message);
                        return;
                    }

                    show_info(data.message);
                }, 'json')
                .fail(function(response) {
                    // Catch failure, such as the server is down/not responding.
                    show_error(response.statusText);
                    // Return or keep going?
                    //return;
                });
            }
        }

        $('.generate-random').click(function () {
            $('#ncpa-api-input').val(generate_random());
        });

        // Add changing the selection box
        $('#node-select').change(function() {
            clear_all_status();

            var key = $(this).val();

            check_service(key, 'ncpa');
        });

        // Do ajax calls to update service information
        check_all_services();

        // Bind click action for starting/stopping/restarting
        $('.service-actions').bind('click', 'a', run_action);
    });

    function show_error(msg) {
        $('#alert-message').html(msg);
        $('#create-alert-message').addClass('alert-danger').show();
    }

    function show_info(msg) {
        $('#alert-message').html(msg);
        $('#create-alert-message').addClass('alert-success').show();
    }

    function generate_random() {
        var alphabet = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_.";
        var value = [];

        for (var i=0; i < 32; i++) {
            var alpha_index = Math.floor(Math.random() * 31);
            value[i] = alphabet[alpha_index];
        }

        return value.join("");
    }

    function check_all_services()
    {
        var key = $('#node-select option:selected').val();

        check_service(key, 'ncpa');
    }

    // For status-check.js
    var base_url = "<?= base_url() ?>";

    var stopText = "<?= _('Stop') ?>";
    var startText = "<?= _('Start') ?>";
    var restartText = "<?= _('Restart') ?>";

</script>

<script type="text/javascript" src="<?= base_url('media') ?>/js/status-check.js"></script>

<?= $footer ?>