<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">
        <h1 class="form-title"><?php echo _('Proxy Configuration'); ?></h1>
        <p class="form-subtitle">
            <?php echo _('These proxy settings, when enabled, <i>only</i> apply to internal Log Server calls back to Nagios. The calls include update checks, maintenance checks, and activation.'); ?>
        </p>
        <div class="form-spacer"></div>

        <?php if (!empty($success)) { ?><div class="tw-bg-green-100 tw-border tw-border-green-400 tw-text-green-700 tw-px-4 tw-py-3 tw-rounded tw-relative tw-mb-4" role="alert"><?php echo $success; ?></div><?php } ?>
        <?php if (!empty($error)) { ?><div class="tw-bg-red-100 tw-border tw-border-red-400 tw-text-red-700 tw-px-4 tw-py-3 tw-rounded tw-relative tw-mb-4" role="alert"><?php echo $error; ?></div><?php } ?>

        <?php echo form_open('admin/proxy', array("class" => "tw-flex tw-flex-col tw-gap-4 tw-w-1/2")); ?>
            <div class="tw-mb-4">
                <div class="ui-checkbox-group">
                    <div class="tw-flex tw-items-center tw-space-x-2">
                        <input type="checkbox" id="use_proxy" name="use_proxy" value="1" <?php if (get_option('use_proxy', 0)) { echo 'checked'; } ?> class="ui-checkbox-group-item">
                        <label for="use_proxy" class="ui-label"><?php echo _("Enable proxy for update checks, maintenance checks, and activation"); ?></label>
                    </div>
                </div>
            </div>

            <h5 class="tw-text-lg tw-font-medium"><?php echo _('Proxy Settings'); ?></h5>

            <div class="tw-mb-2">
                <label class="tw-block tw-text-sm tw-font-medium tw-mb-1" for="proxy_address"><?php echo _("Proxy Address"); ?></label>
                <input type="text" id="proxy_address" name="proxy_address" value="<?php echo htmlentities(get_option('proxy_address'), ENT_COMPAT, 'UTF-8'); ?>" class="ui-input tw-w-full">
            </div>

            <div class="tw-mb-2">
                <label class="tw-block tw-text-sm tw-font-medium tw-mb-1" for="proxy_port"><?php echo _("Proxy Port"); ?></label>
                <input type="text" id="proxy_port" name="proxy_port" value="<?php echo htmlentities(get_option('proxy_port'), ENT_COMPAT, 'UTF-8'); ?>" class="ui-input tw-w-20">
            </div>

            <div class="tw-mb-2">
                <label class="tw-block tw-text-sm tw-font-medium tw-mb-1" for="proxy_auth"><?php echo _("Proxy Auth"); ?></label>
                <input type="text" id="proxy_auth" name="proxy_auth" value="<?php echo htmlentities(get_option('proxy_auth'), ENT_COMPAT, 'UTF-8'); ?>" placeholder="username:password" class="ui-input tw-w-full">
            </div>

            <div class="tw-mb-2">
                <div class="ui-checkbox-group">
                    <div class="tw-flex tw-items-center tw-space-x-2">
                        <input type="checkbox" id="proxy_tunnel" name="proxy_tunnel" value="1" <?php if (get_option('proxy_tunnel', 1)) { echo 'checked'; } ?> class="ui-checkbox-group-item">
                        <label for="proxy_tunnel" class="ui-label"><?php echo _("Use HTTP Tunnel"); ?></label>
                    </div>
                </div>
            </div>

            <div class="tw-mt-6">
                <button type="submit" class="ui-btn ui-btn-default"><?php echo _("Save Settings"); ?></button>
            </div>
        <?php echo form_close(); ?>
        <div class="tw-clear tw-pb-[100px]"></div>
    </div>
</div>

<?php echo $footer; ?>