<?php echo $header; ?>

<script type="text/javascript">
var EDITING;

$(document).ready(function() {

    $('#next-run').datetimepicker({
        timeFormat: "HH:mm:ss"
    });

    $('.edit').click(function() {
        var id = $(this).data('id');
        EDITING = id;

        // Grab the information on the system job before showing modal
        $.post(site_url+'api/system/get_job_by_id', { id: id }, function(data) {

            var freq = data.readable_frequency.split(' ');
            if (freq[1].substr(freq[1].length - 1) != 's') {
                freq[1] += 's';
            }

            // Update modal information
            $('.editing').html('<strong>' + data.id + '</strong> (<?php echo _("Runs"); ?> ' + data.command + ')');
            $('#frequency').val(freq[0]);
            $('#freq-type').val(freq[1]);
            $('#next-run').val(data.readable_run_time);

        });

        $('#edit-system-job').modal('show');
    });

    $('.update-job').click(function() {

        <?php if (is_demo_mode()) { ?>
        alert("<?php echo _('This function is not available in demo mode.'); ?>");
        return false;
        <?php } ?>

        var datetime = $('#next-run').val();
        var date = new Date(datetime);
        var timestamp = date.getTime() / 1000;

        var frequency = $('#frequency').val();
        var freqtype = $('#freq-type').val();
        var multi = 0;

        switch (freqtype) {
            case "seconds":
                multi = 1;
                break;
            case "minutes":
                multi = 60;
                break;
            case "hours":
                multi = 60*60;
                break;
            case "days":
                multi = 60*60*24;
                break;
        }
        
        frequency = frequency * multi;

        // Write these values to the job
        $.post(site_url+'api/system/update_job', { 'job[id]': EDITING, 'job[frequency]': frequency, 'job[run_time]': timestamp }, function(data) {
            $('#edit-system-job').modal('hide');
            location.reload();
        });

    });

    $('.run-job').click(function() {

        <?php if (is_demo_mode()) { ?>
        alert("<?php echo _('This function is not available in demo mode.'); ?>");
        return false;
        <?php } ?>

        // Run the job now
        var job_id = $(this).data('id');
        $.post(site_url+'api/system/run_job', { 'job[id]': job_id }, function(data) {
            location.reload();
        });

    });

    $('.force-reset').click(function() {
        <?php if (is_demo_mode()) { ?>
        alert("<?php echo _('This function is not available in demo mode.'); ?>");
        return false;
        <?php } else { ?>
        if (confirm("<?php echo _('Resetting the subsystem jobs will set all jobs back to the default settings. This should only be done if the jobs have become stuck or one of the 5 standard jobs are missing. Would you like to continue?'); ?>")) {
            return true;
        } else {
            return false;
        }
        <?php } ?>
    });

});
</script>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">

        <h1 class="form-title"><?php echo _("Command Subsystem"); ?></h1>
        <p class="form-subtitle"><?php echo _("The command subsystem runs all the jobs that are scheduled for backup, maintenance, and checks. It also runs occasional jobs that are required by other sections of the program."); ?><br/><?php echo _("Other jobs use the command subsystem to run but are not listed here. System jobs that are in <strong>waiting</strong> status are normal."); ?></p>
        <div class="form-spacer"></div>

        <?php if (!empty($reset)) { ?>
        <div class="alert alert-info">
            <button type="button" class="close" data-dismiss="alert">&times;</button>
            <?php echo _("Subsystem jobs have been reset."); ?>
        </div>
        <?php } else if (!empty($run)) { ?>
        <div class="alert alert-info">
            <button type="button" class="close" data-dismiss="alert"><i class="material-symbols-outlined">close</i></button>
            <?php echo _("Submitted run now command for subsystem job."); ?>
        </div>
        <?php } ?>

        <h4 class="form-header tw-flex tw-justify-between tw-items-center tw-mb-4"><?php echo _("System Jobs"); ?> <a href="<?php echo site_url('admin/reset_subsystem'); ?>" class="force-reset ui-btn ui-btn-outlined no-primary"> <?php echo _("Reset All Jobs"); ?></a></h4>
        <table class="ui-table">
            <thead class="ui-thead">
                <tr class="ui-tr">
                    <th class="ui-th"><?php echo _("Job ID"); ?></th>
                    <th class="ui-th"><?php echo _("Job Status"); ?></th>
                    <th class="ui-th"><?php echo _("Last Run Status"); ?></th>
                    <th class="ui-th"><?php echo _("Last Run Time"); ?></th>
                    <th class="ui-th"><?php echo _("Frequency"); ?></th>
                    <th class="ui-th"><?php echo _("Next Run Time"); ?></th>
                    <th class="ui-th"><?php echo _("Type"); ?></th>
                    <th class="ui-th"></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($globals as $g) { ?>
                <tr class="ui-tr">
                    <td class="ui-td"><?php echo $g['_id']; ?></td>
                    <td class="ui-td"><?php echo ucfirst($g['_source']['status']); ?></td>
                    <td class="ui-td"><?php if (!empty($g['_source']['last_run_status'])) { echo $g['_source']['last_run_status']; } else { echo "-"; } ?></td>
                    <td class="ui-td"><?php if (!empty($g['_source']['last_run_time'])) { echo date("m/d/Y H:i:s", strtotime($g['_source']['last_run_time'])); } else { echo _("Never"); } ?></td>
                    <td class="ui-td"><?php echo humanize_time($g['_source']['frequency']); ?></td>
                    <td class="ui-td"><?php echo date("m/d/Y H:i:s", $g['_source']['run_time']); ?></td>
                    <td class="ui-td"><?php echo ucfirst($g['_source']['type']); ?></td>
                    <td class="ui-td">
                        <dropdown-menu data-position="bottom-right">
                            <dropdown-trigger as-child>
                                <div class="material-symbols-outlined ui-icon-btn">more_horiz</div>
                            </dropdown-trigger>
                            <dropdown-content class="ui-dropdown-content">
                                <a data-id="<?php echo $g['_id']; ?>" class="edit"><dropdown-item class="ui-dropdown-item"><?php echo _("Edit"); ?></dropdown-item></a>
                                <a href="<?php echo site_url('admin/run_job/'.$g['_id']); ?>"><dropdown-item class="ui-dropdown-item"><?php echo _("Run"); ?></dropdown-item></a>
                            </dropdown-content>
                        </dropdown-menu>
                    </td>
                </tr>
                <?php } ?>
            </tbody>
        </table>

    </div>
</div>

<div id="edit-system-job" class="modal hide fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h2 class="form-header"><?php echo _("Edit System Job"); ?></h2>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
            <div class="modal-body">
                <p class="form-subheader"><?php echo _("You can update the frequency (the amount of time the job will wait between the runs) and the time you want the next scheduled run to be. Setting a run time of less than the current time will force the job to run almost instantly. Once a job has been run it will re-schedule itself using the frequency time."); ?></p>
                <div class="tw-mt-6">
                    <div class="tw-flex tw-items-center tw-mb-4">
                        <label class="tw-w-1/3 tw-pr-5 tw-flex tw-items-center tw-justify-end"><?php echo _("Editing job"); ?></label>
                        <div class="tw-2-2/3 tw-mb-[5px]">
                            <span class="editing"></span>
                        </div>
                    </div>
                    <div class="tw-flex tw-items-center tw-mb-4">
                        <label class="tw-w-1/3 tw-pr-5 tw-flex tw-items-center tw-justify-end" for="frequency"><?php echo _("Frequency"); ?></label>
                        <div class="col-sm-8 tw-flex tw-gap-2 tw-w-[200px]">
                            <div class="tw-w-[80px]">
                                <input type="text" id="frequency" value="" class="ui-input">
                            </div>
                            <select id="freq-type" class="ui-select tw-w-[100px]">
                                <option value="seconds"><?php echo _("seconds"); ?></option>
                                <option value="minutes"><?php echo _("minutes"); ?></option>
                                <option value="hours"><?php echo _("hours"); ?></option>
                                <option value="days"><?php echo _("days"); ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="tw-flex tw-items-center tw-mb-4">
                        <label class="tw-w-1/3 tw-pr-5 tw-flex tw-items-center tw-justify-end" for="next-run"><?php echo _("Next Run Time"); ?></label>
                        <div class="col-sm-8">
                            <input type="text" class="ui-input" id="next-run" value="">
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer tw-flex tw-space-x-2 tw-justify-end">
                <button class="ui-btn ui-btn-default update-job"><?php echo _("Update"); ?></button>
                <button class="ui-btn ui-btn-outlined" data-dismiss="modal" aria-hidden="true"><?php echo _("Cancel"); ?></button>
            </div>
        </div>
    </div>
</div>

<?php echo $footer; ?>