<?= $header ?>

<script type="text/javascript">
$(document).ready(function() {

    $('#system-profile').click(function() {
        window.location.href = site_url+'api/system/get_system_profile';
    });

});
</script>

<div class="configure-layout">
    <?= $leftbar ?>
    <div class="form-container">

        <h1 class="form-title"><?= _('System Status') ?></h1>
        <p class="form-subtitle"><?= _('The system status shows the important required components statuses and allows you to start/stop/restart them from the web UI.') ?></p>
        <div class="form-spacer"></div>
        <button type="button" id="system-profile" class="ui-btn ui-btn-default tw-mb-4"><?= _('Download System Profile') ?></button>

        <?php if (!empty($success)) { ?><div class="alert alert-success"><?= $success ?></div><?php } ?>
        <?php if (!empty($error)) { ?><div class="alert alert-error"><?= $error ?></div><?php } ?>

        <h3 class="form-header tw-mb-2"><?= _('Subsystems') ?></h3>
        <div class="tw-grid tw-w-[500px] tw-items-center tw-mb-4">
            <label class="tw-block tw-text-sm tw-font-medium"><?= _("Instance") ?></label>
            <select id="node-select" class="ui-select">
                <?php foreach ($nodes as $node) {
                    $thisInstance = '';

                    # SERVER_ADDR may be localhost or the inet6 address, so check HTTP_HOST, as well.
                    # The value returned by HTTP_HOST and SERVER_ADDR may be the hostname or an ip, so check both.
                    # NOTE: I was changing /etc/hosts and hostname via hostnamectl, so this may not be correct.
                    if ($node['hostname'] == $_SERVER['HTTP_HOST']   || $node['address'] == $_SERVER['HTTP_HOST'] ||
                        $node['hostname'] == $_SERVER['SERVER_ADDR'] || $node['address'] == $_SERVER['SERVER_ADDR']) {

                        $thisInstance = "[This Instance] ";
                    }
                ?>
                <option value="<?= $node['hostname'].'|'.$node['address'] ?>">
                    <?= $thisInstance ?>
                    <?= empty($node['hostname']) ? $node['address'] : "{$node['hostname']} ({$node['address']})" ?>
                </option>
                <?php } ?>
            </select>
        </div>
        <div class="tw-rounded-lg tw-border-border tw-border tw-p-4 tw-w-[500px]">
            <div class="tw-flex tw-justify-between tw-mb-1"><div class="tw-flex tw-gap-2 tw-items-center"><span id="opensearch-status" class="status tw-flex tw-items-center"><i class="spinner"></i></span> <?= _('OpenSearch Database') ?></div> <span data-service="opensearch" class="service-actions tw-flex tw-items-center tw-gap-2" id="opensearch-actions"></span></div>
            <div class="tw-flex tw-justify-between"><div class="tw-flex tw-gap-2 tw-items-center"><span id="logstash-status" class="status tw-flex tw-items-center"><i class="spinner"></i></span> <?= _('Logstash Collector') ?> </div><span data-service="logstash" class="service-actions tw-flex tw-items-center tw-gap-2" id="logstash-actions"></span></div>
        </div>
    </div>
</div>

<script type="text/javascript">
    // Required by status-check.js functions
    var apikey = '<?= $apikey ?>';

    $(document).ready(function() {

        // Add changing the selection box
        $('#node-select').change(function() {
            clear_all_status();

            var key = $(this).val();

            check_service(key, 'logstash');
            check_service(key, 'opensearch');
        });

        // Do ajax calls to update service information
        check_all_services();

        // Bind click action for starting/stopping/restarting
        $('.service-actions').bind('click', 'a', run_action);
    });

    function check_all_services()
    {
        var key = $('#node-select option:selected').val();

        check_service(key, 'logstash');
        check_service(key, 'opensearch');
    }

    // For status-check.js
    var base_url = "<?= base_url() ?>";

    var stopText = "<?= _('Stop') ?>";
    var startText = "<?= _('Start') ?>";
    var restartText = "<?= _('Restart') ?>";

</script>

<script type="text/javascript" src="<?= base_url('media') ?>/js/status-check.js"></script>

<?= $footer ?>