<?php echo $header; ?>

<script type="text/javascript">
$(document).ready(function() {

    update_datetimepicker();
    $('input.date-picker').datetimepicker({
        showOtherMonths: true,
        selectOtherMonths: true
    });

    $('select[name="time"]').change(function() {
        update_datetimepicker();
    });

    $('.show-query').click(function() {
        var id = $(this).data('id');
        $.get('<?php echo site_url("api/check/history_alert_query"); ?>', { id: id }, function(data) {
            if (data.error) {
                alert(data.error);
            } else {
                $('#query').html(JSON.stringify(JSON.parse(data._source.query), null, 4));
                $('#show-query').modal('show');
            }
        });
    });

    if ($('#form_deleted_alert').val()) {
        $('#form_alert').val("");
    }

    $('#form_alert').change(function() {
        $('#form_deleted_alert').val('');
    });
    $('#form_deleted_alert').change(function() {
        $('#form_alert').val('');
    });

    $('#trim-alert-history').click(function(e) {
        e.preventDefault();
        $.post(site_url+'api/system/trim_history', { type: 'alert' }, function(data) {
            data = JSON.parse(data);
            if (data.error.length) {
                alert(data.error);
            } else if (data.curl_response.length) {
                var response = JSON.parse(data.curl_response);
                if (response._indices.nagioslogserver_history._shards.failed == 0) {
                    alert('Trimmed Alert History to remove entries older than ' + data.days_to_trim + ' days.');
                }
            }
        });
    });
});

function update_datetimepicker() {
    if ($('.time-select').val() == 'c') {
        $('.date-picker').show();
    } else {
        $('.date-picker').hide();
    }
}
</script>

<div class="configure-layout">

    <?php echo $leftbar; ?>

    <div class="form-container">

        <div class="tw-flex tw-flex-row tw-justify-between">
            <div class="form-title" style="margin-bottom: 0px"><?php echo _("Alert History"); ?></div>
            <div class="tw-flex tw-gap-4">
                <ui-sheet>
                    <ui-sheet-trigger>
                        <button class="ui-btn ui-btn-default">
                            <div class="tw-flex tw-items-center tw-justify-center tw-gap-2">
                                <i class="material-symbols-outlined">filter_alt</i>                                
                                <?php echo _("Filter"); ?>
                            </div>
                        </button>
                    </ui-sheet-trigger>
                    <ui-sheet-content>
                        <div class="tw-flex tw-justify-between tw-items-center tw-mb-4">
                            <div class="form-header"><?php echo _("Filter Options"); ?></div>
                            <ui-sheet-close></ui-sheet-close>
                        </div>
                    <?php echo form_open('alerts/history', array('method' => 'get')); ?>
                        <div class="tw-grid tw-gap-4">
                            <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4">
                                <label class="tw-text-right tw-font-medium tw-mb-0"><?php echo _('Time Frame'); ?></label>
                                <select class="time-select ui-select tw-col-span-2" name="time">
                                    <option value="24h"<?php if ($time == '24h' || $time == '') { echo ' selected'; } ?>><?php echo _('Last 24 Hours'); ?></option>
                                    <option value="7d"<?php if ($time == '7d') { echo ' selected'; } ?>><?php echo _('Last 7 Days'); ?></option>
                                    <option value="30d"<?php if ($time == '30d') { echo ' selected'; } ?>><?php echo _('Last 30 Days'); ?></option>
                                    <option value="c"<?php if ($time == 'c') { echo ' selected'; } ?>><?php echo _('Custom'); ?></option>
                                </select>
                            </div>
                            <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4 date-picker">
                                <label class="date-picker tw-text-right tw-font-medium tw-mb-0"><?php echo _('From'); ?></label>
                                <input type="text" name="start" class="date-picker ui-input tw-col-span-2" value="<?php if (!empty($start)) { echo $start; } ?>">
                            </div>
                            <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4 date-picker">
                                <label class="date-picker tw-text-right tw-font-medium tw-mb-0"><?php echo _('to'); ?></label>
                                <input type="text" name="end" class="date-picker ui-input tw-col-span-2" value="<?php if (!empty($end)) { echo $end; } ?>">
                            </div>
                            <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4">
                                <label class="tw-text-right tw-font-medium tw-mb-0"><?php echo _('Alert'); ?></label>
                                <select class="ui-select tw-col-span-2" id="form_alert" name="alert">
                                    <option value="[showing-history-for-all-alerts]"><?php echo _('All'); ?></option>
                                    <?php $found_alert = false; ?>
                                    <?php foreach ($alerts as $alert) { ?>
                                    <option value="<?php echo $alert['id']; ?>"<?php if ($alert_id == $alert['id']) { $found_alert = true; echo ' selected'; } ?>><?php echo html_escape($alert['name']); ?></option>
                                    <?php } ?>
                                    <option value=""><?php echo _('[Using Deleted Alerts]'); ?></option>
                                </select>
                            </div>
                            <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4">
                                <label class="tw-text-right tw-font-medium tw-mb-0"><?php echo _('Deleted Alert'); ?></label>
                                <select class="ui-select tw-col-span-2" id="form_deleted_alert" name="deleted_alert">
                                    <option value=""><?php echo _("[Using Alert Selector]"); ?></option>
                                    <?php foreach ($deleted_alerts as $alert) { 
                                    $alert = $alert['_source'];?>
                                    <option value="<?php echo $alert['id']; ?>"<?php if ($alert_id == $alert['id']) { echo ' selected'; } ?>><?php echo html_escape($alert['name']); ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                            <div class="tw-grid tw-grid-cols-3 tw-items-center tw-gap-4">
                                <label class="tw-text-right tw-font-medium tw-mb-0"><?php echo _('Status'); ?></label>
                                <select class="ui-select tw-col-span-2" name="status">
                                    <option value=""><?php echo _('All'); ?></option>
                                    <option value="0"<?php if ($status === '0') { echo ' selected'; } ?>><?php echo _('OK'); ?></option>
                                    <option value="1"<?php if ($status == 1) { echo ' selected'; } ?>><?php echo _('WARNING'); ?></option>
                                    <option value="2"<?php if ($status == 2) { echo ' selected'; } ?>><?php echo _('CRITICAL'); ?></option>
                                    <option value="3"<?php if ($status == 3) { echo ' selected'; } ?>><?php echo _('UNKNOWN'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="tw-flex tw-justify-end tw-mt-4">
                            <button type="submit" class="ui-btn ui-btn-default">
                                <div class="tw-flex tw-items-center tw-justify-center">
                                    <?php echo _('Submit'); ?>
                                </div>
                            </button>
                        </div>
                    </ui-sheet-content>
                    <?php echo form_close(); ?>
                </ui-sheet>
                <button id="trim-alert-history" class="ui-btn ui-btn-outlined">
                    <div class="tw-flex tw-items-center tw-justify-center tw-gap-2">
                        <i class="material-symbols-outlined">content_cut</i> 
                        <?php echo _('Trim Alert History'); ?>
                    </div>
                </button>
            </div>
        </div>
        <div class="form-spacer"></div>
        <div class="tw-flex tw-justify-between tw-my-4 tw-items-center">
            <?php
            if (!empty($record_total)) {
                echo '<span class="form-subheader">' . _('Page') . ' ' . $page . ' of ' . $total_pages . ' &nbsp;&middot;&nbsp; ';
                if (!empty($limiting)) {
                    echo $limiting . ' (' .  number_format($record_total) .  ' ' . _('total records') . ')';
                } else {
                    echo number_format($record_total) .  ' ' . _('records');
                }
                echo '</span>';
            } else {
                echo '<span class="form-subheader">0 ' . _(' records') . '</span>';
            }
            ?>
            <div class="ui-pagination">
                <?php echo $pagination; ?>
            </div>
        </div>

        <table class="ui-table">
            <thead class="ui-thead">
                <tr class="ui-tr">
                    <th class="ui-th"><?php echo _('Alert Name'); ?></th>
                    <th class="ui-th"><?php echo _('Run Time'); ?></th>
                    <th class="ui-th"><?php echo _('Status'); ?></th>
                    <th class="ui-th"><?php echo _('Alert Output'); ?></th>
                    <th class="ui-th"><?php echo _('Interval'); ?></th>
                    <th class="ui-th"><?php echo _('Lookback'); ?></th>
                    <th class="ui-th"><?php echo _('Warning'); ?></th>
                    <th class="ui-th"><?php echo _('Critical'); ?></th>
                    <th class="ui-th"></th>
                 </tr>
            </thead>
            <tbody class="ui-tbody" id="alert-list">
                <?php
                if (!empty($halerts)) {
                    foreach ($halerts as $alert) {
                        $status = get_alert_status($alert['status']);
                ?>
                <tr class="ui-tr">
                    <td class="ui-td"><?php echo html_escape($alert['name']); ?></td>
                    <td class="ui-td"><?php echo date('r', $alert['ran']); ?></td>
                    <td class="ui-td">
                        <div class="badge badge-<?php echo $status; ?>"><?php echo $status; ?></div>
                    </td>
                    <td class="ui-td">
                        <td-overflow class="tw-max-w-[500px]">
                            <td-overflow-content class="tw-font-geist-mono geist-mono">
                                <?php echo $alert['output']; ?>
                            </td-overflow-content>
                        </td-overflow>
                    </td>
                    <td class="ui-td"><?php echo $alert['check_interval']; ?></td>
                    <td class="ui-td"><?php echo $alert['lookback_period']; ?></td>
                    <td class="ui-td"><?php echo $alert['warning']; ?></td>
                    <td class="ui-td"><?php echo $alert['critical']; ?></td>
                    <td class="ui-td actions">
                    <?php if (!array_key_exists('alert_type', $alert) || $alert['alert_type'] === 'query') { ?>
                        <dropdown-menu data-position="bottom">
                            <dropdown-trigger>
                                <div class="material-symbols-outlined ui-icon-btn">more_horiz</div>
                            </dropdown-trigger>
                            <dropdown-content class="ui-dropdown-content">
                                <a data-placement="left" data-id="<?php echo $alert['id']; ?>" target="_new" class="show-query">
                                    <dropdown-item class="ui-dropdown-item">
                                        <?php echo _("Show query"); ?>
                                    </dropdown-item>
                                </a>
                                <a href="<?php echo site_url('alerts/history/show/'.$alert['id']); ?>" data-placement="left" target="_new">
                                    <dropdown-item class="ui-dropdown-item">
                                        <?php echo _("Show results"); ?>
                                    </dropdown-item>
                                </a>
                                <a href="<?php echo site_url('alerts/history/export/'.$alert['id']); ?>" data-placement="left" target="_new">
                                    <dropdown-item class="ui-dropdown-item">
                                        <?php echo _("Download as CSV"); ?>
                                    </dropdown-item>
                                </a>
                            </dropdown-content>
                        </dropdown-menu>
                    <?php } else { ?>
                        <tooltip-provider class="tw-flex tw-items-center">
                            <tooltip data-position="top" data-delay="100">
                                <tooltip-trigger class="tw-flex tw-items-center">
                                    <i class="material-symbols-outlined">help</i>
                                </tooltip-trigger>
                                <tooltip-content>
                                <div><?php echo _('Actions are only available for query-based alerts.'); ?></div>
                            </tooltip-content>
                            </tooltip>
                        </tooltip-provider>
                    <?php } ?>
                    </td>
                </tr>
                <?php
                    } 
                } else {
                ?>
                <tr class="ui-tr">
                    <td class="ui-td" colspan="9"><?php echo _("No alerts found."); ?></td>
                </tr>
                <?php } ?>
            </tbody>
        </table>

        <div>
            <?php
            $url = (!empty($_SERVER['QUERY_STRING'])) ? 'alerts/history?' . $_SERVER['QUERY_STRING'] : 'alerts/history';
            echo form_open($url, array('class' => 'pp-form'));
            ?>
            <input type="hidden" name="pp" class="pp" value="<?php echo $page_size; ?>">
            <?php echo form_close(); ?>
            <div class="tw-flex tw-justify-between tw-my-4 tw-items-center">
                <div class="tw-flex tw-gap-2">
                    <div class="tw-w-fit">
                        <div class="ui-input-group">
                            <div><?php echo _('Results per page'); ?></div>
                            <select class="ui-select results-per-page">
                                <option value="10"<?php if ($page_size == 10) { echo ' selected'; } ?>>10</option>
                                <option value="25"<?php if ($page_size == 25) { echo ' selected'; } ?>>25</option>
                                <option value="50"<?php if ($page_size == 50) { echo ' selected'; } ?>>50</option>
                                <option value="100"<?php if ($page_size == 100) { echo ' selected'; } ?>>100</option>
                                <option value="c"><?php echo _("Custom"); ?></option>
                                <?php if (!in_array($page_size, array(10, 25, 50, 100))) { echo '<option value="' . $page_size . '" selected>' . _('Custom') . ' - ' . $page_size . '</option>'; } ?>
                            </select>
                        </div>
                    </div>
                    <div class="custom-box hide">
                        <label class="tw-flex tw-gap-2">
                            <input type="text" size="4" class="ui-input custom tw-font-normal" placeholder="#" value="">
                            <button type="button" class="ui-btn ui-btn-outlined save-custom"><?php echo _("Save"); ?></button>
                        </label>
                    </div>
                </div>
                <div class="ui-pagination">
                    <?php echo $pagination; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Show a query -->
<div class="modal hide fade" id="show-query" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="form-header"><?php echo _("Showing Query"); ?></div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
            <div class="modal-body">
                <pre id="query"></pre>
            </div>
            <div class="modal-footer">
                <a href="#" class="ui-btn ui-btn-outlined" data-dismiss="modal"><?php echo _("Close"); ?></a>
            </div>
        </div>
    </div>
</div>

<?php echo $footer; ?>