<?php echo $header; ?>

<div class="configure-layout">

    <?php echo $leftbar; ?>

    <div class="form-container">

        <div id="messages">
            <?php if (!empty($success)) { ?>
            <div class="alert alert-success">
                <?php echo $success; ?>
                <button type="button" class="close material-symbols-outlined" data-dismiss="alert">close</button>
            </div>
            <?php } ?>
        </div>

        <div class="form-title"><?php echo _("Email Templates"); ?></div>
        <div class="form-spacer"></div>
        <div class="tw-flex tw-justify-between tw-items-center tw-my-6">
            <div class="tw-flex tw-gap-2">
                <button class="ui-btn ui-btn-outlined" id="add-template" <?php if (!user_has_permission('alerts', array('all')) ) { echo 'disabled'; } ?>>
                    <div class="tw-flex tw-items-center tw-justify-center tw-gap-2">
                        <i class="material-symbols-outlined">add</i>
                        <?php echo _("Add Template"); ?>
                    </div>
                </button>
                <button class="ui-btn ui-btn-secondary" id="view-macros" <?php if (!user_has_permission('alerts', array('all')) ) { echo 'disabled'; } ?>>
                    <?php echo _("View Macros"); ?>
                </button>
            </div>
            <div class="tw-flex tw-items-center tw-gap-2">
                <?php echo _('Default:'); ?>
                <tooltip-provider>
                    <tooltip data-position="top" data-delay="100">
                        <tooltip-trigger>
                            <a class="ui-btn ui-btn-outlined" id="view-default"><?php echo $default_template; ?></a>
                        </tooltip-trigger>
                        <tooltip-content>
                        <div><?php echo _('The default template will be used when an alert is set to use \'default template\' or if the alerts was never given a template.'); ?></div>
                    </tooltip-content>
                    </tooltip>
                </tooltip-provider>
            <?php if (user_has_permission('alerts', array('all')) ) { ?>
                <tooltip-provider>
                    <tooltip data-position="top" data-delay="100">
                        <tooltip-trigger>
                            <a class="tw-leading-none" id="change-default"><i class="material-symbols-outlined tw-text-foreground tw-rounded-md tw-p-1 hover:tw-bg-secondary">edit</i></a>
                        </tooltip-trigger>
                        <tooltip-content>
                        <div><?php echo _("Set default template."); ?></div>
                    </tooltip-content>
                    </tooltip>
                </tooltip-provider>
            <?php } ?>
            </div>
        </div>
        <div>
            <table class="ui-table">
                <thead class="ui-thead">
                    <tr class="ui-tr">
                        <th class="ui-th"><?php echo _("Template Name"); ?></th>
                        <th class="ui-th"><?php echo _("Last modified"); ?></th>
                        <th class="ui-th"><?php echo _("Last modified by"); ?></th>
                        <th class="ui-th"><?php echo _("Created by"); ?></th>
                        <th class="ui-th"></th>
                    </tr>
                </thead>
                <tbody class="ui-tbody" id="template-list">
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Manage a email template -->
<div class="modal hide fade" data-backdrop="static" id="manage-template" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="form-header"><span class="template-action-type"><?php echo _("Add"); ?></span> <?php echo _("Email Template"); ?></div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
            <div class="modal-body">
                <?php if (is_demo_mode()) { ?>
                <div class="alert alert-error">
                    <?php echo _("This function is not available in demo mode."); ?>
                </div>
                <?php } ?>
                <div class="form-subheader tw-mb-4"><?php echo _("Manage email templates for alerts. You can use the macros below inside the email message and they will be populated before the message is sent."); ?></div>
                <div id="manage-template-alerts"></div>
                <div class="tw-flex tw-flex-col tw-gap-2 tw-w-full">
                    <div>
                        <input class="ui-input" type="text" value="" id="tpl-name" <?php if (!user_has_permission('alerts', array('all')) ) { echo 'disabled'; } ?> placeholder="<?php echo _('Template name'); ?>">
                    </div>
                    <div>
                        <input class="ui-input" type="text" value="" id="tpl-subject" <?php if (!user_has_permission('alerts', array('all')) ) { echo 'disabled'; } ?> placeholder="<?php echo _('Subject'); ?>">
                    </div>
                    <div>
                        <textarea class="tw-w-full tw-h-72" id="tpl-body" <?php if (!user_has_permission('alerts', array('all')) ) { echo 'disabled'; } ?> placeholder="<?php echo _('Message body'); ?>"></textarea>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="tw-flex tw-justify-between tw-items-center">
                    <div class="tw-flex tw-gap-2">
                    <?php if (user_has_permission('alerts', array('all'))) { ?>
                        <dropdown-menu data-position="bottom">
                            <dropdown-trigger>
                                <button class="ui-btn ui-btn-default"><?php echo _("Load"); ?></button>
                            </dropdown-trigger>
                            <dropdown-content class="ui-dropdown-content">
                                <a class="tpl-load-default">
                                    <dropdown-item class="ui-dropdown-item">
                                        <?php echo _('System Default'); ?>
                                    </dropdown-item>
                                </a>
                                <a class="tpl-load-current-default">
                                    <dropdown-item class="ui-dropdown-item">
                                        <?php echo _('Current Default'); ?>
                                    </dropdown-item>
                                </a>
                            </dropdown-content>
                        </dropdown-menu>
                    <?php } ?>
                        <button type="button" id="clear" class="ui-btn ui-btn-outlined"><?php echo _('Clear'); ?></button>
                    </div>
                    <div class="tw-flex tw-gap-2">
                        <button class="ui-btn ui-btn-default template-action-type" id="manage-template-button" <?php if (!user_has_permission('alerts', array('all')) || is_demo_mode()) { echo 'disabled'; } ?>><?php echo _("Add"); ?></button>
                        <a href="#" class="ui-btn ui-btn-outlined" data-dismiss="modal"><?php echo _("Cancel"); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- View default email template -->
<div class="modal hide fade" id="view-default-modal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="form-header"><?php echo _("Default Email Template"); ?></div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
            <div class="modal-body">
                <div class="form-subheader tw-mb-2"><?php echo _("The template used for alerts with no template and alerts set to use default."); ?></div>
                <div class="tw-text-foreground tw-text-md tw-font-medium tw-mb-2"><?php echo $default_template; ?></div>
                <div class="tw-flex tw-flex-col tw-gap-2 tw-w-full">
                    <div>
                        <input class="ui-input" type="text" value="<?php echo $default_template_subject; ?>" placeholder="<?php echo _('Subject'); ?>" disabled readonly>
                    </div>
                    <div>
                        <textarea class="tw-w-full tw-h-72" disabled readonly><?php echo $default_template_body; ?></textarea>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <a href="#" class="ui-btn ui-btn-outlined" data-dismiss="modal"><?php echo _("Close"); ?></a>
            </div>
        </div>
    </div>
</div>

<!-- Template macros -->
<div class="modal hide fade" id="view-macros-modal" tabindex="-1" role="dialog">
    <div class="modal-dialog tw-w-[80%] tw-mt-10" role="document" style="top:0px">
        <div class="modal-content">
            <div class="modal-header">
                <div class="form-header"><?php echo _("Email Template Macros"); ?></div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
            <div class="modal-body">
                <div class="form-subheader tw-mb-2"><?php echo _("The following macros will be interpreted before sending emails. If a macro is used for an alert with an unsupported type, it may be filled with irrelevant information."); ?></div>
                <div class="form-spacer"></div>
                <div class="tw-flex tw-gap-4">
                    <table class="ui-table">
                        <thead class="ui-thead">
                            <tr class="ui-tr">
                                <th class="ui-th"><?php echo _('Macro Name'); ?></th>
                                <th class="ui-th"><?php echo _('Supported Types'); ?></th>
                                <th class="ui-th"><?php echo _('Description'); ?></th>
                            </tr>
                        </thead>
                        <tbody class="ui-tbody">
                            <tr class="ui-tr">
                                <td class="ui-td"><div class="tw-font-semibold">%time%</div></td>
                                <td class="ui-td"><?php echo _('Any'); ?></td>
                                <td class="ui-td"><?php echo _('The time the alert was sent'); ?></td>
                            </tr>
                            <tr class="ui-tr">
                                <td class="ui-td"><div class="tw-font-semibold">%alertname%</div></td>
                                <td class="ui-td"><?php echo _('Any'); ?></td>
                                <td class="ui-td"><?php echo _('The name of the alert that is sending a message'); ?></td>
                            </tr>
                            <tr class="ui-tr">
                                <td class="ui-td"><div class="tw-font-semibold">%count%</div></td>
                                <td class="ui-td"><?php echo _('Any'); ?></td>
                                <td class="ui-td"><?php echo _("The total number of events");?></td>
                            <tr class="ui-tr">
                                <td class="ui-td"><div class="tw-font-semibold">%state%</div></td>
                                <td class="ui-td"><?php echo _('Any'); ?></td>
                                <td class="ui-td"><?php echo _('The state of the alert, OK, WARNING, CRITICAL, UNKNOWN'); ?></td>
                            </tr>
                            <tr class="ui-tr">
                                <td class="ui-td"><div class="tw-font-semibold">%lookback%</div></td>
                                <td class="ui-td"><?php echo _('Query'); ?></td>
                                <td class="ui-td"><?php echo _('The alert lookback period (example: 5m)'); ?></td>
                            </tr>
                            <tr class="ui-tr">
                                <td class="ui-td"><div class="tw-font-semibold">%warning%</div></td>
                                <td class="ui-td"><?php echo _('Query, Host&nbsp;Freshness'); ?></td>
                                <td class="ui-td"><?php echo _('The warning threshold value'); ?></td>
                            </tr>
                            <tr class="ui-tr">
                                <td class="ui-td"><div class="tw-font-semibold">%critical%</div></td>
                                <td class="ui-td"><?php echo _('Query, Host&nbsp;Freshness'); ?></td>
                                <td class="ui-td"><?php echo _('The critical threshold value'); ?></td>
                            </tr>
                            <tr class="ui-tr">
                                <td class="ui-td"><div class="tw-font-semibold">%fields.[fieldname]%</div></td>
                                <td class="ui-td"><?php echo _('Query, Real&nbsp;Time'); ?></td>
                                <td class="ui-td"><?php echo _('The data in the specified [fieldname]'); ?><br><?php echo _('Example'); ?>:<br>%fields.message%<br><?php echo _('This will include the message from the last included log in the alert'); ?></td>
                            </tr>
                        </tbody>
                    </table>
                    <div class="tw-border-l tw-border-border"></div>
                    <div>
                        <div class="tw-text-foreground tw-mb-2 tw-font-medium"><?php echo _('Message Body Only'); ?></div>
                        <div class="form-subheader tw-mb-2"><?php echo _('These values can only be used in the body of the email, not the title.'); ?></div>
                        <table class="ui-table">
                            <thead class="ui-thead">
                                <tr class="ui-tr">
                                    <th class="ui-th"><?php echo _('Macro Name'); ?></th>
                                    <th class="ui-th"><?php echo _('Supported Types'); ?></th>
                                    <th class="ui-th"><?php echo _('Description'); ?></th>
                                </tr>
                            </thead>
                            <tbody class="ui-tbody">
                                <tr class="ui-tr">
                                    <td class="ui-td"><div class="tw-font-semibold">%output%</div></td>
                                    <td class="ui-td"><?php echo _('Any'); ?></td>
                                    <td class="ui-td"><?php echo _('The command line check output'); ?></td>
                                </tr>
                                <tr class="ui-tr">
                                    <td class="ui-td"><div class="tw-font-semibold">%url%</div></td>
                                    <td class="ui-td"><?php echo _('Query'); ?></td>
                                    <td class="ui-td"><?php echo _('The url that will show the data returned from the alert'); ?></td>
                                </tr>
                                <tr class="ui-tr">
                                    <td class="ui-td"><div class="tw-font-semibold">%uniquehosts%</div></td>
                                    <td class="ui-td"><?php echo _('Query'); ?></td>
                                    <td class="ui-td"><?php echo _('A newline separated list of unique hosts in the alert query.'); ?><br><?php echo _('Example'); ?>:<br>192.68.1.5 (28)<br>192.168.5.112 (1220)<br><?php echo _('The value inside the parentheses is the amount of matching logs for the alert time period for the hosts.'); ?></td>
                                </tr>
                                <tr class="ui-tr">
                                    <td class="ui-td"><div class="tw-font-semibold">%lastalertlog%</div></td>
                                    <td class="ui-td"><?php echo _('Query, Real&nbsp;Time'); ?></td>
                                    <td class="ui-td"><?php echo _('The last log from the alert query.'); ?><br><?php echo _('Can only use one of %lastalertlog% OR %last10alertlogs% per email.'); ?></td>
                                </tr>
                                <tr class="ui-tr">
                                    <td class="ui-td"><div class="tw-font-semibold">%last10alertlogs%</div></td>
                                    <td class="ui-td"><?php echo _('Query, Real&nbsp;Time'); ?></td>
                                    <td class="ui-td"><?php echo _('The last 10 logs from the alert query.'); ?><br><?php echo _('Can only use one of %lastalertlog% OR %last10alertlogs%s per email.'); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <a href="#" class="ui-btn ui-btn-outlined" data-dismiss="modal"><?php echo _("Close"); ?></a>
            </div>
        </div>
    </div>
</div>

<!-- Set default template -->
<div class="modal hide fade" id="change-default-modal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="form-header"><?php echo _("Set Default Template"); ?></div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><i class="material-symbols-outlined tw-text-foreground">close</i></button>
            </div>
            <div class="modal-body">
                <div class="form-subheader tw-mb-2"><?php echo _('Set the default email template that will be used for all alerts that do not have a template specified.'); ?></div>
                <div>
                    <label class="tw-block tw-text-sm tw-font-medium"><?php echo _('Template'); ?></label>
                    <select class="ui-select" id="tpl-select"></select>
                </div>
            </div>
            <div class="modal-footer">
                <button class="ui-btn ui-btn-default tw-mr-1" id="set-default-button"><?php echo _("Set Default"); ?></button>
                <a href="#" class="ui-btn ui-btn-outlined" data-dismiss="modal"><?php echo _("Cancel"); ?></a>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
var CURRENT_ACTION = 'add';
var CURRENT_EDIT_ID = '';

$(document).ready(function() {

    $('.ls-pop').popover();
    $('.dropdown-toggle').dropdown();

    load_templates();

    $('#view-default').click(function() {
        $('#view-default-modal').modal('show');
    });

    $('#view-macros').click(function() {
        $('#view-macros-modal').modal('show');
    });

    $('#change-default').click(function() {
        $.get('<?php echo site_url("api/check/get_templates"); ?>', { }, function(data) {
            $('#tpl-select').html('<option value="system"><?php echo _("System Default"); ?></option>');
            $(data).each(function(k, v) {
                $('#tpl-select').append('<option value="'+v._id+'">'+v._source.name+'</option>');
            });
            $('#change-default-modal').modal('show');
        });
    });

    $('#set-default-button').click(function() {
        $.post('<?php echo site_url("api/check/set_default_tpl"); ?>', { id: $('#tpl-select').val() }, function(d) {
            if (d.success) {
                window.location.reload();
            } else {
                // Error
            }
        }, 'json');
    });

    $('#add-template').click(function() {
        CURRENT_ACTION = "add";
        clear_template_modal('add');
        $('#manage-template').modal('show');
    });

    $('.tpl-load-default').click(function() {
        $.get('<?php echo site_url("api/check/get_default_tpl"); ?>', { force: 1 }, function(tpl) {
            $('#tpl-body').val(tpl.body);
            $('#tpl-subject').val(tpl.subject);
        });
    });

    $('#clear').click(function() {
        $('#tpl-body').val('');
        $('#tpl-subject').val('');
    });

    $('.tpl-load-current-default').click(function() {
        $.get('<?php echo site_url("api/check/get_default_tpl"); ?>', { }, function(tpl) {
            $('#tpl-body').val(tpl.body);
            $('#tpl-subject').val(tpl.subject);
        });
    });

    $('#manage-template-button').click(function() {
        if ($('#tpl-name').val() == '' || $('#tpl-subject').val() == '' || $('#tpl-body').val() == '') {
            // Display error
            $('#manage-template-alerts').html('<div class="alert alert-error"><?php echo _("You must fill out all the fields."); ?></div>');
            return;
        }

        var data = { name: $('#tpl-name').val(),
                     subject: $('#tpl-subject').val(),
                     body: $('#tpl-body').val() }

        // For editing only
        if (CURRENT_ACTION == "edit") {
            data['id'] = CURRENT_EDIT_ID;
        }
        data['action'] = CURRENT_ACTION;

        $.post('<?php echo site_url("api/check/template"); ?>', data, function(result) {
            if (result.status == "success") {
                $('#manage-template').modal('hide');
                load_templates();
                $('#messages').html('<div class="alert alert-success"><?php echo _("Successfully updated email template"); ?> <button type="button" class="close material-symbols-outlined" data-dismiss="alert">close</button></div>');
            } else {
                $('#manage-template-alerts').html('<div class="alert alert-error">'+result.msg+'</div>');
            }
        }, 'json');
    });

    $('#template-list').on('click', '.delete', function() {

        if (is_demo_mode) {
            alert("<?php echo _('This function is not available in demo mode.'); ?>");
            return;
        }

        var id = $(this).parents('td').data('id');
        $.post('<?php echo site_url("api/check/template"); ?>', { id: id, action: 'delete' }, function(result) {
            load_templates();
        });
    });

    $('#template-list').on('click', '.edit', function() {
        CURRENT_EDIT_ID = $(this).parents('td').data('id');
        CURRENT_ACTION = "edit";
        $.get('<?php echo site_url("api/check/get_templates"); ?>', { id: CURRENT_EDIT_ID }, function(tpl) {
            clear_template_modal('edit');
            $('#tpl-name').val(tpl._source.name);
            $('#tpl-subject').val(tpl._source.subject);
            $('#tpl-body').val(tpl._source.body);
            $('#manage-template').modal('show');
        });
    });

});

function load_templates()
{
    $.get('<?php echo site_url("api/check/get_templates"); ?>', { }, function(data) {
        html = '';
        if (data.length == 0) {
            html = '<tr class="ui-tr"><td class="ui-td" colspan="9"><?php echo _("No email templates have been created."); ?></td></tr>';
        } else {
            $.each(data, function(k, v) {
                var actions = `
                    <dropdown-menu data-position="bottom">
                        <dropdown-trigger>
                            <div class="material-symbols-outlined ui-icon-btn">more_horiz</div>
                        </dropdown-trigger>
                        <dropdown-content class="ui-dropdown-content">
                            <a class="edit">
                                <dropdown-item class="ui-dropdown-item">
                                    <?php echo _("Edit"); ?>
                                </dropdown-item>
                            </a>
                        <?php if (user_has_permission('alerts', array('all'))) { ?>
                            <a class="delete">
                                <dropdown-item class="ui-dropdown-item">
                                    <?php echo _("Remove"); ?>
                                </dropdown-item>
                            </a>
                        <?php } ?>
                        </dropdown-content>
                    </dropdown-menu>`;
                html += `
                    <tr class="ui-tr">
                        <td class="ui-td name">`+v._source.name+`</td>
                        <td class="ui-td">`+v._source.last_edit+`</td>
                        <td class="ui-td modified">`+v._source.modified_by+`</td>
                        <td class="ui-td created">`+v._source.created_by+`</td>
                        <td class="ui-td actions" data-id="`+v._id+`">`+actions+`</td>
                    </tr>`;
            });
        }
        $('#template-list').html(html);
    });
}

function clear_template_modal(type)
{
    $('#manage-template input').val('');
    $('#manage-template textarea').val('');
    $('#manage-template-alerts').html('');
    if (type == 'add') {
        $('.template-action-type').html('<?php echo _("Add"); ?>');
    } else {
        $('.template-action-type').html('<?php echo _("Save"); ?>');
        $('.btn.template-action-type').html('<?php echo _("Save"); ?>');
    }
}
</script>

<?php echo $footer; ?>