<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">

        <div class="doc-wrapper">

            <div class="tw-flex tw-items-end">
                <div class="source-logo">
                    <i class="fa fa-xl fa-fw fa-code"></i>
                </div>
                <h1><?php echo _('PHP'); ?></h1>
            </div>
            <div class="form-spacer"></div>

            <h3><?php echo _("Getting Started"); ?></h3>
            <p class="tw-pb-2.5"><?php echo _("If you run PHP applications on your server, you may want to get your PHP logs in Nagios Log Server as a central location for all errors that happen in your applications. You can easily do this through PHP, via sending PHP error logs to syslog. This guide will give examples of how to set up PHP to send to Log Server using syslog."); ?></p>

            <h3><?php echo _("Requirements"); ?></h3>
            <p><?php echo _("First, we will be using the PHP configuration file on the server you want to send log data from to perform the setup sections below. Depending on the version of PHP that is installed on your server, the"); ?> <code>php.ini</code> <?php echo _("file that needs to be edited may be in a different location than default. To find the php configuration file on your server run this command:"); ?></p>
            <div class="code-tooltip">
                <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                <pre><code class="shell" tabindex="1">php --ini</code></pre>
            </div>
            <p><?php echo _("You should see output similar to the following:"); ?></p>
            <div class="code-tooltip">
                <pre><code class="shell">Configuration File (php.ini) Path: /etc
Loaded Configuration File:         /etc/php.ini
Scan for additional .ini files in: /etc/php.d
Additional .ini files parsed:      /etc/php.d/curl.ini,
/etc/php.d/fileinfo.ini,
/etc/php.d/json.ini,
/etc/php.d/phar.ini,
/etc/php.d/zip.ini</code></pre>
            </div>
            <p><?php echo _("We are looking for the"); ?> <b><?php echo _("Loaded Configuration File"); ?></b> <?php echo _("line that shows the configuration file path that is being used by PHP. This is the file that we will use for the setup sections below."); ?></p>

            <h3><?php echo _("Configuration Setup"); ?></h3>
            <ui-tabs default-value="script">
                <tabs-list>
                    <tabs-trigger value="script"><?php echo _("Automatic"); ?></tabs-trigger>
                    <tabs-trigger value="log"><?php echo _("Automatic (log file)"); ?></tabs-trigger>
                    <tabs-trigger value="manual"><?php echo _("Manual (log file)"); ?></tabs-trigger>
                </tabs-list>

                <tabs-content value="script">
                    <div class="alert alert-info tw-flex tw-items-center tw-my-5 tw-mx-0">
                        <span class="material-symbols-outlined tw-mr-2">error</span>
                        <p><?php echo _("This section requires you to have already set up syslog by going through the"); ?> <a class="tw-text-primary hover:tw-text-primary" href="<?php echo site_url('source/linux'); ?>"><?php echo _("Linux source setup"); ?></a> <?php echo _("guide, since PHP will be sending to syslog directly"); ?>.</p>
                    </div>
                    <h6><?php echo _("Automatic Script - Supported Operating Systems"); ?></h6>
                    <div>
                        <ul class="tw-mb-2.5 tw-ml-7">
                            <li><?php echo _('CentOS, Fedora, and RHEL'); ?></li>
                            <li><?php echo _('Ubuntu and Debian'); ?></li>
                        </ul>
                    </div>
                    <p><i><?php echo _('You must have rsyslog installed. If your operating system is not listed, you can manually configure syslog.'); ?></i></p>
                    <h6><?php echo _("Add Syslog Output to PHP Configuration"); ?></h6>
                    <p><?php echo _("To configure your syslog daemon to send PHP log files to Nagios Log Server we will need to edit the php.ini file so that it sends PHP logs through syslog."); ?></p>
                    <div class="code-tooltip">
                        <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                        <pre><code class="shell" tabindex="2">vi /etc/php.ini</code></pre>
                    </div>
                    <p><?php echo _("Find the line that has the <code>;error_log = syslog</code> which will be commented out. Uncomment this line to so that php logs are sent through syslog. Your PHP config should look similar to:"); ?></p>
                    <div class="code-tooltip">
                        <pre><code class="config">; Log errors to specified file. PHP's default behavior is to leave this value
; empty.
; http://www.php.net/manual/en/errorfunc.configuration.php#ini.error-log
; Example:
;error_log = php_errors.log
; Log errors to syslog (Event Log on NT, not valid in Windows 95).
error_log = syslog
</code></pre>
                    </div>
                </tabs-content>

                <tabs-content value="log" class="tw-pt-2.5">
                    <h6><?php echo _("Automatic Script - Supported Operating Systems"); ?></h6>
                    <div>
                        <ul class="tw-mb-2.5 tw-ml-7">
                            <li><?php echo _('CentOS, Fedora, and RHEL'); ?></li>
                            <li><?php echo _('Ubuntu and Debian'); ?></li>
                        </ul>
                    </div>
                    <p><i><?php echo _('You must have rsyslog installed. If your operating system is not listed, you can manually configure syslog.'); ?></i></p>
                    <h6><?php echo _("Add Log File Output to PHP Configuration"); ?></h6>
                    <p><?php echo _("First, make a file called <code>php_errors.log</code> in <code>/var/log</code> for PHP to start logging errors to."); ?></p>
                    <div class="code-tooltip">
                        <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                        <pre><code class="shell" tabindex="3">touch /var/log/php_errors.log</code></pre>
                    </div>
                    <p><?php echo _("Next, edit the <code>php.ini</code> file so that it sends PHP logs to the new log file: "); ?></p>
                    <div class="code-tooltip">
                        <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                        <pre><code class="shell" tabindex="4">vi /etc/php.ini</code></pre>
                    </div>
                    <p><?php echo _("Find the line that has"); ?> <code>;error_log = syslog</code> <?php echo _("commented out. Replace this with the full path to the file created above.  Make sure to use the absolute path when editing the <code>php.ini</code> file. After editing, the config should look similar to:"); ?></p>
                    <div class="code-tooltip">
                        <pre><code class="config">; Log errors to specified file. PHP's default behavior is to leave this value
; empty.
; http://www.php.net/manual/en/errorfunc.configuration.php#ini.error-log
; Example:
;error_log = php_errors.log
; Log errors to syslog (Event Log on NT, not valid in Windows 95).
error_log = /var/log/php_errors.log
</code></pre>
                    </div>
                    <p><?php echo _("Now that there is a new independant log file and PHP is configured to send logs to the file, use the"); ?> <a class="tw-text-primary hover:tw-text-primary" href="<?php echo site_url('source/linux'); ?>"><?php echo _("Linux source setup"); ?></a> <?php echo _("script to send the new log file to Log Server using syslog."); ?></p>
                    <div class="code-tooltip">
                        <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                        <pre><code class="shell" tabindex="5"><?php echo $step1; ?></code></pre>
                    </div>
                </tabs-content>

                <tabs-content value="manual" class="tw-pt-2.5">
                    <h6><?php echo _("Add Log File Output to PHP Configuration"); ?></h6>
                    <p><?php echo _("First, make a file called <code>php_errors.log</code> in <code>/var/log</code> for PHP to start logging errors to."); ?></p>
                    <div class="code-tooltip">
                        <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                        <pre><code class="shell" tabindex="6">touch /var/log/php_errors.log</code></pre>
                    </div>
                    <p><?php echo _("Next, edit the <code>php.ini</code> file so that it sends PHP logs to the new log file: "); ?></p>
                    <div class="code-tooltip">
                        <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                        <pre><code class="shell" tabindex="7">vi /etc/php.ini</code></pre>
                    </div>
                    <p><?php echo _("Find the line that has"); ?> <code>;error_log = syslog</code> <?php echo _("commented out. Replace this with the full path to the file created above.  Make sure to use the absolute path when editing the <code>php.ini</code> file. After editing, the config should look similar to:"); ?></p>
                    <div class="code-tooltip">
                        <pre><code class="config">; Log errors to specified file. PHP's default behavior is to leave this value
; empty.
; http://www.php.net/manual/en/errorfunc.configuration.php#ini.error-log
; Example:
;error_log = php_errors.log
; Log errors to syslog (Event Log on NT, not valid in Windows 95).
error_log = /var/log/php_errors.log
</code></pre>
                    </div>
                    <h6><?php echo _("Add Log File to Syslog"); ?></h6>
                    <p><?php echo _("Run the following to verify the rsyslog spool directory and that the rsyslog.d folder exists. The second line will give you the path you will need to add in the next section for <b>\$WorkDirectory</b> in the configuration. Then it will open the <code>rsyslog.conf</code> file."); ?></p>
                    <div class="code-tooltip">
                        <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                        <pre><code class="shell" tabindex="8"><?php echo $step2; ?></code></pre>
                    </div>
                    <p><?php echo _("Add the following to the configuration file. Look for the 'begin forwarding rule.'"); ?></p>
                    <div class="code-tooltip">
                        <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                        <pre><code class="apache" tabindex="9"><?php echo $step3; ?></code></pre>
                    </div>
                    <p><?php echo _("You will need to replace "); ?><b>$WorkDirectory</b><?php echo _(" with the unique file path of the rsyslog spool directory.  This was displayed from the command on line 2 of the previous codeblock.  If this isn't set correctly the rsyslog service will error on restart."); ?></p>
                    <p><?php echo _("Example:  \$WorkDirectory /var/lib/rsyslog"); ?></p>
                    <p><?php echo _("Restart the syslog-ng service"); ?></p>
                    <div class="code-tooltip">
                        <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                        <pre><code class="shell" tabindex="10">sudo /etc/init.d/rsyslog restart</code></pre>
                    </div>
                </tabs-content>
            </ui-tabs>

            <h3><?php echo _("Verify Incoming Logs"); ?></h3>
            <p><?php echo _("Once you have configured the log sender, you should start receiving logs right away. Put in the sender's IP address to see if you are receiving logs from that IP."); ?></p>
            <div class="form-inline">
                <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
                    <label class="tw-block tw-text-sm tw-font-medium"><?php echo _("IP Address"); ?></label>
                    <div class="tw-flex tw-w-1/3">
                        <input class="ui-input" name="sender_ip" type="text">
                        <button id="verify" class="ui-btn ui-btn-default tw-ml-3"><?php echo _("Verify"); ?></button>
                        <span id="verify-loading" class="hide"><i class="spinner"></i></span>
                    </div>
                </div>
            </div>
            <div class="verify">
                <div class="well hide verify-logs" id="verify-output"></div>
            </div>
        </div>
    
    </div>
</div>

<?php echo $footer; ?>