<?php echo $header; 
$apikey = '*api-key*';
if ($user['apiaccess']) {
    $apikey = $user['apikey'];
}
$username = $user['username'];
$default_dashboard = isset($user['default_dashboard']) ? $user['default_dashboard'] : '';

function build_curl_call($action, $api_root, $endpoint, $apikey, $query='') {
    if (!empty($query)) {
        $query = "-d '" . json_encode($query, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES) . "'";
    }
    ?>
    <div class="code-tooltip">
        <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
        <pre><div class="tw-w-[95%] tw-p-2"><code class="shell">curl -X<?php echo $action. ' "'. $api_root . $endpoint . '&token=' . $apikey . '" ' . $query;?></code></div></pre>
    </div>
    <?php 
} 

function build_api_return($object) {
    ?>
    <div class="code-tooltip">
        <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
        <pre><code class="json"><?php echo json_encode($object, JSON_PRETTY_PRINT); ?></code></pre>
    </div>
    <?php
}
?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">
        <h1 class="form-title"><?php echo _('API Reference'); ?></h1>
        <p class="form-subtitle"><?php echo _('Use this help section to learn how to operate the Nagios Log Server API, which can be used to access the OpenSearch backend or to gather general information about the Log Server system.'); ?></p>
        <div class="form-spacer"></div>

        <div class="tw-container-fluid">
            <div class="tw-flex tw-flex-col md:tw-flex-row tw-gap-6">
                <div class="tw-w-full md:tw-w-2/3">
                    <h4 class="tw-text-lg tw-font-semibold tw-mb-4"><?php echo _('Getting Started'); ?></h4>
                    <p class="tw-mb-4"><?php echo _('To start using the Log Server API, you will first need your API key. If you have one, you can access it to the right of this text, or by clicking on your profile in the upper right corner of the screen. You will also see your access level. If you aren\'t an administrator, you will have read-only access to the API, meaning that you will not be able to add Alerts through that API endpoint. However, you will still have full access to the Backend API.'); ?></p>
                    <p class="tw-mb-4"><?php echo _("Currently, the API accepts arguments through HTTP GET/POST and returns a JSON object. You can do this through a browser, through cURL (as used in this guide), or via almost any other HTTP client. The root of the API is at:");?></p>
                    <p class="tw-mb-4"><code><?php echo $api_root;?></code></p>
                    <p class="tw-mb-4"><?php echo _("This URL will always return HTTP code 404. For your first API call, try using this example, which will give you the state history of your alerts");?></p>
                    <?php echo build_curl_call("GET", $api_root, '/backend/nagioslogserver_history_alert/_search?pretty=true&q=*:*', $apikey); ?>

                    <h4 class="tw-text-lg tw-font-semibold tw-mt-8 tw-mb-4"><?php echo _('Backend API');?></h4>
                    <p class="tw-mb-4"><?php echo _('The backend API is a pass-through layer to give you access to the OpenSearch index API, with some restrictions. Log Server API users are not able to access the \'nagioslogserver\' or \'nagioslogserver_log\' indices, since these contain sensitive data. However, you will have access to the logstash, kibana, and alert history indices. If you want to track queries made with this API, go to Admin->General->Global Settings, and set \'Log User Queries\' to \'Yes\'.');?></p>
                </div>
                <div class="tw-w-full md:tw-w-1/3">
                    <div class="tw-bg-secondary tw-rounded-lg tw-p-6 tw-border">
                        <h3 class="tw-text-xl tw-font-semibold tw-mb-4"><?php echo _('API Access / Key'); ?></h3>
                        <p class="tw-mb-4"><?php echo _('Your unique API key used for external API access. You can read more about what you can do with the API in the API documents in the help section.'); ?></p>
                        <?php if ($user['apiaccess']) { ?>
                        <p class="tw-mb-2"><strong><?php echo _('Access Level'); ?>:</strong> <?php if ($is_admin) { echo _('Full'); } else { echo _('Read-Only'); } ?></p>
                        <div class="tw-mb-4">
                            <input type="text" value="<?php echo $user['apikey']; ?>" class="ui-input no-highlight tw-w-full" style="cursor: pointer;" id="apikey" maxlength="32" readonly>
                        </div>
                        <div>
                            <?php echo form_open('profile/newkey'); ?>
                            <input type="hidden" value="<?php echo $user['id']; ?>" name="user_id_verify" />
                            <input type="hidden" value="1" name="help" />
                            <button type="submit" class="ui-btn ui-btn-default"><span class="material-symbols-outlined tw-mr-2">refresh</span><?php echo _('Generate New Key'); ?></button>
                            <?php echo form_close(); ?>
                        </div>
                        <?php } else { ?>
                        <p class="tw-font-semibold"><?php echo _('No API Access'); ?></p>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <div class="tw-mt-8">
                <?php if ($is_admin) { ?>
                <ui-tabs default-value="alert-history">
                    <tabs-list>
                        <tabs-trigger value="alert-history"><span class="material-symbols-outlined tw-mr-2">history</span><?php echo _('Reading and Querying (Alert History)'); ?></tabs-trigger>
                        <tabs-trigger value="dashboards"><span class="material-symbols-outlined tw-mr-2">dashboard</span><?php echo _('Modifying Existing Records (Dashboards)'); ?></tabs-trigger>
                        <tabs-trigger value="log-records"><span class="material-symbols-outlined tw-mr-2">note_add</span><?php echo _('Creating and Deleting Records (Logstash)'); ?></tabs-trigger>
                    </tabs-list>
                    <tabs-content value="alert-history">
                        <div class="tw-mt-6">
                            <h6 class="tw-text-lg tw-font-semibold tw-mb-4"><?php echo _("Alert History");?></h6>
                            <p class="tw-mb-4"><?php echo _('The alert history for Nagios Log Server is stored in the index \'nagioslogserver_history_alert\'. As shown above, search queries should use lucene syntax, and wildcards for both tag and value can be used to return all records. Now, let\'s retrieve the alert history for one specific alert. Choose one of the names that appeared in the previous API call. For this example, we\'ll use the name \'new_alert\'. Retrieving the history for this one alert is as simple as ');?></p>
                            <?php echo build_curl_call('GET', $api_root, '/backend/nagioslogserver_history_alert/_search?pretty=true&q=name:new_alert', $apikey); ?>
                            <p class="tw-mt-4 tw-mb-4"><?php echo _("On a successful API call, your output should look like this:");?></p>
                            <?php
                                $ex_result = array(
                                    'took' => 1,
                                    "timed_out" => false,
                                    "_shards" => array(
                                        "total" => 1,
                                        "successful" => 1,
                                        "failed" => 0
                                    ),
                                    "hits" => array(
                                        "total" => 4,
                                        "max_score" => 6.5687685,
                                        "hits" => array(
                                            array(
                                                "_index" => "nagioslogserver_history_alert",
                                                "_id" => "AWZ-U1MqYSpUrRev2Wfm",
                                                "_score" => 6.5687685,
                                                "_source" => array(
                                                    "alert_id" => "AWZ-UzLzYSpUrRev2Wfg",
                                                    "name" => "new_alert",
                                                    "check_interval" => "5m",
                                                    "lookback_period" => "5m",
                                                    "warning" => ": 1",
                                                    "critical" => ": 1",
                                                    "start" => 1539717381,
                                                    "end" => 1539717681,
                                                    "query" => "{\"query\": {\"filtered\": {\"query\": {\"bool\": {\"should\": [{\"query_string\": {\"query\": \"*\"}}]}},\"filter\": {\"bool\": {\"must\": [{\"range\": {\"@timestamp\": {\"from\": 1539717381000,\"to\": 1539717681000}}},{\"fquery\": {\"query\": {\"query_string\": {\"query\": \"type:  (\\\"apache_access\\\")\"}},\"_cache\": true}},{\"fquery\": {\"query\": {\"query_string\": {\"query\": \"response:  (404)\"}},\"_cache\": true}}]}}}}}",
                                                    "indexes" => "logstash-2018.10.16",
                                                    "ran" => 1539717681,
                                                    "status" => 0,
                                                    "output" => "OK:  0 matching entries found |logs=0;: 1;: 1"
                                                )
                                            ),
                                            array(
                                                "_index" => "nagioslogserver_history_alert",
                                                "_id" => "AWZ-U40LYSpUrRev2Wfr",
                                                "_score" => 6.5687685,
                                                "_source" => array(
                                                    "alert_id" => "AWZ-UzLzYSpUrRev2Wfg",
                                                    "name" => "new_alert",
                                                    "check_interval" => "5m",
                                                    "lookback_period" => "5m",
                                                    "warning" => ": 1",
                                                    "critical" => ": 1",
                                                    "start" => 1539717396,
                                                    "end" => 1539717696,
                                                    "query" => "{\"query\": {\"filtered\": {\"query\": {\"bool\": {\"should\": [{\"query_string\": {\"query\": \"*\"}}]}},\"filter\": {\"bool\": {\"must\": [{\"range\": {\"@timestamp\": {\"from\": 1539717396000,\"to\": 1539717696000}}},{\"fquery\": {\"query\": {\"query_string\": {\"query\": \"type:  (\\\"apache_access\\\")\"}},\"_cache\": true}},{\"fquery\": {\"query\": {\"query_string\": {\"query\": \"response:  (404)\"}},\"_cache\": true}}]}}}}}",
                                                    "indexes" => "logstash-2018.10.16",
                                                    "ran" => 1539717696,
                                                    "status" => 0,
                                                    "output" => "OK:  0 matching entries found |logs=0;: 1;: 1"
                                                )
                                            ),
                                            array(
                                                "_index" => "nagioslogserver_history_alert",
                                                "_id" => "AWZ-U8_AYSpUrRev2Wfy",
                                                "_score" => 6.5687685,
                                                "_source" => array(
                                                    "alert_id" => "AWZ-UzLzYSpUrRev2Wfg",
                                                    "name" => "new_alert",
                                                    "check_interval" => "5m",
                                                    "lookback_period" => "5m",
                                                    "warning" => ": 1",
                                                    "critical" => ": 1",
                                                    "start" => 1539717413,
                                                    "end" => 1539717713,
                                                    "query" => "{\"query\": {\"filtered\": {\"query\": {\"bool\": {\"should\": [{\"query_string\": {\"query\": \"*\"}}]}},\"filter\": {\"bool\": {\"must\": [{\"range\": {\"@timestamp\": {\"from\": 1539717413000,\"to\": 1539717713000}}},{\"fquery\": {\"query\": {\"query_string\": {\"query\": \"type:  (\\\"apache_access\\\")\"}},\"_cache\": true}},{\"fquery\": {\"query\": {\"query_string\": {\"query\": \"response:  (404)\"}},\"_cache\": true}}]}}}}}",
                                                    "indexes" => "logstash-2018.10.16",
                                                    "ran" => 1539717713,
                                                    "status" => 0,
                                                    "output" => "OK:  0 matching entries found |logs=0;: 1;: 1"
                                                )
                                            ),
                                            array(

                                                "_index" => "nagioslogserver_history_alert",
                                                "_id" => "AWZ-dRyrYSpUrRev2WuO",
                                                "_score" => 1,
                                                "_source" => array(
                                                    "alert_id" => "AWZ-UzLzYSpUrRev2Wfg",
                                                    "name" => "new_alert",
                                                    "check_interval" => "5m",
                                                    "lookback_period" => "5m",
                                                    "warning" => ": 1",
                                                    "critical" => "1: ",
                                                    "start" => 1539719596,
                                                    "end" => 1539719896,
                                                    "query" => "{\"query\": {\"filtered\": {\"query\": {\"bool\": {\"should\": [{\"query_string\": {\"query\": \"*\"}}]}},\"filter\": {\"bool\": {\"must\": [{\"range\": {\"@timestamp\": {\"from\": 1539719596000,\"to\": 1539719896000}}},{\"fquery\": {\"query\": {\"query_string\": {\"query\": \"type:  (\\\"apache_access\\\")\"}},\"_cache\": true}},{\"fquery\": {\"query\": {\"query_string\": {\"query\": \"response:  (404)\"}},\"_cache\": true}}]}}}}}",
                                                    "indexes" => "logstash-2018.10.16",
                                                    "ran" => 1539719896,
                                                    "status" => 2,
                                                    "output" => "CRITICAL:  1 matching entries found |logs=0;: 1;:1 "
                                                )))));
                                echo build_api_return($ex_result); ?>
                            <p class="tw-mt-4 tw-mb-4"><?php echo _("As you can see, the returned object will give some meta-information about the request itself, and then the records that match your constraint. If your alert has been running for some time, you should see far more records than this.");?></p>

                            <p class="tw-mb-4"><?php echo _("This method works pretty well as long as you only have one constraint. However, once you want to introduce multiple constraints, most users will want to start using the OpenSearch filter DSL. By default, OpenSearch will try to return as many results as possible, sorting them by how well they match the query, and omitting only the records which match no part of the query. Filtered queries do away with this, allowing you to retrieve records as though you're using a SQL WHICH statement. The results from the previous API call can be achieved using this filter query:");?></p>
                            <?php 
                                $ex_query = array("query" => 
                                                array("bool" =>
                                                    array("must" =>
                                                        array(
                                                            array("term" => array("name" => "new_alert"))))));

                                echo build_curl_call('GET', $api_root, '/backend/nagioslogserver_history_alert/_search?pretty=true', $apikey, $ex_query);

                            ?>
                            <p class="tw-mb-4"><?php echo _('The \'bool\' term also helps to remove scoring features: the term is either satisfied or not. This will allow us to use additional constraints. In particular, \'must\' acts like SQL \'AND\', and \'should\' acts like SQL \'OR\'. These expressions can also be nested by placing additional \'bool\' terms inside of \'must\' or \'should\' terms. Now, let\'s only retrieve the events where a WARNING or CRITICAL status was recorded. These are recorded in the \'status\' tag as nagios exit codes, so we\'ll be looking for when the values are 1 or 2. In this case, the API call would be'); ?>
                            <?php 
                                $ex_query = array("query" => 
                                                array("bool" =>
                                                    array("must" =>
                                                        array(
                                                            array("bool" => 
                                                                array("should" =>
                                                                    array(
                                                                        array("term" => array("status" => 1)),
                                                                        array("term" => array("status" => 2))))),
                                                            array("term" => array("name" => "new_alert"))))));
                                echo build_curl_call('POST', $api_root, '/backend/nagioslogserver_history_alert/_search?pretty=true', $apikey, $ex_query);
                                ?>

                            <p class="tw-mt-4 tw-mb-4"><?php echo _("On a successful API call, you should see only the alerts which returned WARNING or CRITICAL. When run against the previous data set, the new API call returns this:");?>
                            <?php
                                $ex_result = array(
                                    'took' => 1,
                                    "timed_out" => false,
                                    "_shards" => array(
                                        "total" => 1,
                                        "successful" => 1,
                                        "failed" => 0
                                    ),
                                    "hits" => array(
                                        "total" => 1,
                                        "max_score" => 1,
                                        "hits" => array(
                                            array(
                                                "_index" => "nagioslogserver_history_alert",
                                                "_id" => "AWZ-dRyrYSpUrRev2WuO",
                                                "_score" => 1,
                                                "_source" => array(
                                                    "alert_id" => "AWZ-UzLzYSpUrRev2Wfg",
                                                    "name" => "new_alert",
                                                    "check_interval" => "5m",
                                                    "lookback_period" => "5m",
                                                    "warning" => ": 1",
                                                    "critical" => "1: ",
                                                    "start" => 1539719596,
                                                    "end" => 1539719896,
                                                    "query" => "{\"query\": {\"filtered\": {\"query\": {\"bool\": {\"should\": [{\"query_string\": {\"query\": \"*\"}}]}},\"filter\": {\"bool\": {\"must\": [{\"range\": {\"@timestamp\": {\"from\": 1539719596000,\"to\": 1539719896000}}},{\"fquery\": {\"query\": {\"query_string\": {\"query\": \"type:  (\\\"apache_access\\\")\"}},\"_cache\": true}},{\"fquery\": {\"query\": {\"query_string\": {\"query\": \"response:  (404)\"}},\"_cache\": true}}]}}}}}",
                                                    "indexes" => "logstash-2018.10.16",
                                                    "ran" => 1539719896,
                                                    "status" => 2,
                                                    "output" => "CRITICAL:  1 matching entries found |logs=0;: 1;:1 ")))));
                                echo build_api_return($ex_result);
                            ?>

                        </div>
                    </tabs-content>
                    <tabs-content value="dashboards">
                        <div class="tw-mt-6">
                            <h6 class="tw-text-lg tw-font-semibold tw-mb-4"><?php echo _("Dashboards");?></h6>
                            <p class="tw-mb-4"><?php echo _('OpenSearch access also gives you the ability to view and modify kibana dashboards. You can list all dashboards on the system with a call like');?></p>
                            <?php echo build_curl_call('GET', $api_root, '/backend/nagioslogserver_dashboards/_search?pretty=true&q=*:*', $apikey); ?>
                            <p class="tw-mb-4"><?php echo _("Similarly, you can retrieve data for only the dashboards that you own with the call"); ?></p>
                            <?php 
                                $ex_query = array("query" => 
                                                    array("bool" =>
                                                        array("must" =>
                                                            array(
                                                                array("term" => array("user" => $username))))));
                                echo build_curl_call('GET', $api_root, '/backend/nagioslogserver_dashboards/_search?pretty=true', $apikey, $ex_query);
                            ?>
                            <p class="tw-mb-4"><?php echo _("On a successful API call, this will return an object like");?></p>
                            <?php 
                                $ex_return = array(
                                    'took' => 37,
                                    'timed_out' => false,
                                    '_shards' => array(
                                        'total' => 1,
                                        'successful' => 1,
                                        'skipped' => 0,
                                        'failed' => 0),
                                    'hits' => array(
                                        'total' => array(
                                            'value' => 2,
                                            'relation' => 'eq'
                                        ),
                                        'max_score' => 1,
                                        'hits' => array(
                                            array(
                                                '_index' => 'nagioslogserver_dashboards',
                                                "_id" => "AWYxcT5pDGp9gjne7-qd",
                                                "_score" => 1,
                                                "_source"=> array(
                                                        "user" => "nagiosadmin",
                                                        "group" => "",
                                                        'title' => 'some_title',
                                                        'dashboard' => 'a very very long JSON-encoded string')
                                            ), array(
                                                "_index" => "nagioslogserver_dashboards",
                                                "_id" => "AWX44gygZElgdfehcyRP",
                                                "_score" => 1,
                                                "_source" => array(
                                                    "user" => "nagiosadmin",
                                                    "group" => "",
                                                    "title" => "My Default Dashboard",
                                                    "dashboard" => 'another very long JSON-encoded string')))));

                                echo build_api_return($ex_return);
                            ?>
                            <p class="tw-mb-4"><?php echo sprintf(_("Now, say a situation came up where the ownership of a dashboard had to be transferred. Normally, this would be done by exporting the dashboard from its respective save menu, then transferring the resulting .json file to the relevant team member, then importing the file back into the interface. Using the API, we can do this much more efficiently. %sAfter ensuring that the owning user's default dashboard is not set to the affected dashboard%s, we can call the API, using the record type and ID of the dashboard as follows"), '<b>','</b>'); ?></p>
                            <?php 
                                $ex_update = array("doc" => 
                                                array("user" => "$username"));
                                echo build_curl_call('POST', $api_root, '/backend/nagioslogserver_dashboards/' . basename($default_dashboard) . '/_update?pretty=true', $apikey, $ex_update);
                            ?>
                            <p class="tw-mb-4"><?php echo _('On a successful API call, you should get an object like this');?></p>
                            <?php 
                                $return = array(
                                    "_index" => "nagioslogserver_dashboards",
                                    "_id" => basename($default_dashboard),
                                    "_version" => 2
                                );
                                echo build_api_return($return);
                            ?>
                            <p class="tw-mb-4"><?php echo _("Note that the value for '_version' will increment every time you update this object. For this exact call, the update effectively does nothing, since we used the ID from your own default dashboard. However, you could change either the dashboard ID or the username to cause a call that would transfer dashboard ownership.");?></p>
                        </div>
                    </tabs-content>
                    <tabs-content value="log-records">
                        <div class="tw-mt-6">
                            <h6 class="tw-text-lg tw-font-semibold tw-mb-4"><?php echo _("Logstash Records"); ?></h6>
                            <p class="tw-mb-4"><?php echo _('Lastly, we can also access the records held by logstash. If you haven\'t changed any index settings, these will all be indices with the pattern \'logstash-YYYY.MM.DD\'. Otherwise, the pattern can be found per-dashboard by going to Configure Dashboard->Index.');?></p>
                            <p class="tw-mb-4"><?php echo _('Consider the situation where you\'ve configured a new logstash filter, but forgot to specify a different type for the processed data. However, after correcting the error, you noticed that the filter creates a property that doesn\'t occur in any other filters (as happens with \'errmsg\' in the default Apache filter). You may now want to correct the previously-collected data, which is now mismatched. While it would be possible to update each log entry, this is somewhat impractical for the current version of the API.'); ?></p>
                            <p class="tw-mb-4"><?php echo _("Instead, we can delete them using a filter. The Delete by Query action will remove any records on the index which match the given query. First, we should try to enumerate all of the objects we would delete (if this returns any hits for you, please do not run the remaining API queries).");?></p>
                            <?php
                                $ex_query = array(
                                    "query" => array(
                                        "bool" => array(
                                            "must" => array(
                                                array(
                                                    "exists" => array(
                                                        "field" => "errmsg"
                                                    )
                                                )
                                            ),
                                            "must_not" => array(
                                                array(
                                                    "term" => array(
                                                        "type" => "apache_error"
                                                    ))))));

                                echo build_curl_call('GET', $api_root, '/backend/logstash-' . date('Y') . '.' . date('m') . '.' . date('d') . '/_search?pretty=true', $apikey, $ex_query);
                            ?>
                            <p class="tw-mb-4"><?php echo _("The API call above would show any record with an 'errmsg' field that didn't have the type 'apache_error'. The call below will delete them."); ?></p>
                            <?php
                                $ex_delete = array(
                                    "query" => array(
                                        "bool" => array(
                                            "must" => array(
                                                array(
                                                    "exists" => array(
                                                        "field" => "errmsg"
                                                    )
                                                )
                                            ),
                                            "must_not" => array(
                                                array(
                                                    "term" => array(
                                                        "type" => "apache_error"
                                                    ))))));
                                echo build_curl_call('DELETE', $api_root, '/backend/logstash-' . date('Y') . '.' . date('m') . '.' . date('d') . '/_query?pretty=true', $apikey, $ex_delete);
                            ?>
                            <p class="tw-mb-4"><?php echo _("In this case, you should see an object similar to this:");?></p>
                            <?php 
                                $return = array(
                                    '_indices' => array(
                                        "logstash-" . date('Y') . '.' . date('m') . '.' . date('d') => array(
                                            '_shards' => array(
                                                'total' => 5,
                                                'successful' => 5,
                                                'failed' => 0
                                            )
                                        )
                                    )
                                );
                                echo build_api_return($return);
                            ?>
                            <p class="tw-mb-4"><?php echo _("Since the Apache Errors filter has been running correctly since you started the server, 'found' should be set to false.");?></p>
                            <p class="tw-mb-4"><?php echo _("For the sake of completeness, we'll also show how to add a record into OpenSearch. To add a record, you'll need to specify the index and type of the record in the URL, keeping the object itself as JSON data. We can add an example log record to logstash like this:");?></p>
                            <?php
                                $ex_query = array(
                                    "message" => "This is an example message",
                                    "host.ip" => "0:0:0:0:0:0:0:1",
                                    "priority" => 85,
                                    "timestamp" => "Oct 17 19:50:32",
                                    "@timestamp" => "2018-10-17T19:00:32.000Z",
                                    "@version" => '1',
                                    "logsource" => "localhost",
                                    "process.name" => "echo",
                                    "severity" => 5,
                                    "facility" => 2,
                                    "facility_label" => "user/nagios",
                                    "severity_label" => "Notice"
                                );

                                echo build_curl_call('POST', $api_root, '/backend/logstash-' . date('Y') . '.' . date('m') . '.' . date('d') . '/syslog/?', $apikey, $ex_query);
                            ?>
                            <p class="tw-mb-4"><?php echo _("On a successful API call, this will return a JSON object like"); ?></p>
                            <?php
                                $ex_return = array(
                                    "_index" => "logstash-2018.10.17",
                                    "type" => "syslog",
                                    "_id" => "AWaDmGUQYSpUrRev2f9Q",
                                    "_version" => 1,
                                    "created" => true
                                );
                                echo build_api_return($ex_return);
                            ?>
                            <p class="tw-mb-4"><?php echo _("Note that to create a record, we're just copying the format of the other records in the index. You should only need to read the '_source' field of a record, since the rest of the fields are metadata and will be generated by OpenSearch on creation. You aren't strictly required to do this, since OpenSearch doesn't truly enforce a schema, but missing values can lead to unexpected behavior in other parts of the product.");?></p>
                        </div>
                    </tabs-content>
                </ui-tabs>
                <?php } else { ?>
                <h3 class="tw-text-xl tw-font-semibold tw-mb-4"><?php echo _('User Videos'); ?></h3>
                <div class="tw-aspect-w-16 tw-aspect-h-9">
                    <iframe src="//www.youtube.com/embed/videoseries?list=PLN-ryIrpC_mB-iHjq7G9jVh1-XVDiIeJE&showinfo=1&rel=0&vq=hd720&hd=1" frameborder="0" allowfullscreen></iframe>
                </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>

<?php echo $footer;?>