<?php
require_once(APPPATH . 'views/leftbar_common.php');

$sections = [
    'Configure' => [
        'header_text'=> _('Configure'),
        'items' => [
            [
                'url' => site_url('configure'),
                'icon' => 'settings',
                'text' => _('Configuration Editor')
            ],
        ]
    ],
    'System Logs' => [
        'header_text'=> _('System Logs'),
        'items' => [
            [
                'url' => site_url('configure/source/linux'),
                'icon' => 'web',
                'text' => _('Linux')
            ],
            [
                'url' => site_url('configure/source/windows'),
                'icon' => 'web',
                'text' => _('Windows')
            ],
            [
                'url' => site_url('configure/source/network'),
                'icon' => 'web',
                'text' => _('Network Device')
            ],
        ]
    ],
    'Application Logs' => [
        'header_text'=> _('Application Logs'),
        'items' => [
            [
                'url' => site_url('configure/source/apache'),
                'icon' => 'web',
                'text' => _('Apache')
            ],
            [
                'url' => site_url('configure/source/iis'),
                'icon' => 'web',
                'text' => _('IIS Web Server')
            ],
            [
                'url' => site_url('configure/source/mysql'),
                'icon' => 'database',
                'text' => _('MySQL')
            ],
            [
                'url' => site_url('configure/source/mssql'),
                'icon' => 'database',
                'text' => _('MS SQL')
            ],
            [
                'url' => site_url('configure/source/php'),
                'icon' => 'code',
                'text' => _('PHP')
            ],
            [
                'url' => site_url('configure/source/linux-files'),
                'icon' => 'folder',
                'text' => _('Linux Files')
            ],
            [
                'url' => site_url('configure/source/windows-files'),
                'icon' => 'folder',
                'text' => _('Windows Files')
            ],
        ]
    ],
    'Archived Logs' => [
        'header_text'=> _('Archived Logs'),
        'items' => [
            [
                'url' => site_url('configure/source/import'),
                'icon' => 'upload_file',
                'text' => _('Import From File')
            ],
        ]
    ],
];

renderLeftbar($sections, 'helpLeftbarSetupOpenSections');
?>

<script type="text/javascript">
$(document).ready(function() {

    $('pre code').each(function(i, block) {
        hljs.highlightBlock(block);
    });

    // Add enter key binding for verify
    $('input[name="sender_ip"]').keyup(function(event) {
        if (event.keyCode == 13) {
            $("#verify").click();
        }
    });

    // Verify incoming logs via ip and possibly type
    $('#verify').click(function() {
        var sender_ip = $('input[name="sender_ip"]').val();
        if (sender_ip) {
            const search = {
                query: {
                    bool: {
                        must: []
                    }
                },
                size: 0,
                track_total_hits: true
            };
            search.query.bool.must.push({
                term: {
                    "host.ip": sender_ip
                }
            });
            $('#verify-loading').show();
//            search = "q=host:" + sender_ip.replace(/:/g, '\\:');
 
            // Check for type
            var type = $(this).data('type');
            if (type) {
                search.query.bool.must.push({
                    term: {
                        type: type
                    }
                });
//                search += ' AND type:' + type;
            }

            // Submit search to OpenSearch
            var index = "logstash-<?php echo date("Y.m.d", time()); ?>";
            var api_url = "<?php echo site_url('api/backend'); ?>/" + index + "/_search";
//            api_url += search;

            $.post(api_url, JSON.stringify(search), function(data) {
                $('#verify-loading').hide();
                if (data.hits?.total?.value > 0) {
                    var type = '';
                    if (type) { type = ' <?php echo _("marked as"); ?> "' + type + '"'; }
                    text = "<b><?php echo _('Verified.'); ?></b> <?php echo _('There are '); ?> <b>" + data.hits.total.value + "</b> <?php echo _('logs'); ?> " + type + " <?php echo _('for the host'); ?> <b>" + sender_ip + "</b>.";
                } else {
                    text = "<b><?php echo _('No logs found.'); ?></b> <?php echo _('No logs from that host in the database. The sender\'s firewall may be blocking the logs or the sender may be misconfigured.'); ?>";
                }
                $('#verify-output').html(text).show();
            });

        } else {
            $('#verify-output').html("<?php echo _('You must enter the IP address of the log sender you configured.'); ?>").show();
        }
    });

});
</script>