<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">
        <div class="doc-wrapper">

            <div class="tw-flex tw-items-end">
                <div class="source-logo">
                    <i class="fa fa-xl fa-fw fa-linux"></i> <!-- needs diff img -->
                </div>
                <h1><?php echo _('Linux'); ?></h1>
            </div>
            <div class="form-spacer"></div>

            <h3><?php echo _("Getting Started"); ?></h3>
            <p class="tw-pb-2.5"><?php echo _("This setup guide will go over both automatic and manual settings for Linux to send the system's logs to Log Server. After configuration you should immediately start receiving the logs that you would normally view in the <code>/var/log/messages</code> file on the Linux system you configured."); ?></p>

            <h3><?php echo _("Configuration Setup"); ?></h3>

            <ui-tabs default-value="script">
                <tabs-list>
                    <tabs-trigger value="script"><?php echo _("Automatic"); ?></tabs-trigger>
                    <tabs-trigger value="manual"><?php echo _("Manual (rsyslog)"); ?></tabs-trigger>
                    <tabs-trigger value="syslog-ng"><?php echo _("Manual (syslog-ng)"); ?></tabs-trigger>
                </tabs-list>
                <tabs-content value="script">
                    <div class="alert alert-info tw-flex tw-items-center tw-my-5 tw-mx-0">
                        <span class="material-symbols-outlined tw-mr-2">error</span>
                        <p> <?php echo _("This uses a script to configure your syslogs to send to Log Server. To customize your syslog install, configure syslog manually by clicking on one of the tabs above."); ?></p>
                    </div>
                    <h6><?php echo _("Automatic Script - Supported Operating Systems"); ?></h6>
                    <div>
                        <ul class="tw-mb-2.5 tw-ml-7">
                            <li><?php echo _('CentOS, Fedora, and RHEL'); ?></li>
                            <li><?php echo _('Ubuntu and Debian'); ?></li>
                        </ul>
                    </div>
                    <p><i><?php echo _('You must have rsyslog installed. If your operating system is not listed, you can manually configure syslog.'); ?></i></p>
                    <h6 class="tw-text-lg tw-font-bold"><?php echo _("Run the Script"); ?></h6>
                    <p><?php echo _("On the system you want to send logs from, run the following commands to download and run the script to automatically setup rsyslog."); ?></p>
                    <div class="code-tooltip">
                        <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                        <pre><code class="shell" tabindex="1"><?php echo $step1; ?></code></pre>
                    </div>
                </tabs-content>

                <tabs-content value="manual" class="tw-pt-2.5">
                    <h6 class="tw-text-lg tw-font-bold"><?php echo _("Verify Spool and Config Location"); ?></h6>
                    <p><?php echo _("Put the following commands in your terminal window to verify the rsyslog spool directory and that the rsyslog.d folder exists. The second line will output the spool path you will need to add in the next section for \$WorkDirectory in the configuration."); ?></p>
                    <div class="code-tooltip">
                        <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                        <pre><code class="shell" tabindex="2"><?php echo $step2; ?></code></pre>
                    </div>
                    <h6 class="tw-text-lg tw-font-bold"><?php echo _("Setup the Rsyslog Configuration File"); ?></h6>
                    <p><?php echo _("Edit your"); ?> <code>/etc/rsyslog.conf</code> <?php echo _("file"); ?>. <?php echo _("Add the following to to the configuration file, looking for the 'begin forwarding rule.'"); ?></p>
                    <div class="code-tooltip">
                        <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                        <pre><code class="apache" tabindex="3"><?php echo $step3; ?></code></pre>
                    </div>
                    <p><?php echo _("You will need to replace "); ?><b>$WorkDirectory</b><?php echo _(" with the unique file path of the rsyslog spool directory. This was displayed from the command on line 2 of the previous code block. If there is no directory specified, or the directory specified doesn't exist, then the rsyslog service will error on restart."); ?></p>
                    <p><?php echo _("Example:  \$WorkDirectory /var/lib/rsyslog"); ?></p>
                    <p><?php echo _("Restart the rsyslog service"); ?></p>
                    <div class="code-tooltip">
                        <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                        <pre><code class="shell" tabindex="4"><?php echo "sudo /etc/init.d/rsyslog restart"; ?></code></pre>
                    </div>
                </tabs-content>

                <tabs-content value="syslog-ng" class="tw-pt-2.5">
                    <h6 class="tw-text-lg tw-font-bold"><?php echo _("Setup the syslog-ng Configuration File"); ?></h6>
                    <p><?php echo _("Add the following to the syslog-ng configuration file, usually located at"); ?> <code>/etc/syslog-ng/syslog-ng.conf</code>.</p>
                    <div class="code-tooltip">
                        <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                        <pre><code class="shell" tabindex="5"><?php echo $step4; ?></code></pre>
                    </div>
                    <p><?php echo _("Restart the syslog-ng service"); ?></p>
                    <div class="code-tooltip">
                        <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                        <pre><code class="shell" tabindex="6"><?php echo "sudo /etc/init.d/syslog-ng restart"; ?></code></pre>
                    </div>
                </tabs-content>
            </ui-tabs>

            <h3 class="tw-text-xl tw-font-bold"><?php echo _("Verify Incoming Logs"); ?></h3>
            <p><?php echo _("Once you have configured the log sender, you should start receiving logs right away. Put in the sender's IP address to see if you are receiving logs from that IP."); ?></p>
            <div class="form-inline">
                <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
                    <label class="tw-block tw-text-sm tw-font-medium"><?php echo _("IP Address"); ?></label>
                    <div class="tw-flex tw-w-1/3">
                        <input class="ui-input" name="sender_ip" type="text">
                        <button id="verify" class="ui-btn ui-btn-default tw-ml-3"><?php echo _("Verify"); ?></button>
                        <span id="verify-loading" class="hide"><i class="spinner"></i></span>
                    </div>
                </div>
            </div>
            <div class="verify">
                <div class="well hide verify-logs" id="verify-output"></div>
            </div>
        </div>
    
    </div>
</div>

<?php echo $footer; ?>