<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">

        <div class="doc-wrapper">

            <div class="tw-flex tw-items-end">
                <div class="source-logo">
                    <i class="fa fa-xl fa-fw fa-database"></i>
                </div>
                <h1><?php echo _('MS SQL'); ?></h1>
            </div>
            <div class="form-spacer"></div>

            <h3><?php echo _("Getting Started"); ?></h3>
            <p class="tw-pb-2.5"><?php echo _("If you're running MS SQL you can get your logs through Nxlog, which sends Windows event logs to Nagios Log Server."); ?></p>

            <h3><?php echo _("Requirements"); ?></h3>
            <p><?php echo _("In order to send Windows event logs (including MS SQL logs) you will need to run the"); ?> <a class="tw-text-primary hover:tw-text-primary" href="<?php echo site_url('source/windows'); ?>"><?php echo _("Windows source setup"); ?></a> <?php echo _("guide to install Nxlog"); ?>.</p>

            <h3><?php echo _("Configuration Setup"); ?></h3>
            <p><?php echo _("Make sure you've followed the configuration for Windows in the requirements above. Once the Windows event logs are being sent to Log Server, your MS SQL servers logs will automatically be sent also. Verify below that you are receiving Windows event logs from the MS SQL server IP/hostname below."); ?> </p>

            <h3 class="tw-pt-5"><?php echo _("Verify Incoming Logs"); ?></h3>
            <p><?php echo _("Once you have configured the log sender, you should start receiving logs right away. Put in the sender's IP address to see if you are receiving logs from that IP."); ?></p>
            <div class="form-inline">
                <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
                    <label class="tw-block tw-text-sm tw-font-medium"><?php echo _("IP Address"); ?></label>
                    <div class="tw-flex tw-w-1/3">
                        <input class="ui-input" name="sender_ip" type="text">
                        <button id="verify" class="ui-btn ui-btn-default tw-ml-3"><?php echo _("Verify"); ?></button>
                        <span id="verify-loading" class="hide"><i class="spinner"></i></span>
                    </div>
                </div>
            </div>
            <div class="verify">
                <div class="well hide verify-logs" id="verify-output"></div>
            </div>
        </div>
    
    </div>
</div>

<?php echo $footer; ?>