<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">

        <div class="doc-wrapper">

            <div class="tw-flex tw-items-end">
                <div class="source-logo">
                    <i class="fa fa-xl fa-fw fa-windows"></i>
                </div>
                <h1><?php echo _('Windows Files'); ?></h1>
            </div>
            <div class="form-spacer"></div>

            <h3><?php echo _("Getting Started"); ?></h3>
            <p class="tw-pb-2.5"><?php echo _("This guide will show how to use NXLog to send logs from a file to Nagios Log Server."); ?></p>

            <h3><?php echo _("Requirements"); ?></h3>
            <p><?php echo _("In order to send Windows log files you will need to run the"); ?> <a class="tw-text-primary hover:tw-text-primary" href="<?php echo site_url('source/windows'); ?>"><?php echo _("Windows source setup"); ?></a> <?php echo _("guide to install NXLog"); ?>.</p>

            <h3><?php echo _("Configuration Setup"); ?></h3>
            <h6><?php echo _("Create the NXLog Input"); ?></h6>
            <p><?php echo _("You can send logs from a specific Windows file to Nagios Log Server. Copy the following Input and add it into the nxlog.conf file on the host where the file is located. This is usually located in <code>C:\Program Files (x86)\\nxlog\conf\\nxlog.conf</code>. You can have multiple inputs, but be sure they are all included in the route section which is covered below."); ?></p>
            <div class="code-tooltip">
                <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                <pre><code class="apache" tabindex="1"><?php echo $step2; ?></code></pre>
            </div>
            <p><?php echo _("You should rename "); ?><b>windowsfile</b><?php echo _(" to the name of the file you desire to monitor. <i>The nxlog.conf Input name must be unique.</i>"); ?></p>
            <p><?php echo _("You should change "); ?><b>'C:\path\to\target\file'</b><?php echo _(" to the path of the file you desire to monitor. <i>The path must be inside single quotes.</i>"); ?></p>
            <h6><?php echo _("Route the Output"); ?></h6>
            <p><?php echo _("While adding the Input and filename of the file you are monitoring you will need to add to the route section in the configuration right under the input section above."); ?></p>
            <div class="code-tooltip">
                <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                <pre><code class="apache" tabindex="2"><?php echo $step3; ?></code></pre>
            </div>
            <p><?php echo _("Again, You will need to rename "); ?><b>windowsfile</b><?php echo _(" to the name of the file you desire to monitor."); ?></p>

            <h3 class="tw-pt-5"><?php echo _("Verify Incoming Logs"); ?></h3>
            <p><?php echo _("Once you have configured the log sender, you should start receiving logs right away. Put in the sender's IP address to see if you are receiving logs from that IP."); ?></p>
            <div class="form-inline">
                <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
                    <label class="tw-block tw-text-sm tw-font-medium"><?php echo _("IP Address"); ?></label>
                    <div class="tw-flex tw-w-1/3">
                        <input class="ui-input" name="sender_ip" type="text">
                        <button id="verify" class="ui-btn ui-btn-default tw-ml-3"><?php echo _("Verify"); ?></button>
                        <span id="verify-loading" class="hide"><i class="spinner"></i></span>
                    </div>
                </div>
            </div>
            <div class="verify">
                <div class="well hide verify-logs" id="verify-output"></div>
            </div>

        </div>

    </div>
</div>

<?php echo $footer; ?>