<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="form-container">

        <div class="doc-wrapper">

            <div class="tw-flex tw-items-end">
                <div class="source-logo">
                    <i class="fa fa-xl fa-fw fa-windows"></i>
                </div>
                <h1><?php echo _('Windows'); ?></h1>
            </div>
            <div class="form-spacer"></div>

            <h3><?php echo _("Getting Started"); ?></h3>
            <p class="tw-pb-2.5"><?php echo _("While there are many agents available for Windows that can send logs to Nagios Log Server, we recommend using NXLog. NXLog is an agent that will allow you to send your Windows event logs. Get started by downloading "); ?><a href="<?php echo base_url('scripts/nxlog-ce-latest.msi'); ?>" class="tw-text-primary hover:tw-text-primary"><?php echo _("NXLog CE"); ?></a> <?php echo _("and install it on the Windows desktop or server you want to receive logs from."); ?></p>

            <h3><?php echo _("Configuration Setup"); ?></h3>
                
            <h6><?php echo _("Configure Windows Event Logs using NXLog"); ?></h6>
            <p><?php echo _("Save the entire contents below to your nxlog.conf file usually located in"); ?> <code>C:\Program Files\nxlog\conf\nxlog.conf</code> or <code>C:\Program Files (x86)\nxlog\conf\nxlog.conf</code></p>
            <div class="code-tooltip">
                <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                <pre><code class="apache" tabindex="1"><?php echo $step2; ?></code></pre>
            </div>

            <h6><?php echo _("Start the NXLog Service"); ?></h6>
            <p><?php echo _("The NXLog service must be started to start sending the eventlog data. You can start it from the Services admin panel or in the command line, you can run the following command."); ?></p>
            <div class="code-tooltip">
                <button class="copy-button"><span class="material-symbols-outlined">content_copy</span></button>
                <pre><code class="shell" tabindex="2">net start nxlog</code></pre>
            </div>

            <h3 class="tw-pt-5"><?php echo _("Verify Incoming Logs"); ?></h3>
            <p><?php echo _("Once you have configured the log sender, you should start receiving logs right away. Put in the sender's IP address to see if you are receiving logs from that IP."); ?></p>
            <div class="form-inline">
                <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
                    <label class="tw-block tw-text-sm tw-font-medium"><?php echo _("IP Address"); ?></label>
                    <div class="tw-flex tw-w-1/3">
                        <input class="ui-input" name="sender_ip" type="text">
                        <button id="verify" class="ui-btn ui-btn-default tw-ml-3"><?php echo _("Verify"); ?></button>
                        <span id="verify-loading" class="hide"><i class="spinner"></i></span>
                    </div>
                </div>
            </div>
            <div class="verify">
                <div class="well hide verify-logs" id="verify-output"></div>
            </div>

        </div>
    
    </div>
</div>

<?php echo $footer; ?>
