<?php echo $header; ?>

<script type="text/javascript">

function load_highcharts()
{
    Highcharts.setOptions({
    lang: {
        thousandsSep: ','
    }
    });
    
    var hc_data = [];
    var alert_data = [];

    const log_count = Highcharts.chart('chart', {
        loading: {
            style: {
                backgroundColor: 'transparent'
            }
        },
        title: {
            text: "<?php echo _('Number of Logs Per 15 Minutes'); ?>",
            style: {
                color: 'hsl(var(--foreground))'
            },
            align: 'left',
            x: 30,
            y: 30,
            margin: 40
        },
        chart: {
            backgroundColor: 'transparent',
            borderColor: 'hsl(var(--border))',
            borderWidth: 1,
            borderRadius: '0.5rem'
        },
        credits: {
            enabled: false
        },
        xAxis: {
            type: "datetime",
            lineColor: 'hsl(var(--border))',
            labels: {
                style: {
                    color: 'hsl(var(--foreground))'
                }
            }
        },
        yAxis: {
            gridLineColor: 'hsl(var(--border))',
            labels: {
                style: {
                    color: 'hsl(var(--foreground))'
                }
            },
            title: {
                style: {
                    color: 'hsl(var(--foreground))'
                }
            }
        },
        legend: {
            itemStyle: {
                color: 'hsl(var(--foreground))'
            },
            itemHoverStyle: {
                color: 'hsl(var(--foreground))'
            }
        },
        lang: {
            noData: "<?php echo _(' '); ?>"
        }
    });
    log_count.showLoading();

    const column_weeks = Highcharts.chart('column2WKs', {
        loading: {
            style: {
                backgroundColor: 'transparent'
            }
        },
        title: {
            text: "<?php echo _('Total Log Entries Within The Last Two Weeks'); ?>",
            style: {
                color: 'hsl(var(--foreground))'
            },
            align: 'left',
            x: 30,
            y: 30,
            margin: 40
        },
        chart: {
            backgroundColor: 'transparent',
            borderColor: 'hsl(var(--border))',
            borderWidth: 1,
            borderRadius: '0.5rem'
        },
        credits: {
            enabled: false
        },
        xAxis: {
            type: "datetime",
            lineColor: 'hsl(var(--border))',
            labels: {
                style: {
                    color: 'hsl(var(--foreground))'
                }
            }
        },
        yAxis: {
            gridLineColor: 'hsl(var(--border))',
            labels: {
                style: {
                    color: 'hsl(var(--foreground))'
                }
            },
            title: {
                style: {
                    color: 'hsl(var(--foreground))'
                }
            }
        },
        legend: {
            itemStyle: {
                color: 'hsl(var(--foreground))'
            },
            itemHoverStyle: {
                color: 'hsl(var(--foreground))'
            }
        },
        lang: {
            noData: "<?php echo _(' '); ?>"
        }
    });
    column_weeks.showLoading();

    const days_chart = Highcharts.chart('days-chart', {
        loading: {
            style: {
                backgroundColor: 'transparent'
            }
        },
        title: {
            text: "<?php echo _('Total and Top 5 Senders Per 12 Hours'); ?>",
            style: {
                color: 'hsl(var(--foreground))'
            },
            align: 'left',
            x: 30,
            y: 30,
            margin: 40
        },
        chart: {
            backgroundColor: 'transparent',
            borderColor: 'hsl(var(--border))',
            borderWidth: 1,
            borderRadius: '0.5rem'
        },
        credits: {
            enabled: false
        },
        xAxis: {
            type: "datetime",
            lineColor: 'hsl(var(--border))',
            labels: {
                style: {
                    color: 'hsl(var(--foreground))'
                }
            }
        },
        yAxis: {
            gridLineColor: 'hsl(var(--border))',
            labels: {
                style: {
                    color: 'hsl(var(--foreground))'
                }
            },
            title: {
                style: {
                    color: 'hsl(var(--foreground))'
                }
            }
        },
        legend: {
            itemStyle: {
                color: 'hsl(var(--foreground))'
            },
            itemHoverStyle: {
                color: 'hsl(var(--foreground))'
            }
        },
        lang: {
            noData: "<?php echo _(' '); ?>"
        }
    });
    days_chart.showLoading();

    var hc_usage_data = [];

    const usage_chart = Highcharts.chart('usage-chart', {
        loading: {
            style: {
                backgroundColor: 'transparent'
            }
        },
        chart: {
            type: "spline",
            backgroundColor: 'transparent',
            borderColor: 'hsl(var(--border))',
            borderWidth: 1,
            borderRadius: '0.5rem'
        },
        title: {
            text: "<?php echo _('Disk Usage - Current Index');?>",
            style: {
                color: 'hsl(var(--foreground))'
            },
            align: 'left',
            x: 30,
            y: 30,
            margin: 40
        },
        subtitle: {
            text: "<?php echo sprintf(_('Includes primary and replica shards across entire cluster - see %1$sIndex Status%2$s for primary shard only'), '<a href=\"'.site_url('admin/index_status').'\">', '</a>'); ?>",
            useHTML: true,
            style: {
                color: 'hsl(var(--foreground)/0.5)'
            },
            align: 'left',
            x: 30,
            y: 50
        },
        lang: {
            noData: "<?php echo _(' '); ?>"
        },
        credits: {
            enabled: false
        },
        tooltip: {
            dateTimeLabelFormats: {
                millisecond:"%A, %b %e, %H:%M",
                second:"%A, %b %e, %H:%M",
                minute:"%A, %b %e, %H:%M",
                hour:"%A, %b %e, %H:%M",
                day:"%A, %b %e, %H:%M",
                week:"%A, %b %e, %H:%M",
                month:"%A, %b %e, %H:%M",
                year:"%A, %b %e, %H:%M"
            },
            valueSuffix: '<?php echo $hc_usage_data_human_unit; ?>'
        },
        xAxis: {
            type: "datetime",
            lineColor: 'hsl(var(--border))',
            labels: {
                style: {
                    color: 'hsl(var(--foreground))'
                }
            }
        },
        yAxis: {
            gridLineColor: 'hsl(var(--border))',
            labels: {
                style: {
                    color: 'hsl(var(--foreground))'
                }
            },
            title: {
                text: undefined
            }
        },
        legend: {
            itemStyle: {
                color: 'hsl(var(--foreground))'
            },
            itemHoverStyle: {
                color: 'hsl(var(--foreground))'
            }
        },
        lang: {
            noData: "<?php echo _(' '); ?>"
        },
        series: [
            {
                name: "<?php echo sprintf(_('Total Size (%s)'), $hc_usage_data_human_unit); ?>",
                data: hc_usage_data,
                color: "hsl(var(--chart-3))"
            },
        ]
    });
    usage_chart.showLoading();

    var es_drive_node_names = '';
    var es_drive_series = '';

    const disk_chart = Highcharts.chart('disk-chart', {
        loading: {
            style: {
                backgroundColor: 'transparent'
            }
        },
        title: {
            text: "<?php echo _('Total OpenSearch Disk Usage'); ?>",
            style: {
                color: 'hsl(var(--foreground))'
            },
            align: 'left',
            x: 30,
            y: 30,
            margin: 40
        },
        chart: {
            type: 'bar',
            backgroundColor: 'transparent',
            borderColor: 'hsl(var(--border))',
            borderWidth: 1,
            borderRadius: '0.5rem'
        },
        credits: {
            enabled: false
        },
        xAxis: {
            type: "category",
            categories: es_drive_node_names,
            lineColor: 'hsl(var(--border))',
            labels: {
                style: {
                    color: 'hsl(var(--foreground))'
                }
            }
        },
        yAxis: {
            gridLineColor: 'hsl(var(--border))',
            labels: {
                style: {
                    color: 'hsl(var(--foreground))'
                }
            },
            title: {
                style: {
                    color: 'hsl(var(--foreground))'
                }
            }
        },
        legend: {
            itemStyle: {
                color: 'hsl(var(--foreground))'
            },
            itemHoverStyle: {
                color: 'hsl(var(--foreground))'
            },
            symbolHeight: 12,
            symbolWidth: 12,
            symbolRadius: 6
        },
        lang: {
            noData: "<?php echo _(' '); ?>"
        },
        tooltip: {
            valueSuffix: "GiB"
        },
        plotOptions: {
            series: {
                stacking: 'normal',
                borderWidth: 0,
                borderRadius: 5
            }
        },
        series: es_drive_series
    });
    disk_chart.showLoading();
}

$(document).ready(function() {

    load_highcharts();

    // Update check
    <?php if (is_admin()) { ?>
        $.get('<?php echo site_url('dashboard/do_update_check') ?>', {}, function(data) {
            if (data != "") {
                $('#updates').html(data);
            } else {
                $('#updates-box').hide();
            }
        });
    <?php } ?>

    var load_dashboards = function() {
        $.post(site_url + 'api/user/get_dashboards', function(data) {
            if ($(data).length > 0) {
                $.each(data, function(index, value) {
                    $('#mydash tbody').append('<tr class="ui-tr"><td class="ui-td"><a href="' + site_url + 'dashboard?dashboardId=' + value.id + '">' + value.title + '</a></td></tr>');
                });
            } else {
                $('#mydash tbody').append("<tr class='ui-tr'><td class='ui-td'>" + <?php echo json_encode(htmlentities(_("You don't have any dashboards"), ENT_QUOTES, 'UTF-8')); ?> + "</td></tr>");
            }
        }, 'json');
        $.post(site_url + 'api/system/get_global_dashboards', function(data) {
            if ($(data).length > 0) {
                $.each(data, function(index, value) {
                    $('#globaldash tbody').append('<tr class="ui-tr"><td class="ui-td"><a href="' + site_url + 'dashboard?dashboardId=' + value.id + '">' + value.title + '</a></td></tr>');
                });
            } else {
                $('#globaldash tbody').append('<tr class="ui-tr"><td class="ui-td">' + JSON.parse(<?php echo json_encode(_("There are no global dashboards")); ?>) + '</td></tr>');
            }
        }, 'json');
    }

    var load_queries = function() {
        var cachebuster = Date.now(); 
        $.post(site_url + 'api/queries/get?cb=' +cachebuster, function(data) {
            var has_queries = false;
            if ($(data).length > 0) {
                $.each(data, function(index, value) {
                    if (value.show_everyone) {
                        $('#globalqueries tbody').append('<tr class="ui-tr"><td class="ui-td"><a href="' + site_url + 'alerts/show_query/' + value.id + '">' + value.name + '</a></td></tr>');
                    } else {
                        has_queries = true;
                        $('#queries tbody').append('<tr class="ui-tr"><td class="ui-td">><a href="' + site_url + 'alerts/show_query/' + value.id + '">' + value.name + '</a></td></tr>');
                    }
                });
            }

            if (!has_queries) {
                $('#queries tbody').append('<tr class="ui-tr"><td class="ui-td">>' + JSON.parse('<?php echo json_encode(_("You have not created any queries")); ?>') + '</td></tr>');
            }

            // Display defaults for globals if none exist
            if ($('#globalqueries tbody tr').length == 0) {
                $('#globalqueries tbody').append('<t class="ui-tr"r><td class="ui-td">>' + JSON.parse('<?php echo json_encode(htmlentities(_("There are no global queries"), ENT_QUOTES, 'UTF-8')); ?>') + '</td></tr>');
            }

        }, 'json');
    }

    load_dashboards();
    // load_queries();

    // Auto-complete POC
    var searchables = [ "security breaches" ];
    $('#auto').autocomplete({
        source: searchables
    });

    //load Log Per 15 Minutes chart
    $.ajax({
        url: site_url + 'api/chart/log_count_15_minutes',
        type: 'POST',
        success: function(data) {
            var data_array = $.parseJSON(data);
            var hc_data = [];
            var alert_data = [];
            $.each(data_array, function(key, value) {
                hc_data.push([ value.key, value.doc_count ]);
            });
            document.getElementById('chart').highchart = Highcharts.chart('chart', {
                title: {
                    text: "<?php echo _('Number of Logs Per 15 Minutes'); ?>",
                    style: {
                        color: 'hsl(var(--foreground))'
                    },
                    align: 'left',
                    x: 30,
                    y: 30,
                    margin: 40
                },
                chart: {
                    backgroundColor: 'transparent',
                    borderColor: 'hsl(var(--border))',
                    borderWidth: 1,
                    borderRadius: '0.5rem'
                },
                credits: {
                    enabled: false
                },
                xAxis: {
                    type: "datetime",
                    lineColor: 'hsl(var(--border))',
                    labels: {
                        style: {
                            color: 'hsl(var(--foreground))'
                        }
                    }
                },
                yAxis: {
                    gridLineColor: 'hsl(var(--border))',
                    labels: {
                        style: {
                            color: 'hsl(var(--foreground))'
                        }
                    },
                    title: {
                        text: undefined
                    }
                },
                legend: {
                    itemStyle: {
                        color: 'hsl(var(--foreground))'
                    },
                    itemHoverStyle: {
                        color: 'hsl(var(--foreground))'
                    }
                },
                series: [
                    {
                        name: "<?php echo _('Logs'); ?>",
                        data: hc_data,
                        color: 'hsl(var(--chart-3))'
                    }
                ]
            });
            $('#chart').highcharts().hideLoading();
        }
    });

    //load Total and Top 5 Senders Per 12 Hours chart
    $.ajax({
        url: site_url + 'api/chart/total_and_top_senders',
        type: 'POST',
        success: function(data) {
            var data_array = $.parseJSON(data);
            var hc_data = [];
            var hc_names = [];
            var alert_data = [];
            var hc_total = [];
            var host_colors = ["hsl(var(--chart-1))", "hsl(var(--chart-2))", "hsl(var(--chart-4))", "hsl(var(--chart-5))", "hsl(var(--chart-6))"];

            // we get the offset from UTC in milliseconds, and we'll use it to adjust the displayed date and time in high charts.
            var offset = data_array['offset'];
            $.each(data_array['data'], function(key, value) {
                hc_data[key] = [];
                $.each(value, function(key2, value2) {
                    hc_data[key].push([ value2.key + offset, value2.doc_count ]);
                });
            });

            $.each(data_array['names'], function(key, value) {
                hc_names.push([ value ]);
            });
            var num_hosts = hc_names.length;

            $.each(data_array['total'], function(key, value) {
                hc_total.push([ value.key + offset, value.doc_count ]);
            });

            document.getElementById('days-chart').highchart = Highcharts.chart('days-chart', {
                title: {
                    text: "<?php echo _('Total and Top 5 Senders Per 12 Hours'); ?>",
                    style: {
                        color: 'hsl(var(--foreground))'
                    },
                    align: 'left',
                    x: 30,
                    y: 30,
                    margin: 40
                },
                chart: {
                    backgroundColor: 'transparent',
                    borderColor: 'hsl(var(--border))',
                    borderWidth: 1,
                    borderRadius: '0.5rem'
                },
                credits: {
                    enabled: false
                },
                xAxis: {
                    type: "datetime",
                    lineColor: 'hsl(var(--border))',
                    labels: {
                        style: {
                            color: 'hsl(var(--foreground))'
                        }
                    }
                },
                yAxis: {
                    gridLineColor: 'hsl(var(--border))',
                    labels: {
                        style: {
                            color: 'hsl(var(--foreground))'
                        }
                    },
                    title: {
                        text: undefined
                    }
                },
                legend: {
                    itemStyle: {
                        color: 'hsl(var(--foreground))'
                    },
                    itemHoverStyle: {
                        color: 'hsl(var(--foreground))'
                    }
                }
            });

            $('#days-chart').highcharts().addSeries(
                {
                    name: "<?php echo _('Total'); ?>",
                    data: hc_total,
                    color: "hsl(var(--chart-3))"
                }
            );

            for (var i = 0; i < num_hosts; i++){
                var hc_data_host = [];
                $.each(hc_data[i], function(key, value) {
                    hc_data_host.push([ value.key, value.doc_count ]);
                });
                $('#days-chart').highcharts().addSeries(
                    {
                        name: hc_names[i],
                        data: hc_data[i],
                        color: host_colors[i % host_colors.length]
                    }
                );
            }

            $('#days-chart').highcharts().hideLoading();
        }
    });

    //load Total Log Entries Within the Last Two Weeks chart
    $.ajax({
        url: site_url + 'api/chart/total_logs_last_two_weeks',
        type: 'POST',
        success: function(data) {
            var data_array = $.parseJSON(data);
            var tw_data = [];
            var pw_data = [];
            var weekString = data_array['weekString'];
            var offset = data_array['offset'] + (new Date().getTimezoneOffset()) * 60 * 1000;
            $.each(data_array['twData'], function(key, value) {
                tw_data.push([ new Date(value.key + offset).toLocaleDateString(), value.doc_count ]);
            });
            $.each(data_array['pwData'], function(key, value) {
                pw_data.push([ new Date(value.key + offset).toLocaleDateString(), value.doc_count ]);
            });

            document.getElementById('column2WKs').highchart = Highcharts.chart('column2WKs', {
                title: {
                    text: "<?php echo _('Total Log Entries Within The Last Two Weeks'); ?>",
                    style: {
                        color: 'hsl(var(--foreground))'
                    },
                    align: 'left',
                    x: 30,
                    y: 30,
                    margin: 40
                },
                subtitle: {
                    text: "<?php echo _('Logs Per Index - Sorted by Week Day'); ?>",
                    style: {
                        color: 'hsl(var(--foreground)/0.5)'
                    },
                    align: 'left',
                    x: 30,
                    y: 50
                },
                chart: {
                    type: 'column',
                    backgroundColor: 'transparent',
                    borderColor: 'hsl(var(--border))',
                    borderWidth: 1,
                    borderRadius: '0.5rem'
                },
                credits: {
                    enabled: false
                },
                xAxis: {
                    type: "category",
                    lineColor: 'hsl(var(--border))',
                    categories: weekString,
                    labels: {
                        style: {
                            color: 'hsl(var(--foreground))'
                        }
                    }
                },
                yAxis: {
                    gridLineColor: 'hsl(var(--border))',
                    labels: {
                        style: {
                            color: 'hsl(var(--foreground))'
                        }
                    },
                    title: {
                        text: undefined
                    }
                },
                legend: {
                    itemStyle: {
                        color: 'hsl(var(--foreground))'
                    },
                    itemHoverStyle: {
                        color: 'hsl(var(--foreground))'
                    },
                    symbolHeight: 12,
                    symbolWidth: 12,
                    symbolRadius: 6
                },
                tooltip: {
                    shared: false
                },
                plotOptions: {
                    column: {
                        grouping: false,
                        shadow: false,
                        borderWidth: 0
                    },
                    series: {
                        borderWidth: 0,
                        borderRadius: 5,
                        cursor: 'pointer',
                        point: {
                            events: {
                                click: function () {
                                    location.href = '<?php $_SERVER['HTTP_REFERER'] ?>'+'admin/index_status';
                                }
                            }
                        }
                    }
                },
            });

            $('#column2WKs').highcharts().addSeries(
                {
                    name: "<?php echo _('Previous Week'); ?>",
                    data: pw_data,
                    color: 'hsl(var(--foreground)/0.5)',
                    tooltip:
                    {
                        valueSuffix: "<?php echo _(' Logs'); ?>",
                    },
                    pointPadding: 0.225,
                    pointPlacement: -0.2
                }
            );

            $('#column2WKs').highcharts().addSeries(
                {
                    name: "<?php echo _('This Week'); ?>",
                    color: 'hsl(var(--chart-3))',
                    data: tw_data,
                    tooltip: {
                        valueSuffix: "<?php echo _(' Logs'); ?>",
                    },
                    pointPadding: 0.225,
                    pointPlacement: 0.2
                },
            );

            $('#column2WKs').highcharts().hideLoading();
        }
    });

    //load Disk Usage chart
    $.ajax({
        url: site_url + 'api/Dashboards/currentindexdiskusage',
        type: 'POST',
        success: function(data) {
            var data_array = $.parseJSON(data);
            var unit_of_measure = data_array.usage_data_human_unit;
            var hc_data = [];
            var alert_data = [];
            $.each(data_array.usage_data, function(key, value) {
                hc_data.push([ value.timestamp, value.used ]);
            });
            document.getElementById('usage-chart').highchart = Highcharts.chart('usage-chart', {
                chart: {
                    type: "spline",
                    backgroundColor: 'transparent',
                    borderColor: 'hsl(var(--border))',
                    borderWidth: 1,
                    borderRadius: '0.5rem'
                },
                credits: {
                    enabled: false
                },
                title: {
                    text: "<?php echo _('Disk Usage - Current Index');?>",
                    style: {
                        color: 'hsl(var(--foreground))'
                    },
                    align: 'left',
                    x: 30,
                    y: 30,
                    margin: 40
                },
                subtitle: {
                    text: "<?php echo sprintf(_('Includes primary and replica shards across entire cluster - see %1$sIndex Status%2$s for primary shard only'), '<a href=\"'.site_url('admin/index_status').'\">', '</a>'); ?>",
                    style: {
                        color: 'hsl(var(--foreground))'
                    },
                    useHTML: true
                },
                lang: {
                    noData: "<?php echo _('No data to display'); ?>"
                },
                tooltip: {
                    dateTimeLabelFormats: {
                        millisecond:"%A, %b %e, %H:%M",
                        second:"%A, %b %e, %H:%M",
                        minute:"%A, %b %e, %H:%M",
                        hour:"%A, %b %e, %H:%M",
                        day:"%A, %b %e, %H:%M",
                        week:"%A, %b %e, %H:%M",
                        month:"%A, %b %e, %H:%M",
                        year:"%A, %b %e, %H:%M"
                    },
                    valueSuffix: unit_of_measure
                },
                xAxis: {
                    type: "datetime",
                    lineColor: 'hsl(var(--border))',
                    labels: {
                        style: {
                            color: 'hsl(var(--foreground))'
                        }
                    }
                },
                yAxis: {
                    gridLineColor: 'hsl(var(--border))',
                    labels: {
                        style: {
                            color: 'hsl(var(--foreground))'
                        },
                        format: "{value} "+ unit_of_measure
                    },
                    title: {
                        text: ""
                    },
                },
                legend: {
                    itemStyle: {
                        color: 'hsl(var(--foreground))'
                    },
                    itemHoverStyle: {
                        color: 'hsl(var(--foreground))'
                    }
                },
                series: [
                    {
                        name: "<?php echo _('Total Size'); ?>" + " (" + unit_of_measure + ")",
                        data: hc_data,
                        color: 'hsl(var(--chart-3))'
                    },

                ]
            });
            $('#usage-chart').highcharts().hideLoading();
        }
    });

    //load Total Elasticsearch Disk Usage chart
    $.ajax({
        url: site_url + 'api/chart/total_opensearch_disk_usage',
        type: 'POST',
        success: function(data) {
            var es_drive_status = $.parseJSON(data);
            var es_drive_node_names = Object.getOwnPropertyNames(es_drive_status);
            var es_drive_series = [{name: 'Free', data:[], color: '#03a645'}, {name: 'Used', data:[], color: '#434348'}];

            /* Marshal data-in-bytes to a Highcharts series using GiB */
            for (var i = 0; i < es_drive_node_names.length; i += 1) {
                var current_node = es_drive_status[es_drive_node_names[i]].total;

                var available_in_bytes = current_node.available_in_bytes;
                var available_in_GiB = Math.round(available_in_bytes / 10737418.24) / 100.0; // Rounded to two digits
                es_drive_series[0].data[i] = available_in_GiB;

                var used_in_bytes = current_node.total_in_bytes - current_node.available_in_bytes
                var used_in_GiB = Math.round(used_in_bytes / 10737418.24) / 100.0; // Rounded to two digits
                es_drive_series[1].data[i] = used_in_GiB;
            }

            document.getElementById('disk-chart').highchart = Highcharts.chart('disk-chart', {
                chart: {
                    type: 'bar',
                    backgroundColor: 'transparent',
                    borderColor: 'hsl(var(--border))',
                    borderWidth: 1,
                    borderRadius: '0.5rem'
                },
                credits: {
                    enabled: false
                },
                title: {
                    text: '<?php echo _('Total OpenSearch Disk Usage'); ?>',
                    style: {
                        color: 'hsl(var(--foreground))'
                    },
                    align: 'left',
                    x: 30,
                    y: 30,
                    margin: 40                },
                xAxis: {
                    categories: es_drive_node_names,
                    lineColor: 'transparent',
                    labels: {
                        style: {
                            color: 'hsl(var(--foreground))'
                        }
                    }
                },
                yAxis: {
                    gridLineColor: 'hsl(var(--border))',
                    labels: {
                        style: {
                            color: 'hsl(var(--foreground))'
                        },
                    },
                    min: 0,
                    title: {
                        text: '<?php echo _("Disk Usage (GiB)"); ?>',
                        style: {
                            color: 'hsl(var(--foreground))'
                        },
                    }
                },
                tooltip: {
                    valueSuffix: "GiB"
                },
                legend: {
                    itemStyle: {
                        color: 'hsl(var(--foreground))'
                    },
                    itemHoverStyle: {
                        color: 'hsl(var(--foreground))'
                    },
                    reversed: true
                },
                plotOptions: {
                    series: {
                        stacking: 'normal'
                    },
                    bar: {
                        grouping: false,
                        shadow: false,
                        borderWidth: 0
                    },
                },
                series: es_drive_series
            });
        }
    });
});

</script>

<div class="configure-layout">
    <div class="tw-grid tw-grid-cols-2 tw-gap-4 tw-pt-8 tw-pb-20 tw-px-8 tw-overflow-auto tw-w-full">
        <div class="tw-flex tw-w-full tw-gap-4">
            <div class="tw-bg-background tw-border tw-rounded-lg tw-border-border tw-grow tw-flex tw-flex-col tw-gap-4 hover:tw-bg-secondary">
                <div class="tw-flex tw-items-center tw-justify-between tw-flex-wrap tw-pt-4 tw-px-4">
                    <div class="tw-flex tw-items-center tw-gap-2">
                        <?php if ($unique_hosts == 1) { echo _('Unique Host'); } else { echo _('Unique Hosts'); } ?>
                        <?php echo question_tooltip(_("Number of unique hosts sending logs to this cluster")); ?>
                    </div>
                    <a class="ui-btn ui-btn-outlined focus:tw-text-foreground" href="<?php echo site_url('admin/unique_hosts'); ?>"><?php echo _("View"); ?></a>
                </div>
                <div class="tw-text-3xl tw-pl-4 tw-pb-4"><?php echo $unique_hosts; ?></div>
            </div>
            <?php if (user_has_permission('alerts', array('view'))) { ?>
            <div class="tw-bg-background tw-border tw-rounded-lg tw-border-border tw-grow tw-flex tw-flex-col tw-gap-4 hover:tw-bg-secondary">
                <div class="tw-flex tw-items-center tw-justify-between tw-flex-wrap tw-pt-4 tw-px-4">
                    <div class="tw-flex tw-items-center tw-gap-2">
                        <?php if ($alerts == 1) { echo _('Active Alert'); } else { echo _('Active Alerts'); } ?>
                        <?php echo question_tooltip(_("Number of active alerts running")); ?>
                    </div>
                    <a class="ui-btn ui-btn-outlined focus:tw-text-foreground" href="<?php echo site_url('alerts'); ?>"><?php if (user_has_permission('alerts', array('all'))) { echo _('Manage'); } else { echo _('View'); } ?></a>
                </div>
                <div class="tw-text-3xl tw-pl-4 tw-pb-4"><?php echo empty($alerts) ? "0" : $alerts; ?></div>
            </div>
            <?php } if (is_admin()) { ?>
            <div class="tw-bg-background tw-border tw-rounded-lg tw-border-border tw-grow tw-flex tw-flex-col tw-gap-4 hover:tw-bg-secondary">
                <div class="tw-flex tw-items-center tw-h-[52px] tw-gap-2 tw-pt-4 tw-px-4">
                    <div><?php echo _('Instances'); ?></div>
                    <?php echo question_tooltip(_("Number of Log Server instances connected to the cluster")); ?>
                </div>
                <div class="tw-text-3xl tw-pl-4 tw-pb-4"><?php echo $nodes; ?></div>
            </div>
            <?php } ?>
        </div>
        <?php if (user_has_permission('configure', array('view'))) { ?>
        <div class="tw-bg-background tw-border tw-border-border tw-rounded-lg tw-flex tw-flex-col hover:tw-bg-secondary">
            <div class="tw-border-b tw-border-border tw-flex tw-items-center tw-p-4">
                <div class="tw-h-[36px] tw-flex tw-items-center"><?php echo _('Add a log source'); ?></div>
            </div>
            <div class="tw-flex tw-gap-4 tw-p-2 tw-overflow-x-auto">
                <a class="tw-p-2 tw-rounded-lg hover:tw-bg-foreground/5 no-primary hover:tw-text-foreground tw-flex tw-items-center tw-gap-2 tw-transition-colors" href="<?php echo site_url('configure/source/windows'); ?>">
                    <i class="material-symbols-outlined">add_circle</i>
                    <?php echo _('Windows'); ?>
                </a>
                <a class="tw-p-2 tw-rounded-lg hover:tw-bg-foreground/5 no-primary hover:tw-text-foreground tw-flex tw-items-center tw-gap-2 tw-transition-colors" href="<?php echo site_url('configure/source/linux'); ?>">
                    <i class="material-symbols-outlined">add_circle</i>
                    <?php echo _('Linux'); ?>
                </a>
                <a class="tw-p-2 tw-rounded-lg hover:tw-bg-foreground/5 no-primary hover:tw-text-foreground tw-flex tw-items-center tw-gap-2 tw-transition-colors" href="<?php echo site_url('configure/source/network'); ?>">
                    <i class="material-symbols-outlined">add_circle</i>
                    <?php echo _('Network Device'); ?>
                </a>
                <a class="tw-p-2 tw-rounded-lg hover:tw-bg-foreground/5 no-primary hover:tw-text-foreground tw-flex tw-items-center tw-gap-2 tw-transition-colors" href="<?php echo site_url('configure/add-log-source'); ?>">
                    <i class="material-symbols-outlined">add_circle</i>
                    <?php echo _('Other'); ?>
                </a>
            </div>
        </div>
        <?php } else { ?>
        <div class="tw-gap-4 tw-flex-wrap tw-border tw-border-border tw-rounded-lg tw-p-4 hover:tw-bg-secondary tw-w-full tw-flex tw-items-center tw-justify-evenly">
            <?php if (is_trial()) { ?>
            <a class="ui-btn ui-btn-outlined tw-flex tw-items-center tw-gap-2" href="https://go.nagios.com/nagios-log-server-demo-request" target="_blank">
                <i class="material-symbols-outlined">computer</i>
                <?php echo _("Request a live demo"); ?>
            </a>
            <?php } ?>
            <a class="ui-btn ui-btn-outlined tw-flex tw-items-center tw-gap-2" href="https://go.nagios.com/nagios-log-server-feedback" target="_blank">
                <i class="material-symbols-outlined">chat</i>
                <?php echo _("Give us feedback"); ?>
            </a>
            <a class="ui-btn ui-btn-outlined tw-flex tw-items-center tw-gap-2" href="https://go.nagios.com/nagios-log-server-request-for-assistance" target="_blank">
                <i class="material-symbols-outlined">help</i>
                <?php echo _("Request assistance"); ?>
            </a>
        </div>
        <?php } ?>
        <div id="chart" class="tw-h-fit tw-w-full"></div>
        <div id="column2WKs" class="tw-h-fit tw-w-full"></div>
        <div id="usage-chart" class="tw-h-fit tw-w-full"></div>
        <div id="disk-chart" class="tw-h-fit tw-w-full"></div>
        <div id="days-chart" class="tw-h-fit tw-w-full"></div>
        <div class="">
            <div class="">
                <div class="tw-flex tw-gap-4 tw-border tw-border-border tw-rounded-lg tw-pt-4 tw-px-4 tw-h-[275px] tw-max-h-[275px] tw-overflow-y-auto">
                    <ui-tabs default-value="globaldash" class="tw-w-full">
                        <tabs-list class="tw-w-full">
                            <tabs-trigger value="globaldash"><?php echo _("Global Dashboards"); ?></tabs-trigger>
                            <tabs-trigger value="mydash"><?php echo _("My Dashboards"); ?></tabs-trigger>
                        </tabs-list>
                        <tabs-content value="globaldash">
                            <table id="globaldash" class="ui-table">
                                <tbody class="ui-tbody"></tbody>
                            </table>
                        </tabs-content>
                        <tabs-content value="mydash">
                            <table id="mydash" class="ui-table">
                                <tbody class="ui-tbody"></tbody>
                            </table>
                        </tabs-content>
                    </ui-tabs>
                    <!-- <ui-tabs default-value="globalqueries" class="tw-w-1/2">
                        <tabs-list class="tw-w-full">
                            <tabs-trigger value="globalqueries"><?php echo _("Global Queries"); ?></tabs-trigger>
                            <tabs-trigger value="myqueries"><?php echo _("My Queries"); ?></tabs-trigger>
                        </tabs-list>
                        <tabs-content value="globalqueries">
                            <table id="globalqueries" class="ui-table">
                                <tbody class="ui-tbody"></tbody>
                            </table>
                        </tabs-content>
                        <tabs-content value="myqueries">
                            <table id="myqueries" class="ui-table">
                                <tbody class="ui-tbody"></tbody>
                            </table>
                        </tabs-content>
                    </ui-tabs> -->
                </div>
            </div>
            <?php if (is_admin()) { ?>
            <div class="tw-mt-4 tw-flex tw-gap-4">
                <div class="tw-border tw-border-border tw-rounded-lg tw-p-4 hover:tw-bg-secondary">
                    <div class="tw-flex tw-flex-col tw-items-center tw-h-full tw-w-full">
                        <div class="tw-whitespace-nowrap"><?php echo _("Update Check"); ?></div>
                        <div id="updates" class="tw-flex tw-h-full tw-items-center tw-justify-center"><span><div class="spinner" style="height:40px; width: 40px"></div></span></div>
                    </div>
                </div>
                <div class="tw-gap-4 tw-flex-wrap tw-border tw-border-border tw-rounded-lg tw-p-4 hover:tw-bg-secondary tw-w-full tw-flex tw-items-center tw-justify-evenly">
                    <?php if (is_trial()) { ?>
                    <a class="ui-btn ui-btn-outlined tw-flex tw-items-center tw-gap-2" href="https://go.nagios.com/nagios-log-server-demo-request" target="_blank">
                        <i class="material-symbols-outlined">computer</i>
                        <?php echo _("Request a live demo"); ?>
                    </a>
                    <?php } ?>
                    <a class="ui-btn ui-btn-outlined tw-flex tw-items-center tw-gap-2" href="https://go.nagios.com/nagios-log-server-feedback" target="_blank">
                        <i class="material-symbols-outlined">chat</i>
                        <?php echo _("Give us feedback"); ?>
                    </a>
                    <a class="ui-btn ui-btn-outlined tw-flex tw-items-center tw-gap-2" href="https://go.nagios.com/nagios-log-server-request-for-assistance" target="_blank">
                        <i class="material-symbols-outlined">help</i>
                        <?php echo _("Request assistance"); ?>
                    </a>
                </div>
            </div>
            <?php } ?>
        </div>
    </div>
</div>

<?php echo $footer; ?>
