<?php
/* Note: Other parts of the page may use the JS functions below, but as a general rule,
 * they should avoid modifying this part of the DOM directly.
 */
?>

<script>
    var SR_EDITING = false;
    $(document).ready(function () {
        clearScheduledReportModal();

        $('#sr-form').on('submit', function(e) {
            $('#sr-message').hide();
            e.preventDefault();
            var form = e.target;
            var array_args = $(e.target).serializeArray();
            var obj_args = serializeArrayToObject(array_args);
            const attachments = {
                'pdf': obj_args['attachments'] === 'pdf' ? 'on': 'off',
                'jpg': obj_args['attachments'] === 'jpg' ? 'on': 'off'
            };
            obj_args[attachments] = attachments;
            var errmsg = scheduledReportValidate(obj_args);

            if (errmsg) {
                sr_show_error(errmsg);
                return;
            }

            str_args = $(e.target).serialize();
            if (SR_EDITING) {
                str_args += '&edit=1';
            }

            url = '<?php echo site_url('api/report/schedule'); ?>';
            url += '?' + str_args;
            $.get(url, {}, function(data) {
                if (data.hasOwnProperty('errmsg')) {
                    sr_show_error(data.errmsg);
                    return;
                }
                else {
                    window.location.href = '<?php echo site_url('reports/scheduled'); ?>';
                }
            }, 'json');
        });
    });

    function sr_show_error(msg) {
        $('#sr-error-message').html(msg);
        $('#sr-message').addClass('alert-danger').show();
    }

    function showTimeOpts() {
        var opt = $('#sr-input-which').val();

        switch (opt) {
            case 'daily':
                $('#sr-input-time-group').show();
                $('#sr-input-weekday-group').hide();
                $('#sr-input-monthday-group').hide();
                break;
            case 'weekly':
                $('#sr-input-time-group').show();
                $('#sr-input-weekday-group').show();
                $('#sr-input-monthday-group').hide();
                break;
            case 'monthly':
                $('#sr-input-time-group').show();
                $('#sr-input-weekday-group').hide();
                $('#sr-input-monthday-group').show();
                break;
            case 'Once': /* Same as default, fall through */
            default:
                $('#sr-input-time-group').hide();
                $('#sr-input-weekday-group').hide();
                $('#sr-input-monthday-group').hide();
                break;
        }
    }
    function showScheduledReportModal() {
        showTimeOpts();
        $('#schedule-report').modal('show');
    }

    function clearScheduledReportModal(is_mail = false) {

        var defaultOptions = {title: '<?php echo _("Schedule this Report"); ?>'};
        $('#sr-is-mail-only').hide();
        if ($('#sr-is-mail-only').is(':selected')) {
            $('#sr-input-which').val('daily');
        }

        if (is_mail) {
            defaultOptions['title'] = '<?php echo _('E-mail this Report'); ?>';
            $('#sr-is-mail-only').show();
            $('#sr-input-which').val('once');
        }

        defaultOptions['recipients'] = '<?php echo htmlspecialchars($email); ?>';
        defaultOptions['subject'] = $('#dashboard-title').html();
        defaultOptions['message'] = '';
        populateScheduledReportModal(defaultOptions);
    }

    function populateScheduledReportModal(options) {

        if (!options.hasOwnProperty('title')) {
            options.title = '<?php echo _('Edit Scheduled Report'); ?>';
        }

        $('#sr-modal-title-here').html(options.title);

        val_array = ['id', 'dashboard-id', 'name', 'which', 'hour', 'minute', 'ampm', 'weekday', 'monthday', 'recipients', 'subject'];
        html_array = ['message'];
        checkbox_array = ['attachments-pdf', 'attachments-jpg', 'hide'];

        for (i in options) {

            if (val_array.indexOf(i) !== -1) {
                $('#sr-input-' + i).val(options[i]);
            }

            if (html_array.indexOf(i) !== -1) {
                $('#sr-input-' + i).html(options[i]);
            }

            if (checkbox_array.indexOf(i) !== -1) {
                $('#sr-input-' + i).prop('checked', options[i]);
            }
        }
    }

    function scheduledReportValidate(query_object) {

        if (query_object.name === '' || query_object.recipients === '' || query_object.subject === '') {
            return '<?php echo _('Please fill out all of the required form fields.'); ?>';
        }

        var rec_arr = query_object.recipients.split(',');
        for (var i = 0; i < rec_arr.length; i++) {
            if (rec_arr[i].indexOf('@') === -1) {
                return '<?php echo _('Please enter valid e-mail addresses for all recipients');?>';
            }
        }
    }

</script>

<div class="modal hide fade in" id="schedule-report" tabindex="-1" role="dialog">
    <form id="sr-form">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <input type="hidden" id="sr-input-id" name="id" value="">
                <input type="hidden" id="sr-input-dashboard-id" name="dashboard-id" value="">
                <div class="modal-header">
                    <h2 id="sr-modal-title-here" class="form-header"></h2>
                    <button type="button" class="close" data-dismiss="modal">
                        <i class="material-symbols-outlined tw-text-foreground">close</i>
                    </button>

                </div>
                <div class="modal-body">
                    <div id="sr-message" class="alert hide">
                        <div id="sr-error-message"></div>
                    </div>
                    <div class="tw-flex tw-flex-col tw-gap-2">
                        <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
                            <label class="tw-block tw-text-sm tw-font-medium form-required" for="sr-input-name"><?php echo _('Name'); ?></label>
                            <input type="text" class="ui-input" id="sr-input-name" name="name">
                        </div>
                        <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
                            <label class="tw-block tw-text-sm tw-font-medium" for="sr-input-frequency"><?php echo _('Frequency'); ?></label>
                            <select id="sr-input-which" name="which" class="ui-select" onchange="showTimeOpts()">
                                <option id="sr-is-mail-only" value='once'><?php echo _("One Time"); ?></option>
                                <option value='daily'><?php echo _("Daily"); ?></option>
                                <option value='weekly'><?php echo _("Weekly"); ?></option>
                                <option value='monthly'><?php echo _("Monthly"); ?></option>
                            </select>
                        </div>
                        <div class="tw-grid tw-mb-2 tw-w-full tw-items-center hide" id="sr-input-time-group">
                            <label class="tw-block tw-text-sm tw-font-medium" for="sr-input-time"><?php echo _('Time'); ?></label>
                            <div class="tw-flex tw-gap-2 tw-items-center">
                                <select id="sr-input-hour" name="hour" class="ui-select">
                                    <?php
                                    for ($x = 1; $x < 12; $x++) {
                                        $nstr = sprintf("%02d", $x);
                                        echo "<option value='" . $nstr . "'>" . $nstr . "</option>";
                                    }
                                    echo "<option value='0'>12</option>";
                                    ?>
                                </select>:<select id="sr-input-minute" name="minute" class="ui-select">
                                    <?php
                                    for ($x = 0; $x < 60; $x++) {
                                        $nstr = sprintf("%02d", $x);
                                        echo "<option value='" . $nstr . "'>" . $nstr . "</option>";
                                    }
                                    ?>
                                </select>
                                <select id="sr-input-ampm" name="ampm" class="ui-select">
                                    <option value="am">AM</option>
                                    <option value="pm">PM</option>
                                </select>
                            </div>
                        </div>
                        <div class="tw-grid tw-mb-2 tw-w-full tw-items-center hide" id="sr-input-weekday-group">
                            <label class="tw-block tw-text-sm tw-font-medium" for="sr-input-weekday"><?php echo _("Weekday"); ?>:</label>
                            <select id="sr-input-weekday" name="weekday" class="ui-select">
                                <?php
                                $days = array(
                                    0 => 'Sunday',
                                    1 => 'Monday',
                                    2 => 'Tuesday',
                                    3 => 'Wednesday',
                                    4 => 'Thursday',
                                    5 => 'Friday',
                                    6 => 'Saturday',
                                );
                                foreach ($days as $did => $day) {
                                    echo "<option value='" . $did . "'>" . $day . "</option>";
                                }
                                ?>
                            </select>
                        </div>
                        <div class="tw-grid tw-mb-2 tw-w-full tw-items-center hide" id="sr-input-monthday-group">
                            <label class="tw-block tw-text-sm tw-font-medium" for="sr-input-monthday"><?php echo _("Day of Month");?></label>
                            <select id="sr-input-monthday" name="monthday" class="ui-select">
                                <?php
                                for ($x = 1; $x <= 31; $x++) {
                                    echo "<option value='" . $x . "'>" . $x . "</option>";
                                }
                                ?>
                            </select>
                        </div>
                        <div class="tw-grid tw-mb-2 tw-w-full tw-items-center" id="sr-input-attachments-group">
                            <label class="tw-block tw-text-sm tw-font-medium" for="sr-input-attachments"><?php echo _('Attachment'); ?></label>
                            <div class="ui-radio-group">
                                <div class="tw-flex tw-items-center tw-space-x-2">
                                    <input type="radio" id="sr-input-attachments-pdf" name="attachments" value="pdf" class="ui-radio-group-item">
                                    <label for="sr-input-attachments-pdf" class="ui-label">PDF</label>
                                </div>
                                <div class="tw-flex tw-items-center tw-space-x-2">
                                    <input type="radio" id="sr-input-attachments-jpg" name="attachments" value="jpg" class="ui-radio-group-item">
                                    <label for="sr-input-attachments-jpg" class="ui-label">JPG</label>
                                </div>
                                <div class="tw-flex tw-items-center tw-space-x-2">
                                    <input type="radio" id="sr-input-attachments-none" name="attachments" value="none" class="ui-radio-group-item" checked>
                                    <label for="sr-input-attachments-none" class="ui-label">None</label>
                                </div>
                            </div>
                        </div>
                        <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
                            <label class="tw-block tw-text-sm tw-font-medium form-required" for="sr-input-recipients"><?php echo _("Recipients"); ?></label>
                            <input type="text" id="sr-input-recipients" name="recipients" class="ui-input" placeholder="<?php echo _("Comma-separated, i.e. 'root@localhost,admin@example.com'"); ?>">
                        </div>
                        <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
                            <label class="tw-block tw-text-sm tw-font-medium form-required" for="sr-input-subject"><?php echo _("Subject"); ?></label>
                            <input type="text" id="sr-input-subject" name="subject" class="ui-input">
                        </div>
                        <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
                            <label class="tw-block tw-text-sm tw-font-medium" for="sr-input-message"><?php echo _("Message"); ?></label>
                            <textarea wrap="physical" id="sr-input-message" class="" name="message"></textarea>
                        </div>
                        <div class="tw-grid tw-mb-2 tw-w-full tw-items-center">
                            <div class="tw-flex tw-items-center tw-space-x-2">
                                <input type="checkbox" id="sr-input-hide" name="hide" value="1" class="ui-checkbox-group-item">
                                <label for="sr-input-hide" class="ui-label"><?php echo _("Do not show this report in the \"Scheduled Reports\" list"); ?></label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer tw-flex tw-space-x-2 tw-justify-end">
                    <button class="ui-btn ui-btn-default" id="schedule-report-submit"><?php echo _("Submit"); ?></button>
                    <button class="ui-btn ui-btn-outlined" id="schedule-report-close-modal" data-dismiss="modal"><?php echo _("Close"); ?></button>
                </div>
            </div>
        </div>
    </form>
</div>

