<?php echo $header; ?>

<script type="text/javascript">
$(document).ready(function() {
    var temp;
    $('input[name="key_type"]').click(function() {
        if ($(this).val() == 'trial') {
            temp = $('input[name="key"]').val();
            $('input[name="key"]').val('');
            $('input[name="key"]').attr('disabled', true);
        } else {
            $('input[name="key"]').val(temp);
            $('input[name="key"]').attr('disabled', false);
        }
    });
    $('a.selector').click(function() {
        var type = $(this).data('type');
        $('.select-type').hide();
        if (type == 'install') {
            $('.install').show();
        }
    });
    $('.back').click(function() {
        $('.install').hide();
        $('.select-type').show();
        $('.alert').hide();
    });
    $('form').submit(function(e) {
        $(this).find('button[name="finish"]').attr('disabled', true).text("<?php echo _('Please Wait...'); ?>");
    });
});
</script>

<div class="configure-layout">
    <div class="form-container" id="container">
        <h1 class="form-title"><?php echo _('Final Installation Steps'); ?></h1>
        <p class="form-subtitle"><?php echo _("You're almost done. Setup your instance."); ?></p>
        <div class="form-spacer"></div>

        <?php if (!empty($error)) { ?>
        <div class="tw-w-full">
            <div class="alert alert-error tw-text-center tw-mb-15"><?php echo $error; ?></div>
        </div>
        <?php } ?>
        
        <div class="select-type <?php if (!empty($type)) { echo 'hide'; } ?>">
            <div class="tw-flex tw-flex-row tw-justify-between tw-gap-4 tw-w-full">
                <div class="ui-card tw-bg-secondary  tw-rounded-md tw-flex-1 hover:tw-bg-foreground/5">
                    <a class="tw-p-8 no-primary hover:tw-text-foreground tw-flex tw-flex-col tw-items-start tw-gap-2 tw-cursor-pointer selector tw-w-full" data-type="install">
                        <div class="tw-flex tw-flex-row tw-items-center tw-gap-2">
                            <span class="material-symbols-outlined tw-text-4xl">storage</span>
                            <span class="tw-text-xl tw-font-medium"><?php echo _('Install'); ?></span>
                        </div>
                        <p class="tw-text-left tw-text-secondary-foreground/80 tw-mt-2"><?php echo _("Install a new Nagios Log Server cluster"); ?></p>
                    </a>
                </div>
            </div>
        </div>
        <div class="install <?php if ($type != 'install') { echo 'hide'; } ?>">
            <?php echo form_open('', array('class' => 'tw-max-w-4xl')); ?>
            <div class="ui-card tw-py-8 tw-mb-8">
                <h4 class="form-title"><?php echo _('License Setup'); ?></h4>
                <p class="form-subtitle"><?php echo _('Choose a trial license, enter your key, or') . ' <a href="https://www.nagios.com/products/nagios-log-server" target="_blank" class="tw-text-primary hover:tw-underline">' . _('get a license now') . '</a>.'; ?></p>
                <div class="form-spacer"></div>
                <div class="tw-flex tw-flex-col tw-gap-4">
                    <div class="ui-radio-group">
                        <div class="tw-flex tw-items-center tw-space-x-2">
                            <input type="radio" id="trial" name="key_type" value="trial" class="ui-radio-group-item" checked>
                            <label for="trial" class="ui-label"><?php echo _('Free 30 day trial'); ?></label>
                        </div>
                        <div class="tw-flex tw-items-center tw-space-x-2">
                            <input type="radio" id="key" name="key_type" value="key" class="ui-radio-group-item">
                            <label for="key" class="ui-label"><?php echo _('I already have a key'); ?></label>
                        </div>
                    </div>
                    <div class="tw-flex tw-items-center tw-gap-4">
                        <label class="tw-w-1/3 tw-text-sm tw-font-medium"><?php echo _('License Key'); ?></label>
                        <input type="text" class="ui-input tw-flex-1" name="key" value="" disabled>
                    </div>
                </div>
            </div>

            <div class="ui-card tw-py-8">
                <h4 class="form-title"><?php echo _('Admin Account Setup'); ?></h4>
                <p class="form-subtitle"><?php echo _('Enter the admin account settings. The default username is nagiosadmin.'); ?></p>
                <div class="form-spacer"></div>
                <div class="tw-flex tw-flex-col tw-gap-4">
                    <div class="tw-flex tw-items-center tw-gap-4">
                        <label class="tw-w-1/3 tw-text-sm tw-font-medium"><?php echo _('Username'); ?></label>
                        <input type="text" class="ui-input tw-flex-1" name="username" value="<?php echo ($username == '') ? 'nagiosadmin' : $username; ?>" required>
                    </div>
                    <div class="tw-flex tw-items-center tw-gap-4">
                        <label class="tw-w-1/3 tw-text-sm tw-font-medium"><?php echo _('Full Name'); ?></label>
                        <input type="text" class="ui-input tw-flex-1" name="admin_name" value="<?php echo ($admin_name == '') ? 'Nagios Administrator' : $admin_name; ?>" required>
                    </div>
                    <div class="tw-flex tw-items-center tw-gap-4">
                        <label class="tw-w-1/3 tw-text-sm tw-font-medium"><?php echo _('Password'); ?></label>
                        <input type="password" class="ui-input tw-flex-1" name="password" required>
                    </div>
                    <div class="tw-flex tw-items-center tw-gap-4">
                        <label class="tw-w-1/3 tw-text-sm tw-font-medium"><?php echo _('Confirm Password'); ?></label>
                        <input type="password" class="ui-input tw-flex-1" name="conf_password" required>
                    </div>
                    <div class="tw-flex tw-items-center tw-gap-4">
                        <label class="tw-w-1/3 tw-text-sm tw-font-medium"><?php echo _('Email'); ?></label>
                        <input type="text" class="ui-input tw-flex-1" name="email" value="<?php echo htmlspecialchars($email); ?>" required>
                    </div>
                    <div class="tw-flex tw-items-center tw-gap-4">
                        <label class="tw-w-1/3 tw-text-sm tw-font-medium"><?php echo _('Language'); ?></label>
                        <select id="language" class="ui-select tw-flex-1" name="language">
                            <option value="default" <?php if ($user_language == 'default') { echo 'selected'; } ?>><?php echo _('Default'); ?></option>
                            <?php foreach ($languages as $l) { ?>
                            <option value="<?php echo $l; ?>" <?php if ($user_language == $language && $language == $l) { echo 'selected'; } ?>>
                                <?php echo get_language_name($l); ?>
                            </option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="tw-flex tw-items-center tw-gap-4">
                        <label class="tw-w-1/3 tw-text-sm tw-font-medium"><?php echo _('Timezone'); ?></label>
                        <select name="timezone" class="ui-select tw-flex-1">
                            <?php
                            $cur_timezone = get_current_timezone();
                            if (!empty($set_timezone)) { $cur_timezone = $set_timezone; }
                            foreach (get_timezones() as $name => $val) {
                            ?>
                            <option value="<?php echo $val; ?>" <?php if ($val == $cur_timezone) { echo 'selected'; } ?>><?php echo $name; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>
                <div class="tw-flex tw-justify-end tw-mt-8">
                    <input type="hidden" name="type" value="install">
                    <button type="button" class="ui-btn ui-btn-secondary back tw-mr-2">
                        <div class="tw-flex tw-items-center tw-justify-center tw-gap-2">
                            <span class="material-symbols-outlined">chevron_left</span>
                            <?php echo _("Back"); ?>
                        </div>
                    </button>
                    <button type="submit" value="1" name="finish" class="ui-btn ui-btn-default">
                        <div class="tw-flex tw-items-center tw-justify-center tw-gap-2">
                            <?php echo _('Finish Installation'); ?>
                            <span class="material-symbols-outlined">chevron_right</span>
                        </div>
                    </button>
                </div>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>

<?php echo $footer; ?>