/// <reference types="react" />
import { BarCanvasLayerId, BarLayerId, ComputedDatum } from './types';
import { InheritedColorConfig, OrdinalColorScaleConfig } from '@nivo/colors';
import { ScaleBandSpec, ScaleSpec } from '@nivo/scales';
export declare const defaultProps: {
    indexBy: string;
    keys: string[];
    groupMode: "stacked";
    layout: "vertical";
    reverse: boolean;
    minValue: "auto";
    maxValue: "auto";
    valueScale: ScaleSpec;
    indexScale: ScaleBandSpec;
    padding: number;
    innerPadding: number;
    axisBottom: {};
    axisLeft: {};
    enableGridX: boolean;
    enableGridY: boolean;
    enableLabel: boolean;
    label: string;
    labelSkipWidth: number;
    labelSkipHeight: number;
    labelTextColor: {
        from: string;
        theme: string;
    };
    colorBy: "id";
    colors: OrdinalColorScaleConfig<any>;
    borderRadius: number;
    borderWidth: number;
    borderColor: InheritedColorConfig<any>;
    isInteractive: boolean;
    tooltip: <RawDatum>({ color, label, ...data }: import("./types").BarTooltipProps<RawDatum>) => JSX.Element;
    tooltipLabel: <RawDatum_1>(datum: ComputedDatum<RawDatum_1>) => string;
    legends: never[];
    initialHiddenIds: never[];
    annotations: never[];
    markers: never[];
    enableTotals: boolean;
    totalsOffset: number;
};
export declare const svgDefaultProps: {
    layers: BarLayerId[];
    barComponent: <RawDatum extends import("./types").BarDatum>({ bar: { data, ...bar }, style: { borderColor, color, height, labelColor, labelOpacity, labelX, labelY, transform, width, }, borderRadius, borderWidth, label, shouldRenderLabel, isInteractive, onClick, onMouseEnter, onMouseLeave, tooltip, isFocusable, ariaLabel, ariaLabelledBy, ariaDescribedBy, }: import("./types").BarItemProps<RawDatum>) => JSX.Element;
    defs: never[];
    fill: never[];
    animate: boolean;
    motionConfig: string;
    role: string;
    isFocusable: boolean;
    indexBy: string;
    keys: string[];
    groupMode: "stacked";
    layout: "vertical";
    reverse: boolean;
    minValue: "auto";
    maxValue: "auto";
    valueScale: ScaleSpec;
    indexScale: ScaleBandSpec;
    padding: number;
    innerPadding: number;
    axisBottom: {};
    axisLeft: {};
    enableGridX: boolean;
    enableGridY: boolean;
    enableLabel: boolean;
    label: string;
    labelSkipWidth: number;
    labelSkipHeight: number;
    labelTextColor: {
        from: string;
        theme: string;
    };
    colorBy: "id";
    colors: OrdinalColorScaleConfig<any>;
    borderRadius: number;
    borderWidth: number;
    borderColor: InheritedColorConfig<any>;
    isInteractive: boolean;
    tooltip: <RawDatum>({ color, label, ...data }: import("./types").BarTooltipProps<RawDatum>) => JSX.Element;
    tooltipLabel: <RawDatum_1>(datum: ComputedDatum<RawDatum_1>) => string;
    legends: never[];
    initialHiddenIds: never[];
    annotations: never[];
    markers: never[];
    enableTotals: boolean;
    totalsOffset: number;
};
export declare const canvasDefaultProps: {
    layers: BarCanvasLayerId[];
    pixelRatio: number;
    indexBy: string;
    keys: string[];
    groupMode: "stacked";
    layout: "vertical";
    reverse: boolean;
    minValue: "auto";
    maxValue: "auto";
    valueScale: ScaleSpec;
    indexScale: ScaleBandSpec;
    padding: number;
    innerPadding: number;
    axisBottom: {};
    axisLeft: {};
    enableGridX: boolean;
    enableGridY: boolean;
    enableLabel: boolean;
    label: string;
    labelSkipWidth: number;
    labelSkipHeight: number;
    labelTextColor: {
        from: string;
        theme: string;
    };
    colorBy: "id";
    colors: OrdinalColorScaleConfig<any>;
    borderRadius: number;
    borderWidth: number;
    borderColor: InheritedColorConfig<any>;
    isInteractive: boolean;
    tooltip: <RawDatum>({ color, label, ...data }: import("./types").BarTooltipProps<RawDatum>) => JSX.Element;
    tooltipLabel: <RawDatum_1>(datum: ComputedDatum<RawDatum_1>) => string;
    legends: never[];
    initialHiddenIds: never[];
    annotations: never[];
    markers: never[];
    enableTotals: boolean;
    totalsOffset: number;
};
//# sourceMappingURL=props.d.ts.map