import { CategoricalColorSchemeId } from './categorical';
import { DivergingColorSchemeId } from './diverging';
import { SequentialColorSchemeId } from './sequential';
export declare const colorSchemes: {
    blues: readonly (readonly string[])[];
    greens: readonly (readonly string[])[];
    greys: readonly (readonly string[])[];
    oranges: readonly (readonly string[])[];
    purples: readonly (readonly string[])[];
    reds: readonly (readonly string[])[];
    blue_green: readonly (readonly string[])[];
    blue_purple: readonly (readonly string[])[];
    green_blue: readonly (readonly string[])[];
    orange_red: readonly (readonly string[])[];
    purple_blue_green: readonly (readonly string[])[];
    purple_blue: readonly (readonly string[])[];
    purple_red: readonly (readonly string[])[];
    red_purple: readonly (readonly string[])[];
    yellow_green_blue: readonly (readonly string[])[];
    yellow_green: readonly (readonly string[])[];
    yellow_orange_brown: readonly (readonly string[])[];
    yellow_orange_red: readonly (readonly string[])[];
    brown_blueGreen: readonly (readonly string[])[];
    purpleRed_green: readonly (readonly string[])[];
    pink_yellowGreen: readonly (readonly string[])[];
    purple_orange: readonly (readonly string[])[];
    red_blue: readonly (readonly string[])[];
    red_grey: readonly (readonly string[])[];
    red_yellow_blue: readonly (readonly string[])[];
    red_yellow_green: readonly (readonly string[])[];
    spectral: readonly (readonly string[])[];
    nivo: string[];
    category10: readonly string[];
    accent: readonly string[];
    dark2: readonly string[];
    paired: readonly string[];
    pastel1: readonly string[];
    pastel2: readonly string[];
    set1: readonly string[];
    set2: readonly string[];
    set3: readonly string[];
    tableau10: readonly string[];
};
export type ColorSchemeId = CategoricalColorSchemeId | DivergingColorSchemeId | SequentialColorSchemeId;
export declare const colorSchemeIds: ColorSchemeId[];
export declare const isCategoricalColorScheme: (scheme: ColorSchemeId) => scheme is "nivo" | "category10" | "accent" | "dark2" | "paired" | "pastel1" | "pastel2" | "set1" | "set2" | "set3" | "tableau10";
export declare const isDivergingColorScheme: (scheme: ColorSchemeId) => scheme is "brown_blueGreen" | "purpleRed_green" | "pink_yellowGreen" | "purple_orange" | "red_blue" | "red_grey" | "red_yellow_blue" | "red_yellow_green" | "spectral";
export declare const isSequentialColorScheme: (scheme: ColorSchemeId) => scheme is "blues" | "greens" | "greys" | "oranges" | "purples" | "reds" | "blue_green" | "blue_purple" | "green_blue" | "orange_red" | "purple_blue_green" | "purple_blue" | "purple_red" | "red_purple" | "yellow_green_blue" | "yellow_green" | "yellow_orange_brown" | "yellow_orange_red";
//# sourceMappingURL=all.d.ts.map