# Installation
> `npm install --save @types/lucene`

# Summary
This package contains type definitions for lucene (https://github.com/bripkens/lucene#readme).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/lucene.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/lucene/index.d.ts)
````ts
export interface TermLocation {
    column: number;
    line: number;
    offset: number;
}

export interface NodeField {
    field: string | "<implicit>";
    fieldLocation: null | {
        end: TermLocation;
        start: TermLocation;
    };
}

export interface NodeTerm extends NodeField {
    boost: null | number;
    prefix: null | string;
    quoted: boolean;
    regex: boolean;
    similarity: null | number;
    term: string;
    termLocation: {
        start: TermLocation;
        end: TermLocation;
    };
}

export interface NodeRangedTerm extends NodeField {
    inclusive: "both" | "none" | "left" | "right";
    term_max: string;
    term_min: string;
}

export type Node =
    | NodeTerm
    | NodeRangedTerm;

export type Operator = "<implicit>" | "NOT" | "OR" | "AND" | "AND NOT" | "OR NOT";

export interface ASTField {
    field?: string;
    fieldLocation?: null | {
        end: TermLocation;
        start: TermLocation;
    };
    parenthesized?: boolean;
}

export interface LeftOnlyAST extends ASTField {
    left: AST | Node;
    start?: Operator | undefined;
}

export interface BinaryAST extends ASTField {
    left: AST | Node;
    operator: Operator;
    right: AST | Node;
}

export type AST = LeftOnlyAST | BinaryAST;

export function parse(query: string): AST;

export function toString(ast: AST): string;

export interface Parser {
    escape(str: string): string;
    unescape(str: string): string;
}

export const term: Parser;
export const phrase: Parser;

````

### Additional Details
 * Last updated: Tue, 07 Nov 2023 09:09:39 GMT
 * Dependencies: none

# Credits
These definitions were written by [Ben Grynhaus](https://github.com/bengry), and [Hugo Muller](https://github.com/HugoMuller).
