'use client'

import Dashboard from '@/dashboard/Dashboard';
import { Toaster } from '@/components/shadcn/toaster';
import { useSearchParams } from 'react-router-dom';
import { DashboardQueryProvider } from '@/dashboard/contexts/DashboardQueryContext';
import { DashboardProvider } from '@/dashboard/contexts/DashboardContext';
import { ErrorBoundary } from 'react-error-boundary';
import { DashboardNotFoundDialog } from '@/DashboardNotFoundDialog';
import { ErrorDialog } from '@/ErrorDialog';
import { AxiosError } from 'axios';
import { subQuery } from '@/dashboard/queries/types';

import 'maplibre-gl/dist/maplibre-gl.css';

function App() {

  const [searchParams] = useSearchParams();

  const dashboardId = searchParams.get('dashboardId') || localStorage.getItem('dashboardId') || searchParams.get('default') || '';
  const report = searchParams.get('report') ? true : false;
  const exporting = searchParams.get('exporting') ? true : false;
  const searchQuery: subQuery | null = searchParams.get('searchQuery')
  ? {
      id: 'id_0',
      query: searchParams.get('searchQuery') || '',
      color: '#1cd98c'
    }
  : null;
  const simpleTokens:string | null = searchParams.get('simpleTokens');

//  if (dashboardId && !report) {
//    localStorage.setItem('dashboardId', dashboardId);
//  }

  const Fallback = ({ error }: { error: AxiosError }) => {
    if (error.response?.status === 404) {
      return <DashboardNotFoundDialog />
    } else {
      return <ErrorDialog>{error.message}</ErrorDialog>
    }
  }

  const GenericFallback = ({ error }: { error: AxiosError }) => {
    return <ErrorDialog>{error.message}</ErrorDialog>
  }
    
  return (
    <div className="min-h-screen w-full min-w-screen bg-background">
      <ErrorBoundary FallbackComponent={GenericFallback} onError={(error: Error) => console.log(error)}>
        <DashboardProvider>
          <DashboardQueryProvider>
            <ErrorBoundary FallbackComponent={Fallback} onError={(error: Error) => console.log(error)}>
              <Dashboard dashboardId={dashboardId} report={report} exporting={exporting} searchQuery={searchQuery} simpleTokens={simpleTokens} />
            </ErrorBoundary>
            <Toaster />
          </DashboardQueryProvider>
        </DashboardProvider>
      </ErrorBoundary>
    </div>
  );
}

export default App;
