import {
    AlertDialog,
    AlertDialogAction,
    AlertDialogContent,
    AlertDialogDescription,
    AlertDialogHeader,
    AlertDialogTitle,
} from '@/components/shadcn/alert-dialog';
import { useTranslation } from 'react-i18next';

export const DashboardNotFoundDialog = () => {
    const { t } = useTranslation();
    localStorage.setItem('dashboardId', 'default');

    return (
        <AlertDialog open={true}>
            <AlertDialogContent>
                <AlertDialogHeader>
                    <AlertDialogTitle>{t('Dashboard Not Found')}</AlertDialogTitle>
                    <AlertDialogDescription>{t('The specified dashboard was not found.') + t(' Redirect to your default dashboard.')}</AlertDialogDescription>
                    <a href="/nagioslogserver/dashboard" target="_parent">
                        <AlertDialogAction>{t('Redirect')}</AlertDialogAction>
                    </a>
                </AlertDialogHeader>
            </AlertDialogContent>
        </AlertDialog>
    );
};
